QUnit.test('Line with useOhlcData and datagrouping.', function (assert) {
    var chart = Highcharts.stockChart('container', {
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: true,
                    forced: true,
                    units: [['day', [5]]]
                }
            }
        },
        series: [
            {
                type: 'line',
                useOhlcData: true,
                dataGrouping: {
                    groupAll: true
                },
                data: [
                    [1536327000000, 221.85, 225.37, 220.71, 221.3, 37619800],
                    [1536586200000, 220.95, 221.85, 216.47, 218.33, 39516500],
                    [1536672600000, 218.01, 224.3, 216.56, 223.85, 35749000],
                    [1536759000000, 224.94, 225, 219.84, 221.07, 49278700],
                    [1536845400000, 223.52, 228.35, 222.57, 226.41, 41706400],
                    [1536931800000, 225.75, 226.84, 222.52, 223.84, 31999300],
                    [1537191000000, 222.15, 222.95, 217.27, 217.88, 37195100],
                    [1537277400000, 217.79, 221.85, 217.12, 218.24, 31571700],
                    [1537363800000, 218.5, 219.62, 215.3, 218.37, 27123800],
                    [1537450200000, 220.24, 222.28, 219.15, 220.03, 26608800],
                    [1537536600000, 220.78, 221.36, 217.29, 217.66, 96246700],
                    [1537795800000, 216.82, 221.26, 216.63, 220.79, 27693400],
                    [1537882200000, 219.75, 222.82, 219.7, 222.19, 24554400],
                    [1537968600000, 221, 223.75, 219.76, 220.42, 23984700],
                    [1538055000000, 223.82, 226.44, 223.54, 224.95, 30181200],
                    [1538141400000, 224.79, 225.84, 224.02, 225.74, 22929400],
                    [1538400600000, 227.95, 229.42, 226.35, 227.26, 23600800],
                    [1538487000000, 227.25, 230, 226.63, 229.28, 24788200],
                    [1538573400000, 230.05, 233.47, 229.78, 232.07, 28654800],
                    [1538659800000, 230.78, 232.35, 226.73, 227.99, 32042000],
                    [1538746200000, 227.96, 228.41, 220.58, 224.29, 33580500],
                    [1539005400000, 222.21, 224.8, 220.2, 223.77, 29663900],
                    [1539091800000, 223.64, 227.27, 222.25, 226.87, 26891000],
                    [1539178200000, 225.46, 226.35, 216.05, 216.36, 41990600],
                    [1539264600000, 214.52, 219.5, 212.32, 214.45, 53124400],
                    [1539351000000, 220.42, 222.88, 216.84, 222.11, 40337900],
                    [1539610200000, 221.16, 221.83, 217.27, 217.36, 30791000],
                    [1539696600000, 218.93, 222.99, 216.76, 222.15, 29184000],
                    [1539783000000, 222.3, 222.64, 219.34, 221.19, 22885400],
                    [1539869400000, 217.86, 219.74, 213, 216.02, 32581300],
                    [1539955800000, 218.06, 221.26, 217.43, 219.31, 33078700],
                    [1540215000000, 219.79, 223.36, 218.94, 220.65, 28792100],
                    [1540301400000, 215.83, 223.25, 214.7, 222.73, 38767800],
                    [1540387800000, 222.6, 224.23, 214.54, 215.09, 40925500],
                    [1540474200000, 217.71, 221.38, 216.75, 219.8, 29855800],
                    [1540560600000, 215.9, 220.19, 212.67, 216.3, 47258400],
                    [1540819800000, 219.19, 219.69, 206.09, 212.24, 45935500],
                    [1540906200000, 211.15, 215.18, 209.27, 213.3, 36660000],
                    [1540992600000, 216.88, 220.45, 216.62, 218.86, 38358900]
                ]
            }
        ]
    });

    assert.strictEqual(
        chart.series[0].points[0].y === 221.3,
        true,
        'Initial number of Awesome points is correct'
    );
});
