QUnit.test('Load map from TopoJSON', assert => {

    // eslint-disable-next-line
    const topojsonText = `{"type":"Topology","objects":{"default":{"type":"GeometryCollection","geometries":[{"type":"MultiPolygon","arcs":[[[0]],[[1,2,3,4,5,6,7,8]]],"id":"US.MA","properties":{"hc-group":"admin1","hc-middle-x":0.36,"hc-middle-y":0.47,"hc-key":"us-ma","hc-a2":"MA","labelrank":"0","hasc":"US.MA","woe-id":"2347580","state-fips":"25","fips":"US25","postal-code":"MA","name":"Massachusetts","country":"United States of America","region":"Northeast","longitude":"-71.99930000000001","woe-name":"Massachusetts","latitude":"42.3739","woe-label":"Massachusetts, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[9]],[[10,11,12]]],"id":"US.WA","properties":{"hc-group":"admin1","hc-middle-x":0.56,"hc-middle-y":0.52,"hc-key":"us-wa","hc-a2":"WA","labelrank":"0","hasc":"US.WA","woe-id":"2347606","state-fips":"53","fips":"US53","postal-code":"WA","name":"Washington","country":"United States of America","region":"West","longitude":"-120.361","woe-name":"Washington","latitude":"47.4865","woe-label":"Washington, US, United States","type":"State"}},{"type":"Polygon","arcs":[[13,14,15,16]],"id":"US.CA","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-middle-y":0.67,"hc-key":"us-ca","hc-a2":"CA","labelrank":"0","hasc":"US.CA","woe-id":"2347563","state-fips":"6","fips":"US06","postal-code":"CA","name":"California","country":"United States of America","region":"West","longitude":"-119.591","woe-name":"California","latitude":"36.7496","woe-label":"California, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-14,17,-12,18,19]],"id":"US.OR","properties":{"hc-group":"admin1","hc-middle-x":0.47,"hc-middle-y":0.52,"hc-key":"us-or","hc-a2":"OR","labelrank":"0","hasc":"US.OR","woe-id":"2347596","state-fips":"41","fips":"US41","postal-code":"OR","name":"Oregon","country":"United States of America","region":"West","longitude":"-120.386","woe-name":"Oregon","latitude":"43.8333","woe-label":"Oregon, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[20]],[[21,22,23,24,25,26,27,28]]],"id":"US.WI","properties":{"hc-group":"admin1","hc-middle-x":0.41,"hc-middle-y":0.38,"hc-key":"us-wi","hc-a2":"WI","labelrank":"0","hasc":"US.WI","woe-id":"2347608","state-fips":"55","fips":"US55","postal-code":"WI","name":"Wisconsin","country":"United States of America","region":"Midwest","longitude":"-89.5831","woe-name":"Wisconsin","latitude":"44.3709","woe-label":"Wisconsin, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[29]],[[30,31]]],"id":"US.ME","properties":{"hc-group":"admin1","hc-middle-x":0.43,"hc-middle-y":0.4,"hc-key":"us-me","hc-a2":"ME","labelrank":"0","hasc":"US.ME","woe-id":"2347578","state-fips":"23","fips":"US23","postal-code":"ME","name":"Maine","country":"United States of America","region":"Northeast","longitude":"-69.1973","woe-name":"Maine","latitude":"45.148","woe-label":"Maine, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[32]],[[33]],[[34,35,36]],[[-26,37]]],"id":"US.MI","properties":{"hc-group":"admin1","hc-middle-x":0.71,"hc-middle-y":0.67,"hc-key":"us-mi","hc-a2":"MI","labelrank":"0","hasc":"US.MI","woe-id":"2347581","state-fips":"26","fips":"US26","postal-code":"MI","name":"Michigan","country":"United States of America","region":"Midwest","longitude":"-84.9479","woe-name":"Michigan","latitude":"43.4343","woe-label":"Michigan, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-20,38,39,40,-15]],"id":"US.NV","properties":{"hc-group":"admin1","hc-middle-x":0.46,"hc-middle-y":0.38,"hc-key":"us-nv","hc-a2":"NV","labelrank":"0","hasc":"US.NV","woe-id":"2347587","state-fips":"32","fips":"US32","postal-code":"NV","name":"Nevada","country":"United States of America","region":"West","longitude":"-117.02","woe-name":"Nevada","latitude":"39.4299","woe-label":"Nevada, US, United States","type":"State"}},{"type":"Polygon","arcs":[[41,42,43,44,45]],"id":"US.NM","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-key":"us-nm","hc-a2":"NM","labelrank":"0","hasc":"US.NM","woe-id":"2347590","state-fips":"35","fips":"US35","postal-code":"NM","name":"New Mexico","country":"United States of America","region":"West","longitude":"-106.024","woe-name":"New Mexico","latitude":"34.5002","woe-label":"New Mexico, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-42,46,47,48,49,50]],"id":"US.CO","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-key":"us-co","hc-a2":"CO","labelrank":"0","hasc":"US.CO","woe-id":"2347564","state-fips":"8","fips":"US08","postal-code":"CO","name":"Colorado","country":"United States of America","region":"West","longitude":"-105.543","woe-name":"Colorado","latitude":"38.9998","woe-label":"Colorado, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-48,51,52,53,54,55]],"id":"US.WY","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-key":"us-wy","hc-a2":"WY","labelrank":"0","hasc":"US.WY","woe-id":"2347609","state-fips":"56","fips":"US56","postal-code":"WY","name":"Wyoming","country":"United States of America","region":"West","longitude":"-107.552","woe-name":"Wyoming","latitude":"42.9999","woe-label":"Wyoming, US, United States","type":"State"}},{"type":"Polygon","arcs":[[56,57,58,-50]],"id":"US.KS","properties":{"hc-group":"admin1","hc-middle-x":0.3,"hc-middle-y":0.49,"hc-key":"us-ks","hc-a2":"KS","labelrank":"0","hasc":"US.KS","woe-id":"2347575","state-fips":"20","fips":"US20","postal-code":"KS","name":"Kansas","country":"United States of America","region":"Midwest","longitude":"-98.3309","woe-name":"Kansas","latitude":"38.5","woe-label":"Kansas, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-57,-49,-56,59,60,61,62]],"id":"US.NE","properties":{"hc-group":"admin1","hc-middle-x":0.43,"hc-key":"us-ne","hc-a2":"NE","labelrank":"0","hasc":"US.NE","woe-id":"2347586","state-fips":"31","fips":"US31","postal-code":"NE","name":"Nebraska","country":"United States of America","region":"Midwest","longitude":"-99.68550000000001","woe-name":"Nebraska","latitude":"41.5002","woe-label":"Nebraska, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-59,63,64,65,-43,-51]],"id":"US.OK","properties":{"hc-group":"admin1","hc-middle-x":0.78,"hc-middle-y":0.52,"hc-key":"us-ok","hc-a2":"OK","labelrank":"0","hasc":"US.OK","woe-id":"2347595","state-fips":"40","fips":"US40","postal-code":"OK","name":"Oklahoma","country":"United States of America","region":"South","longitude":"-97.1309","woe-name":"Oklahoma","latitude":"35.452","woe-label":"Oklahoma, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-64,-58,-63,66,67,68,69,70,71,72]],"id":"US.MO","properties":{"hc-group":"admin1","hc-middle-x":0.48,"hc-middle-y":0.51,"hc-key":"us-mo","hc-a2":"MO","labelrank":"0","hasc":"US.MO","woe-id":"2347584","state-fips":"29","fips":"US29","postal-code":"MO","name":"Missouri","country":"United States of America","region":"Midwest","longitude":"-92.446","woe-name":"Missouri","latitude":"38.5487","woe-label":"Missouri, US, United States","type":"State"}},{"type":"Polygon","arcs":[[73,74,75,-68,76,-29,77]],"id":"US.IL","properties":{"hc-group":"admin1","hc-middle-x":0.56,"hc-middle-y":0.45,"hc-key":"us-il","hc-a2":"IL","labelrank":"0","hasc":"US.IL","woe-id":"2347572","state-fips":"17","fips":"US17","postal-code":"IL","name":"Illinois","country":"United States of America","region":"Midwest","longitude":"-89.1991","woe-name":"Illinois","latitude":"39.946","woe-label":"Illinois, US, United States","type":"State"}},{"type":"Polygon","arcs":[[78,-36,79,80,-75]],"id":"US.IN","properties":{"hc-group":"admin1","hc-middle-x":0.49,"hc-middle-y":0.43,"hc-key":"us-in","hc-a2":"IN","labelrank":"0","hasc":"US.IN","woe-id":"2347573","state-fips":"18","fips":"US18","postal-code":"IN","name":"Indiana","country":"United States of America","region":"Midwest","longitude":"-86.1396","woe-name":"Indiana","latitude":"39.8874","woe-label":"Indiana, US, United States","type":"State"}},{"type":"Polygon","arcs":[[81,82,83,-6]],"id":"US.VT","properties":{"hc-group":"admin1","hc-middle-x":0.42,"hc-middle-y":0.43,"hc-key":"us-vt","hc-a2":"VT","labelrank":"0","hasc":"US.VT","woe-id":"2347604","state-fips":"50","fips":"US50","postal-code":"VT","name":"Vermont","country":"United States of America","region":"Northeast","longitude":"-72.7317","woe-name":"Vermont","latitude":"44.0886","woe-label":"Vermont, US, United States","type":"State"}},{"type":"Polygon","arcs":[[84,-65,-73,85,86,87]],"id":"US.AR","properties":{"hc-group":"admin1","hc-middle-x":0.47,"hc-middle-y":0.43,"hc-key":"us-ar","hc-a2":"AR","labelrank":"0","hasc":"US.AR","woe-id":"2347562","state-fips":"5","fips":"US05","postal-code":"AR","name":"Arkansas","country":"United States of America","region":"South","longitude":"-92.14279999999999","woe-name":"Arkansas","latitude":"34.7563","woe-label":"Arkansas, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[-85,88,89,-44,-66]],[[90]]],"id":"US.TX","properties":{"hc-group":"admin1","hc-middle-x":0.69,"hc-middle-y":0.52,"hc-key":"us-tx","hc-a2":"TX","labelrank":"0","hasc":"US.TX","woe-id":"2347602","state-fips":"48","fips":"US48","postal-code":"TX","name":"Texas","country":"United States of America","region":"South","longitude":"-98.7607","woe-name":"Texas","latitude":"31.131","woe-label":"Texas, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[91,-9]],[[-3,92,93]]],"id":"US.RI","properties":{"hc-group":"admin1","hc-middle-x":0.55,"hc-middle-y":0.78,"hc-key":"us-ri","hc-a2":"RI","labelrank":"0","hasc":"US.RI","woe-id":"2347598","state-fips":"44","fips":"US44","postal-code":"RI","name":"Rhode Island","country":"United States of America","region":"Northeast","longitude":"-71.5082","woe-name":"Rhode Island","latitude":"41.6242","woe-label":"Rhode Island, US, United States","type":"State"}},{"type":"Polygon","arcs":[[94,95,96,97,98]],"id":"US.AL","properties":{"hc-group":"admin1","hc-middle-x":0.47,"hc-middle-y":0.42,"hc-key":"us-al","hc-a2":"AL","labelrank":"0","hasc":"US.AL","woe-id":"2347559","state-fips":"1","fips":"US01","postal-code":"AL","name":"Alabama","country":"United States of America","region":"South","longitude":"-86.7184","woe-name":"Alabama","latitude":"32.8551","woe-label":"Alabama, US, United States","type":"State"}},{"type":"Polygon","arcs":[[99,100,-87,101,-96]],"id":"US.MS","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-middle-y":0.48,"hc-key":"us-ms","hc-a2":"MS","labelrank":"0","hasc":"US.MS","woe-id":"2347583","state-fips":"28","fips":"US28","postal-code":"MS","name":"Mississippi","country":"United States of America","region":"South","longitude":"-89.71890000000001","woe-name":"Mississippi","latitude":"32.8657","woe-label":"Mississippi, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[102,103,104,105]],[[106,107]],[[108,109,110,111,112]]],"id":"US.NC","properties":{"hc-group":"admin1","hc-middle-x":0.62,"hc-key":"us-nc","hc-a2":"NC","labelrank":"0","hasc":"US.NC","woe-id":"2347592","state-fips":"37","fips":"US37","postal-code":"NC","name":"North Carolina","country":"United States of America","region":"South","longitude":"-78.866","woe-name":"North Carolina","latitude":"35.6152","woe-label":"North Carolina, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[113,-104,114,-109,115,116,117,118,119,120,121,-108],[122]],[[123,-106]],[[124,125]],[[126,127]]],"id":"US.VA","properties":{"hc-group":"admin1","hc-middle-x":0.64,"hc-middle-y":0.54,"hc-key":"us-va","hc-a2":"VA","labelrank":"0","hasc":"US.VA","woe-id":"2347605","state-fips":"51","fips":"US51","postal-code":"VA","name":"Virginia","country":"United States of America","region":"South","longitude":"-78.2431","woe-name":"Virginia","latitude":"37.7403","woe-label":"Virginia, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-77,-67,128,-61,129,130,-23,131]],"id":"US.IA","properties":{"hc-group":"admin1","hc-middle-x":0.35,"hc-middle-y":0.49,"hc-key":"us-ia","hc-a2":"IA","labelrank":"0","hasc":"US.IA","woe-id":"2347574","state-fips":"19","fips":"US19","postal-code":"IA","name":"Iowa","country":"United States of America","region":"Midwest","longitude":"-93.3891","woe-name":"Iowa","latitude":"42.0423","woe-label":"Iowa, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[132,-126]],[[133,134]],[[-127,135,136,-119,137,138,139,140]]],"id":"US.MD","properties":{"hc-group":"admin1","hc-middle-x":0.61,"hc-middle-y":0.27,"hc-key":"us-md","hc-a2":"MD","labelrank":"0","hasc":"US.MD","woe-id":"2347579","state-fips":"24","fips":"US24","postal-code":"MD","name":"Maryland","country":"United States of America","region":"South","longitude":"-77.0454","woe-name":"Maryland","latitude":"39.3874","woe-label":"Maryland, US, United States","type":"State"}},{"type":"Polygon","arcs":[[141,-140,142,143,-135]],"id":"US.DE","properties":{"hc-group":"admin1","hc-middle-x":0.91,"hc-middle-y":0.77,"hc-key":"us-de","hc-a2":"DE","labelrank":"0","hasc":"US.DE","woe-id":"2347566","state-fips":"10","fips":"US10","postal-code":"DE","name":"Delaware","country":"United States of America","region":"South","longitude":"-75.41119999999999","woe-name":"Delaware","latitude":"38.8657","woe-label":"Delaware, US, United States","type":"State"}},{"type":"Polygon","arcs":[[144,-143,-139,145,146,147,148,149]],"id":"US.PA","properties":{"hc-group":"admin1","hc-middle-y":0.49,"hc-key":"us-pa","hc-a2":"PA","labelrank":"0","hasc":"US.PA","woe-id":"2347597","state-fips":"42","fips":"US42","postal-code":"PA","name":"Pennsylvania","country":"United States of America","region":"Northeast","longitude":"-77.60939999999999","woe-name":"Pennsylvania","latitude":"40.8601","woe-label":"Pennsylvania, US, United States","type":"State"}},{"type":"Polygon","arcs":[[150,151,152,-150]],"id":"US.NJ","properties":{"hc-group":"admin1","hc-middle-x":0.68,"hc-middle-y":0.64,"hc-key":"us-nj","hc-a2":"NJ","labelrank":"0","hasc":"US.NJ","woe-id":"2347589","state-fips":"34","fips":"US34","postal-code":"NJ","name":"New Jersey","country":"United States of America","region":"Northeast","longitude":"-74.4653","woe-name":"New Jersey","latitude":"40.0449","woe-label":"New Jersey, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-149,153,-82,-5,154,155,-152,156]],"id":"US.NY","properties":{"hc-group":"admin1","hc-middle-x":0.54,"hc-middle-y":0.49,"hc-key":"us-ny","hc-a2":"NY","labelrank":"0","hasc":"US.NY","woe-id":"2347591","state-fips":"36","fips":"US36","postal-code":"NY","name":"New York","country":"United States of America","region":"Northeast","longitude":"-75.32420000000001","woe-name":"New York","latitude":"43.1988","woe-label":"New York, US, United States","type":"State"}},{"type":"Polygon","arcs":[[157,158,-53,159,-39,-19,-11]],"id":"US.ID","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-middle-y":0.75,"hc-key":"us-id","hc-a2":"ID","labelrank":"0","hasc":"US.ID","woe-id":"2347571","state-fips":"16","fips":"US16","postal-code":"ID","name":"Idaho","country":"United States of America","region":"West","longitude":"-114.133","woe-name":"Idaho","latitude":"43.7825","woe-label":"Idaho, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-55,160,161,162,-130,-60]],"id":"US.SD","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-middle-y":0.44,"hc-key":"us-sd","hc-a2":"SD","labelrank":"0","hasc":"US.SD","woe-id":"2347600","state-fips":"46","fips":"US46","postal-code":"SD","name":"South Dakota","country":"United States of America","region":"Midwest","longitude":"-100.255","woe-name":"South Dakota","latitude":"44.4711","woe-label":"South Dakota, US, United States","type":"State"}},{"type":"Polygon","arcs":[[163,-155,-4,-94]],"id":"US.CT","properties":{"hc-group":"admin1","hc-middle-x":0.48,"hc-key":"us-ct","hc-a2":"CT","labelrank":"0","hasc":"US.CT","woe-id":"2347565","state-fips":"9","fips":"US09","postal-code":"CT","name":"Connecticut","country":"United States of America","region":"Northeast","longitude":"-72.7594","woe-name":"Connecticut","latitude":"41.6486","woe-label":"Connecticut, US, United States","type":"State"}},{"type":"Polygon","arcs":[[164,-7,-84,165,-32]],"id":"US.NH","properties":{"hc-group":"admin1","hc-middle-x":0.38,"hc-middle-y":0.57,"hc-key":"us-nh","hc-a2":"NH","labelrank":"0","hasc":"US.NH","woe-id":"2347588","state-fips":"33","fips":"US33","postal-code":"NH","name":"New Hampshire","country":"United States of America","region":"Northeast","longitude":"-71.6301","woe-name":"New Hampshire","latitude":"43.5993","woe-label":"New Hampshire, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[-71,166]],[[-69,-76,-81,167,168,-117,169]],[[170,170,170]]],"id":"US.KY","properties":{"hc-group":"admin1","hc-middle-x":0.65,"hc-key":"us-ky","hc-a2":"KY","labelrank":"0","hasc":"US.KY","woe-id":"2347576","state-fips":"21","fips":"US21","postal-code":"KY","name":"Kentucky","country":"United States of America","region":"South","longitude":"-85.5729","woe-name":"Kentucky","latitude":"37.3994","woe-label":"Kentucky, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-35,171,-147,172,-168,-80]],"id":"US.OH","properties":{"hc-group":"admin1","hc-middle-x":0.45,"hc-middle-y":0.53,"hc-key":"us-oh","hc-a2":"OH","labelrank":"0","hasc":"US.OH","woe-id":"2347594","state-fips":"39","fips":"US39","postal-code":"OH","name":"Ohio","country":"United States of America","region":"Midwest","longitude":"-82.67189999999999","woe-name":"Ohio","latitude":"40.0924","woe-label":"Ohio, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-102,-86,-72,-167,-70,-170,-116,-113,173,-97]],"id":"US.TN","properties":{"hc-group":"admin1","hc-middle-x":0.43,"hc-middle-y":0.54,"hc-key":"us-tn","hc-a2":"TN","labelrank":"0","hasc":"US.TN","woe-id":"2347601","state-fips":"47","fips":"US47","postal-code":"TN","name":"Tennessee","country":"United States of America","region":"South","longitude":"-86.3415","woe-name":"Tennessee","latitude":"35.7514","woe-label":"Tennessee, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-173,-146,-138,-118,-169]],"id":"US.WV","properties":{"hc-group":"admin1","hc-middle-x":0.35,"hc-middle-y":0.56,"hc-key":"us-wv","hc-a2":"WV","labelrank":"0","hasc":"US.WV","woe-id":"2347607","state-fips":"54","fips":"US54","postal-code":"WV","name":"West Virginia","country":"United States of America","region":"South","longitude":"-80.7128","woe-name":"West Virginia","latitude":"38.6422","woe-label":"West Virginia, US, United States","type":"State"}},{"type":"Polygon","arcs":[[174,-120,-137]],"id":"US.DC","properties":{"hc-group":"admin1","hc-middle-x":0.57,"hc-middle-y":0.14,"hc-key":"us-dc","hc-a2":"DC","labelrank":"9","hasc":"US.DC","woe-id":"2347567","state-fips":"11","fips":"US11","postal-code":"DC","name":"District of Columbia","country":"United States of America","region":"South","longitude":"-77.01130000000001","woe-name":"District of Columbia","latitude":"38.8922","woe-label":"District of Columbia, US, United States","type":"Federal District"}},{"type":"Polygon","arcs":[[175,-89,-88,-101]],"id":"US.LA","properties":{"hc-group":"admin1","hc-middle-x":0.34,"hc-middle-y":0.46,"hc-key":"us-la","hc-a2":"LA","labelrank":"0","hasc":"US.LA","woe-id":"2347577","state-fips":"22","fips":"US22","postal-code":"LA","name":"Louisiana","country":"United States of America","region":"South","longitude":"-91.9991","woe-name":"Louisiana","latitude":"30.5274","woe-label":"Louisiana, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-99,176,177]],"id":"US.FL","properties":{"hc-group":"admin1","hc-middle-x":0.77,"hc-key":"us-fl","hc-a2":"FL","labelrank":"0","hasc":"US.FL","woe-id":"2347568","state-fips":"12","fips":"US12","postal-code":"FL","name":"Florida","country":"United States of America","region":"South","longitude":"-81.6228","woe-name":"Florida","latitude":"28.1568","woe-label":"Florida, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-98,-174,-112,178,179,-177]],"id":"US.GA","properties":{"hc-group":"admin1","hc-middle-x":0.43,"hc-middle-y":0.52,"hc-key":"us-ga","hc-a2":"GA","labelrank":"0","hasc":"US.GA","woe-id":"2347569","state-fips":"13","fips":"US13","postal-code":"GA","name":"Georgia","country":"United States of America","region":"South","longitude":"-83.4078","woe-name":"Georgia","latitude":"32.8547","woe-label":"Georgia, US, United States","type":"State"}},{"type":"Polygon","arcs":[[180,-179,-111]],"id":"US.SC","properties":{"hc-group":"admin1","hc-middle-x":0.54,"hc-middle-y":0.35,"hc-key":"us-sc","hc-a2":"SC","labelrank":"0","hasc":"US.SC","woe-id":"2347599","state-fips":"45","fips":"US45","postal-code":"SC","name":"South Carolina","country":"United States of America","region":"South","longitude":"-80.6471","woe-name":"South Carolina","latitude":"33.8578","woe-label":"South Carolina, US, United States","type":"State"}},{"type":"Polygon","arcs":[[181,-24,-131,-163,182]],"id":"US.MN","properties":{"hc-group":"admin1","hc-middle-x":0.38,"hc-middle-y":0.6,"hc-key":"us-mn","hc-a2":"MN","labelrank":"0","hasc":"US.MN","woe-id":"2347582","state-fips":"27","fips":"US27","postal-code":"MN","name":"Minnesota","country":"United States of America","region":"Midwest","longitude":"-93.364","woe-name":"Minnesota","latitude":"46.0592","woe-label":"Minnesota, US, United States","type":"State"}},{"type":"Polygon","arcs":[[183,184,-161,-54,-159]],"id":"US.MT","properties":{"hc-group":"admin1","hc-middle-x":0.55,"hc-middle-y":0.53,"hc-key":"us-mt","hc-a2":"MT","labelrank":"0","hasc":"US.MT","woe-id":"2347585","state-fips":"30","fips":"US30","postal-code":"MT","name":"Montana","country":"United States of America","region":"West","longitude":"-110.044","woe-name":"Montana","latitude":"46.9965","woe-label":"Montana, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-185,185,-183,-162]],"id":"US.ND","properties":{"hc-group":"admin1","hc-middle-x":0.47,"hc-key":"us-nd","hc-a2":"ND","labelrank":"0","hasc":"US.ND","woe-id":"2347593","state-fips":"38","fips":"US38","postal-code":"ND","name":"North Dakota","country":"United States of America","region":"Midwest","longitude":"-100.302","woe-name":"North Dakota","latitude":"47.4675","woe-label":"North Dakota, US, United States","type":"State"}},{"type":"Polygon","arcs":[[186,-16,-41,187,-46]],"id":"US.AZ","properties":{"hc-group":"admin1","hc-middle-x":0.51,"hc-middle-y":0.45,"hc-key":"us-az","hc-a2":"AZ","labelrank":"0","hasc":"US.AZ","woe-id":"2347561","state-fips":"4","fips":"US04","postal-code":"AZ","name":"Arizona","country":"United States of America","region":"West","longitude":"-111.935","woe-name":"Arizona","latitude":"34.3046","woe-label":"Arizona, US, United States","type":"State"}},{"type":"Polygon","arcs":[[-188,-40,-160,-52,-47]],"id":"US.UT","properties":{"hc-group":"admin1","hc-middle-x":0.52,"hc-middle-y":0.59,"hc-key":"us-ut","hc-a2":"UT","labelrank":"0","hasc":"US.UT","woe-id":"2347603","state-fips":"49","fips":"US49","postal-code":"UT","name":"Utah","country":"United States of America","region":"West","longitude":"-111.544","woe-name":"Utah","latitude":"39.5007","woe-label":"Utah, US, United States","type":"State"}},{"type":"MultiPolygon","arcs":[[[188]],[[189]],[[190]],[[191]],[[192]],[[193]],[[194]],[[195]]],"id":"US.HI","properties":{"hc-group":"admin1","hc-middle-x":0.87,"hc-middle-y":0.79,"hc-key":"us-hi","hc-a2":"HI","labelrank":"0","hasc":"US.HI","woe-id":"2347570","state-fips":"15","fips":"US15","postal-code":"HI","name":"Hawaii","country":"United States of America","region":"West","longitude":"-157.999","woe-name":"Hawaii","latitude":"21.4919","woe-label":"Hawaii, US, United States","type":"State","hc-inset":"us-all-hawaii"}},{"type":"MultiPolygon","arcs":[[[196],[197]],[[198]],[[199]],[[200]],[[201]],[[202]],[[203]],[[204]],[[205]],[[206]],[[207]],[[208]],[[209]],[[210]],[[211]],[[212]],[[213]],[[214]],[[215]],[[216]],[[217]],[[218]],[[219]],[[220]],[[221]],[[222]],[[223]],[[224]],[[225]],[[226]],[[227]],[[228]],[[229]],[[230]],[[231]],[[232]],[[233]],[[234]],[[235]],[[236]],[[237]],[[238]],[[239]],[[240]],[[241]]],"id":"US.AK","properties":{"hc-group":"admin1","hc-middle-x":0.53,"hc-middle-y":0.33,"hc-key":"us-ak","hc-a2":"AK","labelrank":"0","hasc":"US.AK","woe-id":"2347560","state-fips":"2","fips":"US02","postal-code":"AK","name":"Alaska","country":"United States of America","region":"West","longitude":"-151.604","woe-name":"Alaska","latitude":"65.3609","woe-label":"Alaska, US, United States","type":"State","hc-inset":"us-all-alaska"}}],"hc-recommended-transform":{"default":{"crs":"+proj=lcc +lat_1=33 +lat_2=45 +lat_0=39 +lon_0=-96 +x_0=0 +y_0=0 +datum=NAD83 +units=m +no_defs","scale":0.000151481324748,"jsonres":15.5,"jsonmarginX":-999,"jsonmarginY":9851,"xoffset":-2361356.09818,"yoffset":1398996.77886},"us-all-hawaii":{"xpan":190,"ypan":417,"crs":"+proj=aea +lat_1=8 +lat_2=18 +lat_0=13 +lon_0=-157 +x_0=0 +y_0=0 +datum=NAD83 +units=m +no_defs","scale":0.000123090941806,"jsonres":15.5,"jsonmarginX":-999,"jsonmarginY":9851,"xoffset":-338610.47557,"yoffset":1022754.31736,"geometry":{"type":"Polygon","coordinates":[[[-108.02234811026737,28.131995556971578],[-99.6925136210582,25.09851533842571],[-99.13103120627295,10.80433106513135],[-105.76273688266124,10.337841364791041],[-108.02234811026737,28.131995556971578]]]}},"us-all-alaska":{"rotation":-0.0174532925199,"xpan":5,"ypan":357,"crs":"+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs","scale":0.0000584397059179,"jsonres":15.5,"jsonmarginX":-999,"jsonmarginY":9851,"xoffset":-1566154.00853,"yoffset":1992671.14918,"geometry":{"type":"Polygon","coordinates":[[[-120.85794661131852,30.762825284322425],[-119.60838899484447,31.05714930388009],[-108.02234811026737,28.131995556971578],[-105.76273688266124,10.337841364791041],[-115.12985129390901,8.8460581322757],[-120.85794661131852,30.762825284322425]]]}}},"hc-recommended-mapview":{"projection":{"name":"LambertConformalConic","parallels":[33,45],"rotation":[96]},"padding":[0,0,"8%",0],"insets":[{"id":"us-alaska","borderPath":{"type":"MultiLineString","coordinates":[[[0,60],[25,80],[25,100]]]},"field":{"type":"Polygon","coordinates":[[[0,60],[25,80],[25,100],[0,100]]]},"geoBounds":{"type":"Polygon","coordinates":[[[-179.5,50],[-129,50],[-129,72],[-179.5,72]]]},"padding":["30%","5%",0,0],"projection":{"name":"LambertConformalConic","parallels":[55,65],"rotation":[154]}},{"id":"us-hawaii","borderPath":{"type":"LineString","coordinates":[[[25,80],[40,92]]]},"field":{"type":"Polygon","coordinates":[[[25,80],[40,92],[40,100],[25,100]]]},"geoBounds":{"type":"Polygon","coordinates":[[[-162,23],[-152,23],[-152,18],[-162,18]]]},"padding":["30%","20%",0,"10%"],"projection":{"name":"LambertConformalConic","parallels":[8,18],"rotation":[157]}}]}}},"arcs":[[[9647,4303],[19,-17],[-20,-2],[-11,-11],[12,30]],[[9596,4344],[1,9],[-5,-2]],[[9592,4351],[-10,17],[-4,41],[-39,0]],[[9539,4409],[-90,3],[-68,5]],[[9381,4417],[-3,4],[23,127]],[[9401,4548],[33,0],[42,-2]],[[9476,4546],[110,-6],[14,21],[32,13]],[[9632,4574],[3,-31],[17,-16],[-26,-18],[-15,-44],[13,2],[17,-21],[17,-75],[25,-19],[24,14],[-3,48],[10,-35],[0,-35],[-23,-3],[-47,-24],[3,36],[-24,-16],[-2,-17],[-18,-7]],[[9603,4313],[-1,29],[-6,2]],[[4722,5694],[15,-16],[-16,-15],[10,-30],[-32,16],[12,9],[11,36]],[[5276,5740],[-1,-498],[12,-37],[4,-35]],[[5291,5170],[-201,-1],[-9,-10],[-46,-4],[-61,-36],[-36,-1],[-27,-17],[-25,-2],[-10,15],[-49,2],[-44,-29],[-45,18],[-6,60],[-10,25],[-26,14]],[[4696,5204],[-18,-5],[-10,23],[-20,6],[-17,-13],[-18,23],[0,56],[6,-38],[10,18],[0,38],[-18,-1],[-4,28],[30,14],[-34,15],[-14,61],[-10,73],[-20,32],[-9,50],[15,38],[49,-37],[76,-12],[9,12],[15,-27],[21,20],[14,-48],[-13,-42],[22,45],[-6,-59],[21,-41],[-34,-8],[-4,-32],[-5,40],[-19,-50],[35,1],[11,37],[20,14],[-8,35],[1,39],[18,39],[-22,48],[5,14],[-19,14],[-12,-28],[11,-5],[24,-49],[-20,7],[-6,33],[-12,17],[15,26],[-6,3],[-6,27],[21,-18],[5,25],[-5,30],[-15,5],[-15,32],[6,12],[539,-1]],[[4599,4406],[397,0]],[[4996,4406],[0,-573],[177,-249],[138,-210],[192,-303]],[[5503,3071],[24,-102],[23,-36],[-24,-29],[-13,-36],[3,-40],[-13,-56],[-9,-4],[2,-62],[21,-19],[-6,-48],[-17,-5]],[[5494,2634],[-227,-34],[-1,30],[-12,2],[-6,78],[-17,43],[-63,82],[-22,-5],[2,19],[-14,38],[-25,-7],[-39,29],[-5,20],[-33,31],[-24,-3],[-25,13],[-31,-4],[-17,26],[1,105],[-24,22],[6,16],[-32,57],[-11,6],[-42,102],[-16,19],[-7,52],[15,21],[2,24],[-13,32],[-21,0],[-23,41],[0,32],[-11,33],[0,48],[10,5],[5,-41],[30,-27],[-12,40],[-16,23],[-3,43],[22,6],[-25,21],[-10,-7],[-2,-57],[-36,41],[-21,80],[-56,89],[4,21],[-14,61],[6,38],[-8,55],[-25,52],[-23,30],[-4,34],[28,114],[4,76],[-9,57],[-10,8],[5,42]],[[4599,4406],[-14,22],[-7,41],[2,64],[-13,35],[10,35],[7,59],[13,39],[8,64],[10,144],[-2,36],[16,140],[-8,40],[4,41],[-5,42],[35,-3],[13,13],[9,-21],[19,7]],[[5291,5170],[11,-32],[21,-16],[7,-32],[-18,-45],[-17,-82],[-35,-83],[1,-35],[27,-22],[-11,-76],[0,-341]],[[5277,4406],[-281,0]],[[8109,5044],[-7,-43],[-23,-56],[-11,19],[16,48],[25,32]],[[7763,4504],[-6,27]],[[7757,4531],[-32,17],[-11,79],[7,23],[-15,43]],[[7706,4693],[-4,79],[-13,20],[-22,10],[-42,69],[-27,28],[-18,5],[-22,28],[6,33],[0,71],[8,28],[-20,24],[0,27],[17,38],[39,32],[0,111],[17,20]],[[7625,5316],[30,-12],[57,30],[21,17],[21,-5],[-6,-28],[13,-26],[24,-10]],[[7785,5282],[17,-15],[11,-33],[94,-36],[26,-22],[61,-14],[11,-33],[26,-19],[-6,-63],[20,-2],[-7,-32],[12,-15]],[[8050,4998],[-21,-29],[-20,-72],[10,-3],[29,55],[16,8],[11,-16],[-21,-94],[5,-17],[-21,-56],[2,-42],[-19,-84],[1,-47],[11,-40],[-3,-61]],[[8030,4500],[-166,2],[-86,1]],[[7778,4503],[-15,1]],[[9856,4851],[15,21],[9,-16],[-21,-35],[-3,30]],[[9606,5037],[17,-12],[21,63],[26,30],[14,43],[-5,22],[12,55],[11,11],[6,55],[70,140],[18,-1],[3,-35],[13,-12],[67,30],[36,-59],[2,-260],[33,-13],[-3,-62],[11,-22],[17,3],[24,-65],[-26,-37],[-13,12],[-7,-21],[-44,-11],[-3,-27],[-14,-14],[-5,29],[-31,2],[-19,-37],[4,-47],[-20,61],[6,32],[-23,-22],[-8,-70],[-18,-24],[-10,9],[-13,-27],[-19,-2],[-11,-24],[-12,29],[-27,-29],[3,-26],[-35,-55],[-15,-36]],[[9639,4613],[-22,57],[1,34],[-12,333]],[[8430,5184],[1,-28],[-23,3],[8,31],[14,-6]],[[7965,5584],[-18,-31],[-42,-34],[1,25],[59,40]],[[8440,4355],[-79,-4],[-48,-2]],[[8313,4349],[0,11],[-192,1]],[[8121,4361],[23,34],[21,60],[15,87],[0,48],[-31,127],[10,30],[-7,57],[23,55],[0,60],[16,11],[2,33],[22,6],[19,45],[7,-23],[-8,-40],[8,-14],[14,28],[2,57],[21,28],[18,2],[-9,47],[29,32],[26,-22],[-8,25],[22,-5],[-10,-23],[22,-5],[12,-26],[55,-28],[12,-15],[7,-40],[-14,-13],[16,-57],[-6,-71],[-17,-12],[-6,-39],[-25,-14],[-4,-59],[21,-14],[18,19],[24,54],[30,15],[22,-28],[15,-123],[11,-50],[-10,-70],[-28,1],[-7,-48],[-23,-25],[-12,-65],[-19,-38]],[[7785,5282],[37,20],[21,26],[37,7],[25,26],[16,3],[31,42],[4,-11],[15,36],[36,22],[31,-10],[-49,-47],[-17,-37],[0,25],[-13,4],[12,-31],[-2,-36],[21,28],[41,-7],[16,-14],[27,-60],[35,5],[8,-16],[28,1],[42,43],[59,-1],[30,18],[23,1],[-10,-48],[21,-14],[17,9],[8,-16],[14,17],[30,3],[-3,-55],[23,-43],[-12,-9],[-48,5],[-12,12],[-7,-38],[-27,32],[-30,17],[-19,-3],[-11,-21],[-56,-6],[-12,-28],[-31,-26],[13,42],[-20,-5],[-20,-28],[-1,36],[-56,-154]],[[5277,4406],[193,1],[88,-1]],[[5558,4406],[0,-536],[0,-417]],[[5558,3453],[-1,-149],[-7,-34],[-41,22],[-15,-13],[5,-42],[0,-68],[9,-62],[-5,-36]],[[6028,3452],[570,0]],[[6598,3452],[0,-71],[0,-24]],[[6598,3357],[-3,-4],[-3,-854],[-339,-1],[15,-44]],[[6268,2454],[-161,2],[0,-86],[-79,0]],[[6028,2370],[1,542],[-1,540]],[[6028,3452],[0,644],[1,120]],[[6029,4216],[470,-1]],[[6499,4215],[189,0],[0,-190]],[[6688,4025],[0,-125],[1,-448]],[[6689,3452],[-91,0]],[[6029,4216],[-189,-1],[0,191]],[[5840,4406],[0,149],[0,328]],[[5840,4883],[0,95],[659,0]],[[6499,4978],[0,-309],[0,-72]],[[6499,4597],[0,-72],[0,-310]],[[6688,4025],[635,0]],[[7323,4025],[41,-35],[-21,-55],[19,-28],[6,-32],[20,-18],[0,-405]],[[7388,3452],[-699,0]],[[6499,4597],[525,0],[38,-37],[23,12],[51,4],[16,-19],[39,-21],[22,-31]],[[7213,4505],[8,-4],[4,-55],[18,-42],[9,-37],[-2,-46],[15,-16],[5,-31],[4,-98]],[[7274,4176],[6,-33],[0,-4]],[[7280,4139],[13,-49],[30,-65]],[[7388,3452],[0,-24],[0,-71]],[[7388,3357],[17,-213],[-4,-331]],[[7401,2813],[-37,20],[-33,40],[-12,-18],[-23,16],[-16,-18],[-16,7],[-37,-37],[-30,41],[-19,-8],[-6,15],[-15,-18],[-4,-25],[-9,35],[-15,-16],[-29,30],[-26,-17],[-13,46],[-37,-12],[-44,26],[-23,4],[-7,34],[-39,-2],[-30,33],[0,367],[-283,1]],[[7280,4139],[121,-5],[131,1],[129,8],[27,-46]],[[7688,4097],[-8,-39],[7,-59],[9,-30],[29,-49],[21,-25],[11,-62],[12,-23],[14,17],[28,-25],[-24,-102],[26,-54],[18,-12],[35,-48],[9,-49],[-7,-34],[13,-34],[25,-20]],[[7906,3449],[-1,-47],[-11,-32],[-10,14],[-6,-27]],[[7878,3357],[-5,-9],[-2,9]],[[7871,3357],[-7,10],[1,-10]],[[7865,3357],[3,-22],[-16,-27],[8,-20],[-10,-27]],[[7850,3261],[-62,-2],[29,58],[-9,40],[-420,0]],[[8030,4500],[-1,-40],[28,-105]],[[8057,4355],[-1,-452],[-12,-47],[11,-28],[3,-40],[-13,-46],[-10,-11],[-17,-57],[-9,-12],[-1,-56]],[[8008,3606],[-11,-32],[4,-31],[-33,-13],[-2,-64],[-39,28],[-13,-2],[-13,-28],[5,-15]],[[7688,4097],[5,42],[19,10],[20,56],[2,25],[-12,22],[8,46],[27,3],[34,30],[14,40],[3,58],[-22,24],[-23,51]],[[7778,4503],[119,-1],[133,-2]],[[8057,4355],[22,-20],[42,26]],[[8313,4349],[1,-77],[-3,-420]],[[8311,3852],[-5,-33],[6,-25],[-35,-19],[-25,6],[3,-35],[-19,-20],[-4,-24],[-14,-4],[-9,-43],[-13,-18],[-22,33],[-23,-23],[-1,-17],[-19,-5],[-7,17],[-33,-28],[-25,19],[-16,-17],[-27,14],[-15,-24]],[[9401,4548],[1,154],[-16,9],[5,29],[-6,58],[10,35],[3,45],[-6,20],[1,81]],[[9393,4979],[61,1],[113,1]],[[9567,4981],[-13,-52],[8,-27],[-11,-29],[-35,-31],[-1,-27],[-15,-68],[-17,-48],[-1,-45],[-14,-80],[8,-28]],[[7443,2691],[-1,103],[-26,1],[-15,18]],[[7850,3261],[0,-31],[-21,-19],[3,-36],[-18,-30],[0,-50],[-19,-24]],[[7795,3071],[3,-15],[-18,-18],[-12,-36],[0,-41],[-34,-51],[4,-23],[-17,-8],[4,-34],[-17,-25],[9,-39],[-5,-31],[8,-32],[-6,-26]],[[7714,2692],[-18,0],[-253,-1]],[[7443,2691],[-1,-193],[22,-55],[-1,-24],[30,-103],[-6,-43],[-15,-48],[1,-93],[-8,-18]],[[7465,2114],[-12,-40],[5,-19],[-17,1],[-56,-44],[9,23],[-19,-9],[5,43],[-26,-15],[-4,-25],[28,-40],[-20,-21],[5,29],[-26,-62],[-41,-54],[-33,-15],[-5,-17],[-38,-39],[-1,-12],[-27,-28],[-29,-56],[12,46],[-13,15],[-19,-26],[19,-6],[-17,-42],[-17,2],[11,-29],[-14,-66],[-7,13],[-21,-26],[26,2],[-11,-51],[23,-169],[16,-30],[-27,-22],[-36,40],[-39,3],[-14,22],[-26,10],[-15,24],[-27,7],[-7,60],[-28,64],[-6,48],[2,50],[-19,17],[-35,95],[-19,26],[-11,57],[-22,63],[-4,37],[-33,52],[7,17],[-19,7],[-24,50],[-67,5],[-20,18],[-7,-23],[-27,-6],[-20,-89],[3,-9],[-27,-47],[-14,3],[-46,53],[-25,12],[-20,35],[-25,27],[-14,53],[0,47],[-31,93],[-33,33],[-61,104],[-15,10],[-18,51],[-14,10]],[[7147,1669],[-19,-85],[0,-53],[11,-88],[-13,69],[3,98],[18,59]],[[9603,4313],[-8,-2],[1,33]],[[9592,4351],[0,-43],[-18,-3],[-6,-20],[-34,-10]],[[9534,4275],[5,40],[0,94]],[[8067,2209],[-22,-44],[-62,-3],[19,7],[-7,18],[-21,4]],[[7974,2191],[-8,286],[38,573],[-9,20]],[[7995,3070],[0,3],[243,-5]],[[8238,3068],[38,-390],[11,-62],[17,-65],[-14,-27],[-9,-60],[10,-55],[-7,-50],[10,-51]],[[8294,2308],[-243,-1],[-4,-24],[21,-43],[-1,-31]],[[7974,2191],[-43,4],[-44,-21],[-19,-21]],[[7868,2153],[-30,94],[11,61],[-181,-1],[7,11],[-6,41],[9,2],[1,42],[9,14],[10,54],[23,30],[16,62],[-16,21],[-6,61],[7,29],[-8,18]],[[7795,3071],[159,-1],[41,0]],[[9152,3366],[0,-10],[-10,10]],[[9142,3366],[4,0]],[[9146,3366],[1,-1],[2,1]],[[9149,3366],[1,0],[2,0]],[[9157,3366],[6,-51],[29,-108],[-23,66],[-14,93]],[[9155,3366],[1,1],[1,-1]],[[8610,3378],[41,-8],[106,-6],[383,2]],[[9140,3366],[23,-89],[-39,42],[14,-25],[-44,-30],[-15,8],[-5,-21],[64,7],[2,-63],[4,45],[13,17],[12,-28],[-6,-49],[-9,12],[-17,-48],[-19,-7],[-29,29],[-2,-20],[-37,19],[46,-35],[-16,-27],[10,-9],[-26,-25],[-23,32],[14,-34],[16,-13],[21,4],[8,27],[12,-34],[-28,-39],[-48,-2],[-50,-58],[-15,-32],[-14,-69],[-26,15],[-30,-8]],[[8901,2858],[-102,174],[-106,5],[-1,26],[-27,37],[-114,10],[-78,-39]],[[8473,3071],[-36,-1],[-78,-2]],[[8359,3068],[5,51],[16,1],[8,32],[22,25],[26,3],[40,42],[16,29],[26,21],[5,-16],[36,36],[11,-12],[15,37],[17,18],[8,43]],[[9155,3366],[-8,31],[-1,-31]],[[9142,3366],[-3,8],[1,-8]],[[8610,3378],[-28,-3],[-162,2]],[[8420,3377],[51,28],[23,27],[24,52],[27,21],[36,50]],[[8581,3555],[13,-48],[26,-14],[20,23],[11,-17],[26,10],[9,25],[11,-9],[41,24],[1,34],[47,113],[15,60],[31,-32],[30,80],[10,-11],[28,39],[16,34],[8,54],[46,-59],[10,36]],[[8980,3897],[25,-17],[-5,-17],[38,-42]],[[9038,3821],[2,-5],[3,-1]],[[9043,3815],[2,-36],[-18,-11],[-11,-47],[9,-15],[20,13],[15,-42],[25,-5],[8,-24],[27,-23],[-7,-54],[-16,7],[-13,30],[-28,31],[38,-69],[26,-32],[-19,-15],[-4,-21]],[[9097,3502],[8,-5],[10,-42],[-12,-8],[-21,50],[-35,11],[29,-27],[22,-46],[20,10],[26,-9],[13,-70]],[[9097,3502],[-3,1],[-24,52],[16,-47],[8,-5],[2,-4],[1,3]],[[9149,3366],[2,5],[1,-5]],[[9214,3647],[-7,-25],[6,25]],[[9213,3647],[1,0]],[[9177,3637],[2,5],[23,4]],[[9202,3646],[-11,-35],[-37,-91],[6,-30],[-12,-21],[-6,43],[7,50],[28,75]],[[7280,4139],[-6,37]],[[7213,4505],[-15,45],[17,70],[-10,20],[-3,52],[13,1]],[[7215,4693],[338,0],[153,0]],[[7757,4531],[7,-23],[-1,-4]],[[9213,3647],[6,16],[-5,-16]],[[9233,3730],[-3,-22],[2,21]],[[9232,3729],[1,1]],[[9177,3637],[-21,-7],[8,43],[-24,29],[-1,-13],[-26,44],[29,18],[-9,23],[-19,15],[19,22],[-13,13],[-3,39],[23,46],[9,40],[-25,-45],[-11,8],[-6,-31],[-17,3],[14,-33],[-12,-38],[3,-69],[9,-39],[-21,29],[30,-64],[0,-19],[-23,30],[-26,11],[-18,43],[-16,-22],[-6,24],[22,41],[1,19]],[[9047,3797],[11,16],[-20,8]],[[8980,3897],[-11,53],[-27,18],[-28,-15],[-4,-17],[-20,2],[-9,17],[-17,-35],[-10,6],[-40,-52],[1,97]],[[8815,3971],[164,0],[184,0]],[[9163,3971],[9,-240],[57,-1]],[[9229,3730],[-6,-41],[-9,-3],[-12,-40]],[[9232,3729],[-3,2],[0,-1]],[[9163,3971],[18,23],[16,-6]],[[9197,3988],[-17,-37],[2,-29],[15,-28],[3,-49],[22,-51],[7,1],[4,-65]],[[9235,4028],[-12,-22],[-26,-18]],[[8815,3971],[-98,1],[0,176]],[[8717,4148],[0,255]],[[8717,4403],[14,8],[58,46]],[[8789,4457],[-1,-51],[418,0],[24,-33],[1,-40],[35,-50]],[[9266,4283],[-42,-71],[8,-17],[-12,-26],[0,-35],[9,-3],[34,-75],[-28,-28]],[[9266,4283],[37,-35]],[[9303,4248],[37,-34]],[[9340,4214],[-11,-53],[-17,-15],[-7,-26],[27,-18],[2,-15],[-12,-114],[-21,-32],[-8,-39],[-23,-30],[-21,-49],[-8,-2],[7,41],[-24,7],[-37,56],[-2,27],[11,30],[28,19],[11,27]],[[8789,4457],[57,60],[27,51],[-19,49],[1,33],[35,16],[54,6],[35,-9],[19,-17],[16,8],[36,-3],[26,11],[28,37],[22,10],[-3,52],[11,28],[-17,-6],[-8,30],[20,31],[28,16],[15,39],[40,53],[38,29],[16,-3],[127,1]],[[9381,4417],[-6,-145],[5,-15],[-22,-22],[7,-19]],[[9365,4216],[-12,-32],[27,21],[25,-7],[12,11],[46,5],[25,28],[15,-25],[5,16],[0,-14],[26,10],[-52,-40],[-30,-10],[-30,-26],[-50,-19],[-39,-1],[-24,-13],[4,24],[13,-2],[14,31],[-8,-4],[8,45]],[[9303,4248],[-28,26],[-9,9]],[[5276,5740],[93,1]],[[5369,5741],[0,-189],[31,-58],[0,-51],[35,-31],[40,-68],[1,-14],[32,-38],[20,7],[1,-28],[-10,-50],[-1,-52],[7,-19],[-15,-22],[1,-40],[19,-17],[36,40],[16,-21],[7,-53],[26,-58],[-4,-13],[14,-27],[14,2],[12,-29],[6,-36],[14,-16],[15,24],[30,-7],[12,19],[41,-7],[28,9],[5,27],[13,3],[25,-45]],[[5840,4406],[-124,0],[-158,0]],[[6499,4978],[1,1],[0,179]],[[6500,5158],[596,0],[110,1]],[[7206,5159],[-8,-35],[-21,-31],[16,-37],[22,-21],[0,-342]],[[9534,4275],[-4,6],[-58,-16],[-36,-3],[-28,-13],[-43,-33]],[[9639,4613],[3,-4],[-10,-35]],[[9567,4981],[16,53],[23,3]],[[7871,3357],[-6,0]],[[8311,3852],[36,1],[12,-14],[12,-42],[31,-8],[14,-24],[17,13],[21,-20],[40,27],[6,-30],[22,-32]],[[8522,3723],[-4,-50],[32,-89],[31,-29]],[[8420,3377],[-5,-4],[-132,7],[-28,-1],[-106,8],[-121,-3],[-22,9],[2,-36],[-130,0]],[[8522,3723],[0,0]],[[8440,4355],[54,-37],[-7,-9],[43,-18],[44,22],[35,2],[30,39],[78,49]],[[8717,4148],[-15,-11],[6,-58],[-24,-98],[0,-27],[-33,-44],[-24,0],[-19,-25],[-13,-37],[5,-26],[-13,-12],[-15,25],[-14,-42],[3,-33],[-15,-32],[-24,-5]],[[8359,3068],[-52,0],[-69,0]],[[9047,3797],[1,9],[-5,9]],[[7868,2153],[-41,14],[-24,23],[-20,-46],[9,-15],[28,-5],[15,22],[23,-2],[-16,-38],[17,-12],[16,37],[12,-30],[-37,-53],[16,-44],[33,-11],[16,-26],[-11,-32],[-22,8],[-11,27],[-30,16],[6,15],[-31,22],[2,-56],[-16,-25],[-5,29],[-20,14],[-14,-32],[-23,-2],[-41,31],[5,38],[-25,8],[-14,42],[-16,-7],[1,22],[-27,-19],[2,-22],[17,6],[19,-13],[-11,-19],[-28,20],[-13,-10],[-38,13],[-49,33],[-24,-1],[-35,-13],[2,54]],[[8294,2308],[14,-54],[247,-29],[6,-39],[12,2],[1,69],[12,16],[39,-20]],[[8625,2253],[5,-2],[5,-77],[14,-108],[30,-127],[38,-114],[-7,-13],[6,-73],[16,-61],[27,-139],[2,-79],[-8,-126],[-19,-77],[-2,-64],[-21,-40],[13,43],[-6,14],[-19,-20],[-13,8],[-22,-12],[-9,20],[3,32],[-13,59],[-32,46],[-10,-3],[-11,92],[-24,2],[4,85],[-15,19],[6,-31],[-15,8],[-33,111],[25,70],[-2,23],[-17,-7],[-4,-34],[-17,20],[4,68],[11,55],[3,81],[-16,57],[-21,0],[-18,45],[-18,23],[-26,75],[-32,35],[-34,-14],[3,-25],[-15,3],[-7,-23],[-36,-35],[-36,12],[5,23],[-10,26],[-25,36],[-37,35],[-43,19],[-95,-24],[17,29],[-7,10]],[[8473,3071],[-23,-56],[29,-41],[18,-6],[11,-53],[16,-41],[31,-42],[4,-22],[25,-30],[0,-22],[16,-39],[23,-22],[11,-79],[19,-27],[12,-76],[17,-11]],[[8682,2504],[6,-6],[-47,-87],[5,-51],[-17,-16],[3,-51],[-7,-40]],[[8901,2858],[-35,-47],[-18,-42],[-5,-45],[-17,-30],[-15,3],[-6,-24],[-39,-57],[-31,-25],[-33,5],[23,-20],[-43,-72]],[[7143,5741],[193,-1],[1,72],[32,-14],[11,-93],[11,-15],[34,-15],[33,-2],[12,-23],[25,5],[21,16],[27,-2],[31,-15],[25,-58],[7,14],[25,5],[33,-45],[25,-12],[48,37],[12,-24],[58,2],[19,-20],[32,-2],[-42,-36],[-43,-19],[-45,-42],[-47,-71],[-56,-67]],[[7206,5159],[-5,73],[-18,60],[4,53],[-7,16],[-2,92],[-26,131],[-3,69],[5,22],[-11,66]],[[5369,5741],[330,-1],[801,0]],[[6500,5740],[0,-545],[0,-37]],[[6500,5740],[173,0],[470,1]],[[6028,2370],[-184,0],[-47,28],[-313,195],[10,41]],[[5558,3453],[309,0],[161,-1]],[[1640,235],[2,-3],[2,1],[4,0],[10,-7],[8,-8],[16,-19],[4,-10],[3,-7],[0,-17],[0,-8],[3,0],[4,3],[2,-3],[2,-4],[-1,-9],[2,-5],[1,-4],[5,-9],[5,-4],[2,-3],[1,-4],[0,-6],[-6,-12],[-4,-3],[-6,-11],[-4,-3],[0,-2],[-4,-1],[-2,-5],[-11,-5],[-4,2],[-2,0],[-2,-2],[-5,-6],[-2,-4],[-3,-2],[-4,-5],[-5,-5],[-1,-1],[-4,-7],[-1,-3],[0,-7],[-4,-10],[-2,-8],[-1,-3],[-4,-6],[-1,1],[0,4],[-2,3],[-4,4],[-7,8],[-5,3],[-2,7],[-1,1],[-1,5],[0,8],[1,10],[2,28],[0,4],[-2,5],[-3,19],[-2,6],[0,4],[-1,4],[-1,10],[-2,5],[-1,2],[-2,4],[-3,12],[2,10],[5,8],[1,4],[1,2],[4,3],[3,8],[2,7],[2,5],[2,0],[1,9],[-1,3],[-2,3],[-3,10],[-1,8],[0,13],[1,7],[2,2],[3,0],[9,-4],[2,-9],[4,-3],[2,-2],[2,-4],[2,-2]],[[1553,310],[-1,-3],[-3,0],[-2,0],[-5,-1],[-3,-1],[-2,4],[1,3],[2,3],[6,6],[2,2],[2,0],[3,-5],[-2,-6],[2,-2]],[[1517,349],[-5,-1],[-1,6],[-1,4],[0,8],[0,4],[-2,2],[-4,3],[-1,4],[1,4],[2,2],[4,1],[9,-3],[4,-7],[3,-7],[1,-5],[0,-4],[-2,-6],[-4,-3],[-4,-2]],[[1548,405],[0,-2],[4,-3],[0,-2],[2,-1],[0,-5],[1,-2],[3,-9],[1,0],[1,3],[2,0],[5,1],[3,4],[2,1],[3,0],[5,-2],[2,-2],[0,-2],[3,-5],[2,-4],[1,-2],[2,1],[1,-2],[1,-4],[3,-1],[3,-3],[5,-3],[2,-8],[0,-7],[-2,-6],[-3,-2],[-1,-5],[-3,0],[-5,-5],[-5,0],[-2,0],[-9,-8],[-5,2],[-1,-1],[-4,0],[-3,4],[-1,5],[0,1],[0,4],[0,12],[-1,4],[0,4],[-1,3],[-2,3],[-3,-2],[0,-2],[-1,-1],[-3,4],[-2,0],[-2,3],[-1,0],[-4,7],[-2,7],[-1,4],[0,2],[0,10],[1,4],[1,3],[1,0],[2,5],[2,-1],[2,2],[1,-1]],[[1485,442],[4,-1],[1,0],[1,-2],[2,0],[13,-4],[4,-1],[1,6],[1,0],[1,-3],[1,-4],[5,-2],[4,0],[2,1],[3,1],[2,0],[3,-1],[1,-2],[3,-1],[-2,-6],[-3,-5],[-4,-4],[-3,-3],[-4,-1],[-3,0],[-4,2],[-7,3],[-5,3],[-11,-1],[-3,-1],[-5,0],[-2,2],[-1,2],[0,4],[2,5],[2,1],[1,4],[1,4],[-2,4],[1,0]],[[1425,514],[0,-4],[1,-1],[1,-3],[1,0],[2,-5],[0,-4],[-1,-1],[1,-9],[2,-1],[1,-5],[2,-1],[1,-2],[1,4],[-1,2],[0,2],[1,1],[4,-1],[-2,-3],[0,-6],[2,-2],[1,-4],[0,-2],[1,-5],[4,-5],[1,-1],[-4,-8],[-1,-1],[-1,3],[-1,1],[-4,-1],[-3,-4],[-2,1],[-1,3],[-5,4],[-1,5],[0,2],[-2,-3],[1,-2],[-4,-1],[0,2],[-2,1],[0,6],[3,3],[0,1],[-3,4],[0,-4],[-3,4],[1,-5],[0,-1],[-3,5],[0,-4],[4,-6],[-1,-3],[-1,-1],[-9,-3],[-2,2],[-1,6],[-1,5],[-2,6],[-2,1],[0,6],[-1,2],[-3,4],[-1,4],[0,9],[-1,2],[-4,6],[4,2],[4,0],[7,0],[1,4],[2,2],[2,4],[0,1],[2,6],[3,5],[3,2],[2,-1],[3,-5],[2,-6],[-1,-4],[3,-5]],[[1207,549],[-1,-1],[-2,3],[-1,7],[0,4],[1,4],[4,7],[3,5],[3,4],[2,5],[-1,3],[2,2],[2,0],[1,-2],[1,-3],[-2,-5],[0,-4],[0,-5],[-1,-3],[-3,-3],[-2,-1],[-3,-5],[-1,-3],[-2,-9]],[[1284,634],[1,-1],[2,0],[1,-2],[1,-3],[2,-2],[1,-7],[1,-1],[0,-7],[-1,-3],[-2,-7],[-1,-1],[0,-6],[0,-7],[0,-5],[-2,-1],[1,-3],[-2,-1],[-2,-2],[0,-3],[-4,-5],[-1,-2],[-4,3],[-5,0],[-4,2],[-1,2],[-2,-2],[0,1],[-2,3],[-2,5],[-1,0],[-1,3],[-2,0],[-3,2],[-3,2],[-1,5],[-2,3],[0,9],[1,1],[4,8],[0,5],[2,3],[4,3],[3,3],[2,3],[2,1],[1,2],[4,2],[1,-2],[3,-2],[0,3],[2,1],[4,0],[2,-1],[2,2],[1,-1]],[[1225,9864],[-7,8],[39,31],[64,-6],[89,12],[78,43],[39,47],[112,-24],[1,-23],[-43,-18],[15,-29],[30,5],[36,53],[57,-24],[-3,-31],[49,-9],[20,22],[56,4],[103,-21],[-40,-48],[85,-1],[-23,-21],[76,-1],[121,14],[82,-5],[60,-34],[21,8],[33,-22],[65,-14],[116,3],[57,-35],[65,-2],[51,19],[71,7],[66,-21],[32,-31],[43,-6],[37,-33],[37,2],[2,-1781],[93,-25],[35,27],[51,2],[-8,-52],[46,-35],[9,-26],[93,-98],[18,-62],[55,46],[22,0],[25,84],[82,39],[42,-49],[-6,-24],[65,-70],[16,-40],[34,-20],[46,-62],[108,-232],[19,-32],[-6,-31],[22,-14],[6,-39],[21,2],[138,-94],[8,-38],[-13,-30],[17,-87],[-35,-73],[-30,-26],[-22,6],[-13,76],[17,27],[-2,71],[-29,50],[-52,-17],[-20,-74],[-28,49],[19,9],[17,79],[-58,74],[-4,29],[-65,80],[-31,1],[20,44],[-26,31],[-7,41],[-35,53],[5,66],[-21,-39],[-12,8],[9,-11],[-34,10],[-4,14],[23,-7],[-33,22],[-55,167],[-2,-65],[31,-110],[-9,-26],[-30,31],[-43,-1],[6,30],[-23,65],[-10,-24],[-78,62],[3,-35],[39,-7],[48,-64],[-2,-35],[-46,4],[-9,-24],[-94,77],[-57,84],[-86,46],[-62,43],[37,34],[-15,33],[-67,-36],[-103,32],[16,28],[-45,-10],[-101,27],[-106,-21],[-30,30],[-65,29],[17,70],[-26,-29],[-8,-40],[-42,27],[-36,1],[30,43],[-60,-5],[-41,17],[18,14],[-22,27],[-50,-12],[-41,11],[-41,-18],[-2,49],[-25,-93],[19,28],[25,-53],[-24,-34],[-21,-68],[-72,9],[-42,-23],[-9,-43],[-16,10],[-46,-53],[17,51],[-44,-75],[-26,-16],[-42,6],[-38,-18],[-17,28],[50,31],[45,57],[-46,-27],[-38,30],[39,75],[18,67],[-14,34],[33,14],[58,46],[39,-22],[20,11],[67,-16],[-90,52],[8,16],[-43,1],[-9,24],[-59,-60],[-39,-13],[-73,-99],[10,-15],[-35,-32],[5,-22],[-47,-78],[-61,-13],[-2,-33],[-38,-16],[-4,-65],[44,7],[40,-45],[-75,-66],[8,-21],[-33,-25],[-22,-44],[-44,-1],[-33,-56],[-20,14],[-13,-47],[-26,6],[-50,-53],[19,3],[-18,-64],[-25,10],[-35,-50],[-22,18],[-4,-43],[-29,8],[-71,-65],[29,-12],[-44,-59],[-78,-38],[-32,16],[-79,-75],[-22,10],[-35,-31],[-21,6],[11,37],[-22,6],[-33,-91],[-31,-28],[-27,61],[-19,-70],[-24,30],[-26,-54],[-1,54],[74,70],[68,80],[90,22],[8,-21],[51,-10],[-32,29],[20,54],[59,59],[76,50],[28,-14],[-3,49],[34,55],[60,49],[17,170],[41,50],[-3,32],[-100,-52],[-38,39],[9,48],[-42,-57],[13,-48],[-27,-19],[-51,93],[-30,-27],[-29,15],[-13,42],[-45,-41],[-42,-13],[-7,-25],[-78,-2],[44,21],[-8,50],[-23,49],[33,43],[-59,116],[-8,53],[-10,-74],[-104,-37],[-46,6],[-1,33],[-52,55],[-30,9],[-42,41],[73,51],[66,-8],[30,-35],[21,32],[-50,19],[-59,-2],[-53,14],[18,17],[-40,38],[0,-28],[-51,63],[13,23],[-40,15],[39,16],[-29,27],[45,4],[-9,52],[54,76],[24,4],[0,57],[27,57],[42,25],[36,-9],[39,-37],[24,5],[47,43],[30,44],[12,-14],[92,13],[37,47],[-18,95],[-43,35],[60,41],[-36,55],[-24,-31],[-62,-9],[-48,-41],[-50,-18],[-38,29],[-82,1],[-61,-23],[-107,26],[-28,27],[9,33],[-53,48],[39,-3],[38,29],[-119,22],[-64,36],[19,30],[55,30],[22,-5],[29,36],[129,69],[81,28],[74,5],[-17,-76],[23,-25],[141,1],[26,-19],[30,53],[55,-5],[-49,34],[-40,-15],[6,28],[-71,80],[28,11],[31,-36],[-7,-19],[46,-42],[37,17],[40,-31],[49,6],[3,24],[-62,26],[-57,-25],[-36,32],[3,67],[-57,-12],[-116,20],[-12,45],[-33,54],[-122,85],[-47,15],[-56,41],[26,40],[1,59],[54,-3],[125,12],[69,38],[47,52],[-5,50],[16,37],[42,50],[19,-10],[43,53],[17,-16],[81,17],[65,51],[15,-1]],[[1225,9864],[5,-5],[-14,-50],[29,35],[-15,15],[1,4],[-6,1]],[[59,6370],[-24,-7],[19,28],[13,-11],[-8,-10]],[[287,6477],[22,5],[-1,-20],[-11,9],[-10,6]],[[429,6502],[-12,8],[-42,-33],[40,81],[16,-6],[5,41],[36,20],[14,-34],[-41,-29],[-16,-48]],[[696,6724],[-25,-22],[-22,16],[14,20],[33,-14]],[[962,6772],[-3,20],[22,-10],[8,-14],[-27,4]],[[872,6899],[17,-2],[20,-55],[-24,-29],[-48,1],[-26,-34],[-42,-2],[-10,31],[24,16],[14,39],[31,3],[44,32]],[[1277,6898],[3,-7],[-22,8],[11,14],[8,-15]],[[3794,6858],[-8,-29],[-35,76],[9,29],[17,-58],[17,-18]],[[3936,6900],[-8,-41],[-28,31],[9,50],[27,-40]],[[1234,6928],[2,-22],[-33,-33],[24,36],[7,19]],[[1195,6963],[-21,-10],[1,-42],[-26,-2],[-3,42],[49,12]],[[3883,6966],[17,-23],[-11,-28],[-11,42],[5,9]],[[3714,6980],[3,-4],[17,6],[-21,-49],[1,47]],[[3742,7042],[-18,-20],[-15,10],[3,13],[30,-3]],[[3940,7067],[23,-47],[-1,-60],[-21,-38],[-58,53],[15,16],[-2,56],[44,20]],[[3692,7058],[14,32],[37,15],[0,-25],[-51,-22]],[[3820,7114],[37,-16],[-20,-36],[-39,37],[18,45],[4,-30]],[[3805,7161],[-1,-30],[-39,12],[13,21],[27,-3]],[[3850,7145],[21,-30],[-12,-15],[-28,30],[1,42],[18,-27]],[[1747,7193],[-1,-16],[-23,-23],[3,25],[21,14]],[[1788,7183],[6,-9],[-34,2],[5,16],[23,-9]],[[3782,7230],[32,-38],[-23,-19],[-15,3],[6,54]],[[1869,7301],[21,0],[-37,-33],[-5,15],[21,18]],[[3528,7314],[-4,-45],[-21,-3],[12,35],[13,13]],[[3457,7461],[-12,-31],[-9,32],[7,16],[14,-17]],[[1866,7478],[30,-20],[-13,0],[-37,13],[20,7]],[[1906,7514],[13,37],[26,-25],[24,9],[14,-30],[-13,-17],[-66,-31],[-35,23],[7,32],[30,2]],[[1935,7551],[-18,13],[28,17],[1,-17],[-11,-13]],[[1148,7583],[-24,-20],[2,29],[35,22],[-13,-31]],[[2369,7855],[-3,-15],[-24,-10],[18,41],[9,-16]],[[2440,7909],[18,-9],[-52,-71],[-41,-27],[20,39],[47,46],[8,22]],[[650,7916],[40,-17],[-4,-45],[17,-26],[-56,-20],[-45,5],[-53,32],[-24,32],[54,4],[7,16],[64,19]],[[2494,7931],[38,-6],[-43,-38],[10,23],[-5,21]],[[2386,7937],[8,-12],[-13,-35],[-11,22],[16,25]],[[44,7916],[-2,-13],[-41,30],[-1,18],[44,-35]],[[2537,7933],[-18,-5],[-1,12],[51,13],[-32,-20]],[[642,6689],[-36,-49],[46,25],[-17,-28],[-112,-71],[-36,-2],[64,32],[13,93],[39,5],[-1,-30],[23,33],[17,-8]],[[3750,6938],[24,70],[-38,-1],[14,49],[-6,53],[-27,4],[-4,31],[42,-3],[10,-53],[30,-11],[61,-137],[13,-94],[-18,-17],[-34,78],[-34,-13],[7,45],[-40,-1]],[[3525,7338],[21,35],[45,-42],[28,-114],[-5,-106],[-49,96],[7,30],[-24,-1],[19,39],[-19,10],[3,30],[-26,23]],[[1900,7449],[-8,-34],[41,37],[13,-32],[-6,-35],[26,2],[-18,-35],[-60,15],[33,-21],[-3,-20],[-45,3],[-51,-58],[-34,-63],[-8,19],[29,70],[-28,-5],[-11,-42],[-28,16],[-1,36],[-23,18],[5,30],[47,47],[21,-8],[11,-44],[7,49],[-11,29],[26,15],[11,-36],[6,53],[37,-27],[-18,33],[40,-12]],[[3507,7412],[24,-58],[-29,-10],[-10,43],[-43,41],[9,29],[48,54],[84,-47],[-1,-41],[-42,-1],[15,-19],[29,10],[8,-53],[-23,-2],[-69,54]],[[3634,7327],[-18,56],[-15,97],[-16,53],[26,-41],[47,-9],[29,-63],[-8,-20],[-24,71],[1,-42],[27,-42],[-1,-59],[-64,-58],[0,42],[16,15]],[[174,8529],[22,-7],[27,22],[33,1],[20,-40],[50,-22],[80,-11],[-10,-26],[-46,4],[-43,-44],[-12,34],[-78,49],[-39,7],[-30,-21],[-28,10],[-10,28],[10,52],[18,-33],[36,-3]],[[3702,7222],[-23,-77],[7,-25],[-29,-30],[-7,56],[23,23],[-25,17],[-9,53],[26,4],[24,-31],[13,12],[-1,7],[-24,50],[22,2],[74,-27],[-1,-63],[-34,44],[25,-57],[-5,-15],[-49,1],[-7,56]]],"bbox":[-173.0093523315348,18.90630573265573,-66.91930887013093,71.31215663572162],"transform":{"scale":[0.010610065352675656,0.005241109201226711],"translate":[-173.0093523315348,18.90630573265573]},"title":"United States of America","version":"2.0.1","copyright":"Copyright (c) 2022 Highsoft AS, Based on data from Natural Earth","copyrightShort":"Natural Earth","copyrightUrl":"http://www.naturalearthdata.com"}`;
    const topology = JSON.parse(topojsonText);

    Highcharts.maps.myMap = topology;

    const chart = Highcharts.mapChart('container', {
            chart: {
                map: 'myMap'
            },
            series: [{
                data: [{
                    'hc-key': 'us-nv',
                    value: 1,
                    id: 'nevada'
                }]
            }]
        }),
        point = chart.get('nevada'),
        screenReaderInfo = chart.accessibility.components
            .infoRegions.screenReaderSections.before.element.textContent;

    const controller = new TestController(chart);

    // #17925 - Reproduction of the action sequence: zoom, click and pinch
    chart.mapZoom(0.6);

    controller.click(
        chart.series[0].data[0].plotX + chart.plotLeft - 20,
        chart.series[0].data[0].plotY + chart.plotTop - 20,
        {},
        false
    );

    controller.pinch(
        chart.series[0].data[0].plotX + chart.plotLeft - 20,
        chart.series[0].data[0].plotY + chart.plotTop - 20,
        10,
        false
    );

    assert.ok(
        !isNaN(chart.mapView.center[0]),
        'The center should not be NaN, #17925.'
    );

    assert.ok(
        point.name === 'Nevada' && point.value === 1,
        'TopoJSON should correctly load map and contain data.'
    );
    assert.ok(
        screenReaderInfo.indexOf('America') > 0,
        'TopoJSON title should be accessible with a11y module loaded.'
    );

    // Zoom to inset point
    chart.series[0].data[50].zoomTo(); // Alaska inset

    assert.close(
        chart.mapView.center[0],
        -114.29,
        3,
        'Center X: Map should zoom to inset point.'
    );
    assert.close(
        chart.mapView.center[1],
        27.91,
        3,
        'Center Y: Map should zoom to inset point.'
    );

    assert.ok(
        chart.series[0].group.getBBox().width > 0,
        `#18590 - TopoJSON map should render from
        Highcharts.maps if string given.`
    );
    assert.ok(
        chart.series[0].group.getBBox().height > 0,
        `#18590 - TopoJSON map should render from
        Highcharts.maps if string given.`
    );
});
