QUnit.test('Range selector buttons states (#3375)', function (assert) {
    const data = [
        [1317888000000, 372.5101, 375, 372.2, 372.52],
        [1317888060000, 372.4, 373, 372.01, 372.16],
        [1317888120000, 372.16, 372.4, 371.39, 371.62],
        [1317888180000, 371.62, 372.16, 371.55, 371.75],
        [1317888240000, 371.75, 372.4, 371.57, 372],
        [1317888300000, 372, 372.3, 371.8, 372.24],
        [1317888360000, 372.22, 372.45, 372.22, 372.3],
        [1317888420000, 372.3, 373.25, 372.3, 373.15],
        [1317888480000, 373.01, 373.5, 373, 373.24],
        [1317888540000, 373.36, 373.88, 373.19, 373.88],
        [1317888600000, 373.8, 374.34, 373.75, 374.29],
        [1317888660000, 374.29, 374.43, 374, 374.01],
        [1317888720000, 374.05, 374.35, 373.76, 374.35],
        [1317888780000, 374.41, 375.24, 374.37, 374.9],
        [1317888840000, 374.83, 375.73, 374.81, 374.96],
        [1317888900000, 374.81, 375.4, 374.81, 375.25],
        [1317888960000, 375.2, 375.7, 375.14, 375.19],
        [1317889020000, 375.43, 375.43, 374.75, 374.76],
        [1317889080000, 374.94, 375.5, 374.81, 375.13],
        [1317889140000, 375.12, 375.48, 375, 375.04],
        [1317889200000, 375.24, 375.24, 375, 375.08],
        [1317889260000, 375.16, 375.16, 374.51, 374.51],
        [1317889320000, 374.51, 374.75, 374.2, 374.27],
        [1317889380000, 374.22, 374.55, 373.83, 374.55],
        [1317889440000, 374.69, 374.86, 374.01, 374.2],
        [1317889500000, 374.32, 374.65, 374.31, 374.51],
        [1317889560000, 374.65, 375.12, 374.51, 375.12],
        [1317889620000, 375.13, 375.25, 374.83, 375.22],
        [1317889680000, 375.16, 375.22, 375, 375],
        [1317889740000, 375, 375, 374.66, 374.8],
        [1317889800000, 374.88, 375, 374.5, 374.85],
        [1317889860000, 374.41, 374.67, 374.25, 374.67],
        [1317889920000, 374.5, 374.75, 374.27, 374.42],
        [1317889980000, 374.4, 374.93, 374.38, 374.85],
        [1317890040000, 374.86, 375.3, 374.8, 375.09],
        [1317890100000, 375, 375.18, 374.9, 375.02],
        [1317890160000, 375.02, 375.08, 374.86, 374.87],
        [1317890220000, 374.93, 375.75, 374.93, 375.75],
        [1317890280000, 375.75, 376.5, 375.75, 376.31],
        [1317890340000, 376.31, 377.2, 376.19, 377.04],
        [1317890400000, 377.2, 377.33, 376.45, 376.47],
        [1317890460000, 376.75, 376.99, 376.53, 376.54],
        [1317890520000, 376.54, 376.67, 376.08, 376.35],
        [1317890580000, 376.41, 376.94, 376.2, 376.5],
        [1317890640000, 376.46, 376.51, 376.06, 376.09],
        [1317890700000, 376.38, 376.84, 376.09, 376.78],
        [1317890760000, 376.55, 376.6, 376.41, 376.44],
        [1317890820000, 376.45, 376.87, 376.31, 376.87],
        [1317890880000, 376.83, 377, 376.63, 376.95],
        [1317890940000, 376.95, 377, 376.1, 376.1],
        [1317891000000, 376.1, 376.17, 375.64, 375.65],
        [1317891060000, 375.68, 376.05, 375.32, 376.05],
        [1317891120000, 376.03, 376.04, 375.5, 375.72],
        [1317891180000, 375.83, 376.195, 375.7, 376],
        [1317891240000, 376.01, 376.6, 376, 376.5],
        [1317891300000, 376.5, 376.53, 376.11, 376.21],
        [1317891360000, 376.17, 376.3, 376.1, 376.25],
        [1317891420000, 376.4, 376.4, 376.13, 376.29],
        [1317891480000, 376.15, 376.39, 376.1, 376.39],
        [1317891540000, 376.4, 377.11, 376.4, 377],
        [1317891600000, 377.01, 377.15, 376.79, 377.15],
        [1317891660000, 377.02, 377.15, 376.55, 376.88],
        [1317891720000, 376.67, 376.76, 376.52, 376.53],
        [1317891780000, 376.78, 376.91, 376.53, 376.82],
        [1317891840000, 376.73, 376.86, 376.7, 376.75],
        [1317891900000, 376.7, 376.71, 376.5, 376.57],
        [1317891960000, 376.53, 376.74, 376.2, 376.2],
        [1317892020000, 376.17, 376.17, 375.91, 376],
        [1317892080000, 376, 376, 375.77, 375.77],
        [1317892140000, 375.78, 375.88, 375.51, 375.57],
        [1317892200000, 375.57, 375.79, 375.34, 375.63],
        [1317892260000, 375.63, 375.78, 375.35, 375.41],
        [1317892320000, 375.38, 375.61, 375.35, 375.58],
        [1317892380000, 375.55, 375.57, 375.34, 375.48],
        [1317892440000, 375.43, 375.57, 375.12, 375.13],
        [1317892500000, 375.15, 375.3, 374.86, 375],
        [1317892560000, 374.9, 375.31, 374.72, 375.14],
        [1317892620000, 375, 375.2, 374.9, 375.06],
        [1317892680000, 375.18, 375.6, 375.12, 375.6],
        [1317892740000, 375.6, 375.87, 375.5, 375.5],
        [1317892800000, 375.49, 375.49, 375.04, 375.25],
        [1317892860000, 375.25, 375.46, 375, 375.24],
        [1317892920000, 375.38, 375.45, 375, 375.1],
        [1317892980000, 375.09, 375.24, 374.83, 374.97],
        [1317893040000, 375.01, 375.01, 374.8, 374.87],
        [1317893100000, 374.98, 375.12, 374.98, 375],
        [1317893160000, 374.9, 374.95, 374.75, 374.87],
        [1317893220000, 374.89, 375.44, 374.87, 375.12],
        [1317893280000, 375.06, 375.12, 373.56, 374.05],
        [1317893340000, 374.1, 374.3, 373.16, 373.21],
        [1317893400000, 373.39, 375, 372.58, 374.8],
        [1317893460000, 374.899, 375.23, 374.33, 374.75],
        [1317893520000, 374.79, 376.71, 374.69, 376.31],
        [1317893580000, 376.32, 376.37, 375.27, 375.331],
        [1317893640000, 375.3301, 377.44, 375.33, 377.43],
        [1317893700000, 377.43, 378.14, 376.83, 377.08],
        [1317893760000, 377.18, 378, 376.5, 376.7],
        [1317893820000, 376.83, 377, 375.51, 375.79],
        [1317893880000, 375.6501, 376.74, 375.23, 376.39],
        [1317893940000, 376.38, 378.75, 376.25, 378.5],
        [1317894000000, 378.54, 378.63, 376.75, 376.87],
        [1317894060000, 376.8664, 377.62, 376.64, 376.908],
        [1317894120000, 376.8336, 377.88, 376.8289, 377.55],
        [1317894180000, 377.36, 377.9, 376.52, 376.75],
        [1317894240000, 376.83, 377.73, 376.71, 376.98],
        [1317894300000, 377, 377.69, 376.87, 377.1212],
        [1317894360000, 377.225, 377.33, 376.01, 376.26],
        [1317894420000, 376.42, 376.64, 375.55, 375.5534],
        [1317894480000, 375.74, 375.94, 374.77, 375.3],
        [1317894540000, 375.3313, 376, 374.92, 375.06],
        [1317894600000, 375.11, 375.46, 374.82, 374.92],
        [1317894660000, 374.82, 375.68, 374.64, 375.668],
        [1317894720000, 375.62, 376.13, 375.46, 376.13],
        [1317894780000, 376.14, 376.6, 375.89, 376.34],
        [1317894840000, 376.39, 376.39, 375.55, 375.99],
        [1317894900000, 376, 376.28, 375.42, 376.21],
        [1317894960000, 376, 377.38, 375.7, 376.591],
        [1317895020000, 376.59, 377.46, 376.57, 376.9348],
        [1317895080000, 376.9481, 377.749, 376.84, 377.563],
        [1317895140000, 377.452, 377.65, 376.43, 376.78],
        [1317895200000, 376.94, 377.01, 375.75, 375.98]
    ];

    const chart = Highcharts.stockChart('container', {
        rangeSelector: {
            buttons: [{
                type: 'hour',
                count: 1,
                text: '1h'
            }, {
                type: 'hour',
                count: 2,
                text: '2h'
            }, {
                type: 'day',
                count: 1,
                text: '1D'
            }, {
                type: 'all',
                count: 1,
                text: 'All'
            }],
            inputEnabled: false,
            selected: 2
        },
        series: [{
            data: data
        }]
    });

    /**
     * Get a string representation of the states.
     * 0 = Normal
     * 1 = Hover
     * 2 = Selected
     * 3 = Disabled
     */
    function getStates() {
        return chart.rangeSelector.buttons
            .map(function (button) {
                return button.state || 0;
            })
            .join(',');
    }

    assert.strictEqual(
        getStates(),
        '0,0,3,0',
        'Initial state. If selected range is greater than data, all should ' +
        'be selected (#19922).'
    );

    chart.rangeSelector.clickButton(1);
    assert.strictEqual(getStates(), '0,2,3,0', 'Selected 2h');

    chart.rangeSelector.clickButton(0);
    assert.strictEqual(getStates(), '2,0,3,0', 'Selected 1h');

    chart.rangeSelector.clickButton(3);
    assert.strictEqual(getStates(), '0,0,3,2', 'Selected All');

    chart.rangeSelector.clickButton(1);
    assert.strictEqual(getStates(), '0,2,3,0', 'Selected 2h');

    chart.rangeSelector.clickButton(2);
    assert.strictEqual(
        chart.fixedRange,
        chart.xAxis[0].dataMax - chart.xAxis[0].dataMin,
        'chart.fixedRange should be equal to maximum range if the clicked ' +
        'button is outside data range, #20327'
    );

    // #19808
    const ordinalData = [
        [1706227200000, 2],    // 26.01
        [1706505600000, 1],    // 29.01
        [1706592000000, 3],    // 30.01
        [1706678400000, 1],    // 31.01
        [1706764800000, 2],    // 01.02
        [1706851200000, 1],    // 02.02
        [1707123200000, 3]     // 05.02
    ];
    chart.update({
        rangeSelector: {
            buttons: [{
                type: 'week',
                count: 1,
                text: 'Week'
            }]
        },
        series: [{
            data: ordinalData
        }],
        xAxis: {
            minRange: 1
        }
    });
    chart.xAxis[0].setExtremes(1706592000000, 1706764800000);
    assert.strictEqual(
        getStates(),
        '0', 'Week button should not be selected, #19808.'
    );

    chart.series[0].setData([
        [1706227200000, 2],    // 26.01
        [1706505600000, 1],    // 29.01
        [1706678400000, 1],    // 31.01
        [1706764800000, 2],    // 01.02
        [1707123200000, 3]     // 05.02
    ]);
    assert.strictEqual(
        getStates(),
        '2', 'Week button should be selected, #19808.'
    );
});
