QUnit.test(
    'Check tooltip position for different axis options (#6327).',
    function (assert) {
        var chart = Highcharts.chart('container', {
                yAxis: [
                    {
                        top: 40,
                        height: 100
                    },
                    {
                        top: 200,
                        height: 80
                    }
                ],
                tooltip: {
                    split: true,
                    formatter() {
                        return 'abc';
                    }
                },
                series: [
                    {
                        data: [1, 2, 3],
                        id: 's1'
                    },
                    {
                        data: [1, 2, 3],
                        id: 's2',
                        yAxis: 1
                    },
                    {
                        type: 'flags',
                        onSeries: 's1',
                        data: [
                            {
                                x: 1,
                                title: 'B'
                            }
                        ]
                    },
                    {
                        type: 'flags',
                        onSeries: 's2',
                        data: [
                            {
                                x: 1,
                                title: 'L'
                            }
                        ],
                        yAxis: 1
                    }
                ]
            }),
            yAxis0 = chart.yAxis[0],
            yAxis1 = chart.yAxis[1],
            ser0 = chart.series[2],
            ser1 = chart.series[3],
            flag0 = ser0.points[0],
            flag1 = ser1.points[0],
            controller = new TestController(chart);

        assert.strictEqual(
            flag0.tooltipPos[1],
            flag0.plotY + yAxis0.pos - chart.plotTop + ser0.options.y,
            'Tooltip will be correctly placed for the top flag'
        );
        assert.strictEqual(
            flag1.tooltipPos[1],
            flag1.plotY + yAxis1.pos - chart.plotTop + ser0.options.y,
            'Tooltip will be correctly placed for the bottom flag'
        );

        yAxis1.update({
            max: 2.5,
            endOnTick: false
        });

        // Skip this test for IE, where clip-paths are removed
        if (
            TestUtilities.browser !== 'Edge' &&
            TestUtilities.browser !== 'MSIE'
        ) {
            controller.mouseOver(
                chart.series[1].points[1].plotX + yAxis1.left,
                chart.series[1].points[1].plotY + yAxis1.top - 20
            );

            assert.strictEqual(
                chart.tooltip.isHidden,
                true,
                'Flag clipped (#8546).'
            );

            controller.mouseMove(
                chart.series[0].points[0].plotX + yAxis0.left,
                chart.series[0].points[0].plotY + yAxis0.top - 25
            );

            controller.mouseOver(
                flag0.plotX + yAxis0.left + 4,
                flag0.plotY + yAxis0.top - 25
            );

            controller.moveTo(0, 0);
            controller.mouseMove(
                chart.series[0].points[0].plotX + yAxis0.left,
                chart.series[0].points[0].plotY + yAxis0.top - 25
            );

            assert.notEqual(
                chart.tooltip.label.element.getBBox().width,
                0,
                'Tooltip should show up (#17565).'
            );

            assert.notEqual(
                chart.tooltip.label.element.getBBox().height,
                0,
                'Tooltip should show up (#17565).'
            );
        }
        // Empty shared tooltip visible, when text is not defined in flag
        // point, #6332
        chart.tooltip.update({ split: true });

        chart.tooltip.refresh(chart.series[2].points[0]);
        assert.ok(
            chart.tooltip.label.hasClass('highcharts-label'),
            'The flags tooltip should not be split'
        );
    });
