QUnit.test('SplineSeries.getPointSpline (#4918)', function (assert) {
    var getPointSpline =
            Highcharts.Series.types.spline.prototype.getPointSpline,
        segment = [
            {
                plotX: -5,
                plotY: 10
            },
            {
                plotX: 240,
                plotY: 250
            },
            {
                plotX: 510,
                plotY: 0
            }
        ];

    const mockSeries = {
        chart: {
            polar: false
        }
    };

    function pathToString(arr) {
        return arr.join(' ');
    }

    assert.strictEqual(
        pathToString(getPointSpline.call(mockSeries, segment, segment[1], 1)),
        pathToString(['C', -5, 10, 142, 250, 240, 250]),
        'Path to point.1 is correct'
    );
    assert.strictEqual(
        pathToString(getPointSpline.call(mockSeries, segment, segment[2], 2)),
        pathToString(['C', 348, 250, 510, 0, 510, 0]),
        'Path to point.2 is correct'
    );
});

QUnit.test('Spline with equal X (#5016)', function (assert) {
    var chart = Highcharts.chart('container', {
        chart: {
            type: 'spline'
        },
        xAxis: {
            type: 'datetime'
        },
        series: [
            {
                data: [
                    [1436898720000, 0.055],
                    [1436898720000, 0.14],
                    [1436900100000, 0.32],
                    [1436901780000, 0.48],
                    [1436908560000, 0.64],
                    [1436951760000, 0.81],
                    [1436954400000, 1.01],
                    [1436961720000, 0.959],
                    [1436961780000, 0.954],
                    [1436962860000, 0.897],
                    [1436963040000, 0.861],
                    [1436974740000, 0.975],
                    [1436974800000, 1.057],
                    [1436977680000, 1.019],
                    [1436977680000, 1.025],
                    [1436978040000, 1.104],
                    [1436978160000, 1.203],
                    [1436978280000, 1.343],
                    [1436979000000, 1.503],
                    [1436981100000, 1.603],
                    [1436981460000, 1.733],
                    [1436982840000, 1.821],
                    [1436982840000, 2.021],
                    [1436988060000, 2.011],
                    [1436988120000, 2.051],
                    [1436988120000, 2.251],
                    [1436988420000, 2.271],
                    [1436989020000, 2.331],
                    [1437018060000, 2.391],
                    [1437036840000, 2.571],
                    [1437043020000, 2.415],
                    [1437045000000, 2.297],
                    [1437045060000, 2.199],
                    [1437045420000, 2.084],
                    [1437047100000, 2.194],
                    [1437047520000, 2.224],
                    [1437049920000, 2.289],
                    [1437050760000, 2.337],
                    [1437051540000, 2.422],
                    [1437060840000, 2.472],
                    [1437060900000, 2.572],
                    [1437067200000, 2.527],
                    [1437067200000, 2.519],
                    [1437102060000, 2.294],
                    [1437103440000, 2.093],
                    [1437138060000, 2.192],
                    [1437142260000, 2.368],
                    [1437142320000, 2.564],
                    [1437144000000, 2.683],
                    [1437144960000, 2.805],
                    [1437145260000, 2.973],
                    [1437164520000, 2.673],
                    [1437164580000, 2.143],
                    [1437164580000, 1.923],
                    [1437379680000, 1.733],
                    [1437385020000, 1.243],
                    [1437387780000, 0.662],
                    [1437387840000, 0.118],
                    [1437402180000, 0.214],
                    [1437402540000, 0.351],
                    [1437403140000, 0.412],
                    [1437403140000, 0.519],
                    [1437405960000, 0.579],
                    [1437406500000, 0.569],
                    [1437406620000, 0.609],
                    [1437409260000, 0.17],
                    [1437409800000, -0.226],
                    [1437413700000, -0.168],
                    [1437413820000, -0.09],
                    [1437413880000, -0.079],
                    [1437414720000, -0.026],
                    [1437414840000, -0.056],
                    [1437419460000, 0.124],
                    [1437423840000, 0.275],
                    [1437423840000, 0.475],
                    [1437473220000, 0.428],
                    [1437475380000, 0.401],
                    [1437485760000, 0.451],
                    [1437486420000, 0.373],
                    [1437487920000, 0.333],
                    [1437490500000, 0.346],
                    [1437490980000, 0.396],
                    [1437493860000, 0.276],
                    [1437495360000, 0.33],
                    [1437495960000, 0.53],
                    [1437497100000, 0.616],
                    [1437499560000, 0.549],
                    [1437499560000, 0.124],
                    [1437499620000, 0.107],
                    [1437500220000, -0.277],
                    [1437504120000, -0.207],
                    [1437505140000, -0.166],
                    [1437505140000, -0.054],
                    [1437506460000, -0.15],
                    [1437506520000, -0.206],
                    [1437510000000, -0.086],
                    [1437510540000, 0.064],
                    [1437510540000, 0.264],
                    [1437510720000, 0.384],
                    [1437511620000, 0.544],
                    [1437514440000, 0.724],
                    [1437514620000, 0.924],
                    [1437515340000, 1.094],
                    [1437561540000, 0.954],
                    [1437561540000, 0.861],
                    [1437570000000, 0.54],
                    [1437576420000, 0.676],
                    [1437576900000, 0.833],
                    [1437579180000, 0.998],
                    [1437582540000, 0.928],
                    [1437582540000, 0.898],
                    [1437582540000, 0.998],
                    [1437582540000, 1.038],
                    [1437582600000, 1.218],
                    [1437582600000, 1.418],
                    [1437582600000, 1.039],
                    [1437582600000, 0.522],
                    [1437582600000, 0.062],
                    [1437582780000, 0.054],
                    [1437582780000, 0.084], // cut here
                    [1437583080000, 0.049],
                    [1437583080000, 0.249],
                    [1437583980000, 0.378],
                    [1437584100000, 0.527],
                    [1437584400000, 0.68],
                    [1437584760000, 0.819],
                    [1437588300000, 1.019],
                    [1437596580000, 1.192],
                    [1437596700000, 1.12],
                    [1437596700000, 1.087],
                    [1437596700000, 0.856],
                    [1437638220000, 1.018],
                    [1437642180000, 0.848],
                    [1437642780000, 0.608],
                    [1437643800000, 0.388],
                    [1437647520000, 0.399],
                    [1437647580000, 0.448],
                    [1437648780000, 0.615],
                    [1437649860000, 0.425],
                    [1437654360000, 0.605],
                    [1437663900000, 0.624],
                    [1437665100000, 0.584],
                    [1437665100000, 0.573],
                    [1437665460000, 0.513],
                    [1437666000000, 0.473],
                    [1437667140000, 0.436],
                    [1437668280000, 0.506],
                    [1437668520000, 0.616],
                    [1437668760000, 0.796],
                    [1437677460000, 0.823],
                    [1437683520000, 0.823],
                    [1437683700000, 0.853],
                    [1437686940000, 1.033],
                    [1437734100000, 0.821],
                    [1437734100000, 0.316],
                    [1437734100000, -0.148],
                    [1437734700000, -0.34],
                    [1437738240000, -0.207],
                    [1437738960000, -0.175],
                    [1437747540000, -0.385],
                    [1437751500000, -0.245],
                    [1437751500000, -0.065],
                    [1437751920000, 0.039],
                    [1437752160000, 0.185],
                    [1437754680000, 0.005],
                    [1437754680000, 0.055],
                    [1437759420000, -0.131],
                    [1437759540000, 0.009],
                    [1437761040000, -0.127],
                    [1437761580000, 0.007],
                    [1437761640000, 0.161],
                    [1437764580000, 0.321],
                    [1437767700000, 0.452],
                    [1437767940000, 0.34],
                    [1437768060000, 0.276],
                    [1437768060000, 0.449],
                    [1437984960000, 0.583],
                    [1437991620000, 0.763],
                    [1437991680000, 0.926],
                    [1437991740000, 1.11],
                    [1437995760000, 1.21],
                    [1437995880000, 1.32],
                    [1438017060000, 1.483],
                    [1438020660000, 1.283],
                    [1438026840000, 1.453],
                    [1438027800000, 1.633],
                    [1438028280000, 1.816],
                    [1438033500000, 1.438],
                    [1438052400000, 1.586],
                    [1438083120000, 1.526],
                    [1438083360000, 1.146],
                    [1438085580000, 1.063],
                    [1438086900000, 0.963],
                    [1438091520000, 1.123],
                    [1438092120000, 1.323],
                    [1438096920000, 1.402],
                    [1438097160000, 0.996],
                    [1438102380000, 0.974],
                    [1438104360000, 0.954],
                    [1438104420000, 0.604],
                    [1438104480000, 0.624],
                    [1438104540000, 0.636],
                    [1438105740000, 0.629],
                    [1438105800000, 0.663],
                    [1438105860000, 0.44],
                    [1438107420000, 0.573],
                    [1438107600000, 0.737],
                    [1438108680000, 0.787],
                    [1438108800000, 0.907],
                    [1438115280000, 1.077],
                    [1438122720000, 1.097],
                    [1438141740000, 0.747],
                    [1438151700000, 0.889],
                    [1438160940000, 1.067],
                    [1438162320000, 1.184],
                    [1438174020000, 1.184],
                    [1438175280000, 1.234],
                    [1438177980000, 0.923],
                    [1438178460000, 1.065],
                    [1438180440000, 1.257],
                    [1438181400000, 0.975],
                    [1438184940000, 0.978],
                    [1438187340000, 1.028],
                    [1438187340000, 1.118],
                    [1438187820000, 1.237],
                    [1438187820000, 1.391],
                    [1438192920000, 1.571],
                    [1438193100000, 1.731],
                    [1438193580000, 1.873],
                    [1438193580000, 2.036],
                    [1438200420000, 1.886],
                    [1438207980000, 1.756],
                    [1438247100000, 1.885],
                    [1438247640000, 2.05],
                    [1438250520000, 2.12],
                    [1438251360000, 2.25],
                    [1438259520000, 2.323],
                    [1438259520000, 2.265],
                    [1438268100000, 2.215],
                    [1438268280000, 2.205],
                    [1438272180000, 2.245],
                    [1438275300000, 2.285],
                    [1438277280000, 2.405],
                    [1438277400000, 2.565],
                    [1438283880000, 2.678],
                    [1438284960000, 2.848],
                    [1438287720000, 2.968],
                    [1438288140000, 2.951],
                    [1438288140000, 3.105],
                    [1438290540000, 3.135],
                    [1438326660000, 3.295],
                    [1438330080000, 3.382],
                    [1438330200000, 3.393],
                    [1438332300000, 3.493],
                    [1438332780000, 3.569],
                    [1438333620000, 3.599],
                    [1438335840000, 3.769],
                    [1438335840000, 3.92],
                    [1438335900000, 4.099],
                    [1438342860000, 4.169],
                    [1438348440000, 4.159],
                    [1438348440000, 4.119],
                    [1438353240000, 4.209],
                    [1438355160000, 4.399],
                    [1438359120000, 4.359],
                    [1438359360000, 4.339],
                    [1438369560000, 3.65],
                    [1438369680000, 2.982],
                    [1438371060000, 3.078],
                    [1438372320000, 3.228],
                    [1438372560000, 3.387],
                    [1438372560000, 3.587],
                    [1438372740000, 3.707],
                    [1438372740000, 3.877],
                    [1438374420000, 3.845],
                    [1438374480000, 3.975],
                    [1438374480000, 4.125],
                    [1438377180000, 4.255],
                    [1438377780000, 4.405],
                    [1438378740000, 4.565],
                    [1438597440000, 4.718],
                    [1438599600000, 4.683],
                    [1438599840000, 4.668],
                    [1438614540000, 4.82],
                    [1438622820000, 4.143],
                    [1438622880000, 3.503],
                    [1438622940000, 3.332],
                    [1438622940000, 2.781],
                    [1438624560000, 2.321],
                    [1438625040000, 1.911],
                    [1438626240000, 1.471],
                    [1438629540000, 1.182],
                    [1438629960000, 1.341],
                    [1438630200000, 1.095],
                    [1438630260000, 1.274],
                    [1438632900000, 1.184],
                    [1438633080000, 1.124],
                    [1438633080000, 1.194],
                    [1438633500000, 1.329],
                    [1438633560000, 1.503],
                    [1438635300000, 1.593],
                    [1438640160000, 1.75],
                    [1438667520000, 1.87],
                    [1438679580000, 2.05],
                    [1438683540000, 2.04],
                    [1438683660000, 2.1],
                    [1438683660000, 2.22],
                    [1438683720000, 2.38],
                    [1438684320000, 2.423],
                    [1438684560000, 2.487],
                    [1438686540000, 2.597],
                    [1438687440000, 2.725],
                    [1438697340000, 2.795],
                    [1438698360000, 2.924],
                    [1438698420000, 3.107],
                    [1438698480000, 2.953],
                    [1438698660000, 3.065],
                    [1438698840000, 2.95],
                    [1438702140000, 3.01],
                    [1438702140000, 3.13],
                    [1438703280000, 3.212],
                    [1438703640000, 3.402],
                    [1438704540000, 3.543],
                    [1438704840000, 3.653],
                    [1438710540000, 3.624],
                    [1438711680000, 3.741],
                    [1438711800000, 3.76],
                    [1438712760000, 3.92],
                    [1438713240000, 3.92],
                    [1438713840000, 3.94],
                    [1438720260000, 3.852],
                    [1438720380000, 3.81],
                    [1438720380000, 3.671],
                    [1438720380000, 3.577],
                    [1438727640000, 3.547],
                    [1438729020000, 3.7],
                    [1438745100000, 3.72],
                    [1438767660000, 3.88],
                    [1438769340000, 3.93],
                    [1438769340000, 3.99],
                    [1438770720000, 4.03],
                    [1438770780000, 4.182],
                    [1438787460000, 4.192],
                    [1438787760000, 4.242],
                    [1438787760000, 4.312],
                    [1438789020000, 4.422],
                    [1438792440000, 4.31],
                    [1438792620000, 4.254],
                    [1438792680000, 4.361],
                    [1438795980000, 4.31],
                    [1438796100000, 4.296],
                    [1438796640000, 4.456],
                    [1438796640000, 4.597],
                    [1438796820000, 4.717],
                    [1438796940000, 4.857],
                    [1438797060000, 5.037],
                    [1438797060000, 5.157],
                    [1438797060000, 5.337],
                    [1438797120000, 5.445],
                    [1438797300000, 5.595],
                    [1438804140000, 5.685],
                    [1438804200000, 5.795],
                    [1438804980000, 5.925],
                    [1438805220000, 6.065],
                    [1438806480000, 6.232],
                    [1438806480000, 6.407],
                    [1438806480000, 6.607],
                    [1438807740000, 6.746],
                    [1438870440000, 6.746],
                    [1438870620000, 6.856],
                    [1438871760000, 6.888],
                    [1438871820000, 6.956],
                    [1438878120000, 7.086],
                    [1438878600000, 7.256],
                    [1438881240000, 6.996],
                    [1438881600000, 6.776],
                    [1438890660000, 6.866],
                    [1438890720000, 7.016],
                    [1438892820000, 6.699],
                    [1438892940000, 6.423],
                    [1438943160000, 6.37],
                    [1438943640000, 6.359],
                    [1438944180000, 6.483],
                    [1438944780000, 6.647],
                    [1438945800000, 6.757],
                    [1438945860000, 6.907],
                    [1438946160000, 6.837],
                    [1438946340000, 6.757],
                    [1438948200000, 6.901],
                    [1438948560000, 7.081],
                    [1438957860000, 7.071],
                    [1438961340000, 6.134],
                    [1438961400000, 5.242],
                    [1438961580000, 5.147],
                    [1438962540000, 5.099],
                    [1438964220000, 5.235],
                    [1438964820000, 5.419],
                    [1438966860000, 5.57],
                    [1438967520000, 5.717],
                    [1438967640000, 5.904],
                    [1438967820000, 6.095],
                    [1438968780000, 6.255],
                    [1438969680000, 6.455],
                    [1438971180000, 6.495],
                    [1438971600000, 6.585],
                    [1438979400000, 6.648],
                    [1438979460000, 6.751],
                    [1438982220000, 6.781],
                    [1438982520000, 6.602],
                    [1438982520000, 6.443],
                    [1439177580000, 6.212],
                    [1439179860000, 6.016],
                    [1439198640000, 6.098],
                    [1439199540000, 6.224],
                    [1439203620000, 5.909],
                    [1439203620000, 5.624],
                    [1439213160000, 5.574],
                    [1439215680000, 5.474],
                    [1439216160000, 5.414],
                    [1439219220000, 5.422],
                    [1439219280000, 5.45],
                    [1439219280000, 5.058],
                    [1439220840000, 4.712],
                    [1439221560000, 4.882],
                    [1439226480000, 4.514],
                    [1439226480000, 4.182],
                    [1439226480000, 4.34],
                    [1439228580000, 4.366],
                    [1439230680000, 4.507],
                    [1439232660000, 4.579],
                    [1439232840000, 4.739],
                    [1439238300000, 4.848],
                    [1439238300000, 5.01],
                    [1439238420000, 5.049],
                    [1439238420000, 5.135],
                    [1439276340000, 5.191],
                    [1439288880000, 5.101],
                    [1439288880000, 4.841],
                    [1439290740000, 4.97],
                    [1439291400000, 5.119],
                    [1439292300000, 5.079],
                    [1439295480000, 5.072],
                    [1439301720000, 5.11],
                    [1439302080000, 5.165],
                    [1439303520000, 5.319],
                    [1439303520000, 5.519],
                    [1439305140000, 5.359],
                    [1439305200000, 5.451],
                    [1439306880000, 5.521],
                    [1439306880000, 5.611],
                    [1439306880000, 5.701],
                    [1439314020000, 5.821],
                    [1439314140000, 5.961],
                    [1439322300000, 6.111],
                    [1439322300000, 6.311],
                    [1439323320000, 5.991],
                    [1439323320000, 5.679],
                    [1439350140000, 5.814],
                    [1439355480000, 5.714],
                    [1439372580000, 5.874],
                    [1439373360000, 6.044],
                    [1439375400000, 6.174],
                    [1439375400000, 6.074],
                    [1439375400000, 6.014],
                    [1439375460000, 5.894],
                    [1439375460000, 5.804],
                    [1439375580000, 5.708],
                    [1439375640000, 5.611],
                    [1439375640000, 5.707],
                    [1439375640000, 5.84],
                    [1439379000000, 5.964],
                    [1439379300000, 6.144],
                    [1439384580000, 6.294],
                    [1439385420000, 6.484],
                    [1439386860000, 6.664],
                    [1439391060000, 6.764],
                    [1439391120000, 6.914],
                    [1439391180000, 7.054],
                    [1439392680000, 7.134],
                    [1439392740000, 7.264],
                    [1439396760000, 7.31],
                    [1439397000000, 7.392],
                    [1439397300000, 7.438],
                    [1439397300000, 7.529],
                    [1439399340000, 7.659],
                    [1439399940000, 6.498],
                    [1439400420000, 6.628],
                    [1439400540000, 6.608],
                    [1439401440000, 6.628],
                    [1439401440000, 6.788],
                    [1439403300000, 6.948],
                    [1439403300000, 7.128],
                    [1439403660000, 7.328],
                    [1439404320000, 7.439],
                    [1439404560000, 7.57],
                    [1439404980000, 6.355],
                    [1439407140000, 6.535],
                    [1439409660000, 6.675],
                    [1439410380000, 6.455],
                    [1439410380000, 6.309],
                    [1439410500000, 6.006],
                    [1439410500000, 5.723],
                    [1439412060000, 5.893],
                    [1439447940000, 5.916],
                    [1439465100000, 5.808],
                    [1439465460000, 5.739],
                    [1439475540000, 5.835],
                    [1439475720000, 5.951],
                    [1439476500000, 5.948],
                    [1439478360000, 6.018],
                    [1439479320000, 6.088],
                    [1439482500000, 6.079],
                    [1439482560000, 6.129],
                    [1439482980000, 6.259],
                    [1439482980000, 6.439],
                    [1439484360000, 6.568],
                    [1439485080000, 6.372],
                    [1439485080000, 6.384],
                    [1439485080000, 6.467],
                    [1439485320000, 6.313],
                    [1439486700000, 6.48],
                    [1439493120000, 6.448],
                    [1439493360000, 6.45],
                    [1439506620000, 6.609],
                    [1439534400000, 6.663],
                    [1439539080000, 6.692],
                    [1439543880000, 6.757],
                    [1439553660000, 6.78],
                    [1439553720000, 6.84],
                    [1439560020000, 6.77],
                    [1439560740000, 6.72],
                    [1439564460000, 6.363],
                    [1439564580000, 6.087],
                    [1439564580000, 5.893],
                    [1439564700000, 5.61],
                    [1439567640000, 5.44],
                    [1439567640000, 5.31],
                    [1439568660000, 5.489],
                    [1439569020000, 5.209],
                    [1439569860000, 5.268],
                    [1439570940000, 5.372],
                    [1439575500000, 5.542],
                    [1439575680000, 5.652],
                    [1439575800000, 5.782],
                    [1439575860000, 5.942],
                    [1439576040000, 6.142],
                    [1439576640000, 6.238],
                    [1439584140000, 6.406],
                    [1439584320000, 6.327],
                    [1439584380000, 6.269],
                    [1439584380000, 6.236],
                    [1439588580000, 6.368],
                    [1439790720000, 5.982],
                    [1439791320000, 5.672],
                    [1439805780000, 5.592],
                    [1439805900000, 5.542],
                    [1439809860000, 5.629],
                    [1439811420000, 5.709],
                    [1439814900000, 5.869],
                    [1439816040000, 5.897],
                    [1439823840000, 5.661],
                    [1439824260000, 5.48],
                    [1439824380000, 5.135],
                    [1439824380000, 4.857],
                    [1439824380000, 4.982],
                    [1439825280000, 4.782],
                    [1439826480000, 4.784],
                    [1439831040000, 4.794],
                    [1439831580000, 4.634],
                    [1439832540000, 4.594],
                    [1439835480000, 4.564],
                    [1439835540000, 4.594],
                    [1439837580000, 4.744],
                    [1439838720000, 4.944],
                    [1439841120000, 5.144],
                    [1439841240000, 5.251],
                    [1439841600000, 5.401],
                    [1439842680000, 5.551],
                    [1439843040000, 5.751],
                    [1439886300000, 5.664],
                    [1439887080000, 5.54],
                    [1439894280000, 5.581],
                    [1439900880000, 5.673],
                    [1439903940000, 5.802],
                    [1439908500000, 5.792],
                    [1439908500000, 5.852],
                    [1439910240000, 5.702],
                    [1439910240000, 5.762],
                    [1439913420000, 5.818],
                    [1439913840000, 5.903],
                    [1439917020000, 5.793],
                    [1439922240000, 5.881],
                    [1439923800000, 6.01],
                    [1439924040000, 5.926],
                    [1439924700000, 5.897],
                    [1439930220000, 6.004],
                    [1439970480000, 5.784],
                    [1439971320000, 5.584],
                    [1439995860000, 5.724],
                    [1439996580000, 5.114],
                    [1439997240000, 4.554],
                    [1439997600000, 4.56],
                    [1440001800000, 4.61],
                    [1440001800000, 4.7],
                    [1440003660000, 4.791],
                    [1440003720000, 4.336],
                    [1440003840000, 4.246],
                    [1440003900000, 4.196],
                    [1440004140000, 3.782],
                    [1440004260000, 3.982],
                    [1440005220000, 4.034],
                    [1440005460000, 4.229],
                    [1440006300000, 4.409],
                    [1440006780000, 4.389],
                    [1440007320000, 4.589],
                    [1440008100000, 4.609],
                    [1440008400000, 4.789],
                    [1440008400000, 4.989],
                    [1440008520000, 5.129],
                    [1440008700000, 5.221],
                    [1440009720000, 5.401],
                    [1440010920000, 5.547],
                    [1440011040000, 5.714],
                    [1440014040000, 5.704],
                    [1440014100000, 5.739],
                    [1440015960000, 5.803],
                    [1440016080000, 5.912],
                    [1440045780000, 6.082],
                    [1440061620000, 6.282],
                    [1440064680000, 6.43],
                    [1440064680000, 6.626],
                    [1440067560000, 6.696],
                    [1440067560000, 6.826],
                    [1440068580000, 6.748],
                    [1440068640000, 6.717],
                    [1440078300000, 6.479],
                    [1440079620000, 6.262],
                    [1440080760000, 6.032],
                    [1440080820000, 5.56],
                    [1440080820000, 5.351],
                    [1440083220000, 5.484],
                    [1440083820000, 5.654],
                    [1440086520000, 5.536],
                    [1440086520000, 5.603],
                    [1440086580000, 5.531],
                    [1440090000000, 5.52],
                    [1440090000000, 5.555],
                    [1440091500000, 5.465],
                    [1440091560000, 5.395],
                    [1440091740000, 5.46],
                    [1440092160000, 5.567],
                    [1440093420000, 5.658],
                    [1440094140000, 5.581],
                    [1440094260000, 5.524],
                    [1440095940000, 5.655],
                    [1440096060000, 5.835],
                    [1440096540000, 6.035],
                    [1440101040000, 6.211],
                    [1440101100000, 6.318],
                    [1440101460000, 6.498],
                    [1440101460000, 6.698],
                    [1440102060000, 6.703],
                    [1440102120000, 6.745],
                    [1440105360000, 6.786],
                    [1440106920000, 6.986],
                    [1440107400000, 7.093],
                    [1440110520000, 7.273],
                    [1440149700000, 7.354],
                    [1440149700000, 7.481],
                    [1440150000000, 7.55],
                    [1440151740000, 7.66],
                    [1440151800000, 7.833],
                    [1440152100000, 7.849],
                    [1440152760000, 7.879],
                    [1440152760000, 7.949],
                    [1440160440000, 8.035],
                    [1440160500000, 7.925],
                    [1440164100000, 7.865],
                    [1440169620000, 7.564],
                    [1440169680000, 7.6],
                    [1440169800000, 7.345],
                    [1440173460000, 7.498],
                    [1440174420000, 7.218],
                    [1440174420000, 6.988],
                    [1440174900000, 7.179],
                    [1440177300000, 7.209],
                    [1440178740000, 7.304],
                    [1440178800000, 7.439],
                    [1440178920000, 7.489],
                    [1440179760000, 7.133],
                    [1440179940000, 6.796],
                    [1440180240000, 6.956],
                    [1440180420000, 7.156],
                    [1440185400000, 7.076],
                    [1440187200000, 7.196],
                    [1440187440000, 7.376],
                    [1440187500000, 7.551],
                    [1440187680000, 7.498],
                    [1440187800000, 7.5],
                    [1440187920000, 7.46],
                    [1440385200000, 7.58],
                    [1440387420000, 7.74],
                    [1440388380000, 7.91],
                    [1440388680000, 8.07],
                    [1440388920000, 8.27],
                    [1440393420000, 8.42],
                    [1440400140000, 8.59],
                    [1440403620000, 8.562],
                    [1440403620000, 8.682],
                    [1440403680000, 8.832],
                    [1440403980000, 8.851],
                    [1440405900000, 8.931],
                    [1440406020000, 9.041],
                    [1440409980000, 9.131],
                    [1440410520000, 8.378],
                    [1440410640000, 8.498],
                    [1440411180000, 7.778],
                    [1440411660000, 7.728],
                    [1440412800000, 7.908],
                    [1440412980000, 7.82],
                    [1440415620000, 7.55],
                    [1440416040000, 7.345],
                    [1440417240000, 7.155],
                    [1440418560000, 7.045],
                    [1440419880000, 6.965],
                    [1440419880000, 7.015],
                    [1440425340000, 7.154],
                    [1440426840000, 7.354],
                    [1440428160000, 7.494],
                    [1440429120000, 7.577],
                    [1440429240000, 7.694],
                    [1440429900000, 7.874],
                    [1440430800000, 7.996],
                    [1440431160000, 8.166],
                    [1440431220000, 8.366],
                    [1440435960000, 8.517],
                    [1440438900000, 8.597],
                    [1440441000000, 8.707],
                    [1440441360000, 8.692],
                    [1440441420000, 8.668],
                    [1440441900000, 8.671],
                    [1440441960000, 8.73],
                    [1440443280000, 8.778],
                    [1440443280000, 8.958],
                    [1440445080000, 9.138],
                    [1440447120000, 9.288],
                    [1440447780000, 9.488],
                    [1440448080000, 9.635],
                    [1440448200000, 9.763],
                    [1440449340000, 9.936],
                    [1440449640000, 10.098],
                    [1440452820000, 10.143],
                    [1440452940000, 10.214],
                    [1440454500000, 10.394],
                    [1440494520000, 10.394],
                    [1440494760000, 10.464],
                    [1440494880000, 10.354],
                    [1440496020000, 10.427],
                    [1440498240000, 10.474],
                    [1440498240000, 10.557],
                    [1440503880000, 10.487],
                    [1440503940000, 10.227],
                    [1440511920000, 10.197],
                    [1440512220000, 10.227],
                    [1440512280000, 10.317],
                    [1440512820000, 10.447],
                    [1440512880000, 10.477],
                    [1440514680000, 10.547],
                    [1440516480000, 10.26],
                    [1440519540000, 9.728],
                    [1440519600000, 9.217],
                    [1440530820000, 9.264],
                    [1440531540000, 9.345],
                    [1440537780000, 8.985],
                    [1440537840000, 8.675],
                    [1440541860000, 8.667],
                    [1440541860000, 8.736],
                    [1440566400000, 8.866],
                    [1440566700000, 9.036],
                    [1440595260000, 9.066],
                    [1440599340000, 9.246],
                    [1440601260000, 9.366],
                    [1440601380000, 9.386],
                    [1440601860000, 9.506],
                    [1440604020000, 9.186],
                    [1440606720000, 9.106],
                    [1440606720000, 9.056],
                    [1440607560000, 9.166],
                    [1440607560000, 9.336],
                    [1440608880000, 8.296],
                    [1440609600000, 7.277],
                    [1440611640000, 7.401],
                    [1440612540000, 7.569],
                    [1440615540000, 7.391],
                    [1440615660000, 7.233],
                    [1440616440000, 7.313],
                    [1440616440000, 7.413],
                    [1440617520000, 7.349],
                    [1440617580000, 7.329],
                    [1440617760000, 6.223],
                    [1440619140000, 6.362],
                    [1440619320000, 6.543],
                    [1440620820000, 6.671],
                    [1440620820000, 6.839],
                    [1440621360000, 6.969],
                    [1440621480000, 6.499],
                    [1440621780000, 6.427],
                    [1440622440000, 6.405],
                    [1440625680000, 6.565],
                    [1440625920000, 6.765],
                    [1440627780000, 6.335],
                    [1440645720000, 6.423],
                    [1440645720000, 6.542],
                    [1440646620000, 6.412],
                    [1440667920000, 6.016],
                    [1440667920000, 5.639],
                    [1440668460000, 5.529],
                    [1440669000000, 5.596],
                    [1440670320000, 5.684],
                    [1440671580000, 5.754],
                    [1440672300000, 5.914],
                    [1440673200000, 6.092],
                    [1440674880000, 6.153],
                    [1440675180000, 6.234],
                    [1440676500000, 6.028],
                    [1440676500000, 5.841],
                    [1440680460000, 5.693],
                    [1440683100000, 5.793],
                    [1440683100000, 5.953],
                    [1440685320000, 5.831],
                    [1440685320000, 5.729],
                    [1440686760000, 5.909],
                    [1440687600000, 5.818],
                    [1440688020000, 5.766],
                    [1440688740000, 5.806],
                    [1440691260000, 5.828],
                    [1440692460000, 5.912],
                    [1440693000000, 6.072],
                    [1440694260000, 6.252],
                    [1440696600000, 6.422],
                    [1440698460000, 6.592],
                    [1440700260000, 6.692],
                    [1440701040000, 6.812],
                    [1440701100000, 6.922],
                    [1440705840000, 6.907],
                    [1440706440000, 6.967],
                    [1440706560000, 7.057],
                    [1440706560000, 7.197],
                    [1440706980000, 7.367],
                    [1440712140000, 7.207],
                    [1440712260000, 7.077],
                    [1440713520000, 6.459],
                    [1440714600000, 6.589],
                    [1440731400000, 6.749],
                    [1440732300000, 6.909],
                    [1440732420000, 6.989],
                    [1440732480000, 7.139],
                    [1440735480000, 7.319],
                    [1440740640000, 7.369],
                    [1440741060000, 7.419],
                    [1440747780000, 7.609],
                    [1440751740000, 7.75],
                    [1440752100000, 7.756],
                    [1440754260000, 7.857],
                    [1440754560000, 7.186],
                    [1440756300000, 6.782],
                    [1440756300000, 6.333],
                    [1440756540000, 5.97],
                    [1440756600000, 5.564],
                    [1440757860000, 5.574],
                    [1440762960000, 5.714],
                    [1440766800000, 5.86],
                    [1440768120000, 5.887],
                    [1440768360000, 5.962],
                    [1440770880000, 6.142],
                    [1440772980000, 6.269],
                    [1440773040000, 6.446],
                    [1440774360000, 6.626],
                    [1440776520000, 5.969],
                    [1440776580000, 5.349],
                    [1440778500000, 5.519],
                    [1440778500000, 5.559],
                    [1440778680000, 5.719],
                    [1440778740000, 5.749],
                    [1440778740000, 5.829],
                    [1440779100000, 5.959],
                    [1440780420000, 5.939],
                    [1440780540000, 5.939],
                    [1440781980000, 5.547],
                    [1440781980000, 5.206],
                    [1440781980000, 5.256],
                    [1440782520000, 5.376],
                    [1440783960000, 5.446],
                    [1440787620000, 5.171],
                    [1440787800000, 4.932],
                    [1440787980000, 4.897],
                    [1440788040000, 4.907],
                    [1440789360000, 5.043],
                    [1440792000000, 5.078],
                    [1440792420000, 4.868],
                    [1440792540000, 4.698],
                    [1440792840000, 4.498],
                    [1440792840000, 4.318],
                    [1440792960000, 4.038],
                    [1440793380000, 4.143],
                    [1440793740000, 4.333],
                    [1440794340000, 4.513],
                    [1440802140000, 4.636],
                    [1440990000000, 4.409],
                    [1440990000000, 4.222],
                    [1440990000000, 4.04],
                    [1440990000000, 3.953],
                    [1441015920000, 4.122],
                    [1441016880000, 4.302],
                    [1441017600000, 4.502],
                    [1441021020000, 4.366],
                    [1441021020000, 4.311],
                    [1441021200000, 3.941],
                    [1441028160000, 3.598],
                    [1441031040000, 3.578],
                    [1441033140000, 3.518],
                    [1441033320000, 3.501],
                    [1441033560000, 3.372],
                    [1441036200000, 3.112],
                    [1441036500000, 2.912],
                    [1441037640000, 3.002],
                    [1441039500000, 2.841],
                    [1441039560000, 2.72],
                    [1441040040000, 2.87],
                    [1441042380000, 3.03],
                    [1441042380000, 3.05],
                    [1441042500000, 3.25],
                    [1441042860000, 3.35],
                    [1441046100000, 3.33],
                    [1441046100000, 3.34],
                    [1441048200000, 3.51],
                    [1441048320000, 3.7],
                    [1441052760000, 3.647],
                    [1441053240000, 2.961],
                    [1441054380000, 2.381],
                    [1441058640000, 2.567],
                    [1441059480000, 2.193],
                    [1441059600000, 1.745],
                    [1441059900000, 1.902],
                    [1441076400000, 1.497],
                    [1441076400000, 1.194],
                    [1441076400000, 1.083],
                    [1441076400000, 1.113],
                    [1441077540000, 1.273],
                    [1441077960000, 0.629],
                    [1441100040000, 0.179],
                    [1441100100000, -0.561],
                    [1441100160000, -1.251],
                    [1441100520000, -1.651],
                    [1441101060000, -2.161],
                    [1441106040000, -2.391],
                    [1441106040000, -2.571],
                    [1441106040000, -2.821],
                    [1441106520000, -3.031],
                    [1441108320000, -2.851],
                    [1441108380000, -2.651],
                    [1441108440000, -2.481],
                    [1441108500000, -2.281],
                    [1441116600000, -2.178],
                    [1441116960000, -2.069],
                    [1441117080000, -2.069],
                    [1441117200000, -1.919],
                    [1441118460000, -1.869],
                    [1441119900000, -2.097],
                    [1441120500000, -2.287],
                    [1441120860000, -2.892],
                    [1441121040000, -3.478],
                    [1441121940000, -3.438],
                    [1441122120000, -3.408],
                    [1441122120000, -3.338],
                    [1441123740000, -3.317],
                    [1441123740000, -3.218],
                    [1441124520000, -3.438],
                    [1441127760000, -3.353],
                    [1441127760000, -3.226],
                    [1441130040000, -3.076],
                    [1441130160000, -3.076],
                    [1441130160000, -3.036],
                    [1441139160000, -2.876],
                    [1441139220000, -2.738],
                    [1441139940000, -2.702],
                    [1441140120000, -2.646],
                    [1441162860000, -2.936],
                    [1441163280000, -3.206],
                    [1441178820000, -3.096],
                    [1441181400000, -2.946],
                    [1441184940000, -2.836],
                    [1441185540000, -2.676],
                    [1441190880000, -2.866],
                    [1441198560000, -2.906],
                    [1441198560000, -2.906],
                    [1441198620000, -2.816],
                    [1441200960000, -2.676],
                    [1441201020000, -2.516],
                    [1441203240000, -2.346],
                    [1441203360000, -2.146],
                    [1441205040000, -1.986],
                    [1441205040000, -2.186],
                    [1441205160000, -1.986],
                    [1441206480000, -1.826],
                    [1441207920000, -1.646],
                    [1441208040000, -1.446],
                    [1441208460000, -1.266],
                    [1441211340000, -1.215],
                    [1441211400000, -1.168],
                    [1441211460000, -1.088],
                    [1441211460000, -0.957],
                    [1441213860000, -1.108],
                    [1441214280000, -1.239],
                    [1441214880000, -1.269],
                    [1441214880000, -1.289],
                    [1441214880000, -1.309],
                    [1441214880000, -1.279],
                    [1441214880000, -1.269],
                    [1441214880000, -1.319],
                    [1441217880000, -1.394],
                    [1441225500000, -1.434],
                    [1441225860000, -1.624],
                    [1441225980000, -1.794],
                    [1441227180000, -1.764],
                    [1441228500000, -1.784],
                    [1441257540000, -1.819],
                    [1441268340000, -1.829],
                    [1441268940000, -1.789],
                    [1441273200000, -1.675],
                    [1441273980000, -1.694],
                    [1441274400000, -1.604],
                    [1441274460000, -1.504],
                    [1441274820000, -1.364],
                    [1441274820000, -1.254],
                    [1441278780000, -1.172],
                    [1441278900000, -1.061],
                    [1441294680000, -1.001],
                    [1441295220000, -0.881],
                    [1441298520000, -0.984],
                    [1441298520000, -1.068],
                    [1441302360000, -1.355],
                    [1441302660000, -1.663],
                    [1441302780000, -1.907],
                    [1441303200000, -1.795],
                    [1441307100000, -2.007],
                    [1441309140000, -1.853],
                    [1441312380000, -1.897],
                    [1441314720000, -1.904],
                    [1441357980000, -1.854],
                    [1441363500000, -2.004],
                    [1441363560000, -2.114],
                    [1441364220000, -2.064],
                    [1441364760000, -1.984],
                    [1441365240000, -1.849],
                    [1441366800000, -1.669],
                    [1441368420000, -1.599],
                    [1441376340000, -1.516],
                    [1441376340000, -1.412],
                    [1441377000000, -1.252],
                    [1441378920000, -1.336],
                    [1441381200000, -1.247],
                    [1441381260000, -1.138],
                    [1441387440000, -0.938],
                    [1441397640000, -0.985],
                    [1441397640000, -0.992],
                    [1441398840000, -0.824],
                    [1441398900000, -0.635],
                    [1441619340000, -0.559],
                    [1441627500000, -0.463],
                    [1441645200000, -0.463],
                    [1441645440000, -0.434],
                    [1441697700000, -0.694],
                    [1441705740000, -0.677],
                    [1441706100000, -0.631],
                    [1441712100000, -0.53],
                    [1441725300000, -0.377],
                    [1441730760000, -0.207],
                    [1441733460000, -0.074],
                    [1441733580000, 0.041],
                    [1441737000000, 0.101],
                    [1441737180000, -0.249],
                    [1441737540000, -0.499],
                    [1441737600000, -0.729],
                    [1441743000000, -0.64],
                    [1441743840000, -0.507],
                    [1441743960000, -0.587],
                    [1441747680000, -0.437],
                    [1441748220000, -0.237],
                    [1441770660000, -0.277],
                    [1441773240000, -0.66],
                    [1441773240000, -1.024],
                    [1441784760000, -0.884],
                    [1441785060000, -0.704],
                    [1441797060000, -0.594],
                    [1441797840000, -0.414],
                    [1441797900000, -0.234],
                    [1441798260000, -0.084],
                    [1441798260000, 0.066],
                    [1441798260000, 0.236],
                    [1441807020000, 0.436],
                    [1441814940000, 0.445],
                    [1441819440000, 0.492],
                    [1441827060000, 0.534],
                    [1441828920000, 0.656],
                    [1441830540000, 0.774],
                    [1441830540000, 0.953],
                    [1441854540000, 0.843],
                    [1441873500000, 1.013],
                    [1441883460000, 0.761],
                    [1441883940000, 0.548],
                    [1441903740000, 0.545],
                    [1441903800000, 0.576],
                    [1441918380000, 0.666],
                    [1441918680000, 0.656],
                    [1441918680000, 0.416],
                    [1441952820000, 0.366],
                    [1441967220000, 0.466],
                    [1441967640000, 0.586],
                    [1441968960000, 0.706],
                    [1441976520000, 0.762],
                    [1441978680000, 0.705],
                    [1441979220000, 0.775],
                    [1441980000000, 0.818],
                    [1441980180000, 0.904],
                    [1441983660000, 0.96],
                    [1441983720000, 1.06],
                    [1441983900000, 1.19],
                    [1441987560000, 1.288],
                    [1441988940000, 1.384],
                    [1441990020000, 1.375],
                    [1441990080000, 1.163],
                    [1441992300000, 1.11],
                    [1441992540000, 1.1],
                    [1441992960000, 1.28],
                    [1442002320000, 1.273],
                    [1442002320000, 1.306],
                    [1442003220000, 1.222],
                    [1442003220000, 1.172],
                    [1442004960000, 1.192],
                    [1442199600000, 1.022],
                    [1442203500000, 0.882],
                    [1442205120000, 0.832],
                    [1442205180000, 0.902],
                    [1442207220000, 0.882],
                    [1442223900000, 0.994],
                    [1442241000000, 1.014],
                    [1442246040000, 1.174],
                    [1442256900000, 0.7],
                    [1442257080000, 0.265],
                    [1442262360000, 0.185],
                    [1442262420000, 0.385],
                    [1442265240000, 0.345],
                    [1442308500000, 0.484],
                    [1442309280000, 0.643],
                    [1442320260000, 0.803],
                    [1442320440000, 1.003],
                    [1442342760000, -0.397],
                    [1442342760000, -1.757],
                    [1442342940000, -2.147],
                    [1442342940000, -3.077],
                    [1442343480000, -3.427],
                    [1442347860000, -4.057],
                    [1442347860000, -4.667],
                    [1442347860000, -4.56],
                    [1442347920000, -4.421],
                    [1442349240000, -4.651],
                    [1442349300000, -4.861],
                    [1442349780000, -4.981],
                    [1442349780000, -5.061],
                    [1442394540000, -5.271],
                    [1442400240000, -5.461],
                    [1442413860000, -5.913],
                    [1442418180000, -5.739],
                    [1442419560000, -5.545],
                    [1442419800000, -6.111],
                    [1442421060000, -6.181],
                    [1442421240000, -6.221],
                    [1442421540000, -6.403],
                    [1442421660000, -6.513],
                    [1442421660000, -6.463],
                    [1442422020000, -6.383],
                    [1442422020000, -6.293],
                    [1442422620000, -6.193],
                    [1442428260000, -6.23],
                    [1442428260000, -6.206],
                    [1442436240000, -6.586],
                    [1442436480000, -6.916],
                    [1442458980000, -6.786],
                    [1442458980000, -6.616],
                    [1442481360000, -6.436],
                    [1442481540000, -6.236],
                    [1442483520000, -6.248],
                    [1442484480000, -6.241],
                    [1442485080000, -6.555],
                    [1442485140000, -6.826],
                    [1442488260000, -6.666],
                    [1442488260000, -6.586],
                    [1442488860000, -6.426],
                    [1442488920000, -6.226],
                    [1442489340000, -6.301],
                    [1442489400000, -6.181],
                    [1442489880000, -6.001],
                    [1442492700000, -5.913],
                    [1442493120000, -5.768],
                    [1442509800000, -5.631],
                    [1442509980000, -5.474],
                    [1442511180000, -5.541],
                    [1442512380000, -5.57],
                    [1442519400000, -6.03],
                    [1442519400000, -6.46],
                    [1442520000000, -6.46],
                    [1442521500000, -6.28],
                    [1442525040000, -6.27],
                    [1442525040000, -6.41],
                    [1442526000000, -6.439],
                    [1442527860000, -6.259],
                    [1442545320000, -6.059],
                    [1442549280000, -6.044],
                    [1442566140000, -6.195],
                    [1442574360000, -6.061],
                    [1442574600000, -5.881],
                    [1442580720000, -6.031],
                    [1442581260000, -6.131],
                    [1442581500000, -6.381],
                    [1442585040000, -6.459],
                    [1442585160000, -6.319],
                    [1442585220000, -6.179],
                    [1442585220000, -6.009],
                    [1442586240000, -5.863],
                    [1442588820000, -5.76],
                    [1442588940000, -5.621],
                    [1442589960000, -5.661],
                    [1442590020000, -5.681],
                    [1442590860000, -5.961],
                    [1442593320000, -5.866],
                    [1442593980000, -5.738],
                    [1442594100000, -5.836],
                    [1442594100000, -6.066],
                    [1442594100000, -6.036],
                    [1442594100000, -6.396],
                    [1442594160000, -6.454],
                    [1442602320000, -6.524],
                    [1442602560000, -6.554],
                    [1442607840000, -6.374],
                    [1442607960000, -6.364],
                    [1442607960000, -6.304],
                    [1442608080000, -6.306],
                    [1442608080000, -6.258],
                    [1442609340000, -6.188],
                    [1442609460000, -6.058],
                    [1442614620000, -5.908],
                    [1442822100000, -5.797],
                    [1442827320000, -5.666],
                    [1442834460000, -5.686],
                    [1442835360000, -5.686],
                    [1442839260000, -5.736],
                    [1442843100000, -5.686],
                    [1442843100000, -5.606],
                    [1442845200000, -5.456],
                    [1442845200000, -5.326],
                    [1442845560000, -5.146],
                    [1442847420000, -4.956],
                    [1442849580000, -4.832],
                    [1442850000000, -4.671],
                    [1442851320000, -4.751],
                    [1442851320000, -4.811],
                    [1442852400000, -4.711],
                    [1442852580000, -4.591],
                    [1442861220000, -4.611],
                    [1442861520000, -4.748],
                    [1442861640000, -4.819],
                    [1442863620000, -4.639],
                    [1442868960000, -4.469],
                    [1442869200000, -4.469],
                    [1442872920000, -4.437],
                    [1442874300000, -4.34],
                    [1442876040000, -4.25],
                    [1442876040000, -4.13],
                    [1442876280000, -4.06],
                    [1442904840000, -3.95],
                    [1442910600000, -3.82],
                    [1442920320000, -3.772],
                    [1442932920000, -3.772],
                    [1442932920000, -3.692],
                    [1442934780000, -3.852],
                    [1442934960000, -3.972],
                    [1442935080000, -3.932],
                    [1442935140000, -3.922],
                    [1442936460000, -4.098],
                    [1442937360000, -4.224],
                    [1442937540000, -4.436],
                    [1442937720000, -4.618],
                    [1442940540000, -4.558],
                    [1442943600000, -4.468],
                    [1442952480000, -4.407],
                    [1442952480000, -4.307],
                    [1442961660000, -4.517],
                    [1442961660000, -4.687],
                    [1442990280000, -4.767],
                    [1443006240000, -4.627],
                    [1443006960000, -4.467],
                    [1443012180000, -4.357],
                    [1443012360000, -4.207],
                    [1443017820000, -4.077],
                    [1443017880000, -3.917],
                    [1443020580000, -3.995],
                    [1443021120000, -4.033],
                    [1443027360000, -4.703],
                    [1443027540000, -5.325],
                    [1443029580000, -5.39],
                    [1443029580000, -5.299],
                    [1443030180000, -5.225],
                    [1443039120000, -5.173],
                    [1443042720000, -5.503],
                    [1443042780000, -5.773],
                    [1443043680000, -5.973],
                    [1443045000000, -6.047],
                    [1443045300000, -6.048],
                    [1443045360000, -6.078],
                    [1443045840000, -6.238],
                    [1443088260000, -6.468],
                    [1443103380000, -6.328],
                    [1443103440000, -6.158],
                    [1443103620000, -6.038],
                    [1443105660000, -6.401],
                    [1443107400000, -6.541],
                    [1443107520000, -6.651],
                    [1443108120000, -6.962],
                    [1443110580000, -7.45],
                    [1443110640000, -7.918],
                    [1443112560000, -7.738],
                    [1443120840000, -7.638],
                    [1443125760000, -7.508],
                    [1443175860000, -7.608],
                    [1443176280000, -7.666],
                    [1443176460000, -7.695],
                    [1443194520000, -7.661],
                    [1443196560000, -7.643],
                    [1443196680000, -7.553],
                    [1443198540000, -8.073],
                    [1443198780000, -8.543],
                    [1443200460000, -8.456],
                    [1443200640000, -8.357],
                    [1443200700000, -8.21],
                    [1443201900000, -8.1],
                    [1443202080000, -7.96],
                    [1443203520000, -7.78],
                    [1443204000000, -7.711],
                    [1443204960000, -7.661],
                    [1443205560000, -7.581],
                    [1443439620000, -7.591],
                    [1443440220000, -7.583],
                    [1443443640000, -7.471],
                    [1443443820000, -7.386],
                    [1443447720000, -7.206],
                    [1443452220000, -7.248],
                    [1443452760000, -7.048],
                    [1443454860000, -6.889],
                    [1443456780000, -6.709],
                    [1443456960000, -6.719],
                    [1443457800000, -7.119],
                    [1443457800000, -7.485],
                    [1443461400000, -7.344],
                    [1443461640000, -7.183],
                    [1443462960000, -7.053],
                    [1443462960000, -6.893],
                    [1443472080000, -7.228],
                    [1443473880000, -7.118],
                    [1443516180000, -6.938],
                    [1443522780000, -6.936],
                    [1443523080000, -6.897],
                    [1443537960000, -7.041],
                    [1443555180000, -6.911],
                    [1443555960000, -7.013],
                    [1443557880000, -7.075],
                    [1443557940000, -7.146],
                    [1443558540000, -7.203],
                    [1443558960000, -7.219],
                    [1443565860000, -7.039],
                    [1443611160000, -7.158],
                    [1443617700000, -7.098],
                    [1443627120000, -6.918],
                    [1443629100000, -6.98],
                    [1443630780000, -6.82],
                    [1443631320000, -6.66],
                    [1443631440000, -6.647],
                    [1443631560000, -6.577],
                    [1443631620000, -6.727],
                    [1443633120000, -6.937],
                    [1443638940000, -6.797],
                    [1443639060000, -6.607],
                    [1443644940000, -6.897],
                    [1443646800000, -6.817],
                    [1443646860000, -6.707],
                    [1443649140000, -6.547],
                    [1443650100000, -6.717],
                    [1443707640000, -7.292],
                    [1443707700000, -7.821],
                    [1443712440000, -7.806],
                    [1443712440000, -7.758],
                    [1443718380000, -8.085],
                    [1443718440000, -8.086],
                    [1443718440000, -7.932],
                    [1443718500000, -7.912],
                    [1443718500000, -7.738],
                    [1443718800000, -7.665],
                    [1443718800000, -7.613],
                    [1443722400000, -7.873],
                    [1443722400000, -8.113],
                    [1443725100000, -8.441],
                    [1443729240000, -8.494],
                    [1443731220000, -8.334],
                    [1443732780000, -8.264],
                    [1443732780000, -8.174],
                    [1443777720000, -8.054],
                    [1443779220000, -7.874],
                    [1443779640000, -7.714],
                    [1443780720000, -7.514],
                    [1443796320000, -7.614],
                    [1443796320000, -7.694],
                    [1443799080000, -7.85],
                    [1443799560000, -8.134],
                    [1443812460000, -8.164],
                    [1443812460000, -8.174],
                    [1443812460000, -8.599],
                    [1443812940000, -8.499],
                    [1443814560000, -8.359],
                    [1443817440000, -8.329],
                    [1443817620000, -8.279],
                    [1443817620000, -8.199],
                    [1443820920000, -8.094],
                    [1444039500000, -8.164],
                    [1444039560000, -8.214],
                    [1444057200000, -8.069],
                    [1444057200000, -7.898],
                    [1444059420000, -7.768],
                    [1444060800000, -7.588],
                    [1444063980000, -7.465],
                    [1444066800000, -7.405],
                    [1444071180000, -7.405],
                    [1444072200000, -7.449],
                    [1444075680000, -7.474],
                    [1444083360000, -7.294],
                    [1444085340000, -7.174],
                    [1444085700000, -7.014],
                    [1444142760000, -6.871],
                    [1444144860000, -6.914],
                    [1444146960000, -6.954],
                    [1444147380000, -7.184],
                    [1444149900000, -7.074],
                    [1444149960000, -6.924],
                    [1444149960000, -6.929],
                    [1444150800000, -6.729],
                    [1444159980000, -6.649],
                    [1444159980000, -6.649],
                    [1444160820000, -6.539],
                    [1444163280000, -6.389],
                    [1444163280000, -6.209],
                    [1444170720000, -6.029],
                    [1444170720000, -5.829],
                    [1444206180000, -5.719],
                    [1444208700000, -5.749],
                    [1444209180000, -5.949],
                    [1444210740000, -6.109],
                    [1444216560000, -6.149],
                    [1444217040000, -6.169],
                    [1444233060000, -6.063],
                    [1444233660000, -5.919],
                    [1444238820000, -6.369],
                    [1444238820000, -6.744],
                    [1444239540000, -6.964],
                    [1444239600000, -7.339],
                    [1444239600000, -7.519],
                    [1444239720000, -7.853],
                    [1444239720000, -7.853],
                    [1444239780000, -7.803],
                    [1444240020000, -7.743],
                    [1444243620000, -7.623],
                    [1444244880000, -7.533],
                    [1444273680000, -7.393],
                    [1444292580000, -7.233],
                    [1444306020000, -7.063],
                    [1444306980000, -7.756],
                    [1444307160000, -8.413],
                    [1444311060000, -8.223],
                    [1444318620000, -8.104],
                    [1444319040000, -7.984],
                    [1444319820000, -7.816],
                    [1444320180000, -7.646],
                    [1444334820000, -7.758],
                    [1444335420000, -7.628],
                    [1444335540000, -7.458],
                    [1444336140000, -7.338],
                    [1444376160000, -7.248],
                    [1444387440000, -7.118],
                    [1444388400000, -7.179],
                    [1444390800000, -7.049],
                    [1444398960000, -6.989],
                    [1444401300000, -7.313],
                    [1444401420000, -7.586],
                    [1444404480000, -7.416],
                    [1444404540000, -7.429],
                    [1444404600000, -7.269],
                    [1444404660000, -7.069],
                    [1444407000000, -7.003],
                    [1444412940000, -7.533],
                    [1444413000000, -8.003],
                    [1444422480000, -7.847],
                    [1444423620000, -7.747],
                    [1444622940000, -7.607],
                    [1444645020000, -7.447],
                    [1444645380000, -7.257],
                    [1444647540000, -7.367],
                    [1444648380000, -7.655],
                    [1444648980000, -7.897],
                    [1444651920000, -7.758],
                    [1444651980000, -7.578],
                    [1444652400000, -7.488],
                    [1444661400000, -7.308],
                    [1444672500000, -7.218],
                    [1444672620000, -7.198],
                    [1444672860000, -7.138],
                    [1444672920000, -6.988],
                    [1444673040000, -6.858],
                    [1444673100000, -6.688],
                    [1444673100000, -6.598],
                    [1444677300000, -6.588],
                    [1444677420000, -6.538],
                    [1444681440000, -6.408],
                    [1444681620000, -6.228],
                    [1444705560000, -6.198],
                    [1444705560000, -6.088],
                    [1444722000000, -5.908],
                    [1444722720000, -5.708],
                    [1444736460000, -5.588],
                    [1444736700000, -5.428],
                    [1444745100000, -5.498],
                    [1444746000000, -5.448],
                    [1444746120000, -5.368],
                    [1444749600000, -5.238],
                    [1444751340000, -5.068],
                    [1444753500000, -4.898],
                    [1444753740000, -4.698],
                    [1444758420000, -5.048],
                    [1444758540000, -5.358],
                    [1444761540000, -6.962],
                    [1444761540000, -8.532],
                    [1444765320000, -8.495],
                    [1444769580000, -8.471],
                    [1444769940000, -8.501],
                    [1444770000000, -8.491],
                    [1444776120000, -8.341],
                    [1444776180000, -8.161],
                    [1444813920000, -8.001],
                    [1444817880000, -7.861],
                    [1444820100000, -7.681],
                    [1444823520000, -7.531],
                    [1444823700000, -7.341],
                    [1444829460000, -7.181],
                    [1444829580000, -6.981],
                    [1444839900000, -7.546],
                    [1444841280000, -8.09],
                    [1444844640000, -8.065],
                    [1444846080000, -7.993],
                    [1444851300000, -8.013],
                    [1444851900000, -7.943],
                    [1444851900000, -7.808],
                    [1444852680000, -7.768],
                    [1444854420000, -7.764],
                    [1444854420000, -7.74],
                    [1444854480000, -7.67],
                    [1444861860000, -7.54],
                    [1444862880000, -7.38],
                    [1444920480000, -7.502],
                    [1444921380000, -7.604],
                    [1444929120000, -7.534],
                    [1444929180000, -7.374],
                    [1444930620000, -7.711],
                    [1444931040000, -7.988],
                    [1444941540000, -8.068],
                    [1444942380000, -8.088],
                    [1444942920000, -8.315],
                    [1444944900000, -8.508],
                    [1444984620000, -8.601],
                    [1444986840000, -8.659],
                    [1445008080000, -8.571],
                    [1445009220000, -8.441],
                    [1445013240000, -8.307],
                    [1445014380000, -8.407],
                    [1445014500000, -8.242],
                    [1445014740000, -8.302],
                    [1445018460000, -8.217],
                    [1445020020000, -8.098],
                    [1445022180000, -8.018],
                    [1445022240000, -7.888],
                    [1445023620000, -7.788],
                    [1445023860000, -7.628],
                    [1445026800000, -7.512],
                    [1445027100000, -7.364],
                    [1445031840000, -7.384],
                    [1445250420000, -7.274],
                    [1445252460000, -7.124],
                    [1445254680000, -6.974],
                    [1445261700000, -6.784],
                    [1445263620000, -6.604],
                    [1445267160000, -6.485],
                    [1445267520000, -6.395],
                    [1445269020000, -6.238],
                    [1445270340000, -6.373],
                    [1445272380000, -6.213],
                    [1445274480000, -6.06],
                    [1445274540000, -6.174],
                    [1445277840000, -6.314],
                    [1445278200000, -6.369],
                    [1445278440000, -6.479],
                    [1445278440000, -6.539],
                    [1445283900000, -6.594],
                    [1445284260000, -6.592],
                    [1445286060000, -6.502],
                    [1445286060000, -6.342],
                    [1445286420000, -6.212],
                    [1445286480000, -6.032],
                    [1445286780000, -5.832],
                    [1445287860000, -5.862],
                    [1445287920000, -5.855],
                    [1445292720000, -5.73],
                    [1445293020000, -5.564],
                    [1445325840000, -5.404],
                    [1445348220000, -5.494],
                    [1445348220000, -5.564],
                    [1445349840000, -5.374],
                    [1445353980000, -5.194],
                    [1445354100000, -4.994],
                    [1445358000000, -5.205],
                    [1445358060000, -5.376],
                    [1445359260000, -5.236],
                    [1445362680000, -5.066],
                    [1445364240000, -5.018],
                    [1445365200000, -4.933],
                    [1445366820000, -4.865],
                    [1445380200000, -4.75],
                    [1445423220000, -4.57],
                    [1445423880000, -4.45],
                    [1445441820000, -4.83],
                    [1445442540000, -4.967],
                    [1445444280000, -5.297],
                    [1445447400000, -5.247],
                    [1445453640000, -5.127],
                    [1445453820000, -5.598],
                    [1445454720000, -6.039],
                    [1445459100000, -5.947],
                    [1445459100000, -5.817],
                    [1445522940000, -6.017],
                    [1445525820000, -5.907],
                    [1445526000000, -5.737],
                    [1445527860000, -5.858],
                    [1445530440000, -6.038],
                    [1445533080000, -5.981],
                    [1445534220000, -5.878],
                    [1445539620000, -5.718],
                    [1445544420000, -5.578],
                    [1445545680000, -5.723],
                    [1445546820000, -5.806],
                    [1445549700000, -5.685],
                    [1445550780000, -5.522],
                    [1445595660000, -5.669],
                    [1445597880000, -5.776],
                    [1445610600000, -5.64],
                    [1445610720000, -5.46],
                    [1445615160000, -5.481],
                    [1445615340000, -5.443],
                    [1445618100000, -5.451],
                    [1445618340000, -5.391],
                    [1445619780000, -5.362],
                    [1445619960000, -5.293],
                    [1445866140000, -6.22],
                    [1445866320000, -7.105],
                    [1445870700000, -7.012],
                    [1445870940000, -6.887],
                    [1445874240000, -6.727],
                    [1445888700000, -7.517],
                    [1445891760000, -7.804],
                    [1445894280000, -8.033],
                    [1445916000000, -7.863],
                    [1445937120000, -7.793],
                    [1445944980000, -7.623],
                    [1445958720000, -7.593],
                    [1445959200000, -7.779],
                    [1445959500000, -7.921],
                    [1445960580000, -8.921],
                    [1445960640000, -8.772],
                    [1445960880000, -8.592],
                    [1445965500000, -8.506],
                    [1445973660000, -9.236],
                    [1445973660000, -10.036],
                    [1445973900000, -10.476],
                    [1445973900000, -10.866],
                    [1445974020000, -10.706],
                    [1445980020000, -10.55],
                    [1445982480000, -10.403],
                    [1446044520000, -10.523],
                    [1446044520000, -10.603],
                    [1446046260000, -10.423],
                    [1446046260000, -10.223],
                    [1446053940000, -10.711],
                    [1446054900000, -11.239],
                    [1446061140000, -11.806],
                    [1446105720000, -12.016],
                    [1446106140000, -12.206],
                    [1446113640000, -12.365],
                    [1446113880000, -12.489],
                    [1446116880000, -12.329],
                    [1446116940000, -12.129],
                    [1446127200000, -12.163],
                    [1446127260000, -12.169],
                    [1446128280000, -12.429],
                    [1446128580000, -12.599],
                    [1446129600000, -12.459],
                    [1446129780000, -12.259],
                    [1446131400000, -12.213],
                    [1446131940000, -12.121],
                    [1446132780000, -12.021],
                    [1446132960000, -11.871],
                    [1446134520000, -12.171],
                    [1446136020000, -12.161],
                    [1446139500000, -12.127],
                    [1446139620000, -12.033],
                    [1446144960000, -12.103],
                    [1446145260000, -12.113],
                    [1446149700000, -12.184],
                    [1446151320000, -12.203],
                    [1446174000000, -12.193],
                    [1446174000000, -12.133],
                    [1446201900000, -12.103],
                    [1446205680000, -12.143],
                    [1446206040000, -12.163],
                    [1446209760000, -11.984],
                    [1446210120000, -11.785],
                    [1446221760000, -11.645],
                    [1446221940000, -11.445],
                    [1446228120000, -11.305],
                    [1446228240000, -11.125],
                    [1446231540000, -11.134],
                    [1446232140000, -11.111],
                    [1446433500000, -10.941],
                    [1446441420000, -10.751],
                    [1446453240000, -10.78],
                    [1446453300000, -10.736],
                    [1446453420000, -10.655],
                    [1446455880000, -10.664],
                    [1446456420000, -10.636],
                    [1446458940000, -10.506],
                    [1446460740000, -10.346],
                    [1446460740000, -10.286],
                    [1446462180000, -10.138],
                    [1446474120000, -9.989],
                    [1446479820000, -9.899],
                    [1446485400000, -9.879],
                    [1446485820000, -9.809],
                    [1446542460000, -9.827],
                    [1446552480000, -10.137],
                    [1446552720000, -10.417],
                    [1446561540000, -10.327],
                    [1446561540000, -10.207],
                    [1446566220000, -10.117],
                    [1446566640000, -10.007],
                    [1446572280000, -9.937],
                    [1446573720000, -9.827],
                    [1446575280000, -9.647],
                    [1446581880000, -10.464],
                    [1446582300000, -11.254],
                    [1446583440000, -11.882],
                    [1446586620000, -11.872],
                    [1446625800000, -11.903],
                    [1446625860000, -11.733],
                    [1446625920000, -11.658],
                    [1446628080000, -11.518],
                    [1446630240000, -11.338],
                    [1446635340000, -11.308],
                    [1446635760000, -11.248],
                    [1446648480000, -11.178],
                    [1446651420000, -11.068],
                    [1446653820000, -11.091],
                    [1446654720000, -11.075],
                    [1446657000000, -11.183],
                    [1446657000000, -11.453],
                    [1446657120000, -11.703],
                    [1446668580000, -11.692],
                    [1446668820000, -11.532],
                    [1446669240000, -11.478],
                    [1446696960000, -11.965],
                    [1446702660000, -12.404],
                    [1446719040000, -12.524],
                    [1446719400000, -12.614],
                    [1446720120000, -12.512],
                    [1446721440000, -12.369],
                    [1446734760000, -12.209],
                    [1446735000000, -12.019],
                    [1446736260000, -11.849],
                    [1446736380000, -11.649],
                    [1446737760000, -11.811],
                    [1446738780000, -11.934],
                    [1446744240000, -12.042],
                    [1446744240000, -12.104],
                    [1446744240000, -12.078],
                    [1446744240000, -11.992],
                    [1446755220000, -12.014],
                    [1446755220000, -11.999],
                    [1446802080000, -11.839],
                    [1446813180000, -11.761],
                    [1446813180000, -11.634],
                    [1446823020000, -11.594],
                    [1446831660000, -11.974],
                    [1446832020000, -12.304],
                    [1446837480000, -12.384],
                    [1446840660000, -12.234],
                    [1446840660000, -12.054],
                    [1446841680000, -12.104],
                    [1446847020000, -11.924],
                    [1446847020000, -11.794],
                    [1446849420000, -11.624],
                    [1447058340000, -11.424],
                    [1447072020000, -11.294],
                    [1447072440000, -11.134],
                    [1447073640000, -11.047],
                    [1447073700000, -10.925],
                    [1447077960000, -10.795],
                    [1447078260000, -10.625],
                    [1447083240000, -10.471],
                    [1447083660000, -10.693],
                    [1447085100000, -11.248],
                    [1447085640000, -11.783],
                    [1447086120000, -11.927],
                    [1447088400000, -12.027],
                    [1447088880000, -12.087],
                    [1447089120000, -11.897],
                    [1447100580000, -11.785],
                    [1447132500000, -11.695],
                    [1447133580000, -11.545],
                    [1447142640000, -11.385],
                    [1447148580000, -11.185],
                    [1447166760000, -11.165],
                    [1447166820000, -11.325],
                    [1447167420000, -11.255],
                    [1447167600000, -11.666],
                    [1447167600000, -12.022],
                    [1447167840000, -12.142],
                    [1447167900000, -12.032],
                    [1447170540000, -11.952],
                    [1447170540000, -11.812],
                    [1447176360000, -11.732],
                    [1447176540000, -11.622],
                    [1447176720000, -11.492],
                    [1447178160000, -11.342],
                    [1447178340000, -11.408],
                    [1447178820000, -11.454],
                    [1447188660000, -11.394],
                    [1447188960000, -11.287],
                    [1447189800000, -11.207],
                    [1447195980000, -11.103],
                    [1447232280000, -10.951],
                    [1447243260000, -10.841],
                    [1447244040000, -10.912],
                    [1447244700000, -10.762],
                    [1447248600000, -10.755],
                    [1447249740000, -10.696],
                    [1447251120000, -10.587],
                    [1447253940000, -10.52],
                    [1447257720000, -10.44],
                    [1447259460000, -10.53],
                    [1447259460000, -10.43],
                    [1447259520000, -10.49],
                    [1447259520000, -10.33],
                    [1447259520000, -10.21],
                    [1447259580000, -10.01],
                    [1447260720000, -9.867],
                    [1447272900000, -9.935],
                    [1447274040000, -9.93],
                    [1447275960000, -9.957],
                    [1447323180000, -9.931],
                    [1447336800000, -9.991],
                    [1447340460000, -10.119],
                    [1447341480000, -10.208],
                    [1447346100000, -10.418],
                    [1447346160000, -10.528],
                    [1447348020000, -10.398],
                    [1447348140000, -10.228],
                    [1447353420000, -10.048],
                    [1447357440000, -10.305],
                    [1447357500000, -10.526],
                    [1447385040000, -10.636],
                    [1447385400000, -10.696],
                    [1447389900000, -10.736],
                    [1447410120000, -10.906],
                    [1447423440000, -10.843],
                    [1447424220000, -10.731],
                    [1447425960000, -10.811],
                    [1447429380000, -10.738],
                    [1447435740000, -10.948],
                    [1447435740000, -10.868],
                    [1447435740000, -10.928],
                    [1447435740000, -10.948],
                    [1447435800000, -11.128],
                    [1447435800000, -11.008],
                    [1447436220000, -11.286],
                    [1447436220000, -11.538],
                    [1447438320000, -11.428],
                    [1447438980000, -11.258],
                    [1447642800000, -11.198],
                    [1447642800000, -11.098],
                    [1447662300000, -11.222],
                    [1447662900000, -11.307],
                    [1447664940000, -11.137],
                    [1447665480000, -10.947],
                    [1447669380000, -10.859],
                    [1447669680000, -10.741],
                    [1447686060000, -10.941],
                    [1447686060000, -11.101],
                    [1447688340000, -11.163],
                    [1447688640000, -10.993],
                    [1447689060000, -10.803],
                    [1447697880000, -11.004],
                    [1447702740000, -11.136],
                    [1447703820000, -11.228],
                    [1447706280000, -11.558],
                    [1447707720000, -11.768],
                    [1447742460000, -12.068],
                    [1447755660000, -12.001],
                    [1447767960000, -12.001],
                    [1447768020000, -11.971],
                    [1447769760000, -11.791],
                    [1447770060000, -11.972],
                    [1447770840000, -11.792],
                    [1447775400000, -11.677],
                    [1447777260000, -11.772],
                    [1447777740000, -11.818],
                    [1447781040000, -11.696],
                    [1447781400000, -11.516],
                    [1447782000000, -11.486],
                    [1447782060000, -11.426],
                    [1447783260000, -11.3],
                    [1447784640000, -11.12],
                    [1447790520000, -11.04],
                    [1447790700000, -10.91],
                    [1447792020000, -10.754],
                    [1447800300000, -10.688],
                    [1447837560000, -10.528],
                    [1447837680000, -10.328],
                    [1447838100000, -10.232],
                    [1447845180000, -10.462],
                    [1447853220000, -10.472],
                    [1447857840000, -10.522],
                    [1447859400000, -10.362],
                    [1447859820000, -10.367],
                    [1447863240000, -10.337],
                    [1447865220000, -10.217],
                    [1447866600000, -10.066],
                    [1447867500000, -9.876],
                    [1447868880000, -9.725],
                    [1447873800000, -9.615],
                    [1447873860000, -9.435],
                    [1447876260000, -9.285],
                    [1447932060000, -9.341],
                    [1447933140000, -9.355],
                    [1447940880000, -9.225],
                    [1447942800000, -9.055],
                    [1447955580000, -9.013],
                    [1447957080000, -8.879],
                    [1447957140000, -8.706],
                    [1447958400000, -8.506],
                    [1447961220000, -8.405],
                    [1447965240000, -8.205],
                    [1447969320000, -8.525],
                    [1447970160000, -8.795],
                    [1447970460000, -8.745],
                    [1448004840000, -8.655],
                    [1448011740000, -8.739],
                    [1448012880000, -8.768],
                    [1448016000000, -8.668],
                    [1448016300000, -8.518],
                    [1448016900000, -8.374],
                    [1448017380000, -8.194],
                    [1448040480000, -8.437],
                    [1448046000000, -8.617],
                    [1448046000000, -8.757],
                    [1448046000000, -8.577],
                    [1448046000000, -8.407],
                    [1448046660000, -8.227],
                    [1448046660000, -8.027],
                    [1448050140000, -7.875],
                    [1448262060000, -7.741],
                    [1448275680000, -7.581],
                    [1448284440000, -7.961],
                    [1448284500000, -8.321],
                    [1448285280000, -8.351],
                    [1448286480000, -8.351],
                    [1448286960000, -8.614],
                    [1448287680000, -8.563],
                    [1448290560000, -8.481],
                    [1448290560000, -8.378],
                    [1448296080000, -8.248],
                    [1448296080000, -8.088],
                    [1448299980000, -7.948],
                    [1448300400000, -7.788],
                    [1448301300000, -7.959],
                    [1448301660000, -8.091],
                    [1448301780000, -7.931],
                    [1448305260000, -7.871],
                    [1448306460000, -7.791],
                    [1448306580000, -7.671],
                    [1448306940000, -7.521],
                    [1448316000000, -7.391],
                    [1448344200000, -7.221],
                    [1448365740000, -7.307],
                    [1448366040000, -7.187],
                    [1448366100000, -7.017],
                    [1448377980000, -6.947],
                    [1448378160000, -6.837],
                    [1448378460000, -7.204],
                    [1448380440000, -7.024],
                    [1448383140000, -6.844],
                    [1448384880000, -6.644],
                    [1448386620000, -6.544],
                    [1448390400000, -6.394],
                    [1448395440000, -6.417],
                    [1448395500000, -6.408],
                    [1448441100000, -6.418],
                    [1448441280000, -6.388],
                    [1448445180000, -6.208],
                    [1448453220000, -6.148],
                    [1448456880000, -6.116],
                    [1448457060000, -5.936],
                    [1448458800000, -5.84],
                    [1448459280000, -5.695],
                    [1448461920000, -5.628],
                    [1448462760000, -5.478],
                    [1448462880000, -5.418],
                    [1448463900000, -5.358],
                    [1448466060000, -5.254],
                    [1448472360000, -5.104],
                    [1448472360000, -4.914],
                    [1448472600000, -5.153],
                    [1448473260000, -5.135],
                    [1448473980000, -5.443],
                    [1448474160000, -5.731],
                    [1448475540000, -5.693],
                    [1448479980000, -5.623],
                    [1448479980000, -5.533],
                    [1448482620000, -5.433],
                    [1448511780000, -5.283],
                    [1448512200000, -5.113],
                    [1448525160000, -4.953],
                    [1448527140000, -4.753],
                    [1448531640000, -4.603],
                    [1448534820000, -4.413],
                    [1448552160000, -4.233],
                    [1448552160000, -4.033],
                    [1448559480000, -4.153],
                    [1448559600000, -4.223],
                    [1448564940000, -4.063],
                    [1448564940000, -3.883],
                    [1448565180000, -3.727],
                    [1448565300000, -3.551],
                    [1448593200000, -3.741],
                    [1448593200000, -3.901],
                    [1448616480000, -3.868],
                    [1448620560000, -3.698],
                    [1448625000000, -3.758],
                    [1448625060000, -3.798],
                    [1448627460000, -3.639],
                    [1448627460000, -3.439],
                    [1448628660000, -3.279],
                    [1448629380000, -3.279],
                    [1448630820000, -3.119],
                    [1448636580000, -3.06],
                    [1448636700000, -2.947],
                    [1448640360000, -3.077],
                    [1448640420000, -3.177],
                    [1448643120000, -3.021],
                    [1448643360000, -2.845],
                    [1448645040000, -2.825],
                    [1448649540000, -2.654],
                    [1448649600000, -2.594],
                    [1448852400000, -2.504],
                    [1448852400000, -2.384],
                    [1448871180000, -2.264],
                    [1448877660000, -2.094],
                    [1448877780000, -1.904],
                    [1448892720000, -2.196],
                    [1448892840000, -2.447],
                    [1448895540000, -2.457],
                    [1448895540000, -2.437],
                    [1448904180000, -2.356],
                    [1448904180000, -2.255],
                    [1448906040000, -2.168],
                    [1448906280000, -2.008],
                    [1448907180000, -1.868],
                    [1448907240000, -2.011],
                    [1448920140000, -2.198],
                    [1448920140000, -2.313],
                    [1448964480000, -2.443],
                    [1448968860000, -2.263],
                    [1448968860000, -2.658],
                    [1448973120000, -2.508],
                    [1448973120000, -2.668],
                    [1448979060000, -3.177],
                    [1448979720000, -3.007],
                    [1448979900000, -2.817],
                    [1448982240000, -2.749],
                    [1448985180000, -3.112],
                    [1448985240000, -3.456],
                    [1448985660000, -3.711],
                    [1448985780000, -4.679],
                    [1448985780000, -5.627],
                    [1448985960000, -5.809],
                    [1448988120000, -5.689],
                    [1448989500000, -5.793],
                    [1448999700000, -5.613],
                    [1448999880000, -5.769],
                    [1448999880000, -5.898],
                    [1448999880000, -5.931],
                    [1448999940000, -5.819],
                    [1449004440000, -5.661],
                    [1449004500000, -5.787],
                    [1449006300000, -5.607],
                    [1449065400000, -5.737],
                    [1449065400000, -5.897],
                    [1449066180000, -6.041],
                    [1449066360000, -6.131],
                    [1449068100000, -6.261],
                    [1449068160000, -6.287],
                    [1449070860000, -6.187],
                    [1449072540000, -6.067],
                    [1449073800000, -6.13],
                    [1449073800000, -6.151],
                    [1449074040000, -6.001],
                    [1449074640000, -5.811],
                    [1449077820000, -5.723],
                    [1449080280000, -5.545],
                    [1449080340000, -5.502],
                    [1449080580000, -5.439],
                    [1449084240000, -5.349],
                    [1449084420000, -5.219],
                    [1449087300000, -5.08],
                    [1449087300000, -4.901],
                    [1449091860000, -5.015],
                    [1449091920000, -5.059],
                    [1449092280000, -4.899],
                    [1449112440000, -4.854],
                    [1449125640000, -4.784],
                    [1449126300000, -4.674],
                    [1449126540000, -4.498],
                    [1449128820000, -4.359],
                    [1449136860000, -4.199],
                    [1449149880000, -4.34],
                    [1449150000000, -4.48],
                    [1449150000000, -4.56],
                    [1449150180000, -4.681],
                    [1449154800000, -4.561],
                    [1449155220000, -4.421],
                    [1449163140000, -4.688],
                    [1449163800000, -4.928],
                    [1449167220000, -4.775],
                    [1449167340000, -5.355],
                    [1449167340000, -6.169],
                    [1449167700000, -6.923],
                    [1449167940000, -7.922],
                    [1449168300000, -7.722],
                    [1449170640000, -8.923],
                    [1449173940000, -8.813],
                    [1449173940000, -8.673],
                    [1449183420000, -8.737],
                    [1449223800000, -8.577],
                    [1449224340000, -8.647],
                    [1449224460000, -8.697],
                    [1449225600000, -8.55],
                    [1449237540000, -8.692],
                    [1449238020000, -9.046],
                    [1449240720000, -8.937],
                    [1449240720000, -8.777],
                    [1449240780000, -8.714],
                    [1449240780000, -8.565],
                    [1449241320000, -8.431],
                    [1449241680000, -8.341],
                    [1449241680000, -8.221],
                    [1449241680000, -8.031],
                    [1449243000000, -8.133],
                    [1449243000000, -8.214],
                    [1449244740000, -8.166],
                    [1449244800000, -8.098],
                    [1449247860000, -7.928],
                    [1449250140000, -8.019],
                    [1449250140000, -8.083],
                    [1449259080000, -7.967],
                    [1449259080000, -7.811],
                    [1449260220000, -7.841],
                    [1449260820000, -8.171],
                    [1449260820000, -8.451],
                    [1449260880000, -8.431],
                    [1449263640000, -8.47],
                    [1449263640000, -8.473],
                    [1449264240000, -8.423],
                    [1449264240000, -8.363],
                    [1449457200000, -8.213],
                    [1449457200000, -8.043],
                    [1449465060000, -7.933],
                    [1449479940000, -7.858],
                    [1449480120000, -7.764],
                    [1449497160000, -7.86],
                    [1449497220000, -7.898],
                    [1449503340000, -7.793],
                    [1449503580000, -7.668],
                    [1449504420000, -7.578],
                    [1449506940000, -7.488],
                    [1449506940000, -7.348],
                    [1449507180000, -7.238],
                    [1449507660000, -7.058],
                    [1449509040000, -6.898],
                    [1449509040000, -6.698],
                    [1449519960000, -6.846],
                    [1449519960000, -6.943],
                    [1449544800000, -6.973],
                    [1449546720000, -6.923],
                    [1449551520000, -6.843],
                    [1449576780000, -6.756],
                    [1449579660000, -6.642],
                    [1449581940000, -6.552],
                    [1449581940000, -6.422],
                    [1449581940000, -6.292],
                    [1449582000000, -6.112],
                    [1449585120000, -6.112],
                    [1449585120000, -6.082],
                    [1449594720000, -6.422],
                    [1449595740000, -6.742],
                    [1449606480000, -6.672],
                    [1449606540000, -6.532],
                    [1449613920000, -6.516],
                    [1449613980000, -6.47],
                    [1449656280000, -6.37],
                    [1449657780000, -6.44],
                    [1449657840000, -6.46],
                    [1449659940000, -6.409],
                    [1449663180000, -6.359],
                    [1449663240000, -6.269],
                    [1449665220000, -6.197],
                    [1449669180000, -6.047],
                    [1449669180000, -5.867],
                    [1449673500000, -5.687],
                    [1449673800000, -5.487],
                    [1449675480000, -5.384],
                    [1449676380000, -5.206],
                    [1449676740000, -5.026],
                    [1449677340000, -4.826],
                    [1449677760000, -4.786],
                    [1449677880000, -4.696],
                    [1449678540000, -4.606],
                    [1449678540000, -4.476],
                    [1449679800000, -4.396],
                    [1449679800000, -4.296],
                    [1449682980000, -4.224],
                    [1449683040000, -4.073],
                    [1449683040000, -3.882],
                    [1449683040000, -3.736],
                    [1449690720000, -3.608],
                    [1449690780000, -3.408],
                    [1449741840000, -3.395],
                    [1449741840000, -3.337],
                    [1449751980000, -3.286],
                    [1449752040000, -3.183],
                    [1449756420000, -3.003],
                    [1449756600000, -2.933],
                    [1449758760000, -2.932],
                    [1449758820000, -2.897],
                    [1449760260000, -2.777],
                    [1449762000000, -3.077],
                    [1449762000000, -3.357],
                    [1449765300000, -3.197],
                    [1449769620000, -3.217],
                    [1449774960000, -3.079],
                    [1449775020000, -3.22],
                    [1449775020000, -3.261],
                    [1449775140000, -3.304],
                    [1449775860000, -3.364],
                    [1449776580000, -3.404],
                    [1449830940000, -3.324],
                    [1449830940000, -3.214],
                    [1449846480000, -3.067],
                    [1449846480000, -2.867],
                    [1449849360000, -3.107],
                    [1449851700000, -3.561],
                    [1449851700000, -3.995],
                    [1449854820000, -3.835],
                    [1449854820000, -3.655],
                    [1449857340000, -4.046],
                    [1449857880000, -4.416],
                    [1449858000000, -5.296],
                    [1449858060000, -6.156],
                    [1449858540000, -6.736],
                    [1449862560000, -6.816],
                    [1449868440000, -6.648],
                    [1450062240000, -6.808],
                    [1450084140000, -6.638],
                    [1450085880000, -6.577],
                    [1450085880000, -6.495],
                    [1450086600000, -6.375],
                    [1450086720000, -6.495],
                    [1450088820000, -6.425],
                    [1450089000000, -6.305],
                    [1450089660000, -6.205],
                    [1450096200000, -6.259],
                    [1450096560000, -6.293],
                    [1450096560000, -6.163],
                    [1450101480000, -7.081],
                    [1450101540000, -7.887],
                    [1450105020000, -8.177],
                    [1450105020000, -8.427],
                    [1450105560000, -8.51],
                    [1450106580000, -8.33],
                    [1450106580000, -8.13],
                    [1450111920000, -8.489],
                    [1450112100000, -8.828],
                    [1450114140000, -8.708],
                    [1450115040000, -8.568],
                    [1450124160000, -8.684],
                    [1450124280000, -8.644],
                    [1450124280000, -8.504],
                    [1450124580000, -8.6],
                    [1450124940000, -8.61],
                    [1450173540000, -8.58],
                    [1450173720000, -8.53],
                    [1450177200000, -8.852],
                    [1450177200000, -9.138],
                    [1450180320000, -9.058],
                    [1450180320000, -8.948],
                    [1450184700000, -8.768],
                    [1450186260000, -8.568],
                    [1450188840000, -8.638],
                    [1450190460000, -8.458],
                    [1450191780000, -8.352],
                    [1450191780000, -8.227],
                    [1450192740000, -8.197],
                    [1450192740000, -8.127],
                    [1450194060000, -8.733],
                    [1450195080000, -8.613],
                    [1450197660000, -8.433],
                    [1450197780000, -8.503],
                    [1450198500000, -8.533],
                    [1450198860000, -8.613],
                    [1450199580000, -8.673],
                    [1450199640000, -8.839],
                    [1450204320000, -8.939],
                    [1450204320000, -9.079],
                    [1450207500000, -9.53],
                    [1450210800000, -9.37],
                    [1450210980000, -9.19],
                    [1450219320000, -9.183],
                    [1450257180000, -9.156],
                    [1450273920000, -9.826],
                    [1450273920000, -10.426],
                    [1450283340000, -10.436],
                    [1450283400000, -10.411],
                    [1450291260000, -11.141],
                    [1450293780000, -11.671],
                    [1450294380000, -12.161],
                    [1450294740000, -12.871],
                    [1450295100000, -13.141],
                    [1450295100000, -13.381],
                    [1450297260000, -13.311],
                    [1450297260000, -13.191],
                    [1450335120000, -13.061],
                    [1450344240000, -12.881],
                    [1450371900000, -13.221],
                    [1450372860000, -13.591],
                    [1450373760000, -13.431],
                    [1450373760000, -13.231],
                    [1450378260000, -13.071],
                    [1450378500000, -12.891],
                    [1450383240000, -13.071],
                    [1450383480000, -13.191],
                    [1450384020000, -13.241],
                    [1450384020000, -13.231],
                    [1450414020000, -13.261],
                    [1450414560000, -13.231],
                    [1450430820000, -13.141],
                    [1450430820000, -13.011],
                    [1450430820000, -12.871],
                    [1450434060000, -12.691],
                    [1450434120000, -12.491],
                    [1450440360000, -12.411],
                    [1450440420000, -12.301],
                    [1450440420000, -12.151],
                    [1450440420000, -11.981],
                    [1450464900000, -12.121],
                    [1450464900000, -12.211],
                    [1450470120000, -12.121],
                    [1450470120000, -12.011],
                    [1450683600000, -12.061],
                    [1450683960000, -12.091],
                    [1450686960000, -11.941],
                    [1450686960000, -11.751],
                    [1450691460000, -11.591],
                    [1450691460000, -11.411],
                    [1450696860000, -11.488],
                    [1450700640000, -11.488],
                    [1450700640000, -11.468],
                    [1450704780000, -11.438],
                    [1450704960000, -11.358],
                    [1450712820000, -11.318],
                    [1450712880000, -11.258],
                    [1450718940000, -11.148],
                    [1450718940000, -10.998],
                    [1450812000000, -11.108],
                    [1450812120000, -11.178],
                    [1450814160000, -11.118],
                    [1450814460000, -11.118],
                    [1450888740000, -10.938],
                    [1450889100000, -10.838],
                    [1450897680000, -11.608],
                    [1450897740000, -12.358],
                    [1450936020000, -12.458],
                    [1450936020000, -12.518],
                    [1450941180000, -12.368],
                    [1450944360000, -12.198],
                    [1450949280000, -12.098],
                    [1450949280000, -11.958],
                    [1450949340000, -11.978],
                    [1450949580000, -11.958],
                    [1450950540000, -11.838],
                    [1450952040000, -11.658],
                    [1450953900000, -11.618],
                    [1450954260000, -11.538],
                    [1450963320000, -11.618],
                    [1450963380000, -11.728],
                    [1450980360000, -11.588],
                    [1450980660000, -11.408],
                    [1450981020000, -11.528],
                    [1450982280000, -11.568],
                    [1451271660000, -11.528],
                    [1451273640000, -11.448],
                    [1451294820000, -11.398],
                    [1451294820000, -11.318],
                    [1451303100000, -11.218],
                    [1451303160000, -11.098],
                    [1451308140000, -11.078],
                    [1451313240000, -11.088],
                    [1451313240000, -11.058],
                    [1451318040000, -10.96],
                    [1451319540000, -10.78],
                    [1451319600000, -10.58],
                    [1451321280000, -10.572],
                    [1451323740000, -10.482],
                    [1451323860000, -10.372],
                    [1451334180000, -10.262],
                    [1451334240000, -10.112],
                    [1451334480000, -10.022],
                    [1451334480000, -9.902],
                    [1451334600000, -9.742],
                    [1451334660000, -9.542],
                    [1451335140000, -9.404],
                    [1451399520000, -9.414],
                    [1451400120000, -9.364],
                    [1451469600000, -9.274],
                    [1451469660000, -9.444],
                    [1451470260000, -9.314],
                    [1451470980000, -9.444],
                    [1451473980000, -9.304],
                    [1451474280000, -9.114],
                    [1451489580000, -8.954],
                    [1451489820000, -8.754],
                    [1451492940000, -8.705],
                    [1451492940000, -8.615],
                    [1451493780000, -8.445],
                    [1451496000000, -8.282],
                    [1451500860000, -8.182],
                    [1451500860000, -8.132],
                    [1451505600000, -7.962],
                    [1451505660000, -7.772],
                    [1451512140000, -7.652],
                    [1451535000000, -7.492],
                    [1451574720000, -7.372],
                    [1451577120000, -7.212],
                    [1451586480000, -7.182],
                    [1451880120000, -7.132],
                    [1451880360000, -7.032],
                    [1451894760000, -7.222],
                    [1451894880000, -7.382],
                    [1451896740000, -7.232],
                    [1451896740000, -7.052],
                    [1451903580000, -6.942],
                    [1451903580000, -6.802],
                    [1451926920000, -6.783],
                    [1451927100000, -6.744],
                    [1451927100000, -6.646],
                    [1451927100000, -6.518],
                    [1451927940000, -6.728],
                    [1451928060000, -6.918],
                    [1451928360000, -6.888],
                    [1451942040000, -6.898],
                    [1451965260000, -6.738],
                    [1451977980000, -6.538],
                    [1451985720000, -6.358],
                    [1452020700000, -6.368],
                    [1452020760000, -6.538],
                    [1452068280000, -6.558],
                    [1452068580000, -6.548],
                    [1452069240000, -6.408],
                    [1452069780000, -6.238],
                    [1452072840000, -6.098],
                    [1452078780000, -5.898],
                    [1452096720000, -6.108],
                    [1452097080000, -6.278],
                    [1452098880000, -6.108],
                    [1452098880000, -5.918],
                    [1452099300000, -5.828],
                    [1452100800000, -5.658],
                    [1452141540000, -5.488],
                    [1452144360000, -5.448],
                    [1452144420000, -5.458],
                    [1452144420000, -5.258],
                    [1452150540000, -5.078],
                    [1452157500000, -5.048],
                    [1452157620000, -4.978],
                    [1452172380000, -5.108],
                    [1452172680000, -5.208],
                    [1452182400000, -5.148],
                    [1452186120000, -5.138],
                    [1452187440000, -5.048],
                    [1452263460000, -4.988],
                    [1452264180000, -4.988],
                    [1452264240000, -4.898],
                    [1452264360000, -4.868],
                    [1452269220000, -4.768],
                    [1452269280000, -4.728],
                    [1452269400000, -4.798],
                    [1452269460000, -4.838],
                    [1452272700000, -4.762],
                    [1452281820000, -5.032],
                    [1452282120000, -5.262],
                    [1452481200000, -5.122],
                    [1452488580000, -5.192],
                    [1452488940000, -5.222],
                    [1452498780000, -5.082],
                    [1452499260000, -4.962],
                    [1452506100000, -4.882],
                    [1452506100000, -4.772],
                    [1452514422000, -4.652],
                    [1452514482000, -4.512],
                    [1452514542000, -4.322],
                    [1452514602000, -4.152],
                    [1452591755000, -4.302],
                    [1452592775000, -4.422],
                    [1452610234000, -4.302],
                    [1452617313000, -4.146],
                    [1452617373000, -4.014],
                    [1452617493000, -3.814],
                    [1452617733000, -3.634],
                    [1452619413000, -3.434],
                    [1452624393000, -3.314],
                    [1452638072000, -3.214],
                    [1452654090000, -3.114],
                    [1452658890000, -2.974],
                    [1452675808000, -2.894],
                    [1452677308000, -2.774],
                    [1452702566000, -2.724],
                    [1452703166000, -2.544],
                    [1452703346000, -2.414],
                    [1452704846000, -2.254],
                    [1452705566000, -2.074],
                    [1452760281000, -2.504],
                    [1452761721000, -3.014],
                    [1452782000000, -2.974],
                    [1452782540000, -2.894],
                    [1452791959000, -2.864],
                    [1452802998000, -2.804],
                    [1452857473000, -3.024],
                    [1452868512000, -3.214],
                    [1452869472000, -3.034],
                    [1452871332000, -2.964],
                    [1452871512000, -2.854],
                    [1452877092000, -2.754],
                    [1452877152000, -2.634],
                    [1452879072000, -2.504],
                    [1452881711000, -2.344],
                    [1452882551000, -2.164],
                    [1452882671000, -1.964],
                    [1453088574000, -1.784],
                    [1453114312000, -2.274],
                    [1453114552000, -2.724],
                    [1453123791000, -2.704],
                    [1453124631000, -2.644],
                    [1453125351000, -2.544],
                    [1453128891000, -2.404],
                    [1453136270000, -2.224],
                    [1453143050000, -2.064],
                    [1453143530000, -1.864],
                    [1453172447000, -1.774],
                    [1453172447000, -1.664],
                    [1453174067000, -1.544],
                    [1453177667000, -1.384],
                    [1453184866000, -1.184],
                    [1453200345000, -1.084],
                    [1453201725000, -0.914],
                    [1453210484000, -0.904],
                    [1453212884000, -0.854],
                    [1453212944000, -0.834],
                    [1453213064000, -0.774],
                    [1453216123000, -0.664],
                    [1453216243000, -0.514],
                    [1453218583000, -0.37],
                    [1453218643000, -0.263],
                    [1453218643000, -0.069],
                    [1453260700000, 0.077],
                    [1453284938000, -0.363],
                    [1453284938000, -0.773],
                    [1453287338000, -1.173],
                    [1453290697000, -1.533],
                    [1453295977000, -1.963],
                    [1453296097000, -2.353],
                    [1453304976000, -2.403],
                    [1453305396000, -2.433],
                    [1453323155000, -2.523],
                    [1453323155000, -2.573],
                    [1453325314000, -2.483],
                    [1453328614000, -2.373],
                    [1453329094000, -2.253],
                    [1453345293000, -2.073],
                    [1453378470000, -2.013],
                    [1453378470000, -1.933],
                    [1453386269000, -1.813],
                    [1453386269000, -1.673],
                    [1453387289000, -1.573],
                    [1453389209000, -1.423],
                    [1453389389000, -1.253],
                    [1453393289000, -1.123],
                    [1453393349000, -0.973],
                    [1453396288000, -0.823],
                    [1453396288000, -0.623],
                    [1453481661000, -0.793],
                    [1453482921000, -0.913],
                    [1453487121000, -0.743],
                    [1453494380000, -0.543],
                    [1453709102000, -0.583],
                    [1453709162000, -0.563],
                    [1453709282000, -0.833],
                    [1453711742000, -1.263],
                    [1453712222000, -1.653],
                    [1453713482000, -2.016],
                    [1453713902000, -2.333],
                    [1453713962000, -2.655],
                    [1453715102000, -2.936],
                    [1453715882000, -2.936],
                    [1453715882000, -2.896],
                    [1453732620000, -2.926],
                    [1453732680000, -2.936],
                    [1453735260000, -2.796],
                    [1453735740000, -2.616],
                    [1453777737000, -2.506],
                    [1453784276000, -2.376],
                    [1453791476000, -2.336],
                    [1453791655000, -2.256],
                    [1453797955000, -2.166],
                    [1453802395000, -2.026],
                    [1453814874000, -1.966],
                    [1453815054000, -1.866],
                    [1453821713000, -1.726],
                    [1453822013000, -1.546],
                    [1453911965429, -1.856],
                    [1453911965429, -2.126],
                    [1453916289057, -1.976],
                    [1453917309913, -1.806],
                    [1453986668185, -1.996],
                    [1453989670726, -1.816],
                    [1453991292081, -2.586],
                    [1453991352138, -2.416],
                    [1453991412185, -2.596],
                    [1453992012691, -3.516],
                    [1453992132785, -4.003],
                    [1453992132785, -4.723],
                    [1453992132785, -5.603],
                    [1453992793341, -5.553],
                    [1453992793341, -5.463],
                    [1453994835078, -5.812],
                    [1453994955183, -6.258],
                    [1453995255438, -6.561],
                    [1454001020299, -6.431],
                    [1454001020299, -6.281],
                    [1454002221304, -6.101],
                    [1454057751327, -6.141],
                    [1454058231722, -6.161],
                    [1454062135000, -6.011],
                    [1454062795556, -5.821],
                    [1454071563013, -5.691],
                    [1454081091009, -5.521],
                    [1454081691508, -5.681],
                    [1454085234505, -5.526],
                    [1454085474732, -5.329],
                    [1454085835032, -5.479],
                    [1454088777509, -5.599],
                    [1454102228792, -5.979],
                    [1454316314746, -5.799],
                    [1454337992972, -5.634],
                    [1454337992972, -5.714],
                    [1454337992972, -6.324],
                    [1454337992972, -6.304],
                    [1454338173124, -6.11],
                    [1454338593469, -6.04],
                    [1454346700325, -5.87],
                    [1454347300817, -6.19],
                    [1454347300817, -6.47],
                    [1454355648120, -6.29],
                    [1454420642847, -6.47],
                    [1454421003147, -6.63],
                    [1454443442056, -7.04],
                    [1454443502110, -7.41],
                    [1454466541461, -7.25],
                    [1454467262063, -7.05],
                    [1454479812591, -6.89],
                    [1454479872638, -6.69],
                    [1454479992747, -6.76],
                    [1454494885235, -6.61],
                    [1454501130476, -6.43],
                    [1454505454101, -6.43]
                ]
            }
        ]
    });

    assert.ok(
        chart.series[0].graph.element.getAttribute('d').length > 1000,
        'Has a long and nice graph'
    );
});
