QUnit.test('MIDI export basic', function (assert) {
    Highcharts.sonification.Sonification.prototype.forceReady = true;

    var basicChart = Highcharts.chart('container', {
            sonification: {
                duration: 4300,
                pointGrouping: {
                    enabled: true,
                    groupTimespan: 100
                },
                defaultInstrumentOptions: {
                    mapping: {
                        pitch: {
                            min: 0,
                            max: 128
                        }
                    }
                }
            },
            series: [{
                data: [
                    10, 14, 9, 2, 5, 3, 6, 14, 2, 3, 12, 4,
                    15, 17, 19, 2, 3, 11, 16, 11, 20
                ]
            }]
        }),
        basicChartMIDI = '77,84,104,100,0,0,0,6,0,0,0,1,1,244,77,84,114,107,' +
            '0,0,1,43,0,255,81,3,7,161,32,0,192,1,0,255,3,8,83,101,114,105,' +
            '101,115,32,49,50,176,10,1,0,144,69,127,129,72,128,69,127,0,176,' +
            '10,7,0,144,97,127,129,72,128,97,127,0,176,10,13,0,144,62,127,' +
            '129,72,128,62,127,0,176,10,19,0,144,12,127,129,72,128,12,127,0,' +
            '176,10,26,0,144,33,127,129,72,128,33,127,0,176,10,32,0,144,19,' +
            '127,129,72,128,19,127,0,176,10,38,0,144,40,127,129,72,128,40,' +
            '127,0,176,10,45,0,144,97,127,129,72,128,97,127,0,176,10,51,0,' +
            '144,12,127,129,72,128,12,127,0,176,10,57,0,144,19,127,129,72,' +
            '128,19,127,0,176,10,64,0,144,83,127,129,72,128,83,127,0,176,10,' +
            '70,0,144,26,127,129,72,128,26,127,0,176,10,76,0,144,104,127,129,' +
            '72,128,104,127,0,176,10,82,0,144,119,127,129,72,128,119,127,0,' +
            '176,10,89,0,144,5,127,129,72,128,5,127,0,176,10,95,0,144,12,127,' +
            '129,72,128,12,127,0,176,10,101,0,144,19,127,129,72,128,19,127,0,' +
            '176,10,108,0,144,76,127,129,72,128,76,127,0,176,10,114,0,144,' +
            '112,127,129,72,128,112,127,0,176,10,120,0,144,76,127,129,72,128,' +
            '76,127,0,176,10,127,0,144,12,127,129,72,128,12,127,0,255,47,0';

    assert.strictEqual(
        basicChart.sonification.timeline.getMIDIData().toString(),
        basicChartMIDI,
        'MIDI output is as expected'
    );

    delete Highcharts.sonification.Sonification.prototype.forceReady;
});


QUnit.test('MIDI export advanced', function (assert) {
    Highcharts.sonification.Sonification.prototype.forceReady = true;

    var advChart = Highcharts.chart('container', {
            sonification: {
                duration: 4300,
                pointGrouping: {
                    enabled: true,
                    groupTimespan: 100
                },
                defaultInstrumentOptions: {
                    mapping: {
                        pitch: {
                            min: 0,
                            max: 128
                        }
                    }
                }
            },
            series: [{
                data: [
                    10, 14, 9, 2, 5, 3, 6, 14, 2, 3, 12, 4,
                    15, 17, 19, 2, 3, 11, 16, 11, 20
                ]
            }, {
                sonification: {
                    tracks: [{}, {
                        mapping: {
                            tremoloDepth: 'x',
                            tremoloSpeed: 'y',
                            pan: 'x',
                            volume: {
                                mapTo: 'y',
                                mapFunction: 'logarithmic'
                            },
                            duration: {
                                mapTo: 'y',
                                min: 20,
                                max: 300
                            },
                            lowpass: {
                                frequency: {
                                    min: 2000,
                                    max: 5000,
                                    mapTo: 'x'
                                }
                            },
                            highpass: {
                                frequency: {
                                    min: 0,
                                    max: 200,
                                    mapTo: 'y'
                                },
                                resonance: {
                                    min: -3,
                                    max: 3,
                                    mapTo: 'y'
                                }
                            }
                        }
                    }]
                },
                data: [
                    1, 1, 51, 32, 60, 4, 12, 13, 1, 14,
                    15.1, 17.4, -19, 2, -3, 11, 16, 11, 0
                ]
            }]
        }),
        advChartMIDI = '77,84,104,100,0,0,0,6,0,1,0,4,1,244,77,84,114,107,0,' +
            '0,0,11,0,255,81,3,7,161,32,0,255,47,0,77,84,114,107,0,0,1,15,0,' +
            '192,1,0,255,3,8,83,101,114,105,101,115,32,49,25,176,10,1,0,144,' +
            '59,127,50,176,10,7,0,144,65,127,75,176,10,13,0,144,57,127,75,' +
            '128,59,127,25,176,10,19,0,144,46,127,25,128,65,127,75,128,57,' +
            '127,0,176,10,26,0,144,51,127,100,128,46,127,0,176,10,32,0,144,' +
            '48,127,100,128,51,127,0,176,10,38,0,144,53,127,75,176,10,45,0,' +
            '144,65,127,25,128,48,127,25,176,10,51,0,144,46,127,75,128,53,' +
            '127,0,176,10,57,0,144,48,127,75,128,65,127,25,176,10,64,0,144,' +
            '62,127,25,128,46,127,75,128,48,127,0,176,10,70,0,144,49,127,100,' +
            '128,62,127,0,176,10,76,0,144,67,127,100,128,49,127,0,176,10,82,' +
            '0,144,70,127,100,128,67,127,0,176,10,89,0,144,74,127,75,176,10,' +
            '95,0,144,46,127,25,128,70,127,25,176,10,101,0,144,48,127,75,128,' +
            '74,127,0,176,10,108,0,144,61,127,75,128,46,127,25,176,10,114,0,' +
            '144,69,127,25,128,48,127,75,128,61,127,0,176,10,120,0,144,61,' +
            '127,100,128,69,127,0,176,10,127,0,144,75,127,100,128,61,127,100,' +
            '128,75,127,0,255,47,0,77,84,114,107,0,0,0,248,0,192,1,0,255,3,8,' +
            '83,101,114,105,101,115,32,50,147,18,176,10,1,0,144,44,127,100,' +
            '176,10,7,0,144,44,127,75,176,10,13,0,144,125,127,25,128,44,127,' +
            '25,176,10,19,0,144,95,127,75,128,44,127,0,176,10,26,0,144,12,' +
            '127,75,128,125,127,25,176,10,32,0,144,49,127,25,128,95,127,75,' +
            '128,12,127,0,176,10,38,0,144,62,127,100,128,49,127,0,176,10,45,' +
            '0,144,64,127,100,128,62,127,0,176,10,51,0,144,44,127,100,128,64,' +
            '127,0,176,10,57,0,144,65,127,75,176,10,64,0,144,67,127,25,128,' +
            '44,127,25,176,10,70,0,144,71,127,75,128,65,127,0,176,10,76,0,' +
            '144,12,127,75,128,67,127,25,176,10,82,0,144,46,127,25,128,71,' +
            '127,75,128,12,127,0,176,10,89,0,144,38,127,100,128,46,127,0,176,' +
            '10,95,0,144,61,127,100,128,38,127,0,176,10,101,0,144,69,127,75,' +
            '176,10,108,0,144,61,127,25,128,61,127,25,176,10,114,0,144,43,' +
            '127,75,128,69,127,75,128,61,127,50,128,43,127,0,255,47,0,77,84,' +
            '114,107,0,0,2,40,0,192,1,0,255,3,8,83,101,114,105,101,115,32,50,' +
            '147,18,176,10,1,0,176,74,12,0,176,75,0,0,176,71,63,0,176,76,57,' +
            '0,144,44,70,100,176,10,7,0,176,74,13,0,176,75,0,0,176,71,63,0,' +
            '176,76,57,0,144,44,70,75,176,10,13,0,176,74,14,0,176,75,1,0,176,' +
            '71,63,0,176,76,71,0,144,125,124,25,128,44,70,25,176,10,19,0,176,' +
            '74,15,0,176,75,0,0,176,71,63,0,176,76,66,0,144,95,116,75,128,44,' +
            '70,0,176,10,26,0,176,74,16,0,176,75,1,0,176,71,63,0,176,76,73,0,' +
            '144,12,127,75,128,125,124,25,176,10,32,0,176,74,17,0,176,75,0,0,' +
            '176,71,63,0,176,76,58,0,144,49,85,25,128,95,116,75,128,12,127,0,' +
            '176,10,38,0,176,74,18,0,176,75,0,0,176,71,63,0,176,76,60,0,144,' +
            '62,100,100,128,49,85,0,176,10,45,0,176,74,19,0,176,75,0,0,176,' +
            '71,63,0,176,76,61,0,144,64,102,100,128,62,100,0,176,10,51,0,176,' +
            '74,20,0,176,75,0,0,176,71,63,0,176,76,57,0,144,44,70,100,128,64,' +
            '102,0,176,10,57,0,176,74,21,0,176,75,0,0,176,71,63,0,176,76,61,' +
            '0,144,65,103,75,176,10,64,0,176,74,22,0,176,75,0,0,176,71,63,0,' +
            '176,76,61,0,144,67,104,25,128,44,70,25,176,10,70,0,176,74,23,0,' +
            '176,75,0,0,176,71,63,0,176,76,62,0,144,71,106,75,128,65,103,0,' +
            '176,10,76,0,176,74,24,0,176,75,0,0,176,71,63,0,176,76,52,0,144,' +
            '12,12,75,128,67,104,25,176,10,82,0,176,74,25,0,176,75,0,0,176,' +
            '71,63,0,176,76,58,0,144,46,77,25,128,71,106,75,128,12,12,0,176,' +
            '10,89,0,176,74,26,0,176,75,0,0,176,71,63,0,176,76,56,0,144,38,' +
            '39,100,128,46,77,0,176,10,95,0,176,74,26,0,176,75,0,0,176,71,63,' +
            '0,176,76,60,0,144,61,99,100,128,38,39,0,176,10,101,0,176,74,27,' +
            '0,176,75,0,0,176,71,63,0,176,76,61,0,144,69,105,75,176,10,108,0,' +
            '176,74,28,0,176,75,0,0,176,71,63,0,176,76,60,0,144,61,99,25,128,' +
            '61,99,25,176,10,114,0,176,74,29,0,176,75,0,0,176,71,63,0,176,76,' +
            '57,0,144,43,60,75,128,69,105,75,128,61,99,50,128,43,60,0,255,47,0';

    assert.strictEqual(
        advChart.sonification.timeline.getMIDIData().toString(),
        advChartMIDI,
        'MIDI output is as expected'
    );

    delete Highcharts.sonification.Sonification.prototype.forceReady;
});
