/*
 * Copyright (C) Highsoft AS
 */

const gulp = require('gulp');
const log = require('../libs/log');

/**
 * Create the palette module file based on highcharts.css
 *
 * @return {Promise<void>}
 *         Promise to keep
 */
async function task() {
    const fs = require('fs');
    const path = require('path');
    const lines = fs.readFileSync(
        path.join(__dirname, '../../css/highcharts.css'), 'utf8'
    ).split('\n');
    const dataColors = [];

    let paletteTS = '',
        dataColorsComment = '',
        comment = '',
        commentOpen = false;
    lines.forEach(line => {

        // Start of comment
        if (line.indexOf('/*') > -1) {
            const parts = line.split('/*');
            comment = parts[1];
            commentOpen = true;

        // Inside a multiline comment
        } else if (commentOpen && line.indexOf('*/') === -1) {
            comment += line;
        }
        // End of comment, on the same line
        if (comment.indexOf('*/') > -1) {
            const parts = comment.split('*/');
            comment = parts[0];
            commentOpen = false;
        } else if (line.indexOf('*/') > -1) {
            const parts = line.split('*/');
            comment += parts[0];
            commentOpen = false;
        }


        if (line.trim().indexOf('--') === 0) {

            comment = comment
                .trim()
                .replace(/\s+/ug, ' ');

            const parts = line
                    .replace(/\r/u, '')
                    .split(':'),
                key = parts[0].trim()
                    .replace(/^--highcharts-/u, '')
                    // Camelcase
                    .replace(/-([a-z0-9])/gu, g => g[1].toUpperCase()),
                val = parts[1].split(';')[0].trim(),
                isHexColor = /^#[a-f0-9]{6}/u.test(val),
                isDataColor = /^color[0-9]+$/u.test(key);

            // Single color
            if (isHexColor && !isDataColor) {
                paletteTS += `    /**
     * ${comment}
     */
    ${key} = '${val}',\n`;

            // Array of colors
            } else if (isHexColor && isDataColor) {
                dataColorsComment = comment;
                dataColors.push(val);
            }
        }
    });

    fs.writeFileSync(
        path.join(__dirname, '../../ts/core/Color/Palettes.ts'),
        `/* eslint comma-dangle: 0, max-len: 0 */
import type ColorString from './ColorString';
/**
 * Palette for Highcharts. Palette colors are defined in highcharts.css.
 * **Do not edit this file!** This file is generated using the 'gulp palette' task.
 * @private
 */
export const enum Palette {\n${paletteTS}}
/**
 * Series palettes for Highcharts. Series colors are defined in highcharts.css.
 * **Do not edit this file!** This file is generated using the 'gulp palette' task.
 * @private
 */
const SeriesPalettes = {
    /**
     * ${dataColorsComment}
     */
    colors: [
        '${dataColors.join('\',\n        \'')}'
    ] as Array<ColorString>,
};
export default SeriesPalettes;
`,
        'utf8'
    );
    log.success('Wrote palette colors to ts/Core/Color/Palettes.ts');

}

gulp.task('palette', task);
