# Highcharts Dashboards

Highcharts Dashboards is a JavaScript library for interactive dashboards from the creators of the [Highcharts](https://github.com/highcharts/highcharts) charting library.

With built-in data synchronization, ready-made components and completely customizable options, Highcharts Dashboards does all the heavy lifting out of the box, saving you valuable time on your dashboard projects.

Note that this library also includes [Highcharts DataGrid](https://www.highcharts.com/docs/datagrid/general), that can be used as a standalone component outside of Dashboards if needed.

- Official website: [www.highcharts.com](http://www.highcharts.com)
- Product page: [www.highcharts.com/products/dashboards](https://www.highcharts.com/products/dashboards/)
- Documentation: [www.highcharts.com/docs/dashboards/installation](https://www.highcharts.com/docs/dashboards/installation)
- Demos: [https://www.highcharts.com/demo](https://www.highcharts.com/demo#highcharts-dashboards-demo-basic)
- Download page: [www.highcharts.com/download](http://www.highcharts.com/download)

- Licensing: [shop.highcharts.com](https://shop.highcharts.com/)
- Support: [www.highcharts.com/support](http://www.highcharts.com/support)
- Issues: [Repo guidelines](repo-guidelines.md)

Highcharts Dashboards is a [source available](https://en.wikipedia.org/wiki/Source-available_software) product. Please refer to [shop.highcharts.com](https://shop.highcharts.com/) for details on licensing.

## Installation

If you simply want to include Highcharts Dashboards into a project, use the [distribution package](https://www.npmjs.com/package/@highcharts/dashboards), or read the [download page](http://www.highcharts.com/download).

Please note that there are several ways to use Highcharts Dashboards. For general installation instructions, see [installation documentation](https://highcharts.com/docs/dashboards/installation)

### Use our CDN

Instead of downloading, you can use our CDN to access files directly. See [code.highcharts.com](https://code.highcharts.com) for details.

```HTML
    <script src="https://code.highcharts.com/dashboards/dashboards.js"></script>
    <link rel="stylesheet" src="https://code.highcharts.com/dashboards/css/dashboards.css">
```

### Install from npm

See [npm documentation](https://docs.npmjs.com/) on how to get started with npm.

Using npm by running the following command in your terminal:

```Shell
    npm install @highcharts/dashboards
```

Then import the package in your project:

```JS
    import Dashboards from '@highcharts/dashboards';
```

For other ways to use Highcharts Dashboards in your projects, please refer to our [installation documentation](https://highcharts.com/docs/dashboards/installation).
