<?php

include './inc/phpQrcode.class.php';
include './inc/poster.class.php';

//辅助类函数，转换单位
function changeFileSize($size, $dec = 2) {
    $a = array('Byte', 'KB', 'MB', 'GB', 'TB', 'PB');
    $pos = 0;
    while ($size >= 1024) {
        $size /= 1024;
        $pos++;
    }
    return round($size, $dec) . ' ' . $a[$pos];
}

//二维码生成内容
$code = 'https://www.baidu.com/';
//生成二维码图片
$qrCodeData = QRcode::pngData($code, 13);

$config = array(
    'bg_url' => './img/haibao.jpg',//背景图片路径
    'text' => array(
        array(
            'text' => '某某小区的房子出售',//文本内容
            'left' => 70, //左侧字体开始的位置
            'top' => 90, //字体的下边框
            'fontSize' => 16, //字号
            'fontColor' => '255,87,34', //字体颜色
            'angle' => 0,
        ),
        array(
            'text' => '汇川区 出售',//文本内容
            'left' => 70, //左侧字体开始的位置
            'top' => 140, //字体的下边框
            'fontSize' => 14, //字号
            'fontColor' => '76,175,80', //字体颜色
            'angle' => 0,
        ),
        array(
            'text' => '你不运动，地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动地球也会动',
            'left' => 70,
            'top' => 190,
            'width' => 250,
            'fontSize' => 12, //字号
            'fontColor' => '47,47,47', //字体颜色
            'angle' => 0,
        ),
        array(
            'text' => '电话: 15555555555',//文本内容
            'left' => 180, //左侧字体开始的位置
            'top' => 415, //字体的下边框
            'fontSize' => 12, //字号
            'fontColor' => '76,175,80', //字体颜色
            'angle' => 0,
        ),
        array(
            'text' => '觅分类信息网',//文本内容
            'left' => 180, //左侧字体开始的位置
            'top' => 450, //字体的下边框
            'fontSize' => 12, //字号
            'fontColor' => '76,175,80', //字体颜色
            'angle' => 0,
        ),
        array(
            'text' => 'www.mifenlei.com',//文本内容
            'left' => 180, //左侧字体开始的位置
            'top' => 480, //字体的下边框
            'fontSize' => 12, //字号
            'fontColor' => '76,175,80', //字体颜色
            'angle' => 0,
        ),
 
    ),
    'image' => array(
        array(
            'name' => 'logo', //图片名称，用于出错时定位
            'url' => './img/logo.png',
            'stream' => 0,
            'left' => 170,
            'top' => 515,
            'right' => 0,
            'bottom' => 0,
            'width' => 140,
            'height' => 40,
            'radius' => 0,
            'opacity' => 100
        ),
        array(
            'name' => '二维码', //图片名称，用于出错时定位
            'url' => '',
            'stream' => $qrCodeData,
            'left' => 65,
            'top' => 395,
            'right' => 0,
            'bottom' => 0,
            'width' => 100,
            'height' => 100,
            'radius' => 0,
            'opacity' => 100
        ),
 
    )
);

//设置海报背景图
poster::setConfig($config);
//设置保存路径
$res = poster::make();
//是否要清理缓存资源
poster::clear();
if (!$res) {
    echo '生成失败：', poster::getErrMessage();
} else {
    header("content-type:image/png");
    echo $res;
}
echo '消耗内存：', changeFileSize(memory_get_usage());
