﻿<%
''' EYCMS 系统核心函数 
''' ==================================================================

dim eycms,sysdata,get_cate_option
dim get_content_page
set eycms=new eycms_function
	eycms.init
class eycms_function
	private reg,match,matches
	private fso,stm
	public db,temp,page,sysdb,classdb
	
	private sub class_initialize
		set reg=new regexp
			reg.ignorecase=true
			reg.global=true
		set fso=createobject("scripting.filesystemobject") 
		set stm=server.createobject("adodb.stream")
		set sysdb=server.createobject("scripting.dictionary")
		set classdb=server.createobject("scripting.dictionary")
	end sub
	
	private sub class_terminate
		set reg=nothing
		set fso=nothing
		set stm=nothing
		set sysdb=nothing
		set classdb=nothing
		set page=nothing
		set db=nothing
	end sub
	
	public sub init()
		set db=new eycms_dbbase
		set page=new eycms_pagelist
		set temp=new eycms_template
	end sub
	
	public sub show(byval t0,byval t1)
		dim temproot:temproot=getsplitname(t0)
		temp.isgzip=isgzip
		temp.iscache=tempcache
		temp.isencry=tempencry
		temp.cname=t1
		temp.cachepath=webroot&"cache/theme/"&theme_root&temproot(0)
		temp.templatepath=webroot&"theme/"&theme_root&temproot(0)
		temp.templatename=temproot(1)
		temp.templateext=temproot(2)
		temp.load()
		temp.display()
	end sub
	
	public sub sitedb()
		dim i,t0
		t0=eycmsdata
		for i=0 to ubound(t0,2)
			if sysdb.exists(t0(0,i)) then
				sysdb.item(t0(0,i))=t0(1,i)
			else
				sysdb.add t0(0,i),t0(1,i)
			end if
		next
	end sub
	
	public sub catedb()
		dim i,t0,t1
		t0=categorydata
		if isarray(t0) then
			for i=0 to ubound(t0,2)
			t1=array(t0(0,i),t0(1,i),t0(2,i),t0(3,i),t0(4,i),t0(5,i),t0(6,i),t0(7,i),t0(8,i),t0(9,i),t0(10,i),t0(11,i),t0(12,i),t0(13,i),t0(14,i),t0(15,i),t0(16,i),t0(17,i),t0(18,i),t0(19,i),t0(20,i),t0(21,i),t0(22,i),t0(23,i),t0(24,i),t0(25,i),t0(26,i),t0(27,i),t0(28,i),t0(29,i),t0(30,i),t0(31,i),t0(32,i))
				if classdb.exists(t0(0,i)) then
					classdb.item(t0(0,i))=t1
				else
					classdb.add t0(0,i),t1
				end if
			next
		end if
	end sub
	
	public sub auto_update()
		exit sub
	end sub
	
	public sub order_auto(byval t0,byval t1)
		exit sub
	end sub
	
	public function getsys(byval t0)
		getsys=sysdb.item(t0)
		getsys=replace(getsys,"{webroot}",webroot)
	end function
	
	public function getclassdb(byval t0)
		getclassdb=classdb.item(cdbl(t0))
	end function
	
	public function runtime()
		runtime=formatnumber(timer()-startime,4,true,false,true)
	end function
	
	public sub echo(byval t0)
		response.write t0
	end sub
	
	public sub die()
		response.end()
	end sub

	sub ajaxjson(byval t0,byval t1)
		dim t2:t2=iif(t1=1,"y","n")
		echo "{""info"":"""&t0&""",""status"":"""&t2&"""}"
	end sub
	
	public sub trans(t0)
		err.clear
		on error resume next
		server.transfer t0
		if err then
			echo "&#25991;&#20214;&#27809;&#26377;&#29983;&#25104;&#65292;&#26080;&#27861;&#35775;&#38382;"
			err.clear
		end if
	end sub
	
	public sub go(byval t0)
		response.redirect t0
	end sub
	
	function strlen(byval t0)
		if isnull(t0) then strlen=0:exit function
		strlen=len(t0)
	end function
	
	function is_null(byval t0)
		if isnull(t0) or isempty(t0) or t0="" then
			is_null=true
		else
			is_null=false
		end if
	end function
	
	public sub back(byval t0)
		echo "<script>alert("""&t0&""");location.href=""javascript:history.go(-1)""</script>"
	end sub
	
	public sub backurl(byval t0,byval t1)
		echo "<script>alert("""&t0&""");location.href="""&t1&"""</script>"
	end sub
	
	public sub script(byval t0)
		echo "<script>"&t0&"</script>"
	end sub
	
	public function iif(byval t0,byval t1,byval t2)
		if t0 then iif=t1 else iif=t2
	end function
	
	public function iiif(byval t0,byval t1,byval t2,byval t3,byval t4)
		if t0 then
			iiif=t2
		elseif t1 then
			iiif=t3
		else
			iiif=t4
		end if
	end function
	
	public function sqlstr(byval t0)
		sqlstr="'"&replace(t0,"'","''")&"'"
		sqlstr=replace(sqlstr,"%27","")
	end function
	
	public function fget(byval t0,byval t1)
		fget=request.querystring(t0)
		if t1=0 then fget=trim(fget)
	end function
	
	public function fpost(byval t0,byval t1)
		fpost=request.form(t0)
		if t1=0 then fpost=trim(fpost)
		if t1=2 then fpost=rtrim(fpost)
	end function
	
	public function fquery(byval t0,byval t1)
		fquery=request(t0)
		if t1=0 then fquery=trim(fquery)
	end function
	
	public function isnum(byval t0)
		isnum=true
		if not isnumeric(t0) then isnum=false
	end function
	
	public function ismoney(byval t0)
		ismoney=true
		if not isnumeric(t0) then ismoney=false:exit function
		if t0<0 then ismoney=false
	end function
	
	public function isSame(byval t0,byval t1)
		isSame=false
		if isnumeric(t0) and isnumeric(t1) then
			if CInt(t0)=CInt(t1) then isSame=true
		else
			if Cstr(t0)=Cstr(t1) then isSame=true
		end if
	end Function

	public function isinstall(byval t0)
		err.clear
		on error resume next
		isinstall=false
		dim obj
		set obj=server.createobject(t0)
			if err.number=0 then isinstall=true
		set obj=nothing
		err.clear()
	end function
	
	public function get_ismobile()
		if not(getsys("sys_mobile")) then exit function
		dim t1:t1=request.servervariables("http_user_agent")
		if eycms.strlen(t1)=0 then get_ismobile=false:exit function
		dim arr
		arr=array("android","phone","ipod","mqqbrowser","blackberry","nokia","windowsce","symbian","lg","ucweb","skyfire","webos","incognito","blackberry","mobile","bada")
		dim i
		for i=0 to ubound(arr)
			if instr(lcase(t1),arr(i))>0 then
				dim t0:t0=true
				exit for
			end if
		next
		if t0 then
			if webmode=3 then webmode=1
		end if
		get_ismobile=t0
	end Function

	public function getrnd(byval t0)
		randomize
		dim n1,n2,n3
		t0=getint(t0,10)
		do while len(getrnd)<t0  
			n1=cstr(chrw((57-48)*rnd+48))
			n2=cstr(chrw((90-65)*rnd+65))
			n3=cstr(chrw((122-97)*rnd+97))
			getrnd=getrnd&n1&n2&n3 
		loop
	end function
	
	public function getrndfilename()
		dim t0,t1
		randomize
		t0=int(900*rnd)+100
		t1=now()
		getrndfilename=year(t1)&month(t1)&day(t1)&hour(t1)&minute(t1)&second(t1)&t0
	end function
	
	public function get_second(byval t0)
		dim a:a=t0
		dim b:b="1970-1-1 23:59:59"
		dim c:c=datediff("s",b,a)
		get_second=c
	end function
	
	public function get_pinyin(byval t0)
		t0=replace(t0," ","-")
		t0=replace(t0,"　","-")
		dim py
		set py=new eycms_pinyin
			get_pinyin=py.pinyin(t0)
		set py=nothing
		get_pinyin=left(get_pinyin,50)
	end function
	
	public function get_english(byval t0)
		on error resume Next
		Dim query,appid,appkey,salt,sign
		query=t0
		appid="20160201000010190"
		appkey="RgF7uzudNDOneNG4BA9w"
		salt=year(Date())&right("000000"&cstr(clng(timer()*1000)+1),6)
		sign=md5_32(appid & query & salt & appkey)
		dim url
		url="http://api.fanyi.baidu.com/api/trans/vip/translate?q="&server.urlencode(t0)&"&from=zh&to=en&appid="&appid&"&salt="&salt&"&sign="&sign
		dim html
		html=gethttp(url,"")
		html=left(html,len(html)-4)
		html=split(html,"""dst"":""")
		dim str:str=html(1)
		str=lcase(replace(str," ","-"))
		if err then err.clear:str=""
		get_english=str
	end function
	
	public function split_tags(byval t0)
		on error resume next
		dim xml,objnodes,i,str
		t0=server.urlencode(t0)
		set xml=server.createObject("microsoft.xmldom")
		with xml
			.async="false"
			.resolveexternals="false"
			.setproperty "ServerHTTPRequest",true
			.load("http://keyword.discuz.com/related_kw.html?title="&t0&"&ics=utf-8&ocs=utf-8")
			if .getelementsbytagname("info")(0).selectsinglenode("count").text>0 then
				set objnodes=.getelementsbytagname("item")
				for i=0 to objnodes.length-1
					str=str&trim(objnodes(i).selectsinglenode("kw").text)&","
				next
				set objnodes=nothing
				str=left(str,len(str)-1)
			else
				str=""
			end If
		end with
		set xml=nothing
		if err then err.clear:str=""
		split_tags=str
	end function
	
	public function get_express(byval t0)
		if checkcache("express",0) then
			get_express=loadcache("express",0)
		else
			dim url:url="http://182.254.131.222/Express/GetExpressInfo?postid="&t0&"&format=xml"
			dim xml,objnodes,i,str
			set xml=server.createObject("microsoft.xmldom")
			with xml
			.async="false"
				.resolveexternals="false"
				.setproperty "ServerHTTPRequest",true
				.load(url)
				if .getelementsbytagname("GetExpressInfoResult")(0).selectsinglenode("status").text="200" then
					set objnodes=.getelementsbytagname("d2p1:ExpressInfo")
					for i=0 to objnodes.length-1
						str=str&"<li><span>"&trim(objnodes(i).selectsinglenode("d2p1:acceptTime").text)&"</span>"&trim(objnodes(i).selectsinglenode("d2p1:remark").text)&"</li>"
					next
					set objnodes=nothing
				else
					str="<li>单号不存在或者已经过期</li>"
				end if
			end with
			set xml=nothing
			str="<ul>"&str&"</ul>"
			setcache "express",str,0
			get_express=str
		end if
	end function
	
	public function get_frist_pic(byval t0)
		get_frist_pic=""
		if strlen(t0)=0 then exit function
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   get_frist_pic=matches(0).submatches(0)
		end if
	end function

	public function replacetext(byval t0,byval t1,byval t2)
		reg.pattern=t1
		reg.ignorecase=true
		reg.global=true
		replacetext=reg.replace(""&t0&"",""&t2&"")
	end Function

	public function getRquestParam(byval t0,byval t1)
		reg.pattern=t1
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   getRquestParam=matches(0).submatches(0)
		end if
	end Function
	
	public function getkey()
		getkey=getrnd(5)
	end function

	public function get_thisfolder
		dim a,b,c
		a=request.servervariables("script_name")
		b=split(a,"/")
		c=ubound(b)
		if c<=1 then
			get_thisfolder=""
		else
			get_thisfolder=b(c-2)
		end if
	end function
	
	public function getsplitname(byval t0)
		dim str:str=t0
		if t0="" then
			echo "模板文件不能为空":die
		end if
		if instr(t0,".")<=0 then
			echo "模板路径错误("&t0&")":die
		end if
		dim str_arr:str_arr=split(str,"/")
		dim file_full_name:file_full_name=str_arr(ubound(str_arr))
		dim file_dir:file_dir=replace(t0,file_full_name,"")
		dim filearr:filearr=split(file_full_name,".")
		dim filename:filename=filearr(0)
		dim file_fix:file_fix=filearr(1)
		if len(file_dir)=0 then file_dir="/" else file_dir="/"&file_dir
		getsplitname=array(file_dir,filename,file_fix)
	end function
	
	public function getint(byval t0,byval t1)
		on error resume next
		if isnum(t0) then getint=cdbl(t0) else getint=t1
		if err then
			errlog "getint："&t0&","&t1&"<br>详情："&err.description,1
			err.clear
		end if
	end function
	
	public function getprice(byval t0,byval t1)
		if isnum(t0) then getprice=t0 else getprice=t1
	end function
	
	public function get_int(byval t0,byval t1)
		get_int=iif(checkstr(t0,"int"),t0,t1)
	end function
	
	public function getdate(byval t0,byval t1,byval t2)
		getdate=""
		if t2=1 then getdate=getdate&year(t0)&t1
		getdate=getdate&right("0"&month(t0),2)&t1
		getdate=getdate&right("0"&day(t0),2)
	end function
	
	public function numtodate(byval t0)
		if not isnumeric(t0) or len(t0)<>8 then
			numtodate=""
		else
			numtodate=mid(t0,1,4)&"-"&mid(t0,5,2)&"-"&mid(t0,7,2)
		end if
	end function
	
	public function getnum(byval t0)
		getnum=formatnumber(t0,2,true,false,true)
	end function
	
	public function getmoney(byval t0)
		If strlen(t0)=0 Then t0=0
		getmoney=formatcurrency(t0,2,true,false,true)
	end function
	
	public function get_discount(byval t0,byval t1)
		dim t2
		if t0=0 or t1=0 then
			t2=0
			get_discount="-"
			exit function
		else
			t2=t0/t1
		end if
		get_discount=formatnumber(t2,2,true,false,true)
		if right(get_discount,1)="0" then get_discount=left(get_discount,len(get_discount)-1)
		get_discount=get_discount*10
		if get_discount=10 then get_discount="-"
	end function
	
	public function getdot(byval t0)
		if t0<1 and t0>0 then
			if left(t0,1)<>"0" then t0="0"&t0
		end if
		getdot=t0
	end function
	
	public function getpcent(byval t0,byval t1)
		dim t2
		if t1="" then
			t1=0
			t2="0%"
		else
			t2="0.00%"
		end if
		if isnum(t0) then getpcent=formatpercent(t0,t1,true) else getpcent=t2
	end function
	
	public function getthisurl()
		dim t0
		t0=fget("url",0)
		if len(t0)>0 then
			getthisurl=t0
		else
			t0=request.servervariables("http_x_rewrite_url")
			if len(t0)=0 then t0=request.servervariables("http_x_original_url")
			if len(t0)>0 then
				getthisurl=weburl&t0
			else
				dim t5 
				dim t1,t2,t3,t4 
				t1=request.servervariables("server_name") 
				t2=request.servervariables("server_port") 
				t3=request.servervariables("script_name") 
				t4=request.servervariables("query_string") 
				t5="http://"&t1 
				if t2<>"80" then t5=t5&":"&t2 
				t5=t5&t3 
				if t4<>"" then t5=t5&"?"&t4 
				getthisurl=t5
			end if
		end if
		getthisurl=enhtml(replace(getthisurl,"&","%26"))
	end function
	
	public function geturlparam()
		dim x,queryarray,tempstr
		for each x in split(request.querystring,"&")
		   queryarray=split(x,"=")
		   if ubound(queryarray)>0 then
			   if lcase(queryarray(0))<>"page" then
				   tempstr=tempstr&queryarray(0)&"="&queryarray(1)&"&"
			   end if
		   end if
		next
		geturlparam=enhtml(tempstr)
	end function
	
	public function getip()
		getip=request.servervariables("http_x_forwarded_for")
		if getip="" then getip=request.servervariables("remote_addr")
		if not(checkstr(getip,"ip")) then getip="unknow"
	end function
	
	public function gethttp(byval t0,byval t1)
		select case t1
			case "get","post"
			case else:t1="get"
		end select
		on error resume next
		dim http
		set http=server.createobject(xmlhttp)
			http.open t1,t0,false
			http.setRequestHeader "If-Modified-Since","0"
			http.send()
			If http.Readystate<>4 then
				Set http=nothing
				gethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				gethttp=http.responsetext
			else
				Set http=nothing
				gethttp="ERR"
				Exit function
			end if
		set http=nothing
		if err then 
			gethttp="0"&err.description
			errlog "网址："&t0&"<br>函数：gethttp<br>详情："&err.description,1
			eycms.echo " <a href="""&webroot&""">返回网站</a>"
			err.clear
			die
		end if
	end function
	
	public function sethttp(byval t0,byval t1)
		dim http
		set http=server.createobject(xmlhttp)
			http.open "POST",t0,false
			http.setRequestHeader "Content-Type","application/x-www-form-urlencoded"
			http.send(t1)
			If http.Readystate<>4 then
				Set http=nothing
				sethttp="ERR"
				Exit function
			End if
			if http.status=200 then
				sethttp=http.responsetext
			else
				Set http=nothing
				sethttp="ERR"
				Exit function
			end if
		set http=nothing
	end function
	
	public function deal_strmid(byval t0,byval t1)
		if len(t0)=0 or len(t1)=0 then deal_strmid="":exit function
		dim i,t2,t3
		t2=split(t0,t1)
		t3=""
		for i=0 to ubound(t2)
			if len(t2(i))>0 then
				if len(t3)=0 then
					t3=t2(i)
				else
					t3=t3&t1&t2(i)
				end if
			end if
		next
		deal_strmid=t3
	end function
	
	public function is_pic(byval t0)
		if isnull(t0) or len(t0)=0 then is_pic=0:exit function
		if instr(t0,".")<0 then is_pic=0:exit function
		if len(t0)<4 then is_pic=0:exit function
		select case lcase(right(t0,3))
			case "gif","jpg","bmp","png":is_pic=1
			case else:is_pic=0
		end select
	end function
	
	public function is_video(byval t0)
		if isnull(t0) or len(t0)=0 then is_video="other":exit function
		if instr(t0,".")<0 then is_video="other":exit function
		if len(t0)<4 then is_video="other":exit function
		if instr(lcase(t0),".swf")>0 and instr(lcase(t0),"http://") then is_video="swf":exit function
		select case lcase(right(t0,3))
			case "flv":is_video="flv"
			case "swf":is_video="swf"
			case "mp4":is_video="mp4"
			case else:is_video="other"
		end select
	end function
	
	public function nohtml(byval t0)
		if strlen(t0)=0 then nohtml="":exit Function
		t0 = Replace(t0, "<br />", "[br]",1,-1,1)
		t0 = Replace(t0, "<br/>", "[br]",1,-1,1)
		t0 = Replace(t0, "<br>", "[br]",1,-1,1)
		reg.pattern="<.+?>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"")
		next
		t0=replace(t0,"&nbsp;"," ")
		t0=replace(t0,"　","")
		t0 = Replace(t0, "[br]", "<br>",1,-1,1)
		t0 = Replace(t0, "<br><br>", "<br>",1,-1,1)
		nohtml=t0
	end Function
	
	public function dishtml(byval t0)
		if strlen(t0)=0 then dishtml="":exit function
		reg.pattern="<.+?>"
		set matches=reg.execute(t0)
		for each match in matches
			t0=replace(t0,match.value,"")
		next
		t0=replace(t0,"&nbsp;"," ")
		t0=replace(t0,"　","")
		dishtml=t0
	end Function
	
	public function enhtml(byval t0)
		if isnull(t0) then enhtml="":exit function
		if t0="<p>&nbsp;</p>" then enhtml="":exit function
		reg.pattern ="<script.+?/script>"
		t0=reg.replace(t0,"")
		reg.pattern ="<iframe.+?/iframe>"
		t0=reg.replace(t0,"")
		t0=replace(t0,"&","&amp;")
		t0=replace(t0,"'","&#39;")
		t0=replace(t0,"""","&quot;")
		t0=replace(t0,"<","&lt;")
		t0=replace(t0,">","&gt;")
		reg.pattern="(w)(here)"
		t0=reg.replace(t0,"$1h&#101;re")
		reg.pattern="(s)(elect)"
		t0=reg.replace(t0,"$1el&#101;ct")
		reg.pattern="(i)(nsert)"
		t0=reg.replace(t0,"$1ns&#101;rt")
		reg.pattern="(c)(reate)"
		t0=reg.replace(t0,"$1r&#101;ate")
		reg.pattern="(d)(rop)"
		t0=reg.replace(t0,"$1ro&#112;")
		reg.pattern="(a)(lter)"
		t0=reg.replace(t0,"$1lt&#101;r")
		reg.pattern="(d)(elete)"
		t0=reg.replace(t0,"$1el&#101;te")
		reg.pattern="(u)(pdate)"
		t0=reg.replace(t0,"$1p&#100;ate")
		reg.pattern="(\s)(or)"
		t0=reg.replace(t0,"$1o&#114;")
		reg.pattern="(java)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		reg.pattern="(j)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		reg.pattern="(vb)(script)"
		t0=reg.replace(t0,"$1scri&#112;t")
		if instr(t0,"expression")<>0 then
			t0=replace(t0,"expression","e&#173;xpression",1,-1,0)
		end if
		enhtml=t0
	end function
	
	public function theme_html(byval t0)
		t0=replace(t0,"&","&amp;")
		t0=replace(t0,"'","&#39;")
		t0=replace(t0,"""","&quot;")
		t0=replace(t0,"<","&lt;")
		t0=replace(t0,">","&gt;")
		theme_html=t0
	end function
	
	public function dehtml(byval t0)
		if isnull(t0) then
			dehtml=""
			exit function
		end if
		t0=replace(t0,"&amp;","&")
		t0=replace(t0,"&#39;","'")
		t0=replace(t0,"&quot;","""")
		t0=replace(t0,"&lt;","<")
		t0=replace(t0,"&gt;",">")
		t0=replace(t0,chr(10),vbcrlf)
		dehtml=t0
	end function
	
	public function checkstr(byval t0,byval t1)
		dim t2
		select case t1
			case "null":checkstr=is_null(t0):exit function
			case "en":t2="^[a-zA-Z]+$"
			case "cn":t2="^[\u4e00-\u9fa5]+$"
			case "int":t2="^[-\+]?\d+$"
			case "price":t2="^\d+(\.\d+)?$"
			case "username":t2="^[a-zA-Z0-9_]{5,20}$"
			case "password":t2="^[a-zA-Z0-9.]{6,16}$"
			case "email":t2="^[\w\-\.]+@[a-zA-Z0-9]+\.(([a-zA-Z0-9]{2,4})|([a-zA-Z0-9]{2,4}\.[a-zA-Z]{2,4}))$"
			case "date":checkstr=isdate(t0):exit function
			case "qqemail":t2="^[\w\-\.]+@qq.com"
			case "tel":t2="^((\(\+?\d{2,3}\))|(\+?\d{2,3}\-))?(\(0?\d{2,3}\)|0?\d{2,3}-)?[1-9]\d{4,7}(\-\d{1,4})?$"
			case "mobile":t2="^(\+?\d{2,3})?0?1(3\d|5\d|7[0]|8[0256789])\d{8}$"
			case "zipcode":t2="^\d{6}$"
			case "qq":t2="^[1-9]\d{4,15}$"
			case "url":t2 = "^(http|https|ftp):\/\/[a-zA-Z0-9]+\.[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\""])*$"
			case "ip":t2="^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)$"
			case "file":t2="^[a-zA-Z0-9/_-]{1,50}$"
			case "filename":t2="^[a-zA-Z0-9._\-/]{1,50}$"
			case "urlname":t2="^[a-zA-Z0-9]{1,50}$"
		end select
		reg.pattern=t2
		checkstr=reg.test(trim(t0))
	end function

	public function regtest(byval t0,byval t1)
		reg.pattern=t1
		regtest=reg.test(trim(t0))
	end Function

	public function cutstr(byval t0,byval t1,byval t2)
		dim l,t,c,i
		if strlen(t0)=0 then cutstr="":exit function
		l=len(t0)
		t1=int(t1)
		t=0
		for i=1 to l
			c=ascw(mid(t0,i,1))
			if c<0 or c>255 then t=t+2 else t=t+1
			if t>t1 then
				cutstr=left(t0,i)
				if t2=1 then cutstr=cutstr&"…"
				exit for
			else
				cutstr=t0
			end if
		next
	end function
	
	public function checkpost
		checkpost=false
		dim t0,t1,t2
		t0=cstr(request.servervariables("http_referer"))
		t1=cstr(request.servervariables("server_name"))
		t2=request.servervariables("http_user_agent")
		if instr(lcase(t2),"firefox")>0 Then
			checkpost=true
			exit function
		end if
		if instr(t0,replace(replace(t1,"http://",""),"www.",""))=0 then
			checkpost=false
		else
			checkpost=true
		end if
	end function
	
	public function closehtml(byval t0)
		dim t1,i,t2,t3,j
		t1=array("p","div","span","table","ul","font","b","u","i","h1","h2","h3","h4","h5","h6")
		for i=0 to ubound(t1)
			t2=0:t3=0
			reg.pattern="\<"&t1(i)&"( [^\<\>]+|)\>"
			set matches=reg.execute(t0)
			for each match in matches
				t2=t2+1
			next
			reg.pattern="\</"&t1(i)&"\>"
			set matches=reg.execute(t0)
			for each match in matches
				t3=t3+1
			next
			for j=1 to t2-t3
				t0=t0+"</"&t1(i)&">"
			next
		next
		closehtml=t0
	end function
	
	public function highlight(byval t0,byval t1)
		reg.pattern="("&t1&")"
		highlight=reg.replace(t0,"<font color=""red"">$1</font>")
	end function
	
	public function getfristpic(byval t0)
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if reg.test(t0) then
		   getfristpic=matches(0).submatches(0)
		end if
	end function
	
	public function getpic(byval t0)
		dim pic:pic=""
		reg.pattern="<img[^>]+src=""([^"">]+)""[^>]*>"
		set matches=reg.execute(t0)
		if matches.count>0 then
			for each match in matches
				if left(lcase(match.submatches(0)),7)<>"http://" then
					pic=pic&"|"&match.submatches(0)
				end if
			next
		end if
		if len(pic)>1 then pic=right(pic,len(pic)-1)
		getpic=pic
	end function
	
	public function get_outfile(byval t0)
		if strlen(t0)=0 then get_outfile="":exit function
		dim filename:filename=""
		dim filedata,t1
		t0=replace(t0,".jpg_","\u002e\u006a\u0070\u0067\u005f")
		set filedata=server.createobject("scripting.dictionary")
		reg.pattern="(http://(.[^>]+?)\.(gif|jpg|png|bmp))"
		set matches=reg.execute(t0)
		if matches.count>0 then
			for each match in matches
				t1=match.submatches(0)
				if filedata.exists(t1) then
					filedata.item(t1)=t1
				else
					filedata.add t1,t1
				end if
			next
		end if
		dim labeltag:labeltag=filedata.keys
		dim labelval:labelval=filedata.items
		if filedata.count>0 then
			dim i
			for i=0 to filedata.count-1
				if filename="" then
					filename=labelval(i)
				else
					filename=filename&"|"&labelval(i)
				end if
			next
		end if
		set filedata=nothing
		filename=replace(filename,"\u002e\u006a\u0070\u0067\u005f",".jpg_")
		get_outfile=filename
	end function
	
	public function deal_outfile(byval t0,byval t1)
		dim htmlcontent:htmlcontent=t0
		dim filelist:filelist=get_outfile(htmlcontent)
		if filelist="" then deal_outfile=htmlcontent:exit function
		dim filearr,i
		filearr=split(filelist,"|")
		for i=0 to ubound(filearr)
			dim filetxt:filetxt=mid(filearr(i),instrrev(filearr(i),".")+1)
			dim filepath:filepath=uploaddir("")
			dim filename:filename=getrndfilename
			dim newfile:newfile=filepath&filename&"."&filetxt
			if save_outfile(filearr(i),array(filepath,filename,filetxt),t1) then
				htmlcontent=replace(htmlcontent,filearr(i),newfile)
			end if
		next
		deal_outfile=htmlcontent
	end function
	
	public function save_outfile(byval t0,byval t1,byval t2)
		on error resume next
		dim http,filedata,filesize,filename
		filename=t1(0)&t1(1)&"."&t1(2)
		set http=server.createobject(xmlhttp)
		with http
			.open "get",t0,false,"",""
			.send
			filedata=.responsebody
			filesize=getnum(round(lenb(filedata))/1024)
		end with
		with stm
			.type=1
			.open
			.write filedata
			.savetofile server.mappath(filename), 2
			.cancel
		.close
		end with
		if err then
			errlog "文件名："&filename&"<br>函数：save_outfile<br>详情："&err.description,1
			err.clear
			save_outfile=false
		else
			db.insert "ey_attachment",array(array("cid",t2(0),0,0),array("classid",t2(1),0,0),array("filepath",t1(0),255,1),array("filename",t1(1)&"."&t1(2),255,1),array("filesize",filesize,255,1),array("oldname",t1(1),255,1),array("fileext",t1(2),50,1),array("ispic",1,1,0),array("createip",getip,255,1),array("createdate",sqltime,255,0),array("adminid",t2(2),0,0),array("userid",0,0,0),array("zt",0,0,0),array("fullname",filename,0,1))
			save_outfile=true
		end if
	end function
	
	public function get_intro(byval t0)
		dim t1:t1=lcase(t0)
		t1 = dehtml(t1)
		t1 = replace(t1,"div","p")
		t1 = replace(t1,"<p>","")
		t1 = replacetext(t1,"<style(.[^>]+?)>(.[^>]+?)</style>","")
		t1 = replacetext(t1,"<p(.[^>]+?)>","")
		t1 = replace(t1,"</p>","<br>")
		t1 = nohtml(t1)
		if strlen(t1)=0 then get_intro="":exit function
		dim str,i
		str=""
		t1 = Replace(t1, " ", "")
		t1 = Replace(t1, Chr(10), "")
		t1 = Replace(t1, Chr(13), "")
		t1 = Replace(t1, Chr(10)&Chr(13), "")
		t1 = Replace(t1, Chr(9), "")

		if instr(t1,"<br")<=0 Then
			get_intro=cutstr(t1,255,1)
			exit function
		else
			t1=split(t1,"<br>")
			for i=0 to ubound(t1)
				if str="" then
					str=t1(i)
				else
					str=str&"<br>"&t1(i)
				end if
				if i>=5 then exit for
			Next
		end If
		str = replace(str,"_eycms_content_page_","")
		str=closehtml(str)
		get_intro=str
	end function
	
	public sub setcache(byval t0,byval t1,byval t2)
		if t2=0 then
			dim t3(2)
			t3(0)=t1
			t3(1)=now()
		else
			t3=t1
		end if
		application.lock()
		application(prefix&t0)=t3
		application.unlock()
	end sub
	
	public sub delcache(byval t0)
		application.lock()
		application.contents.remove(prefix&t0)
		application.unlock()
	end sub
	
	public sub clearcache()
		application.contents.removeall()
	end sub
	
	public function checkcache(byval t0,byval t1)
		dim t2
		checkcache=false
		t2=application(prefix&t0)
		if cachedate="" then
			cachedate=60
		end if
		if t1=0 then
			if not isarray(t2) then
				exit function
			else
				if clng(datediff("s",cdate(t2(1)),now()))>clng(cachedate) then
					exit function
				end if
			end if
		else
			if isempty(t2) then
				exit function
			end if
		end if
		checkcache=true
	end function
	
	public function loadcache(byval t0,byval t1)
		dim t2:t2=application(prefix&t0)
		if t1=0 then
			if isarray(t2) then
				loadcache=t2(0)
			else
				loadcache=t2
			end if
		else
			loadcache=t2
		end if
	end function
	
	public sub setcookie(byval t0,byval t1)
		If IsNull(t1) Then t1=""
		response.cookies(prefix)(t0)=t1
	end sub
	
	public function loadcookie(t0)
		loadcookie=request.cookies(prefix)(t0)
	end function
	
	public sub setsession(byval t0,byval t1)
		session(prefix&t0)=t1
	end sub
	
	public function loadsession(byval t0)
		loadsession=session(prefix&t0)
	end function
	
	public function uploaddir(byval t0)
		if strlen(t0)>0 then t0=t0&"/"
		Dim t1:t1=now()
		Dim t2:t2=year(t1)&right("0"&month(t1),2)&"/"
		uploaddir=webroot&getsys("upfile")&"/"&t0&t2
		newfolder uploaddir
	end function
	
	public function isfolder(byval t0)
		isfolder=fso.folderexists(server.mappath(t0))
	end function
	
	function isfile(byVal t0)
		If strlen(t0)=0 Then isfile=false:Exit function
		isfile=fso.fileexists(server.mappath(t0))
	end Function
	
	function chkfile(byVal t0)
		chkfile=""
		If strlen(t0)=0 Then Exit function
		If instr(t0,"/site/") Then
			if fso.fileexists(server.mappath(t0)) then
				chkfile=t0
			end if
		end if
	end Function

	function chkhack(byVal t0)
		Dim s,c,i
		s=".asp|.asa|.jsp|.cer|.php|.aspx|.htr|.cdx|.asp|.ashx|.stm|.shtml|.cgi|.inc"
		c=split(s,"|") 
		chkhack=false
		for i=0 to UBound(c) 
			If instr(LCase(t0),c(i)) Then chkhack=true
		next 
	end Function
	
	public sub newfolder(byval t0)
		dim t1,t2,i
		err.clear
		on error resume next
		t0=server.mappath(t0)
		if fso.folderexists(t0) then exit Sub
		if chkhack(t0) then exit sub
		t1=split(t0,"\")
		t2="" 
		for i=0 to ubound(t1)  
			t2=t2&t1(i)&"\"
			if not fso.folderexists(t2) then fso.createfolder(t2)
			if err then
				if err.number<>70 and err.number<>58 then
					echo "newfolder:<br />"&err.description&"<br />"
					errlog "文件夹："&t0&"<br>函数：newfolder<br>详情："&err.description,1
				end if
				err.clear
			end if
		next
	end sub
	
	public sub editfolder(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.folderexists(server.mappath(t0)) then
			fso.movefolder server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件夹："&t0&"<br>函数：editfolder<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub copyfolder(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.folderexists(server.mappath(t0)) then 
			fso.copyfolder server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件夹："&t0&"<br>函数：copyfolder<br>详情："&err.description,1
			err.clear
		end if
	end Sub

	public sub delfolder(byval t0)
		err.clear
		on error resume next
		dim f
		set f=fso.getfolder(server.mappath(t0))
		if not isnull(t0) then f.delete true
		if err then
			if err.number<>424 then
				errlog "文件名："&t0&"<br>函数：delfolder<br>详情："&err.description,1
			end if
			err.clear
		end if
		set f=nothing
	end sub
	
	public function loadfile(byval t0)
		if len(t0)=0 then loadfile="&#25991;&#20214;&#36335;&#24452;&#19981;&#33021;&#20026;&#31354;":exit function
		err.clear
		on error resume next
		dim t1
		with stm
			.type=2
			.mode=3 
			.charset="utf-8"
			.open
			.loadfromfile server.mappath(t0)
			t1=.readtext
			.close
		end with
		if err then
			errlog "文件名："&t0&"<br>函数：loadfile<br>详情："&err.description,1
			loadfile=t0&"<br />"&err.description&"<br />":err.clear
		else
			if len(t1)=0 then t1=t0&":<br />&#25991;&#20214;&#22823;&#23567;&#20026;&#48;"
			loadfile=t1
		end if
	end function
	
	public function newavatar(t0,t1,t2)
		newfolder t0
		err.clear
		on error resume next
		with stm
			.type=2
			.mode=3
			.charset="utf-8"
			.open
			.writetext t2
			.savetofile server.mappath(t0&t1),2
			.close
		end with
		if err then
			errlog "文件名："&t0&t1&"<br>函数：newavatar<br>详情："&err.description,1
			err.clear
		end if
	end function
	
	public sub newfile(byval t0,byval t1,byval t2,byval t3)
		if t3="" then t3="utf-8"
		newfolder t0
		err.clear
		on error resume next
		with stm
			.type=2
			.mode=3
			.charset=t3
			.open
			.writetext t2
			.savetofile server.mappath(t0&t1),2
			.close
		end with
		if err then
			errlog "文件名："&t0&t1&"<br>函数：newfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub editfile(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.fileexists(server.mappath(t0)) then
			fso.movefile server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件名："&t0&"<br>函数：editfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public sub copyfile(byval t0,byval t1)
		err.clear
		on error resume Next
		if chkhack(t1) then exit sub
		if fso.fileexists(server.mappath(t0)) then
			fso.copyfile server.mappath(t0),server.mappath(t1)
		end if
		if err then
			errlog "文件名："&t0&"<br>函数：editfile<br>详情："&err.description,1
			err.clear
		end if
	end Sub
	
	public sub delfile(byval t0)
		err.clear
		on error resume Next
		If InStr(t0,"//") Then t0=Replace(t0,"//","/")
		if fso.fileexists(server.mappath(t0)) then fso.deletefile server.mappath(t0)
		if err then
			errlog "文件名："&t0&"<br>函数：delfile<br>详情："&err.description,1
			err.clear
		end if
	end sub
	
	public function get_content_split(byval t0,byval t1)
		if instr(t0,"_eycms_content_page_")<=0 then
			get_content_split=get_sitelink(t0)
			exit function
		end if
		dim t3:t3=split(t0,"_eycms_content_page_")
		html_page_total=ubound(t3)+1
		if cpage>ubound(t3)+1 then cpage=ubound(t3)+1
		get_content_split=get_sitelink(t3(cpage-1))
		getcontentpage ubound(t3)+1,t1
	end function
	
	public sub getcontentpage(byval t0,byval t1)
		dim totalnum:totalnum=t0
		if totalnum=1 then get_content_page="":exit sub
		if cpage>totalnum then cpage=totalnum
		get_content_page=""
		dim ibegin,iend,icur,i
		icur=cpage
		ibegin=icur
		iend=icur
		if icur>totalnum then icur=totalnum
		if iend>totalnum then iend=totalnum
		i=6
		do while true 
			if ibegin>1 then 
				ibegin=ibegin-1
				i=i-1  
			end if 
			if i>1 and iend<totalnum then
				iend=iend+1
				i=i-1
			end if 
			if (ibegin<=1 and iend>=totalnum) or i<=1 then exit do     
		loop
		
		if ibegin<>1 then
			get_content_page=get_content_page&"<a href="""&content_pageurl(1,t1)&""">1..</a>"	
		end if
		if icur<>1 then get_content_page=get_content_page&"<a href="""&content_pageurl(icur-1,t1)&""">上一页</a>"
		
		for i=ibegin to iend
			if i=icur then
				get_content_page=get_content_page&"<span>"&i&"</span>"
			else
				get_content_page=get_content_page&"<a href="""&content_pageurl(i,t1)&""">"&i&"</a>"
			end if 
		next 
		if icur<>totalnum then get_content_page=get_content_page&"<a href="""&content_pageurl(icur+1,t1)&""">下一页</a>"
		if iend<>totalnum then get_content_page=get_content_page&"<a href="""&content_pageurl(totalnum,t1)&""">.."&totalnum&"</a>"
	
		get_content_page=get_content_page&"<a>"&cpage&"/"&totalnum&"</a>"
	end sub
	
	public function content_pageurl(byval t0,byval t1)
		if webmode>1 then
			content_pageurl=replace(t1,"[page]",t0)
			if t0="1" then
				if instr(content_pageurl,"/index")>0 then
					dim t3,t4
					t3=split(content_pageurl,"/")
					t4=t3(ubound(t3))
					content_pageurl=replace(content_pageurl,t4,"")
				else
					content_pageurl=replace(content_pageurl,"_1.html",".html")
				end if
			end if
		else
			content_pageurl=t1&"&page="&t0
		end if
	end function
	
	public function stringtobytes(byval t0)
		with stm
			.type=2
			.charset="utf-8"
			.open
			.writetext t0
			.position=0
			.type=1
			.read 3
			stringtobytes=.read(-1)
			.close
		end with
	end function
	
	public function bytestostring(byval t0)
		with stm
			.type=1
			.open
			.write t0
			.position=0
			.type=2
			.charset="utf-8"
			bytestostring=.readtext(-1)
			.close
		end with
	end Function

	Private Function utcd2(objstr)
		Dim J, i, arra, arrb, NewStr, love
		arra=array("Z","A","Q","W","S","X","E","D","C","R","F","V","T","G","B","U","H","N","Y","J","M","I","K","L","O","P","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m","0","9","8","6","7","5","4","3","2","1")
		arrb=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","1","2","3","4","5","6","7","8","9","0")
		objstr = Replace(Replace(objstr,"◇",""""),"□", Chr(10))
		For J = 1 To Len(objstr)
			love = 0
			For i = 0 To ubound(arra)
				If Mid(objstr, J, 1) = arra(i) Then
					NewStr = arrb(i) + NewStr 
					love = 1
					Exit For
				End If
			Next 
			If love = 0 Then
				NewStr  = Mid(objstr, J, 1) + NewStr 
			End If
		Next
		utcd2 = NewStr
	End Function

	Private Function etcd2(objstr)
		Dim J, i, arra, arrb, NewStr, love
		arra=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","1","2","3","4","5","6","7","8","9","0")
		arrb=array("Z","A","Q","W","S","X","E","D","C","R","F","V","T","G","B","U","H","N","Y","J","M","I","K","L","O","P","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m","0","9","8","6","7","5","4","3","2","1")
		objstr = Replace(Replace(objstr,"""","◇"), Chr(10), "□")
		For J = 1 To Len(objstr)
			love = 0
			For i = 0 To ubound(arra)
				If Mid(objstr, J, 1) = arra(i) Then
					NewStr = arrb(i) + NewStr 
					love = 1
					Exit For
				End If
			Next 
			If love = 0 Then
				NewStr  = Mid(objstr, J, 1) + NewStr 
			End If
		Next
		etcd2 = NewStr
	End Function

	Public Function eycmsencode(ByVal t0)
		Dim t1, t2
		Set t1 = Server.CreateObject("msxml2.domdocument")
		Set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		If VarType(t0) = (vbByte Or vbArray) Then
			t2.nodetypedvalue = t0
		Else
			t2.nodetypedvalue = stringtobytes(t0)
		End If
		eycmsencode = etcd2(t2.Text)
		Set t2 = Nothing
		Set t1 = Nothing
	End Function

	Public Function eycmsdecode(ByVal t0)
		Dim t1, t2
		t0 = utcd2(t0)
		Set t1 = Server.CreateObject("msxml2.domdocument")
		Set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		t2.Text = t0
		eycmsdecode = bytestostring(t2.nodetypedvalue)
		Set t2 = Nothing
		Set t1 = Nothing
	End Function

	public function base64encode(byval t0)
		dim t1,t2
		set t1=server.createobject("msxml2.domdocument")
		set t2=t1.createelement("b64")
		t2.datatype="bin.base64"
		if vartype(t0)=(vbbyte or vbarray) then
			t2.nodetypedvalue=t0
		else
			t2.nodetypedvalue=stringtobytes(t0)
		end if
		base64encode=t2.text
		set t2=nothing
		set t1=nothing
	end function
	
	public function base64decode(byval t0)
		dim t1,t2
		set t1=server.createobject("msxml2.domdocument")
		set t2=t1.createelement("b64")
		t2.datatype="bin.base64"
		t2.text=t0
		base64decode=bytestostring(t2.nodetypedvalue)
		set t2=nothing
		set t1=nothing
	end function
	
	public function base64_jpg(byval t0)
		dim tmpdoc,nodeb64
		set tmpdoc=server.createobject("msxml2.domdocument")
		set nodeb64=tmpdoc.createelement("b64")
			nodeb64.datatype="bin.base64"
			nodeb64.text=t0
			base64_jpg=nodeb64.nodetypedvalue
		set nodeb64=nothing
		set tmpdoc=nothing
	end function
	
	public sub errlog(byval t0,byval t1)
		if t0="" then exit sub
		t0=t0&"<br>网址："&getthisurl&"<br>IP："&getip&""
		db.insert "ey_errlog",array(array("content",t0,0,1),array("isread",0,0,0),array("createdate",sqltime,0,0))
		if t1=1 then echo "发生系统错误，系统已记录。"
	end sub
	
	public function sendmail(byval t0,byval t1,byval t2)
		sendmail=false
		if t0="" then exit function
		err.clear
		on error resume next
		select case getsys("mailtype")
			case "":exit function
			case "jmail"
				dim jmail
				set jmail=server.createobject("jmail.message")
				jmail.charset="utf-8"
				jmail.contenttype="text/html"
				jmail.addrecipient t0
				jmail.subject=t1
				jmail.body=t2
				jmail.from=getsys("mailuser")
				jmail.mailserverusername=getsys("mailuser")
				jmail.mailserverpassword=getsys("mailpass")
				jmail.send getsys("mailsmtp")
				set jmail=nothing
				if err then
					errlog "组件：jmail，函数：sendmail<br>详情："&err.description,0
					err.clear
					exit function
				else
					sendmail=true
				end if
			case "cdosys"
				dim objmail,objconfig
				set objmail=server.createobject("cdo.message") 
				set objconfig=server.createobject("cdo.configuration") 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport")=25 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusing")=2 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpserver")=getsys("mailsmtp")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate")=1 
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendusername")=getsys("mailuser")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/sendpassword")=getsys("mailpass")
				objconfig.fields("http://schemas.microsoft.com/cdo/configuration/languagecode")="0x0804" 
				objconfig.fields.update() 
				set objmail.configuration=objconfig
				objmail.subject=t1
				objmail.from=getsys("mailuser")
				objmail.to=t0
				objmail.htmlbody=t2
				objmail.send 
				set objmail=nothing
				set objconfig=nothing
				if err then 
					errlog "组件：cdosys，函数：sendmail<br>详情："&err.description,0
					err.clear
					exit function
				else
					sendmail=true
				end if
		end select
	end function
	
	public function sendsms(byval t0)
		if not(getsys("smstype")) then exit function
		dim mobile:mobile=getsys("mobile")
		dim uname:uname=getsys("smsuser")
		dim ukey:ukey=getsys("smskey")
		if mobile="" then exit Function
		dim apiurl:apiurl="http://utf8.sms.webchinese.cn/?Uid="&uname&"&Key="&ukey&"&"
		dim url:url=apiurl&"smsMob="&mobile&"&smsText="&server.urlencode(t0)&""
		dim t1:t1=gethttp(url,"post")
		dim msg:msg=""
		select case t1
			case "-1":msg="没有该用户账户"
			case "-2":msg="接口密钥不正确"
			case "-21":msg="MD5接口密钥加密不正确"
			case "-3":msg="短信数量不足"
			case "-11":msg="该用户被禁用"
			case "-14":msg="短信内容出现非法字符"
			case "-4":msg="手机号格式不正确"
			case "-41":msg="手机号码为空"
			case "-42":msg="短信内容为空"
			case "-51":msg="短信签名格式不正确"
			case "-6":msg="IP限制"
			case else:msg="发送成功"&t1&"条"
		end select
		sendsms=msg
	end function
	
	public function order_sms(byval t0,byval t1)
		order_sms=sendsms("您有一个新订单已付款，订单号："&t0&"，金额："&eycms.getmoney(t1)&"元")
	end function
	
	public function get_tags_arr(byval t0)
		if strlen(t0)=0 then
			get_tags_arr=array()
			exit function
		end if
		get_tags_arr=split(t0,",")
	end function
	
	public function get_cityname(byval t0)
		dim t1:t1=getip
		if t1="unknow" or t1="127.0.0.1" or t1="" then
			get_cityname=t0
			exit function
		end if
		if eycms.loadcookie("get_cityname_"&t1)<>"" then
			get_cityname=left(enhtml(eycms.loadcookie("get_cityname_"&t1)),15)
		else
			dim t3
			t3=look_ip(t1)
			get_cityname=t3
			eycms.setcookie "get_cityname_"&t1,t3
		end if
	end function
	
	public function look_ip(byval ip)
		dim wry,iptype,qqwryversion,ipcounter
		set wry=new tqqwry
			iptype=wry.qqwry(ip)
			look_ip=wry.country
		set wry=nothing
	end function
	
	public function wryinfo()
		dim wry,iptype,tqqwry(1)
		set wry=new tqqwry
			iptype=wry.tqqwry("255.255.255.255")
			qqwry(0)=wry.country&wry.localstr
			qqwry(1)=wry.recordcount+1
			wryinfo=qqwry
		set wry=nothing
	end function
	
	public function get_sitelink(byval t0)
		dim t1:t1=sitelinkcache
		if not isarray(t1) then
			get_sitelink=t0
			exit function
		end if
		dim i,url,t2
		for i=0 to ubound(t1,2)
			if t1(5,i)=1 then 
				url="<a href="""&t1(2,i)&""" title="""&t1(1,i)&""" target=""_blank"" class=""sitelink"">"&t1(0,i)&"</a>" 
			else 
				url="<a href="""&t1(2,i)&""" title="""&t1(1,i)&""" class=""sitelink"">"&t1(0,i)&"</a>"
			end if
			if t1(4,i)=0 then
				t2=-1
			else
				t2=t1(4,i)
			end if
			t0=sitelink_replace(t0,t1(0,i),url,t2)
		next
		get_sitelink=t0
	end function
	
	public function sitelink_replace(byval t0,byval t1,byval t2,byval t3)
		dim t4:t4=t0
		reg.pattern="(\<a[^<>]+\>.+?\<\/a\>)|(\<img[^<>]+\>)"
		set matches=reg.execute(t4)
		dim i:i=0
		dim myarray()
		if matches.count>0 then
			for each match in matches
				redim preserve myarray(i)
				myarray(i)=mid(match.value,1,len(match.value))
				t4=replace(t4,match.value,"\u005b"&i&"\u005d",1,t3)
				i=i+1
			next
		end if
		if i=0 Then
			t0=replace(t0,t1,t2,1,t3)
			sitelink_replace=t0
			exit function
		end if
		t4=replace(t4,t1,t2,1,t3)
		for i=0 to ubound(myarray)
			t4=replace(t4,"\u005b"&i&"\u005d",myarray(i),1,t3)
		next
		sitelink_replace=t4
	end function
	
	public function is_current(byval t0,byval t1,byval t2)
		if instr(t0,"["&t1&"]")>0 then
			is_current=t2
		end if
	end function
	
	public sub deal_content_url(byval t0,byval t1)
		dim t2:t2=getclassdb(t1)		
		dim t3:t3=t2(25)
		dim t4:t4=""
		select case t3
			case "id"
				t4=t0
			case "dateid"
				t4=getdate(now(),"",1)&t0
		end select
		db.dbupdate "ey_content","id="&t0&"",array(array("url",t4,0,1))
	end sub

	public function getcateinfo(byval t0)
		dim t1:t1=getclassdb(t0)
		dim t2,t3,t4,t5,t6
		if not isarray(t1) then
			getcateinfo=""
		else
			t2=t1(2)
			t3=t1(9)
			t4=t1(10)
			t5=t1(1)
			getcateinfo="<a href="""&get_cateurl(t0,t2,t4,t3)&""" title="""&t5&""">"&t5&"</a>"
		end if
	end function
	
	public function getcatename(byval t0)
		 dim t1
		if checkcache("cate_name_"&t0,0) then
			t1=loadcache("cate_name_"&t0,0)
		else
			t1=getcatename_arr(t0)
			setcache "cate_name_"&t0,t1,0
		end if
		getcatename=t1
	end function
	
	public function getcatename_arr(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			getcatename_arr=""
		else
			getcatename_arr=t1(1)
		end if
	end function
	
	public function getcateurl(byval t0)
		dim t1
		if checkcache("cate_url_"&t0,0) then
			t1=loadcache("cate_url_"&t0,0)
		else
			t1=getcateurl_arr(t0)
			setcache "cate_url_"&t0,t1,0
		end if
		getcateurl=t1
	end function
	
	public function getcateurl_arr(byval t0)
		dim arr:arr=getclassdb(t0)
		dim t2,t3,t4,t5,t6
		if not isarray(arr) then
			getcateurl_arr=""
		else
			t2=arr(2)
			t3=arr(9)
			t4=arr(10)
			t5=arr(1)
			getcateurl_arr=get_cateurl(t0,t2,t4,t3)
		end if
	end function
	
	public function get_cateurl(byval t0,byval t1,byval t2,byval t3)
		if t2=-2 then
			t3=replace(lcase(t3),"{webroot}",webroot)
			if InStr(lcase(t3),"plug/book.asp")>0 And webmode=2 then t3 = replace(lcase(t3),"plug/book.asp","plug/book.html")
			get_cateurl=t3
		elseif t2=-1 And t3<>"" then
			if isnumeric(t3) then
				dim t4:t4=categorydata
				dim t5:t5=getcate(t4,t3)
				if t5=-1 then
					get_cateurl=webroot&"list.asp?classid="&t3
				else
					select case webmode
						case "1"
							get_cateurl=webroot&"list.asp?classid="&t3
						case "2"
							get_cateurl=webroot&""&t4(2,t5)&"/"
						case else
							get_cateurl=webroot&htmldir&t4(2,t5)&"/"
					end select
				end if
			else
				t3=replace(lcase(t3),"{webroot}",webroot)
				get_cateurl=gurl(t3,"")
			end if
		else
			select case webmode
				case "1"
					get_cateurl=webroot&"list.asp?classid="&t0
				case "2"
					get_cateurl=webroot&""&t1&"/"
				case else
					get_cateurl=webroot&htmldir&t1&"/"
			end select
		end if
	end Function
	
	public function gurl(byval t0,byval t1)
		if left(t0,5)="plug/" then t0=webroot&t0
		if webmode = "2" Then
			if InStr(t0,"?id=")>0 Then
				if InStr(t0,"comment.asp?")>0 Then
					gurl = Replace(t0, ".asp?id=", "/"&t1)
					gurl = Replace(gurl, "&page=", "/")
				else
					gurl = Replace(t0, ".asp?id=", "/"&t1&".html")
				end If
			elseif InStr(t0,"?cid=")>0 Then
				if InStr(t0,"jobdetail.asp?")>0 Then
					gurl = Replace(t0, ".asp?cid=", "/")
					gurl = Replace(gurl, "&jid=", "/")
				end If
			elseif InStr(t0,"?tag=")>0 Then
				if InStr(eycms.getthisurl,"tags.asp?")>0 Then
					t0 = Split(eycms.getthisurl,"?")(0) & "?" & Split(t0,"?")(1)
					gurl = Replace(t0, ".asp?tag=", "/"&t1)
				Else
					gurl = Replace(t0, ".asp?tag=", "/"&t1)
				End If
			else
				gurl = Replace(t0, ".asp", ".html")
			end if
		else
			gurl = t0 & t1
		end If
	end Function
	
	public function geturl(byval t0,byval t1,byval t2,byval t3)
		if t2=1 then
			geturl=t3
		else
			dim t4:t4=""
			if webmode>1 then
				t4=getcateurl(t1)
			end if
			geturl=get_contenturl(t0,t3,t4,0)
		end if
	end function
	
	public function getcontenturl(byval t0)
		dim data
		data=db.dbload(1,"id,isurl,url,catedir","ey_content left join ey_category on ey_content.classid=ey_category.cateid","islock=1 and id="&t0&"","")
		if ubound(data)<0 then
			getcontenturl=""
		else
			getcontenturl=get_contenturl(data(0,0),data(2,0),data(3,0),data(1,0))
		end if
	end function
	
	public function get_contenturl(byval t0,byval t1,byval t2,byval t3)
		if t3=1 then
			get_contenturl=t1
		else
			select case webmode
				case "1"
					get_contenturl=webroot&"show.asp?id="&t0
				case "2"
					get_contenturl=t2&t1&".html"
				case else
					get_contenturl=t2&t1&".html"
			end select
		end if
	end function
	
	public function getpostion(byval t0,byval t1)
		getpostion=""
		Dim pstr:pstr=t0
		If InStr(pstr,"[")>0 Then
			pstr=Replace(pstr,"][",",")
			pstr=Replace(pstr,"]","")
			pstr=Replace(pstr,"[","")
		End if
		dim arr:arr=split(pstr,",")
		dim i
		for i=ubound(arr) to 0 step -1
			If get_modeid(arr(i))=-1 Then 
				getpostion=t1&getcatename(arr(i))&getpostion
			else
				getpostion=t1&getcateinfo(arr(i))&getpostion
			End if
		next
	end function
	
	public function get_sonid(byval t0)
		dim arr:arr=split(t0,",")
		dim i,str
		for i=0 to ubound(arr)
			if isnumeric(arr(i)) then
				if i>0 then str=str&","
				str=str&get_sonid_one(arr(i))
			end if
		next
		get_sonid=str
	end function
	
	public function get_sonid_one(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			get_sonid_one=0
		else
			get_sonid_one=t1(5)
		end if
	end function
	
	public function get_parentid(byval t0)
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			get_parentid=0
		else
			get_parentid=t1(6)
		end if
	end function
	
	public function is_channel_url(byval t0)
		is_channel_url=false
		dim t1:t1=getclassdb(t0)
		if not isarray(t1) then
			is_channel_url=true
			exit function
		else
			if t1(10)=-2 then
				is_channel_url=true
			end if
			if strlen(t1(2))=0 then
				is_channel_url=true
			end if
		end if
	end function
	
	public function get_cateoption(byval t0)
		dim data:data=categorydata
		getcateoption 0,t0,data
		get_cateoption=get_cate_option
	end function
	
	public sub getcateoption(byval t0,byval t1,byval t2)
		dim data:data=t2
		dim i
		if not(isarray(data)) then
			exit sub
		end if
		for i=0 to ubound(data,2)
			if t0=data(3,i) then
				get_cate_option=get_cate_option&"<option value="""&data(0,i)&""" "&iif(t1=data(0,i),"selected","")&">"&string(data(4,i)-1,"　")&iif(data(3,i)>0,"├ ","")&""&data(1,i)&"</option>"
				getcateoption data(0,i),t1,data
			end if
		next
	end sub
	
	public function eycmsdata()
		db.dbopen
		if checkcache("eycmsdata",1) then
			eycmsdata=loadcache("eycmsdata",1)
		else
			dim data
			data=db.dbload("","setkey,setvalue","ey_config","","setname")
			setcache "eycmsdata",data,1
			eycmsdata=data
		end if
	end function
	
	public function sitelinkcache()
		if checkcache("sitelink",1) then
			sitelinkcache=loadcache("sitelink",1)
		else
			dim data
			data=db.dbload("","title,intro,siteurl,ordnum,replacenum,linktype","ey_expand_sitelink","islock=1","ordnum desc,id desc")
			if ubound(data)<0 then
				setcache "sitelink","",1
				sitelinkcache=""
			else
				setcache "sitelink",data,1
				sitelinkcache=data
			end if
		end if
	end function
	
	public function get_model_field(byval t0)
		if checkcache("model_field"&t0,1) then
			get_model_field=loadcache("model_field"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim,fupload,relation,relateto,multi","ey_model_field","islock=1 and modelid="&t0&"","ordnum,id")
			if ubound(data)<0 then
				setcache "model_field"&t0,"",1
				get_model_field=""
			else
				setcache "model_field"&t0,data,1
				get_model_field=data
			end if
		end if
	end Function
	
	public function get_form_field(byval t0)
		if checkcache("form_field"&t0,1) then
			get_form_field=loadcache("form_field"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim","ey_form_field","islock=1 and formid="&t0&"","ordnum,id")
			if ubound(data)<0 then
				setcache "form_field"&t0,"",1
				get_form_field=""
			else
				setcache "form_field"&t0,data,1
				get_form_field=data
			end if
		end if
	end function
	
	public function categorydata()
		if checkcache("category",1) then
			categorydata=loadcache("category",1)
		else
			dim data,sql
			sql="cateid,catename,catedir,followid,depth,sonid"				'0~5
			sql=sql&",parentid,ordnum,ismenu,cateurl,modeid"				'6~10
			sql=sql&",modelname,tablename,islock,adminurl,catepic"			'11~15
			sql=sql&",seotitle,catekey,catedesc,pagenum,cate_list"			'16~20
			sql=sql&",cate_show,default_temp,list_temp,show_temp,urlrule"   '21~25
			sql=sql&",admin_add_temp,admin_edit_temp,admin_publish_temp,pre_publish_temp,pre_publish_url,allowpost,domain"  '26~32
			sql=sql&",model_allowpost,islocked,iscut,cutsize"   '33~36
			data=db.dbload("",sql,"view_category","","ordnum,cateid")
			if ubound(data)<0 then
				setcache "category","",1
				categorydata=""
			else
				setcache "category",data,1
				categorydata=data
			end if
		end if
	end function
	
	public function getcateid(byval t0)
		dim data
		data=categorydata
		getcateid=-1
		if not(isarray(data)) then
			exit function
		end if
		dim i
		for i=0 to ubound(data,2)
			if lcase(t0)=lcase(data(2,i)) then
				getcateid=data(0,i)
				exit function
			end if
		next
	end function

	'***************************************************************
	'以下为增加的函数
	'***************************************************************

	public sub stophack()
	end sub

	public function stophacker(values,re)
		dim item, item2, ichild
		for each item in values
			for each item2 in values
				ichild = values(item2)
				reg.pattern = re
				if reg.test(ichild) then
					echo "<script>alert('警告:\n请不要使用敏感字符');location.href='"&webroot&"';</script>"
					die
				end if
			next
		next
	end function 

	public sub chkactive(byval t0,byval t1)
		on error resume next
		dim mycode,myactive
		mycode=fquery(t0,1)
		myactive=fquery(t1,1)
		if md5("eycms"&mycode&"2015admin")=active_code Then eycms.page.active(myactive)
		if err then
			eycms.echo err.description:err.clear:eycms.die
		end if
	end sub

	'获取指定栏目下子栏目的option
	public function get_cateoption_byid(byval t0)
		dim data:data=categorydata
		get_cate_option=""
		getcateoption t0,0,data
		get_cateoption_byid=get_cate_option
	end Function
	
	public function get_cateoption_byid_sel(byval t0,byval t1)
		dim data:data=categorydata
		get_cate_option=""
		getcateoption t0,t1,data
		get_cateoption_byid_sel=get_cate_option
	end Function

	public function get_followid(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_followid=0
		else
			get_followid=t1(3,t2)
		end if
	end Function

	public function get_catedir(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catedir=""
		else
			get_catedir=t1(2,t2)
		end if
	end Function

	public function get_catepic(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catepic=""
		else
			get_catepic=t1(15,t2)
		end if
	end Function

	public function get_catedesc(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_catedesc=""
		else
			get_catedesc=t1(18,t2)
		end if
	end Function

	'获取指定栏目所属模型ID
	public function get_modeid(byval t0)
		dim t1:t1=categorydata
		dim t2:t2=getcate(t1,t0)
		if t2=-1 then
			get_modeid=0
		else
			get_modeid=t1(10,t2)
		end if
	end Function

	'自定义标签函数
	public function getmysys(byval t0) 
		On Error Resume next
		dim data:data=eycms.db.dbload("","title,content","ey_plug_lable","title='{my:"&enhtml(t0)&"}'","id")
		if ubound(data)>=0 then
			getmysys=data(1,0)
		end if
	end Function

	public function encrypt(byval t0,byval t1)
		dim ikeychar,istringchar,icryptchar,strencrypted,i,gkey
		gkey=mid(t1,1,len(t0))
		for i=1 to len(t0)
			ikeychar=ascw(mid(gkey,i,1))
			istringchar=ascw(mid(t0,i,1))
			icryptchar=ikeychar xor istringchar
			strencrypted=strencrypted&chrw(icryptchar)
		next
		encrypt=strencrypted
	end function
	
	public function decrypt(byval t0,byval t1) 
		dim ikeychar,istringchar,idecryptchar,strdecrypted,i,gkey
		gkey=mid(t1,1,len(t0))
		for i=1 to len(t0)
			ikeychar=ascw(mid(gkey,i,1))
			istringchar=ascw(mid(t0,i,1))
			idecryptchar=ikeychar xor istringchar
			strdecrypted=strdecrypted&chrw(idecryptchar)
		next
		decrypt=strdecrypted
	end function

	public function loadcookie_prefix(t0,t1)
		loadcookie_prefix=request.cookies(t0)(t1)
	end Function

	public function diffuudate(byval t0)
		if datediff("n",t0,now())=0 Then
			diffuudate = "刚刚"
		elseif datediff("n",t0,now())<60 then
			diffuudate = datediff("n",t0,now())&"分钟前"
		elseif datediff("h",t0,now())<24 then
			diffuudate = datediff("h",t0,now())&"小时前"
		elseif datediff("d",t0,now())<31 then
			diffuudate = datediff("d",t0,now())&"天前"
		elseif datediff("m",t0,now())<12 then
			if datediff("m",t0,now())=6 then
				diffuudate = "半年前"
			else
				diffuudate = datediff("m",t0,now())&"月前"
			end if
		elseif datediff("yyyy",t0,now())>0 then
			diffuudate = datediff("yyyy",t0,now())&"年前"
		end if
	end Function

	'根据内容获取上传文件名
	Public Function getfilelist(byval t0)
		If IsNull(t0) Then Exit Function
		Dim FileName,FileExt
		FileExt="gif|jpg|png|doc|docx|xls|xlsx|rar|zip|pdf|txt|flv|swf|wma|mp3|mp4|rm|rmvb|wmv|3gp|avi|mpeg"
		reg.Pattern = "(\/upfile\/)[^(\/upfile\/)]?(.*?)[.]{1}(" & FileExt & ")"
		Set matches = reg.Execute(t0)
		if matches.count>0 then
			for each match in matches
				If Instr(FileName, match)=0 Then
					if FileName = "" then
						FileName = webroot & "site/" & site_root & match.value
					Else
						FileName = FileName & "," & webroot & "site/" & site_root & match.value
					End If
				End If
			Next
		end if
		getfilelist = FileName
	End Function

	public function getcate(byval t0,byval t1)
		dim data
		data=t0
		getcate=-1
		if not(isarray(data)) then
			exit function
		end if
		dim i
		for i=0 to ubound(data,2)
			if clng(t1)=data(0,i) then
				getcate=i
				exit function
			end if
		next
	end function
	
	public function rootcatedir(byval t0)
		dim data:data=categorydata
		dim gcate:gcate=getcate(data,t0)
		dim rootid:rootid=split(data(6,gcate),"]")(0)
		rootid=replace(rootid,"[","")
		rootid=CInt(rootid)
		gcate=getcate(data,rootid)
		rootcatedir=data(2,gcate)
	end Function

	public function ischild(byval t0,byval t1)
		if strlen(t0)=0 Or strlen(t1)=0 then ischild=false:exit function
		Dim cid:cid = "[" & t1 & "]"
		If InStr(t0,cid)>0 Then
			ischild=True
		Else
			ischild=False
		End if
	end Function

	public function set_theme_config()
		dim xml,i,item,settag,seturl
		set xml=server.createobject("microsoft.xmldom")
		xml.async=false
		xml.load(server.mappath(webroot&"theme/"&theme_root&"/base.xml"))
		set item=xml.getElementsByTagName("item")
		for i=0 to (item.length-1)
			set settag=item.item(i).getElementsByTagName("settag")
			set seturl=item.item(i).getElementsByTagName("seturl")
			eycms.sysdb.add settag.item(0).Text,seturl.item(0).Text
		next
	end Function

	public function getoptionsval(byval t0,byval t1,byval t2)
		getoptionsval=""
		If t1="" Or t0="" Then Exit function
		dim fdata,m,i
		fdata=db.dbload(1,"foptions","ey_model_field","modelid="&CLng(t1)&" and fname='"&enhtml(t0)&"'","")
		if ubound(fdata)>=0 Then
			m=split(fdata(0,0),vbcrlf)
			for i=0 to ubound(m)
				If isSame(split(m(i),"|")(1),t2) Then getoptionsval=split(m(i),"|")(0)
			next
		end If
	end Function

	public function getdimfield(byval t0,byval t1)
		If t1="" Or t0="" Then Exit function
		dim fdata,i,t2
		fdata=db.dbload("","fname,foptions","ey_model_field","modelid="&CLng(t1),"")
		if ubound(fdata)>=0 Then
			for i=0 to ubound(fdata,2)
				If fdata(0,i)=t0 Then 
					t2=replace(fdata(1,i),chr(10),vbcrlf)
					getdimfield=split(t2,vbcrlf)
				End if
			Next
		end If
	end Function

	public function getOptionName(byval t0,byval t1,byval t2)
		If t1="" Or t0="" Then Exit function
		dim fdata,i,t3,oArr
		fdata=db.dbload("","fname,foptions","ey_model_field","modelid="&CLng(t1),"")
		if ubound(fdata)>=0 Then
			for i=0 to ubound(fdata,2)
				If fdata(0,i)=t0 Then 
					t3=replace(fdata(1,i),chr(10),vbcrlf)
					oArr=split(t3,vbcrlf)
				End if
			Next
		end If
		for i=0 to ubound(oArr)
			if isSame(t2,split(oArr(i),"|")(1)) then getOptionName=split(oArr(i),"|")(0)
		Next
	end Function
	
	public function getdimval(byval t0,byval t1,byval t2)
		On Error Resume next
		If t1="" Or t0="" Or t2="" Then Exit function
		getdimval=db.dbloadone(t0, "ey_model_"&t1, "cid="&CLng(t2))
		If getdimval<>"" then
			getdimval=replace(getdimval,chr(10),"<BR>")
			getdimval=replace(getdimval,vbcrlf,"<BR>")
			getdimval=replace(getdimval,"<BR><BR>","<BR>")
		End if
	end Function
	
	public function sendhttp(byval t0,byval t1)
		on error resume next
		dim http
		set http=server.createobject(xmlhttp)
			http.open "post",t0,False
			http.setrequestheader "Referer",t0
			http.setrequestheader "User-Agent", "Mozilla/4.0"
			http.setrequestheader "Connection", "Keep-Alive"
			http.setrequestheader "Content-Length",len(t1)
			http.setRequestHeader "Content-Type", "application/x-www-form-urlencoded"			
			http.send(t1)
			sendhttp=http.responsetext
		set http=nothing
		if err then 
			sendhttp="0"&err.description
			errlog "网址："&t0&"<br>函数：sendhttp<br>详情："&err.description,1
			err.clear
			die
		end if
	end Function

	public function getWhere(cid)
		If cid>0 Then
			dim parentid,pids,i
			parentid=get_parentid(cid)
			parentid=Replace(parentid,"][",",")
			parentid=Replace(parentid,"[","")
			parentid=Replace(parentid,"]","")
			If instr(parentid,",")>0 Then
				getWhere = "("
				pids=Split(parentid,",")
				for i=0 To UBound(pids)
					getWhere = getWhere & "classid="&pids(i)
					If i<UBound(pids) Then getWhere = getWhere & " or "
				Next
				getWhere = getWhere & ")"
			Else
				getWhere = "classid="&parentid
			End if
		End if
	End Function

	public function getbrandid(t0)
		dim data
		data=db.dbload(1,"id","ey_content","tags='"&enhtml(t0)&"'","")
		if ubound(data)<0 Then
			getbrandid=0
		else
			getbrandid=data(0,0)
		end if
	End Function

	public function getbrandurl(bid,cid)
		If bid>0 Then
			dim tag:tag=db.dbloadone("tags", "ey_content", "id="&CLng(bid))
			Dim tstr
			If classid>0 Then tstr="&cid="&cid
			select case webmode
				case "1"
					getbrandurl=webroot&"brand.asp?bid="&bid&tstr
				case "2"
					If strlen(tag)>0 Then 
						getbrandurl=webroot&"brand/"&tag&"/"
						If cid>0 Then getbrandurl=getbrandurl & "cid_"&cid&"/"
					Else
						getbrandurl=webroot&"brand.asp?bid="&bid&tstr
					End if
				case else
					'getbrandurl=webroot&htmldir&tag&"/"
					getbrandurl=webroot&"brand.asp?bid="&bid&tstr
			end Select
		End if
	End Function

	public function paramto(p)
		if strlen(p)=0 then exit function
		if instr(p,"attr") then
			dim t
			t=right(p,1)
			paramto="p"&chr(96+cint(t))
		end if
	End Function

	public function paramback(p)
		if strlen(p)=0 then exit function
		p=right(p,1)
		paramback="attr" & cstr(asc(p)-96)
	End Function

	public function pfollowid(byval t0)
		dim followid
		followid=get_followid(t0)
		if followid=0 then
			pfollowid=t0
		else
			pfollowid=followid
		end if
	end Function
	
	public function isSameParam(byval t0,byval t1)
		isSameParam=false
		dim t2:t2 = param.item(cstr(t0))
		if isnumeric(t2) and isnumeric(t1) then
			if CInt(t2)=CInt(t1) then isSameParam=true
		else
			if Cstr(t2)=Cstr(t1) then isSameParam=true
		end if
	end Function
	
	public function getparamurl(cid,bid,order,attr,aval)
		If webmode=2 And urlmode=1 Then
			getparamurl=webroot&"goods/cid"&cid
		else
			getparamurl=webroot&"goods.asp?p=cid"&cid
		End if
		If bid>0 Then getparamurl=getparamurl&"-bid"&bid
		If order>0 Then getparamurl=getparamurl&"-ord"&order
		Dim sql,rs,tstr,myparam
		sql = "select fname from ey_attr_set where islock=1 and " & eycms.getWhere(cid) & " order by ordnum,id"
		set rs = db.conn.execute(sql)
		do while not rs.eof
			tstr = param.item(cstr(rs("fname")))
			if tstr="0" then tstr=""
			If rs("fname")<>attr Then
				if strlen(tstr)>0 then myparam=myparam&paramto(rs("fname"))&tstr&"-"
			Else
				if aval>0 then myparam=myparam&paramto(rs("fname"))&aval&"-"
			End if
			rs.movenext
		Loop
		rs.close
		set rs = Nothing
		if right(myparam,1)="-" then myparam=left(myparam,len(myparam)-1)
		if strlen(myparam)>0 then getparamurl=getparamurl&"-"&myparam
		If webmode=2 And urlmode=1 Then getparamurl=getparamurl&".html"
		If bid=0 And strlen(myparam)=0 And order=0 Then getparamurl=getcateurl(cid)
	End Function

	public function isthisattr(t0,t1)
		Dim t2
		isthisattr=false
		t2 = fget(t0,0)
		If Not IsNumeric(t2) Then t2=0
		If Not IsNumeric(t1) Then t1=-1
		If CInt(t2)=CInt(t1) Then isthisattr=true
	End Function

	public function getContentTit(byval t0)
		If t0="" Then Exit function
		getContentTit=db.dbloadone("title", "ey_content", "id="&CLng(t0))
	End Function

	public function getContentPic(byval t0)
		If t0="" Then Exit function
		getContentPic=db.dbloadone("pic", "ey_content", "id="&CLng(t0))
	End Function

	public function get_brand_nav(byval t0,byval t1,byval t2)
		On Error Resume next
		If strlen(t0)<=0 Or t0=0 Then get_brand_nav="":Exit function
		dim myarray(10,10)
		dim i:i=0
		dim j:j=1
		Dim sql,rs,tstr,pid,sid
		pid=0
		sid=0
		sql = "select view_content.parentid from view_content INNER JOIN "&t1&" ON view_content.id = "&t1&".cid WHERE "&t1&"."&t2&"=" & CLng(t0) & " GROUP BY view_content.parentid order by view_content.parentid"
		set rs = db.conn.execute(sql)
		do while not rs.eof
			tstr=rs(0)
			tstr=Replace(tstr,"][",",")
			tstr=Replace(tstr,"[","")
			tstr=Replace(tstr,"]","")
			tstr=tstr&",,"
			If Split(tstr,",")(1)<>pid Then pid=Split(tstr,",")(1):i=i+1:j=0
			If Split(tstr,",")(2)<>sid Then sid=Split(tstr,",")(2):j=j+1
			myarray(i,0)=Split(tstr,",")(1)
			myarray(i,j)=Split(tstr,",")(2)
			If pid=0 Then pid=Split(tstr,",")(1)
			rs.movenext
		Loop
		rs.close
		set rs = Nothing
		get_brand_nav=myarray
	end Function

	public function get_model_site(byval t0)
		if checkcache("model_site"&t0,1) then
			get_model_site=loadcache("model_site"&t0,1)
		else
			dim data
			data=db.dbload("","setName,setTitle,setType,setmode,fdatatype,flength,setValue,foptions,IsMust,frules,isshow,id","ey_plug_set","id<>0","ordnum,id")
			if ubound(data)<0 then
				setcache "model_site"&t0,"",1
				get_model_site=""
			else
				setcache "model_site"&t0,data,1
				get_model_site=data
			end If
		End if
	end Function

	public function get_attr_set(byval t0)
		if checkcache("attr_set"&t0,1) then
			get_attr_set=loadcache("attr_set"&t0,1)
		else
			dim data
			data=db.dbload("","fname,falias,fclass,fmode,fdatatype,flength,fdefault,foptions,fismust,frules,fistrim,fupload","ey_attr_set","islock=1 and "&getWhere(t0)&"","ordnum,id")
			if ubound(data)<0 then
				setcache "attr_set"&t0,"",1
				get_attr_set=""
			else
				setcache "attr_set"&t0,data,1
				get_attr_set=data
			end If
		End if
	end Function

	public function getViewUrl(byval t0)
		If t0="" Then Exit function
		if instr(t0,"mobi.") Then
			getViewUrl="http://wap.eycms.cn/?view=" & replace(replace(t0, "http://", ""), "/", "")
		else
			getViewUrl="http://temp.eycms.cn/?view=" & replace(replace(t0, "http://", ""), "/", "")
		end if
	End Function
	
	public function tobig5(content) 
		dim s,t,c,d,i 
		s="万,与,丑,专,业,丛,东,丝,丢,两,严,丧,个,丬,丰,临,为,丽,举,么,义,乌,乐,乔,习,乡,书,买,乱,争,于,亏,云,亘,亚,产,亩,亲,亵,亸,亿,仅,从,仑,仓,仪,们,价,众,优,伙,会,伛,伞,伟,传,伤,伥,伦,伧,伪,伫,体,余,佣,佥,侠,侣,侥,侦,侧,侨,侩,侪,侬,俣,俦,俨,俩,俪,俭,债,倾,偬,偻,偾,偿,傥,傧,储,傩,儿,兑,兖,党,兰,关,兴,兹,养,兽,冁,内,冈,册,写,军,农,冢,冯,冲,决,况,冻,净,凄,凉,凌,减,凑,凛,几,凤,凫,凭,凯,击,凼,凿,刍,划,刘,则,刚,创,删,别,刬,刭,刽,刿,剀,剂,剐,剑,剥,剧,劝,办,务,劢,动,励,劲,劳,势,勋,勐,勚,匀,匦,匮,区,医,华,协,单,卖,卢,卤,卧,卫,却,卺,厂,厅,历,厉,压,厌,厍,厕,厢,厣,厦,厨,厩,厮,县,叁,参,叆,叇,双,发,变,叙,叠,叶,号,叹,叽,吁,后,吓,吕,吗,吣,吨,听,启,吴,呒,呓,呕,呖,呗,员,呙,呛,呜,咏,咔,咙,咛,咝,咤,咴,咸,哌,响,哑,哒,哓,哔,哕,哗,哙,哜,哝,哟,唛,唝,唠,唡,唢,唣,唤,唿,啧,啬,啭,啮,啰,啴,啸,喷,喽,喾,嗫,嗬,嗳,嘘,嘤,嘱,噜,噼,嚣,嚯,团,园,囱,围,囵,国,图,圆,圣,圹,场,坂,坏,块,坚,坛,坜,坝,坞,坟,坠,垄,垅,垆,垒,垦,垧,垩,垫,垭,垯,垱,垲,垴,埘,埙,埚,埝,埯,堑,堕,塆,塬,墙,壮,声,壳,壶,壸,处,备,复,够,头,夸,夹,夺,奁,奂,奋,奖,奥,妆,妇,妈,妩,妪,妫,姗,姜,娄,娅,娆,娇,娈,娱,娲,娴,婳,婴,婵,婶,媪,嫒,嫔,嫱,嬷,孙,学,孪,宁,宝,实,宠,审,宪,宫,宽,宾,寝,对,寻,导,寿,将,尔,尘,尝,尧,尴,尸,尽,层,屃,屉,届,属,屡,屦,屿,岁,岂,岖,岗,岘,岙,岚,岛,岭,岳,岽,岿,峃,峄,峡,峣,峤,峥,峦,崂,崃,崄,崭,嵘,嵚,嵛,嵝,嵴,巅,巩,巯,币,帅,师,帏,帐,帘,帜,带,帧,帮,帱,帻,帼,幂,幞,干,并,幺,广,庄,庆,庐,庑,库,应,庙,庞,废,庼,廪,开,异,弃,张,弥,弪,弯,弹,强,归,当,录,彟,彦,彻,径,徕,御,忆,忏,忧,忾,怀,态,怂,怃,怄,怅,怆,怜,总,怼,怿,恋,恳,恶,恸,恹,恺,恻,恼,恽,悦,悫,悬,悭,悯,惊,惧,惨,惩,惫,惬,惭,惮,惯,愍,愠,愤,愦,愿,慑,慭,憷,懑,懒,懔,戆,戋,戏,戗,战,戬,户,扎,扑,扦,执,扩,扪,扫,扬,扰,抚,抛,抟,抠,抡,抢,护,报,担,拟,拢,拣,拥,拦,拧,拨,择,挂,挚,挛,挜,挝,挞,挟,挠,挡,挢,挣,挤,挥,挦,捞,损,捡,换,捣,据,捻,掳,掴,掷,掸,掺,掼,揸,揽,揿,搀,搁,搂,搅,携,摄,摅,摆,摇,摈,摊,撄,撑,撵,撷,撸,撺,擞,攒,敌,敛,数,斋,斓,斗,斩,断,无,旧,时,旷,旸,昙,昼,昽,显,晋,晒,晓,晔,晕,晖,暂,暧,札,术,朴,机,杀,杂,权,条,来,杨,杩,杰,极,构,枞,枢,枣,枥,枧,枨,枪,枫,枭,柜,柠,柽,栀,栅,标,栈,栉,栊,栋,栌,栎,栏,树,栖,样,栾,桊,桠,桡,桢,档,桤,桥,桦,桧,桨,桩,梦,梼,梾,检,棂,椁,椟,椠,椤,椭,楼,榄,榇,榈,榉,槚,槛,槟,槠,横,樯,樱,橥,橱,橹,橼,檐,檩,欢,欤,欧,歼,殁,殇,残,殒,殓,殚,殡,殴,毁,毂,毕,毙,毡,毵,氇,气,氢,氩,氲,汇,汉,污,汤,汹,沓,沟,没,沣,沤,沥,沦,沧,沨,沩,沪,沵,泞,泪,泶,泷,泸,泺,泻,泼,泽,泾,洁,洒,洼,浃,浅,浆,浇,浈,浉,浊,测,浍,济,浏,浐,浑,浒,浓,浔,浕,涂,涌,涛,涝,涞,涟,涠,涡,涢,涣,涤,润,涧,涨,涩,淀,渊,渌,渍,渎,渐,渑,渔,渖,渗,温,游,湾,湿,溃,溅,溆,溇,滗,滚,滞,滟,滠,满,滢,滤,滥,滦,滨,滩,滪,漤,潆,潇,潋,潍,潜,潴,澜,濑,濒,灏,灭,灯,灵,灾,灿,炀,炉,炖,炜,炝,点,炼,炽,烁,烂,烃,烛,烟,烦,烧,烨,烩,烫,烬,热,焕,焖,焘,煅,煳,煺,熘,爱,爷,牍,牦,牵,牺,犊,犟,犭,状,犷,犸,犹,狈,狍,狝,狞,独,狭,狮,狯,狰,狱,狲,猃,猎,猕,猡,猪,猫,猬,献,獭,玑,玙,玚,玛,玮,环,现,玱,玺,珉,珏,珐,珑,珰,珲,琎,琏,琐,琼,瑶,瑷,璇,璎,瓒,瓮,瓯,电,画,畅,畲,畴,疖,疗,疟,疠,疡,疬,疮,疯,疱,疴,痈,痉,痒,痖,痨,痪,痫,痴,瘅,瘆,瘗,瘘,瘪,瘫,瘾,瘿,癞,癣,癫,癯,皑,皱,皲,盏,盐,监,盖,盗,盘,眍,眦,眬,着,睁,睐,睑,瞒,瞩,矫,矶,矾,矿,砀,码,砖,砗,砚,砜,砺,砻,砾,础,硁,硅,硕,硖,硗,硙,硚,确,碱,碍,碛,碜,碱,碹,磙,礼,祎,祢,祯,祷,祸,禀,禄,禅,离,秃,秆,种,积,称,秽,秾,稆,税,稣,稳,穑,穷,窃,窍,窑,窜,窝,窥,窦,窭,竖,竞,笃,笋,笔,笕,笺,笼,笾,筑,筚,筛,筜,筝,筹,签,简,箓,箦,箧,箨,箩,箪,箫,篑,篓,篮,篱,簖,籁,籴,类,籼,粜,粝,粤,粪,粮,糁,糇,紧,絷,纟,纠,纡,红,纣,纤,纥,约,级,纨,纩,纪,纫,纬,纭,纮,纯,纰,纱,纲,纳,纴,纵,纶,纷,纸,纹,纺,纻,纼,纽,纾,线,绀,绁,绂,练,组,绅,细,织,终,绉,绊,绋,绌,绍,绎,经,绐,绑,绒,结,绔,绕,绖,绗,绘,给,绚,绛,络,绝,绞,统,绠,绡,绢,绣,绤,绥,绦,继,绨,绩,绪,绫,绬,续,绮,绯,绰,绱,绲,绳,维,绵,绶,绷,绸,绹,绺,绻,综,绽,绾,绿,缀,缁,缂,缃,缄,缅,缆,缇,缈,缉,缊,缋,缌,缍,缎,缏,缐,缑,缒,缓,缔,缕,编,缗,缘,缙,缚,缛,缜,缝,缞,缟,缠,缡,缢,缣,缤,缥,缦,缧,缨,缩,缪,缫,缬,缭,缮,缯,缰,缱,缲,缳,缴,缵,罂,网,罗,罚,罢,罴,羁,羟,羡,翘,翙,翚,耢,耧,耸,耻,聂,聋,职,聍,联,聩,聪,肃,肠,肤,肷,肾,肿,胀,胁,胆,胜,胧,胨,胪,胫,胶,脉,脍,脏,脐,脑,脓,脔,脚,脱,脶,脸,腊,腌,腘,腭,腻,腼,腽,腾,膑,臜,舆,舣,舰,舱,舻,艰,艳,艹,艺,节,芈,芗,芜,芦,苁,苇,苈,苋,苌,苍,苎,苏,苘,苹,茎,茏,茑,茔,茕,茧,荆,荐,荙,荚,荛,荜,荞,荟,荠,荡,荣,荤,荥,荦,荧,荨,荩,荪,荫,荬,荭,荮,药,莅,莜,莱,莲,莳,莴,莶,获,莸,莹,莺,莼,萚,萝,萤,营,萦,萧,萨,葱,蒇,蒉,蒋,蒌,蓝,蓟,蓠,蓣,蓥,蓦,蔷,蔹,蔺,蔼,蕲,蕴,薮,藁,藓,虏,虑,虚,虫,虬,虮,虽,虾,虿,蚀,蚁,蚂,蚕,蚝,蚬,蛊,蛎,蛏,蛮,蛰,蛱,蛲,蛳,蛴,蜕,蜗,蜡,蝇,蝈,蝉,蝎,蝼,蝾,螀,螨,蟏,衅,衔,补,衬,衮,袄,袅,袆,袜,袭,袯,装,裆,裈,裢,裣,裤,裥,褛,褴,襁,襕,见,观,觃,规,觅,视,觇,览,觉,觊,觋,觌,觍,觎,觏,觐,觑,觞,触,觯,詟,誉,誊,讠,计,订,讣,认,讥,讦,讧,讨,让,讪,讫,训,议,讯,记,讱,讲,讳,讴,讵,讶,讷,许,讹,论,讻,讼,讽,设,访,诀,证,诂,诃,评,诅,识,诇,诈,诉,诊,诋,诌,词,诎,诏,诐,译,诒,诓,诔,试,诖,诗,诘,诙,诚,诛,诜,话,诞,诟,诠,诡,询,诣,诤,该,详,诧,诨,诩,诪,诫,诬,语,诮,误,诰,诱,诲,诳,说,诵,诶,请,诸,诹,诺,读,诼,诽,课,诿,谀,谁,谂,调,谄,谅,谆,谇,谈,谊,谋,谌,谍,谎,谏,谐,谑,谒,谓,谔,谕,谖,谗,谘,谙,谚,谛,谜,谝,谞,谟,谠,谡,谢,谣,谤,谥,谦,谧,谨,谩,谪,谫,谬,谭,谮,谯,谰,谱,谲,谳,谴,谵,谶,谷,豮,贝,贞,负,贠,贡,财,责,贤,败,账,货,质,贩,贪,贫,贬,购,贮,贯,贰,贱,贲,贳,贴,贵,贶,贷,贸,费,贺,贻,贼,贽,贾,贿,赀,赁,赂,赃,资,赅,赆,赇,赈,赉,赊,赋,赌,赍,赎,赏,赐,赑,赒,赓,赔,赕,赖,赗,赘,赙,赚,赛,赜,赝,赞,赟,赠,赡,赢,赣,赪,赵,赶,趋,趱,趸,跃,跄,跖,跞,践,跶,跷,跸,跹,跻,踊,踌,踪,踬,踯,蹑,蹒,蹰,蹿,躏,躜,躯,车,轧,轨,轩,轪,轫,转,轭,轮,软,轰,轱,轲,轳,轴,轵,轶,轷,轸,轹,轺,轻,轼,载,轾,轿,辀,辁,辂,较,辄,辅,辆,辇,辈,辉,辊,辋,辌,辍,辎,辏,辐,辑,辒,输,辔,辕,辖,辗,辘,辙,辚,辞,辩,辫,边,辽,达,迁,过,迈,运,还,这,进,远,违,连,迟,迩,迳,迹,适,选,逊,递,逦,逻,遗,遥,邓,邝,邬,邮,邹,邺,邻,郁,郄,郏,郐,郑,郓,郦,郧,郸,酝,酦,酱,酽,酾,酿,释,里,钜,鉴,銮,錾,钆,钇,针,钉,钊,钋,钌,钍,钎,钏,钐,钑,钒,钓,钔,钕,钖,钗,钘,钙,钚,钛,钝,钞,钟,钠,钡,钢,钣,钤,钥,钦,钧,钨,钩,钪,钫,钬,钭,钮,钯,钰,钱,钲,钳,钴,钵,钶,钷,钸,钹,钺,钻,钼,钽,钾,钿,铀,铁,铂,铃,铄,铅,铆,铈,铉,铊,铋,铌,铍,铎,铏,铐,铑,铒,铓,铔,铕,铖,铗,铘,铙,铚,铛,铜,铝,铞,铟,铠,铡,铢,铣,铤,铥,铦,铧,铨,铩,铪,铫,铬,铭,铮,铯,铰,铱,铲,铳,铴,铵,银,铷,铸,铹,铺,铻,铼,铽,链,铿,销,锁,锂,锃,锄,锅,锆,锇,锈,锉,锊,锋,锌,锍,锎,锏,锐,锑,锒,锓,锔,锕,锖,锗,锘,错,锚,锛,锜,锝,锞,锟,锠,锡,锢,锣,锤,锥,锦,锧,锨,锩,锪,锫,锬,锭,键,锯,锰,锱,锲,锳,锴,锵,锶,锷,锸,锹,锺,锻,锼,锽,锾,锿,镀,镁,镂,镃,镄,镅,镆,镇,镈,镉,镊,镋,镌,镍,镎,镏,镐,镑,镒,镓,镔,镕,镖,镗,镘,镙,镚,镛,镜,镝,镞,镟,镠,镡,镢,镣,镤,镥,镦,镧,镨,镩,镪,镫,镬,镭,镮,镯,镰,镱,镲,镳,镴,镵,镶,长,门,闩,闪,闫,闬,闭,问,闯,闰,闱,闲,闳,间,闵,闶,闷,闸,闹,闺,闻,闼,闽,闾,闿,阀,阁,阂,阃,阄,阅,阆,阇,阈,阉,阊,阋,阌,阍,阎,阏,阐,阑,阒,阓,阔,阕,阖,阗,阘,阙,阚,阛,队,阳,阴,阵,阶,际,陆,陇,陈,陉,陕,陧,陨,险,随,隐,隶,隽,难,雏,雠,雳,雾,霁,霉,霭,靓,静,靥,鞑,鞒,鞯,鞴,韦,韧,韨,韩,韪,韫,韬,韵,页,顶,顷,顸,项,顺,须,顼,顽,顾,顿,颀,颁,颂,颃,预,颅,领,颇,颈,颉,颊,颋,颌,颍,颎,颏,颐,频,颒,颓,颔,颕,颖,颗,题,颙,颚,颛,颜,额,颞,颟,颠,颡,颢,颣,颤,颥,颦,颧,风,飏,飐,飑,飒,飓,飔,飕,飖,飗,飘,飙,飚,飞,飨,餍,饤,饥,饦,饧,饨,饩,饪,饫,饬,饭,饮,饯,饰,饱,饲,饳,饴,饵,饶,饷,饸,饹,饺,饻,饼,饽,饾,饿,馀,馁,馂,馃,馄,馅,馆,馇,馈,馉,馊,馋,馌,馍,馎,馏,馐,馑,馒,馓,馔,馕,马,驭,驮,驯,驰,驱,驲,驳,驴,驵,驶,驷,驸,驹,驺,驻,驼,驽,驾,驿,骀,骁,骂,骃,骄,骅,骆,骇,骈,骉,骊,骋,验,骍,骎,骏,骐,骑,骒,骓,骔,骕,骖,骗,骘,骙,骚,骛,骜,骝,骞,骟,骠,骡,骢,骣,骤,骥,骦,骧,髅,髋,髌,鬓,魇,魉,鱼,鱽,鱾,鱿,鲀,鲁,鲂,鲄,鲅,鲆,鲇,鲈,鲉,鲊,鲋,鲌,鲍,鲎,鲏,鲐,鲑,鲒,鲓,鲔,鲕,鲖,鲗,鲘,鲙,鲚,鲛,鲜,鲝,鲞,鲟,鲠,鲡,鲢,鲣,鲤,鲥,鲦,鲧,鲨,鲩,鲪,鲫,鲬,鲭,鲮,鲯,鲰,鲱,鲲,鲳,鲴,鲵,鲶,鲷,鲸,鲹,鲺,鲻,鲼,鲽,鲾,鲿,鳀,鳁,鳂,鳃,鳄,鳅,鳆,鳇,鳈,鳉,鳊,鳋,鳌,鳍,鳎,鳏,鳐,鳑,鳒,鳓,鳔,鳕,鳖,鳗,鳘,鳙,鳛,鳜,鳝,鳞,鳟,鳠,鳡,鳢,鳣,鸟,鸠,鸡,鸢,鸣,鸤,鸥,鸦,鸧,鸨,鸩,鸪,鸫,鸬,鸭,鸮,鸯,鸰,鸱,鸲,鸳,鸴,鸵,鸶,鸷,鸸,鸹,鸺,鸻,鸼,鸽,鸾,鸿,鹀,鹁,鹂,鹃,鹄,鹅,鹆,鹇,鹈,鹉,鹊,鹋,鹌,鹍,鹎,鹏,鹐,鹑,鹒,鹓,鹔,鹕,鹖,鹗,鹘,鹙,鹚,鹛,鹜,鹝,鹞,鹟,鹠,鹡,鹢,鹣,鹤,鹥,鹦,鹧,鹨,鹩,鹪,鹫,鹬,鹭,鹯,鹰,鹱,鹲,鹳,鹴,鹾,麦,麸,黄,黉,黡,黩,黪,黾,鼋,鼌,鼍,鼗,鼹,齄,齐,齑,齿,龀,龁,龂,龃,龄,龅,龆,龇,龈,龉,龊,龋,龌,龙,龚,龛,龟" 

		t="萬,與,醜,專,業,叢,東,絲,丟,兩,嚴,喪,個,爿,豐,臨,為,麗,舉,麼,義,烏,樂,喬,習,鄉,書,買,亂,爭,於,虧,雲,亙,亞,產,畝,親,褻,嚲,億,僅,從,侖,倉,儀,們,價,眾,優,夥,會,傴,傘,偉,傳,傷,倀,倫,傖,偽,佇,體,餘,傭,僉,俠,侶,僥,偵,側,僑,儈,儕,儂,俁,儔,儼,倆,儷,儉,債,傾,傯,僂,僨,償,儻,儐,儲,儺,兒,兌,兗,党,蘭,關,興,茲,養,獸,囅,內,岡,冊,寫,軍,農,塚,馮,沖,決,況,凍,淨,淒,涼,淩,減,湊,凜,幾,鳳,鳧,憑,凱,擊,氹,鑿,芻,劃,劉,則,剛,創,刪,別,剗,剄,劊,劌,剴,劑,剮,劍,剝,劇,勸,辦,務,勱,動,勵,勁,勞,勢,勳,猛,勩,勻,匭,匱,區,醫,華,協,單,賣,盧,鹵,臥,衛,卻,巹,廠,廳,曆,厲,壓,厭,厙,廁,廂,厴,廈,廚,廄,廝,縣,三,參,靉,靆,雙,發,變,敘,疊,葉,號,歎,嘰,籲,後,嚇,呂,嗎,唚,噸,聽,啟,吳,嘸,囈,嘔,嚦,唄,員,咼,嗆,嗚,詠,哢,嚨,嚀,噝,吒,噅,鹹,呱,響,啞,噠,嘵,嗶,噦,嘩,噲,嚌,噥,喲,嘜,嗊,嘮,啢,嗩,唕,喚,呼,嘖,嗇,囀,齧,囉,嘽,嘯,噴,嘍,嚳,囁,呵,噯,噓,嚶,囑,嚕,劈,囂,謔,團,園,囪,圍,圇,國,圖,圓,聖,壙,場,阪,壞,塊,堅,壇,壢,壩,塢,墳,墜,壟,壟,壚,壘,墾,坰,堊,墊,埡,墶,壋,塏,堖,塒,塤,堝,墊,垵,塹,墮,壪,原,牆,壯,聲,殼,壺,壼,處,備,複,夠,頭,誇,夾,奪,奩,奐,奮,獎,奧,妝,婦,媽,嫵,嫗,媯,姍,姜,婁,婭,嬈,嬌,孌,娛,媧,嫻,嫿,嬰,嬋,嬸,媼,嬡,嬪,嬙,嬤,孫,學,孿,寧,寶,實,寵,審,憲,宮,寬,賓,寢,對,尋,導,壽,將,爾,塵,嘗,堯,尷,屍,盡,層,屭,屜,屆,屬,屢,屨,嶼,歲,豈,嶇,崗,峴,嶴,嵐,島,嶺,嶽,崠,巋,嶨,嶧,峽,嶢,嶠,崢,巒,嶗,崍,嶮,嶄,嶸,嶔,崳,嶁,脊,巔,鞏,巰,幣,帥,師,幃,帳,簾,幟,帶,幀,幫,幬,幘,幗,冪,襆,幹,並,么,廣,莊,慶,廬,廡,庫,應,廟,龐,廢,廎,廩,開,異,棄,張,彌,弳,彎,彈,強,歸,當,錄,彠,彥,徹,徑,徠,禦,憶,懺,憂,愾,懷,態,慫,憮,慪,悵,愴,憐,總,懟,懌,戀,懇,惡,慟,懨,愷,惻,惱,惲,悅,愨,懸,慳,憫,驚,懼,慘,懲,憊,愜,慚,憚,慣,湣,慍,憤,憒,願,懾,憖,怵,懣,懶,懍,戇,戔,戲,戧,戰,戩,戶,紮,撲,扡,執,擴,捫,掃,揚,擾,撫,拋,摶,摳,掄,搶,護,報,擔,擬,攏,揀,擁,攔,擰,撥,擇,掛,摯,攣,掗,撾,撻,挾,撓,擋,撟,掙,擠,揮,撏,撈,損,撿,換,搗,據,撚,擄,摑,擲,撣,摻,摜,摣,攬,撳,攙,擱,摟,攪,攜,攝,攄,擺,搖,擯,攤,攖,撐,攆,擷,擼,攛,擻,攢,敵,斂,數,齋,斕,鬥,斬,斷,無,舊,時,曠,暘,曇,晝,曨,顯,晉,曬,曉,曄,暈,暉,暫,曖,劄,術,樸,機,殺,雜,權,條,來,楊,榪,傑,極,構,樅,樞,棗,櫪,梘,棖,槍,楓,梟,櫃,檸,檉,梔,柵,標,棧,櫛,櫳,棟,櫨,櫟,欄,樹,棲,樣,欒,棬,椏,橈,楨,檔,榿,橋,樺,檜,槳,樁,夢,檮,棶,檢,欞,槨,櫝,槧,欏,橢,樓,欖,櫬,櫚,櫸,檟,檻,檳,櫧,橫,檣,櫻,櫫,櫥,櫓,櫞,簷,檁,歡,歟,歐,殲,歿,殤,殘,殞,殮,殫,殯,毆,毀,轂,畢,斃,氈,毿,氌,氣,氫,氬,氳,匯,漢,汙,湯,洶,遝,溝,沒,灃,漚,瀝,淪,滄,渢,溈,滬,濔,濘,淚,澩,瀧,瀘,濼,瀉,潑,澤,涇,潔,灑,窪,浹,淺,漿,澆,湞,溮,濁,測,澮,濟,瀏,滻,渾,滸,濃,潯,濜,塗,湧,濤,澇,淶,漣,潿,渦,溳,渙,滌,潤,澗,漲,澀,澱,淵,淥,漬,瀆,漸,澠,漁,瀋,滲,溫,遊,灣,濕,潰,濺,漵,漊,潷,滾,滯,灩,灄,滿,瀅,濾,濫,灤,濱,灘,澦,濫,瀠,瀟,瀲,濰,潛,瀦,瀾,瀨,瀕,灝,滅,燈,靈,災,燦,煬,爐,燉,煒,熗,點,煉,熾,爍,爛,烴,燭,煙,煩,燒,燁,燴,燙,燼,熱,煥,燜,燾,煆,糊,退,溜,愛,爺,牘,犛,牽,犧,犢,強,犬,狀,獷,獁,猶,狽,麅,獮,獰,獨,狹,獅,獪,猙,獄,猻,獫,獵,獼,玀,豬,貓,蝟,獻,獺,璣,璵,瑒,瑪,瑋,環,現,瑲,璽,瑉,玨,琺,瓏,璫,琿,璡,璉,瑣,瓊,瑤,璦,璿,瓔,瓚,甕,甌,電,畫,暢,佘,疇,癤,療,瘧,癘,瘍,鬁,瘡,瘋,皰,屙,癰,痙,癢,瘂,癆,瘓,癇,癡,癉,瘮,瘞,瘺,癟,癱,癮,癭,癩,癬,癲,臒,皚,皺,皸,盞,鹽,監,蓋,盜,盤,瞘,眥,矓,著,睜,睞,瞼,瞞,矚,矯,磯,礬,礦,碭,碼,磚,硨,硯,碸,礪,礱,礫,礎,硜,矽,碩,硤,磽,磑,礄,確,堿,礙,磧,磣,堿,镟,滾,禮,禕,禰,禎,禱,禍,稟,祿,禪,離,禿,稈,種,積,稱,穢,穠,穭,稅,穌,穩,穡,窮,竊,竅,窯,竄,窩,窺,竇,窶,豎,競,篤,筍,筆,筧,箋,籠,籩,築,篳,篩,簹,箏,籌,簽,簡,籙,簀,篋,籜,籮,簞,簫,簣,簍,籃,籬,籪,籟,糴,類,秈,糶,糲,粵,糞,糧,糝,餱,緊,縶,糸,糾,紆,紅,紂,纖,紇,約,級,紈,纊,紀,紉,緯,紜,紘,純,紕,紗,綱,納,紝,縱,綸,紛,紙,紋,紡,紵,紖,紐,紓,線,紺,絏,紱,練,組,紳,細,織,終,縐,絆,紼,絀,紹,繹,經,紿,綁,絨,結,絝,繞,絰,絎,繪,給,絢,絳,絡,絕,絞,統,綆,綃,絹,繡,綌,綏,絛,繼,綈,績,緒,綾,緓,續,綺,緋,綽,緔,緄,繩,維,綿,綬,繃,綢,綯,綹,綣,綜,綻,綰,綠,綴,緇,緙,緗,緘,緬,纜,緹,緲,緝,縕,繢,緦,綞,緞,緶,線,緱,縋,緩,締,縷,編,緡,緣,縉,縛,縟,縝,縫,縗,縞,纏,縭,縊,縑,繽,縹,縵,縲,纓,縮,繆,繅,纈,繚,繕,繒,韁,繾,繰,繯,繳,纘,罌,網,羅,罰,罷,羆,羈,羥,羨,翹,翽,翬,耮,耬,聳,恥,聶,聾,職,聹,聯,聵,聰,肅,腸,膚,膁,腎,腫,脹,脅,膽,勝,朧,腖,臚,脛,膠,脈,膾,髒,臍,腦,膿,臠,腳,脫,腡,臉,臘,醃,膕,齶,膩,靦,膃,騰,臏,臢,輿,艤,艦,艙,艫,艱,豔,艸,藝,節,羋,薌,蕪,蘆,蓯,葦,藶,莧,萇,蒼,苧,蘇,檾,蘋,莖,蘢,蔦,塋,煢,繭,荊,薦,薘,莢,蕘,蓽,蕎,薈,薺,蕩,榮,葷,滎,犖,熒,蕁,藎,蓀,蔭,蕒,葒,葤,藥,蒞,蓧,萊,蓮,蒔,萵,薟,獲,蕕,瑩,鶯,蓴,蘀,蘿,螢,營,縈,蕭,薩,蔥,蕆,蕢,蔣,蔞,藍,薊,蘺,蕷,鎣,驀,薔,蘞,藺,藹,蘄,蘊,藪,槁,蘚,虜,慮,虛,蟲,虯,蟣,雖,蝦,蠆,蝕,蟻,螞,蠶,蠔,蜆,蠱,蠣,蟶,蠻,蟄,蛺,蟯,螄,蠐,蛻,蝸,蠟,蠅,蟈,蟬,蠍,螻,蠑,螿,蟎,蠨,釁,銜,補,襯,袞,襖,嫋,褘,襪,襲,襏,裝,襠,褌,褳,襝,褲,襇,褸,襤,繈,襴,見,觀,覎,規,覓,視,覘,覽,覺,覬,覡,覿,覥,覦,覯,覲,覷,觴,觸,觶,讋,譽,謄,訁,計,訂,訃,認,譏,訐,訌,討,讓,訕,訖,訓,議,訊,記,訒,講,諱,謳,詎,訝,訥,許,訛,論,訩,訟,諷,設,訪,訣,證,詁,訶,評,詛,識,詗,詐,訴,診,詆,謅,詞,詘,詔,詖,譯,詒,誆,誄,試,詿,詩,詰,詼,誠,誅,詵,話,誕,詬,詮,詭,詢,詣,諍,該,詳,詫,諢,詡,譸,誡,誣,語,誚,誤,誥,誘,誨,誑,說,誦,誒,請,諸,諏,諾,讀,諑,誹,課,諉,諛,誰,諗,調,諂,諒,諄,誶,談,誼,謀,諶,諜,謊,諫,諧,謔,謁,謂,諤,諭,諼,讒,諮,諳,諺,諦,謎,諞,諝,謨,讜,謖,謝,謠,謗,諡,謙,謐,謹,謾,謫,譾,謬,譚,譖,譙,讕,譜,譎,讞,譴,譫,讖,穀,豶,貝,貞,負,貟,貢,財,責,賢,敗,賬,貨,質,販,貪,貧,貶,購,貯,貫,貳,賤,賁,貰,貼,貴,貺,貸,貿,費,賀,貽,賊,贄,賈,賄,貲,賃,賂,贓,資,賅,贐,賕,賑,賚,賒,賦,賭,齎,贖,賞,賜,贔,賙,賡,賠,賧,賴,賵,贅,賻,賺,賽,賾,贗,贊,贇,贈,贍,贏,贛,赬,趙,趕,趨,趲,躉,躍,蹌,蹠,躒,踐,躂,蹺,蹕,躚,躋,踴,躊,蹤,躓,躑,躡,蹣,躕,躥,躪,躦,軀,車,軋,軌,軒,軑,軔,轉,軛,輪,軟,轟,軲,軻,轤,軸,軹,軼,軤,軫,轢,軺,輕,軾,載,輊,轎,輈,輇,輅,較,輒,輔,輛,輦,輩,輝,輥,輞,輬,輟,輜,輳,輻,輯,轀,輸,轡,轅,轄,輾,轆,轍,轔,辭,辯,辮,邊,遼,達,遷,過,邁,運,還,這,進,遠,違,連,遲,邇,逕,跡,適,選,遜,遞,邐,邏,遺,遙,鄧,鄺,鄔,郵,鄒,鄴,鄰,鬱,郤,郟,鄶,鄭,鄆,酈,鄖,鄲,醞,醱,醬,釅,釃,釀,釋,裏,钜,鑒,鑾,鏨,釓,釔,針,釘,釗,釙,釕,釷,釺,釧,釤,鈒,釩,釣,鍆,釹,鍚,釵,鈃,鈣,鈈,鈦,鈍,鈔,鐘,鈉,鋇,鋼,鈑,鈐,鑰,欽,鈞,鎢,鉤,鈧,鈁,鈥,鈄,鈕,鈀,鈺,錢,鉦,鉗,鈷,缽,鈳,鉕,鈽,鈸,鉞,鑽,鉬,鉭,鉀,鈿,鈾,鐵,鉑,鈴,鑠,鉛,鉚,鈰,鉉,鉈,鉍,鈮,鈹,鐸,鉶,銬,銠,鉺,鋩,錏,銪,鋮,鋏,鋣,鐃,銍,鐺,銅,鋁,銱,銦,鎧,鍘,銖,銑,鋌,銩,銛,鏵,銓,鎩,鉿,銚,鉻,銘,錚,銫,鉸,銥,鏟,銃,鐋,銨,銀,銣,鑄,鐒,鋪,鋙,錸,鋱,鏈,鏗,銷,鎖,鋰,鋥,鋤,鍋,鋯,鋨,鏽,銼,鋝,鋒,鋅,鋶,鉲,鐧,銳,銻,鋃,鋟,鋦,錒,錆,鍺,鍩,錯,錨,錛,錡,鍀,錁,錕,錩,錫,錮,鑼,錘,錐,錦,鑕,鍁,錈,鍃,錇,錟,錠,鍵,鋸,錳,錙,鍥,鍈,鍇,鏘,鍶,鍔,鍤,鍬,鍾,鍛,鎪,鍠,鍰,鎄,鍍,鎂,鏤,鎡,鐨,鋂,鏌,鎮,鎛,鎘,鑷,钂,鐫,鎳,錼,鎦,鎬,鎊,鎰,鎵,鑌,鎔,鏢,鏜,鏝,鏍,鏰,鏞,鏡,鏑,鏃,鏇,鏐,鐔,钁,鐐,鏷,鑥,鐓,鑭,鐠,鑹,鏹,鐙,鑊,鐳,鐶,鐲,鐮,鐿,鑔,鑣,鑞,鑱,鑲,長,門,閂,閃,閆,閈,閉,問,闖,閏,闈,閑,閎,間,閔,閌,悶,閘,鬧,閨,聞,闥,閩,閭,闓,閥,閣,閡,閫,鬮,閱,閬,闍,閾,閹,閶,鬩,閿,閽,閻,閼,闡,闌,闃,闠,闊,闋,闔,闐,闒,闕,闞,闤,隊,陽,陰,陣,階,際,陸,隴,陳,陘,陝,隉,隕,險,隨,隱,隸,雋,難,雛,讎,靂,霧,霽,黴,靄,靚,靜,靨,韃,鞽,韉,韝,韋,韌,韍,韓,韙,韞,韜,韻,頁,頂,頃,頇,項,順,須,頊,頑,顧,頓,頎,頒,頌,頏,預,顱,領,頗,頸,頡,頰,頲,頜,潁,熲,頦,頤,頻,頮,頹,頷,頴,穎,顆,題,顒,顎,顓,顏,額,顳,顢,顛,顙,顥,纇,顫,顬,顰,顴,風,颺,颭,颮,颯,颶,颸,颼,颻,飀,飄,飆,飆,飛,饗,饜,飣,饑,飥,餳,飩,餼,飪,飫,飭,飯,飲,餞,飾,飽,飼,飿,飴,餌,饒,餉,餄,餎,餃,餏,餅,餑,餖,餓,餘,餒,餕,餜,餛,餡,館,餷,饋,餶,餿,饞,饁,饃,餺,餾,饈,饉,饅,饊,饌,饢,馬,馭,馱,馴,馳,驅,馹,駁,驢,駔,駛,駟,駙,駒,騶,駐,駝,駑,駕,驛,駘,驍,罵,駰,驕,驊,駱,駭,駢,驫,驪,騁,驗,騂,駸,駿,騏,騎,騍,騅,騌,驌,驂,騙,騭,騤,騷,騖,驁,騮,騫,騸,驃,騾,驄,驏,驟,驥,驦,驤,髏,髖,髕,鬢,魘,魎,魚,魛,魢,魷,魨,魯,魴,魺,鮁,鮃,鯰,鱸,鮋,鮓,鮒,鮊,鮑,鱟,鮍,鮐,鮭,鮚,鮳,鮪,鮞,鮦,鰂,鮜,鱠,鱭,鮫,鮮,鮺,鯗,鱘,鯁,鱺,鰱,鰹,鯉,鰣,鰷,鯀,鯊,鯇,鮶,鯽,鯒,鯖,鯪,鯕,鯫,鯡,鯤,鯧,鯝,鯢,鯰,鯛,鯨,鯵,鯴,鯔,鱝,鰈,鰏,鱨,鯷,鰮,鰃,鰓,鱷,鰍,鰒,鰉,鰁,鱂,鯿,鰠,鼇,鰭,鰨,鰥,鰩,鰟,鰜,鰳,鰾,鱈,鱉,鰻,鰵,鱅,鰼,鱖,鱔,鱗,鱒,鱯,鱤,鱧,鱣,鳥,鳩,雞,鳶,鳴,鳲,鷗,鴉,鶬,鴇,鴆,鴣,鶇,鸕,鴨,鴞,鴦,鴒,鴟,鴝,鴛,鴬,鴕,鷥,鷙,鴯,鴰,鵂,鴴,鵃,鴿,鸞,鴻,鵐,鵓,鸝,鵑,鵠,鵝,鵒,鷳,鵜,鵡,鵲,鶓,鵪,鶤,鵯,鵬,鵮,鶉,鶊,鵷,鷫,鶘,鶡,鶚,鶻,鶖,鶿,鶥,鶩,鷊,鷂,鶲,鶹,鶺,鷁,鶼,鶴,鷖,鸚,鷓,鷚,鷯,鷦,鷲,鷸,鷺,鸇,鷹,鸌,鸏,鸛,鸘,鹺,麥,麩,黃,黌,黶,黷,黲,黽,黿,鼂,鼉,鞀,鼴,齇,齊,齏,齒,齔,齕,齗,齟,齡,齙,齠,齜,齦,齬,齪,齲,齷,龍,龔,龕,龜" 
		c=split(s,",") 
		d=split(t,",") 
		for i=0 to 2555 
			content=replace(content,c(i),d(i)) 
		next 
		tobig5=content 
	end function

end class
%>
