﻿<%
''' EYCMS 分页
''' ==================================================================

class eycms_pagelist

	private table_,field_,join_,where_,group_,order_,sql_,conn_,rs_,pagesize_,page_,pagenumber_,htmlurl_,isadminurl_
	private rspage,totalnumber,pagecount
	private home_url,pre_url,next_url,last_url,page_url
	private isajax

	public property let field(str)
		field_=str
	end property
	
	public property let table(str)
		table_=str
	end property
	
	public property let join(str)
		join_=str
	end property
	
	public property let where(str)
		if str<>"" then
			where_=" where "&str
		end if
	end property
	
	public property let group(str)
		if str<>"" then
			group_=" group by "&str
		end if
	end property
	
	public property let order(str)
		if str<>"" then
			order_=" order by "&str
		end if
	end property
	
	public property let pagesize(num)
		if isnumeric(num) then
			pagesize_=cint(num)
			if pagesize_<1 then
				pagesize_=20
			end if
		else
			pagesize_=20
		end if
	end property
	
	public property let page(num)
		if isnumeric(num) then
			page_=cint(num)
			if page_<1 then
				page_=1
			end if
		else
			page_=1
		end if
	end property
	
	public property let pagenumber(num)
		if isnumeric(num) then
			pagenumber_=clng(num)
			if pagenumber_<8 then
				pagenumber_=8
			end if
		else
			pagenumber_=8
		end if
		if pagenumber_ mod 2=0 then
			pagenumber_=8
		end if
	end property
	
	public property let htmlurl(str)
		htmlurl_=str
	end property
	
	public property let isadminurl(str)
		isadminurl_=str
	end property
	
	'初始化类
	private sub class_initialize()
		table_=""
		field_="*"
		join_=""
		where_=""
		group_=""
		order_=""
		pagesize_=20
		pagecount=0
		page_=1
		pagenumber_=6
		htmlurl_=""
		isadminurl_=1
		isajax=0
		set rspage=server.createobject("adodb.recordset")
	end Sub
	
	private sub class_terminate()
		set rspage=nothing
	end Sub
	
	public function getrs()
		sql_="select "&field_&" from "&table_&" "&join_&where_&group_&order_
		'eycms.errlog sql_,0
		rspage.open sql_,eycms.db.conn,1,1
		dbquery=dbquery+1
		if not rspage.eof and not rspage.bof then
			rspage.pagesize=pagesize_
			rspage.absolutepage=page_
			totalnumber=rspage.recordcount
			pagecount=abs(int(-abs(totalnumber/pagesize_)))
		end if
		set getrs=rspage
		dopage
	end function
	
	public function number(byval num)
		number=pagesize_*(page_-1)+num
	end function
	
	public function totalurl()
		totalurl=pagecount
	end function
	
	public function homeurl()
		homeurl=home_url
	end function
	
	public function nexturl()
		nexturl=replace(next_url,"amp;","")
	end function
	
	public function preurl()
		preurl=pre_url
	end function
	
	public function lasturl()
		lasturl=last_url
	end function
	
	public function pageurl()
		pageurl=page_url
	end function
	
	public sub dopage()
		isajax=1
		home_url=geturl(1)
		if page_>1 then
			pre_url=geturl(page_-1)
		else
			pre_url=""
		end if
		
		if page_<pagecount then
			next_url=geturl(page_+1)
		else
			next_url=""
		end if
		
		if page_<>pagecount then
			last_url=geturl(pagecount)
		else
			last_url=""
		end if
		
		page_url=page_&"/"&pagecount
		isajax=0
	end sub
	
	public function showpage()
		if totalnumber<=0 or pagecount=1 then exit Function
		dim pagehtml,beginpage,endpage,i
		beginpage=page_
		endpage=page_
		i=pagenumber_
		if page_>pagecount then page_=pagecount
		if endpage>pagecount then endpage=pagecount
		do while true
			if beginpage>1 then
				beginpage=beginpage - 1
				i=i-1
			end if 
			if i>1 and endpage<pagecount then
				endpage=endpage + 1
				i=i-1
			end if
			if (beginpage<=1 and endpage>=pagecount) or i<=1 then exit do
		loop
		pagehtml=""
		if page_>1 then pagehtml = pagehtml&"<a href="""&geturl(page_-1)&""">上一页</a>"
		if beginpage<>1 then pagehtml = pagehtml&"<a href="""&geturl(1)&""">1...</a>"
		for i = beginpage To endpage
			if i=page_ Then
				pagehtml=pagehtml&"<span>"&i&"</span>"
			else
				pagehtml=pagehtml&"<a href="""&geturl(i)&""">"&i&"</a>"
			end if
		next
		if endpage<>pagecount then pagehtml=pagehtml&"<a href="""&geturl(pagecount)&""">..."&pagecount&"</a>"
		if page_<pagecount then pagehtml=pagehtml&"<a href="""&geturl(page_+1)&""">下一页</a>"
		pagehtml=pagehtml&"<a>"&page_&"/"&pagecount&"</a>"
		showpage=pagehtml
	end function
	
	public function show_page_num()
		show_page_num=page_
	end function
	
	public function show_page_total()
		show_page_total=pagecount
	end function
	
	public function show_totalnum()
		show_totalnum=totalnumber
	end Function

	public function getpageto(byval t0,byval t1)
		Dim prevpage
		Select Case t0
		Case 0
			prevpage=t1-1
			If prevpage<1 Then prevpage=1
			getpageto=geturl(prevpage)
		Case 1
			getpageto=geturl(t1+1)
		End select
	end Function

	public function geturl(byval num)
		If ismobile=True Then 
			geturl=request.ServerVariables("url") & "?" & eycms.geturlparam & "page=" & num
			Exit function
		end if
		if InStr(eycms.getthisurl,"goods.asp?")>0 Or InStr(eycms.getthisurl,"goods/")>0  Then
			geturl="?"&eycms.geturlparam&"page="&num
			If webmode=2 Then
				geturl=Replace(geturl,"?","")
				geturl=Replace(geturl,"&amp;","_")
				geturl=Replace(geturl,"&","_")
				geturl=Replace(geturl,"=","-")
				geturl=Replace(geturl,"p-","")
				geturl=Replace(geturl,"page-","")
				geturl=geturl&".html"
			End if
			Exit function
		End If
		select case webmode
		case "1"
			geturl="?"&eycms.geturlparam&"page="&num
		case "2"
			if isajax=0 then
				if isadminurl_=1 Then
					if InStr(eycms.getthisurl,"brand.asp?")>0 Or InStr(eycms.getthisurl,"brand/")>0 Then
						If cid>0 Then
							geturl=replace(""&webroot&"brand/"&broot&"/cid_"&cid&"/[page]/","[page]",num)
						else
							geturl=replace(""&webroot&"brand/"&broot&"/[page]/","[page]",num)
						End if
					else
						geturl=replace(""&webroot&broot&"/[page]/","[page]",num)
					End if
					if num="1" then
						geturl=replace(geturl,"/1/","/")
					end if
					geturl=replace(geturl,"//","/")
				else
					if InStr(eycms.getthisurl,"admin")<=0 then
						if InStr(eycms.geturlparam,"id=")>0 Then
							if InStr(eycms.getthisurl,"comment.asp?")>0 Or InStr(eycms.getthisurl,"comment/")>0 Then
								geturl = webroot&"plug/comment/"&gparam(eycms.geturlparam,"id=")&"/"&num
							else
								geturl=gparam(eycms.geturlparam,"id=")&"_"&num
							end if
						elseif InStr(eycms.geturlparam,"tag=")>0 Then
							geturl=gparam(eycms.geturlparam,"tag=")&"_"&num
						else
							geturl="?"&eycms.geturlparam&"page="&num
							If InStr(eycms.getthisurl,"user/")<=0 and InStr(eycms.getthisurl,"plug")<=0 then
								if InStr(eycms.getthisurl,"?")>0 Then
									geturl=Split(eycms.getthisurl,"?")(0) & geturl
									geturl = Replace(geturl, ".asp?page=", "/")
								else
									geturl = Replace(eycms.getthisurl & geturl, ".asp?page=", "/")
								end If
							end if
						end If
					else
						geturl="?"&eycms.geturlparam&"page="&num
					end if
				end if
			else
				geturl=request.ServerVariables("url") & "?" & eycms.geturlparam & "page=" & num
			end if
		case "3"
			if isadminurl_=1 then
				geturl=replace("index_[page].html","[page]",num)
				if num="1" then
					geturl=replace(geturl,"index_1.html","./")
				end if
			else
				geturl="?"&eycms.geturlparam&"page="&num
			end if
		end select
	end Function
	
	private function gparam(byval t0,byval t1)
		dim t2
		t2=replace(eycms.geturlparam,t1,"")
		If right(t2,1)="&" then t2=left(t2,len(t2)-1)
		t2=replace(t2,"&amp;","")
		gparam=t2
	end function
	
end class
%>
