/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.commons.code.plugin.ui;

import cn.wizzer.commons.code.plugin.utils.GenerateConfig;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ConfigDialog
extends DialogWrapper {
    private JBCheckBox controllerCheckBox;
    private JBCheckBox serviceCheckBox;
    private JBCheckBox viewCheckBox;
    private JBCheckBox viewAddCheckBox;
    private JBCheckBox viewDetailCheckBox;
    private JBCheckBox viewEditCheckBox;
    private JBCheckBox viewIndexCheckBox;
    private JBCheckBox localeCheckBox;
    private JBCheckBox forceCheckBox;
    private JBLabel basePathLabel;
    private JBLabel baseUriLabel;
    private JBLabel basePackageLabel;
    private JBTextField basePathTextField;
    private JBTextField baseUriTextField;
    private JBTextField basePackageTextField;
    private JBLabel modPackageLabel;
    private JBLabel serPackageLabel;
    private JBLabel ctrPackageLabel;
    private JBTextField modPackageTextField;
    private JBTextField serPackageTextField;
    private JBTextField ctrPackageTextField;
    private final PsiClass mClass;
    private final String basePackage;
    private final String basePerPackage;
    private final String baseUri;
    private final String modelPackageName;
    private final String modelUriName;

    public ConfigDialog(PsiClass psiClass) {
        super(psiClass.getProject());
        String[] arr = psiClass.getQualifiedName().split("\\.");
        String modelName = psiClass.getName();
        this.basePackage = psiClass.getQualifiedName().replace("." + arr[arr.length - 3] + "." + arr[arr.length - 2] + "." + arr[arr.length - 1], "");
        this.basePerPackage = psiClass.getQualifiedName().replace("." + arr[arr.length - 4] + "." + arr[arr.length - 3] + "." + arr[arr.length - 2] + "." + arr[arr.length - 1], "");
        this.modelPackageName = arr[arr.length - 2];
        this.modelUriName = arr[arr.length - 4];
        this.baseUri = "/platform/" + arr[arr.length - 4];
        this.mClass = psiClass;
        this.setupViews(modelName);
        this.init();
    }

    private void setupViews(String modelName) {
        this.setTitle("Generate Model:" + modelName);
        this.controllerCheckBox = new JBCheckBox("controllers", true);
        this.serviceCheckBox = new JBCheckBox("services", true);
        this.viewCheckBox = new JBCheckBox("views", true);
        this.viewAddCheckBox = new JBCheckBox("add", true);
        this.viewDetailCheckBox = new JBCheckBox("detail", true);
        this.viewEditCheckBox = new JBCheckBox("edit", true);
        this.viewIndexCheckBox = new JBCheckBox("index", true);
        this.localeCheckBox = new JBCheckBox("locales", true);
        this.forceCheckBox = new JBCheckBox("replace", false);
        this.basePathTextField = new JBTextField("wk-app/wk-web");
        this.baseUriTextField = new JBTextField(this.baseUri);
        this.basePackageTextField = new JBTextField(this.basePackage);
        this.basePathLabel = new JBLabel("base Path:");
        this.baseUriLabel = new JBLabel("base Uri:");
        this.basePackageLabel = new JBLabel("base Package:");
        this.modPackageLabel = new JBLabel("models Package:");
        this.serPackageLabel = new JBLabel("services Package:");
        this.ctrPackageLabel = new JBLabel("controllers Package:");
        this.modPackageTextField = new JBTextField(this.basePackage + ".modules.models");
        this.modPackageTextField.disable();
        this.serPackageTextField = new JBTextField(this.basePackage + ".modules.services");
        this.ctrPackageTextField = new JBTextField(this.basePerPackage + ".web.modules.controllers.platform." + this.modelUriName);
        this.viewCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigDialog.this.viewCheckBox.isSelected()) {
                    ConfigDialog.this.viewAddCheckBox.setSelected(true);
                    ConfigDialog.this.viewDetailCheckBox.setSelected(true);
                    ConfigDialog.this.viewEditCheckBox.setSelected(true);
                    ConfigDialog.this.viewIndexCheckBox.setSelected(true);
                    ConfigDialog.this.viewAddCheckBox.setVisible(true);
                    ConfigDialog.this.viewDetailCheckBox.setVisible(true);
                    ConfigDialog.this.viewEditCheckBox.setVisible(true);
                    ConfigDialog.this.viewIndexCheckBox.setVisible(true);
                } else {
                    ConfigDialog.this.viewAddCheckBox.setSelected(false);
                    ConfigDialog.this.viewDetailCheckBox.setSelected(false);
                    ConfigDialog.this.viewEditCheckBox.setSelected(false);
                    ConfigDialog.this.viewIndexCheckBox.setSelected(false);
                    ConfigDialog.this.viewAddCheckBox.setVisible(false);
                    ConfigDialog.this.viewDetailCheckBox.setVisible(false);
                    ConfigDialog.this.viewEditCheckBox.setVisible(false);
                    ConfigDialog.this.viewIndexCheckBox.setVisible(false);
                }
            }
        });
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        if (null == southPanel) {
            return null;
        }
        VerticalBox root = new VerticalBox();
        root.add((Component)this.basePathLabel);
        root.add((Component)this.basePathTextField);
        root.add((Component)this.baseUriLabel);
        root.add((Component)this.baseUriTextField);
        root.add((Component)this.basePackageLabel);
        root.add((Component)this.basePackageTextField);
        root.add((Component)this.modPackageLabel);
        root.add((Component)this.modPackageTextField);
        root.add((Component)this.serPackageLabel);
        root.add((Component)this.serPackageTextField);
        root.add((Component)this.ctrPackageLabel);
        root.add((Component)this.ctrPackageTextField);
        root.add((Component)this.forceCheckBox);
        root.add((Component)southPanel);
        return root;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent centerPanel = super.createContentPane();
        VerticalBox verticalBox = new VerticalBox();
        HorizontalBox horizontalBox1 = new HorizontalBox();
        HorizontalBox horizontalBox2 = new HorizontalBox();
        horizontalBox1.add((Component)this.controllerCheckBox);
        horizontalBox1.add((Component)this.serviceCheckBox);
        horizontalBox1.add((Component)this.localeCheckBox);
        horizontalBox1.add((Component)this.viewCheckBox);
        horizontalBox2.add((Component)this.viewAddCheckBox);
        horizontalBox2.add((Component)this.viewDetailCheckBox);
        horizontalBox2.add((Component)this.viewEditCheckBox);
        horizontalBox2.add((Component)this.viewIndexCheckBox);
        verticalBox.add((Component)horizontalBox1);
        verticalBox.add((Component)horizontalBox2);
        centerPanel.add((Component)verticalBox);
        return centerPanel;
    }

    public GenerateConfig getGenerateConfig() {
        GenerateConfig config = new GenerateConfig();
        config.setBasePackage(this.basePackage);
        config.setBasePath(this.basePathTextField.getText().trim());
        config.setBaseUri(this.baseUriTextField.getText().trim());
        config.setConroller(this.controllerCheckBox.isSelected());
        config.setService(this.serviceCheckBox.isSelected());
        config.setLocale(this.localeCheckBox.isSelected());
        config.setView(this.viewCheckBox.isSelected());
        config.setForce(this.forceCheckBox.isSelected());
        config.setModelPakName(this.modPackageTextField.getText().trim());
        config.setServicePakName(this.serPackageTextField.getText().trim());
        config.setControllerPakName(this.ctrPackageTextField.getText().trim());
        StringBuilder pages = new StringBuilder();
        pages.append(this.viewIndexCheckBox.isSelected() ? "index_" : "").append(this.viewAddCheckBox.isSelected() ? "add_" : "").append(this.viewDetailCheckBox.isSelected() ? "detail_" : "").append(this.viewEditCheckBox.isSelected() ? "edit_" : "");
        config.setPages(pages.toString());
        return config;
    }
}

