## 单数据源配置

#### web-app\wk-web\src\main\resources\config\custom\db.properties

~~~
db.url=jdbc:mysql://127.0.0.1:3306/nutzwk?useUnicode=true&characterEncoding=utf8
db.username=root
db.password=root
db.validationQuery=select 1
db.maxActive=100
db.testWhileIdle=true
db.filters=mergeStat
db.connectionProperties=druid.stat.slowSqlMillis=2000
db.defaultAutoCommit=true
~~~

#### web-app\wk-web\src\main\resources\config\ioc\dao.json

* cachedTableNames 为需要缓存的表名,当select这些表时结果是缓存的

* 当且仅当dao对这些表进行insert/update/drop操作时清除缓存

~~~
var ioc = {
		conf : {
			type : "org.nutz.ioc.impl.PropertiesProxy",
			fields : {
				paths : ["config/custom/"]
			}
		},
	    dataSource : {
			factory : "$conf#make",
			args : ["com.alibaba.druid.pool.DruidDataSource", "db."],
	        type : "com.alibaba.druid.pool.DruidDataSource",
	        events : {
	        	create : "init",
	            depose : 'close'
	        }
	    },
		dao : {
			type : "org.nutz.dao.impl.NutDao",
			args : [{refer:"dataSource"}],
			fields : {
				executor : {refer:"cacheExecutor"}
			}
		},
		cacheExecutor : {
			type : "org.nutz.plugins.cache.dao.CachedNutDaoExecutor",
			fields : {
				cacheProvider : {refer:"cacheProvider"},
				cachedTableNames : ["sys_user", "sys_role", "sys_menu"]
			}
		},
		/*
		// 基于内存的简单LRU实现
		cacheProvider : {
			type : "org.nutz.plugins.cache.dao.impl.provider.MemoryDaoCacheProvider",
			fields : {
				cacheSize : 10000 // 缓存的对象数
			},
			events : {
				create : "init"
			}
		}
		*/
		// 基于Ehcache的DaoCacheProvider
		cacheProvider : {
			type : "org.nutz.plugins.cache.dao.impl.provider.EhcacheDaoCacheProvider",
			fields : {
				cacheManager : {refer:"cacheManager"} // 引用ehcache.json中定义的CacheManager
			},
			events : {
				create : "init"
			}
		}
};
~~~

## 多数据源配置

#### web-app\wk-web\src\main\resources\config\custom\db.properties

~~~
#db1
db.url=jdbc:mysql://127.0.0.1:3306/nutzwk?useUnicode=true&characterEncoding=utf8
db.username=root
db.password=root
db.validationQuery=select 1
db.maxActive=100
db.testWhileIdle=true
db.filters=mergeStat
db.connectionProperties=druid.stat.slowSqlMillis=2000
db.defaultAutoCommit=true

#db2
db2.url=jdbc:mysql://127.0.0.1:3306/nutzwk2?useUnicode=true&characterEncoding=utf8
db2.username=root
db2.password=root
db2.validationQuery=select 1
db2.maxActive=100
db2.testWhileIdle=true
db2.filters=mergeStat
db2.connectionProperties=druid.stat.slowSqlMillis=2000
db2.defaultAutoCommit=true
~~~

#### web-app\wk-web\src\main\resources\config\ioc\dao.json

* 配置第二个dataSource及dao2，代码中通过 @Inject Dao dao2 获取dao

* 注意加2的地方

~~~
var ioc = {
		conf : {
			type : "org.nutz.ioc.impl.PropertiesProxy",
			fields : {
				paths : ["config/custom/"]
			}
		},
	    dataSource : {
			factory : "$conf#make",
			args : ["com.alibaba.druid.pool.DruidDataSource", "db."],
	        type : "com.alibaba.druid.pool.DruidDataSource",
	        events : {
	        	create : "init",
	            depose : 'close'
	        }
	    },
		dao : {
			type : "org.nutz.dao.impl.NutDao",
			args : [{refer:"dataSource"}],
			fields : {
				executor : {refer:"cacheExecutor"}
			}
		},
        dataSource2 : {
        factory : "$conf#make",
        args : ["com.alibaba.druid.pool.DruidDataSource", "db2."],
            type : "com.alibaba.druid.pool.DruidDataSource",
            events : {
              create : "init",
                depose : 'close'
            }
        },
        dao2 : {
          type : "org.nutz.dao.impl.NutDao",
          args : [{refer:"dataSource2"}]
        },
		cacheExecutor : {
			type : "org.nutz.plugins.cache.dao.CachedNutDaoExecutor",
			fields : {
				cacheProvider : {refer:"cacheProvider"},
				cachedTableNames : ["sys_user", "sys_role", "sys_menu"]
			}
		},
		/*
		// 基于内存的简单LRU实现
		cacheProvider : {
			type : "org.nutz.plugins.cache.dao.impl.provider.MemoryDaoCacheProvider",
			fields : {
				cacheSize : 10000 // 缓存的对象数
			},
			events : {
				create : "init"
			}
		}
		*/
		// 基于Ehcache的DaoCacheProvider
		cacheProvider : {
			type : "org.nutz.plugins.cache.dao.impl.provider.EhcacheDaoCacheProvider",
			fields : {
				cacheManager : {refer:"cacheManager"} // 引用ehcache.json中定义的CacheManager
			},
			events : {
				create : "init"
			}
		}
};
~~~

## 数据库密码加密配置

#### web-app\wk-web\src\main\resources\config\custom\db.properties

* java -cp druid-1.0.28.jar com.alibaba.druid.filter.config.ConfigTools root
* 通过如上命令给root加密获取加密密码及公钥
* db.url 增加 &useSSL=false
* db.password 改为加密后的密码
* db.filters 增加 config 配置项
* db.connectionProperties 增加 config.decrypt=true;config.decrypt.key=配置项

~~~
db.url=jdbc:mysql://127.0.0.1:3306/nutzwk?useUnicode=true&characterEncoding=utf8&useSSL=false
db.username=root
#java -cp druid-1.0.28.jar com.alibaba.druid.filter.config.ConfigTools root
db.password=JihMljGR2lbBbKrx2VY1bwvepOuzizt/p3mbN7HY///FxJ1j7OXoxz5LpzsKv4vl512r800Y/8ksW3fqpyhKqg==
#db.password=root
db.validationQuery=select 1
db.maxActive=100
db.testWhileIdle=true
db.filters=mergeStat,config
db.connectionProperties=druid.stat.slowSqlMillis=2000;config.decrypt=true;config.decrypt.key=MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAJw7fy1mPXb/WkKnpta1NGx+rUHFG7B2uXR6v64xsLQXw9xcRINZ1mcGK8fZt7YB5AIuRaMMSodePkuswInc5GUCAwEAAQ==
db.defaultAutoCommit=true
~~~
