# 入口类Module

`cn.wizzer.app.web.commons.core.Module`

~~~
@Modules(scanPackage = true, packages = "cn.wizzer")
@Ok("json:full")
@Fail("http:500")
@IocBy(type = ComboIocProvider.class, args = {"*json", "config/ioc/", "*anno", "cn.wizzer", "*tx", "*quartz", "*async"})
@Localization(value = "locales/", defaultLocalizationKey = "zh_CN")
@Encoding(input = "UTF-8", output = "UTF-8")
@Views({BeetlViewMaker.class, PdfViewMaker.class})
@SetupBy(value = Setup.class)
@ChainBy(args = "config/chain/nutzwk-mvc-chain.json")
@SessionBy(ShiroSessionProvider.class)
public class Module {
}
~~~
* `@Modules` 扫描package及子package下的类中的入口方法，扩展自己的包需要在这里加包名，详见 [http://nutzam.com/core/mvc/modules.html](扩展自己的包需要在这里加包名)
* `@Ok` 全局配置响应成功返回的结果，这里配的是输出json格式（含null值）
* `@Fail` 全局配置响应失败返回的结果，这里配的是返回500页面
* `@IocBy` 配置加载容器对象，扩展自己的包需要在这里加包名，详见 [http://nutzam.com/core/ioc/loader_annotation.html](http://nutzam.com/core/ioc/loader_annotation.html)
* `@Localization` 语言包放置的路径，及默认的语言
* `@Encoding` 运行时、输入输出、数据库、文件编码等，统一为UTF-8
* `@Views` 加载视图，这里添加了beetl模板引擎及pdf视图，@Ok("beetl:/..html")返回页面，@Ok("raw:pdf") 结果直接生成PDF文件，@Ok("raw:png") 直接输出图片等等，详见 [http://nutzam.com/core/mvc/view.html](http://nutzam.com/core/mvc/view.html)
* `@SessionBy` session交给shiro管理
* `@ChainBy` 加载的动作链配置文件
* `@SetupBy` 启动类，初始化数据

# 启动类Setup

`cn.wizzer.app.web.commons.core.Setup`

* 为Globals全局变量赋值，如Globals.AppRoot项目物理路径，
* 启动时根据Sys_user表是否有数据，初始化表数据
* 初始化自定义路由、定时任务、插件等，详见代码
