# GlobalsSettingProcessor
`cn.wizzer.app.web.commons.processor.GlobalsSettingProcessor`

~~~
public class GlobalsSettingProcessor extends AbstractProcessor {

	@SuppressWarnings("rawtypes")
	public void process(ActionContext ac) throws Throwable {
		ac.getRequest().setAttribute("AppRoot", Globals.AppRoot);
		ac.getRequest().setAttribute("AppBase", Globals.AppBase);
		ac.getRequest().setAttribute("AppName", Globals.AppName);
		ac.getRequest().setAttribute("AppDomain", Globals.AppDomain);
		ac.getRequest().setAttribute("AppShrotName", Globals.AppShrotName);
		ac.getRequest().setAttribute("shiro", Mvcs.ctx().getDefaultIoc().get(ShiroUtil.class));
		ac.getRequest().setAttribute("date", Mvcs.ctx().getDefaultIoc().get(DateUtil.class));
		ac.getRequest().setAttribute("string", Mvcs.ctx().getDefaultIoc().get(StringUtil.class));
		// 如果url中有语言属性则设置
		String lang=ac.getRequest().getParameter("lang");
		if (!Strings.isEmpty(lang)) {
			Mvcs.setLocalizationKey(lang);
		}else{
			// Mvcs.getLocalizationKey()  1.r.56 版本是null,所以要做两次判断, 1.r.57已修复为默认值 Nutz:Fix issue 1072
			lang=Strings.isBlank(Mvcs.getLocalizationKey())?Mvcs.getDefaultLocalizationKey():Mvcs.getLocalizationKey();
		}
		ac.getRequest().setAttribute("lang", lang);
		doNext(ac);
	}

}
~~~

* 页面上可以通过beetl或其他模板引擎，获取 ${AppBase} 部署路径（或者使用系统自带的 ${base} 对象）
* 页面上可通过 `@shiro.hasRole("sysadmin")` 、`@shiro.hasPermission("sys.manager.user.add")` 等验证是否有对应的权限，`${@shiro.getPrincipalProperty('username')}`获取当前登录用户的一个属性，详见 `ShiroUtil`
* 设置了根据lang 参数值加载不同的国际化语言，前台使用 `${msg['index.custommenu']}` 输出对应的字符串，后台使用 `Mvcs.getMessage(req, msg)` 获取字符串
