# RouteFilter 自定义路由

## web.xml

~~~
<filter>
    <filter-name>route</filter-name>
    <filter-class>cn.wizzer.app.web.commons.filter.RouteFilter</filter-class>
</filter>
<filter-mapping>
    <filter-name>route</filter-name>
    <url-pattern>/*</url-pattern>
</filter-mapping>

~~~

## RouteFilter
~~~
public class RouteFilter implements Filter {

    @Override
    public void doFilter(ServletRequest req, ServletResponse res,
                         FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req2 = (HttpServletRequest) req;
        HttpServletResponse res2 = (HttpServletResponse) res;
        res2.setCharacterEncoding("utf-8");
        req2.setCharacterEncoding("utf-8");
        Sys_route route = Globals.RouteMap.get(req2.getRequestURI().replace(Globals.AppBase, ""));
        if (route != null) {
            if ("show".equals(route.getType())) {
                res2.sendRedirect(route.getToUrl());
            } else {
                req2.getRequestDispatcher(route.getToUrl()).forward(req2, res2);
            }
        } else chain.doFilter(req2, res2);
    }

    @Override
    public void init(FilterConfig arg0) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}
~~~
