# Pojo实体类

~~~
@Table("wx_config")
public class Wx_config extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column
    @Name
    @ColDefine(type = ColType.VARCHAR, width = 32)
    @Prev(els = {@EL("uuid()")})
    private String id;

    @Column
    @Comment("发送状态")
    @ColDefine(type = ColType.INT)
    protected Integer status;

~~~
* Pojo类继承BaseModel类，启动时会自动建表同时包含BaseModel中的三个字段
* 建议所有的ID主键，使用UUID字符串
* `@ColDefine(type = ColType.INT)` int类型字段不要设置width，因为这里的width不是数据库里的长度，且java类型设置为Integer，因为后台表单提交都是调用dao.updateIgnoreNull() 方法，如果是int且表单没有隐藏的input则会被置为0
* 加了 `@Comment` 注解的字段才会被代码生成器识别，生成到模板文件和国际化语言中
* 命名规范： Wx_config，wx为模块名称，代码生成器会根据下划线切分数组，组装路径
* 注意：请遵从系统自带模块的包及类命名规范

详见 [http://nutzam.com/core/dao/entity.html](http://nutzam.com/core/dao/entity.html)
