# Service类

必须写一个接口类：

~~~
public interface CmsArticleService extends BaseService<Cms_article>{

}
~~~

以及实现类，并注入dao：

~~~
@IocBean(args = {"refer:dao"})
public class CmsArticleServiceImpl extends BaseServiceImpl<Cms_article> implements CmsArticleService {
    public CmsArticleServiceImpl(Dao dao) {
        super(dao);
    }
}
~~~

* Service写成接口，这样才能映射服务接口，配合dubbo、rsf等实现分布式部署
* 注入dao或者dao2等，可方便多数据源业务
* 建议所有的业务都写在 Service 中
* 配合 `@Async` 可以实现异步方法调用
* 使用 `@Aop(TransAop.READ_COMMITTED)` 实现事务，使用事务时不可捕获异常，否则事务不能回滚
* 注意：请遵从系统自带模块的包及类命名规范
