# Controller类

~~~
@IocBean
@At("/platform/sys/log")
public class SysLogController {
    private static final Log log = Logs.get();
    @Inject
    private SysLogService sysLogService;

    @At("")
    @Ok("beetl:/platform/sys/log/index.html")
    @RequiresAuthentication
    public void index() {

    }

    @At(value={"/", "/index"}, top=true)
    @Ok(">>:/sysadmin")
    public void index() {
      //这个是首页路径配置
    }

    @At("")
    @Ok("re")
    @Filters
    public String login() {
        //根据条件，返回不同的视图
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            return "redirect:/platform/home";
        } else {
            return "beetl:/platform/sys/login.html";
        }
    }

    @At("/doLogin")
    @Ok("json")
    @Filters(@By(type = PlatformAuthenticationFilter.class))
    public Object doLogin(@Attr("loginToken") AuthenticationToken token, HttpServletRequest req, HttpSession session) {
        //使用过滤器
    }
~~~

* 通过 `@Inject` 注入service类
* `@At` 请求路径
* `@Ok` 返回视图或对象
* `@Param` 获取参数
* `@Attr` 等同于req.getAttribute("")
* REST支持见[http://nutzam.com/core/mvc/rest.html](http://nutzam.com/core/mvc/rest.html)

控制类是开发中最常用的功能，请详细阅读官方文档MVC章节，详见 [http://nutzam.com/core/mvc/overview.html](http://nutzam.com/core/mvc/overview.html)
