# nutz-plugins-wkcache 方法缓存

pom.xml
```
        <dependency>
            <groupId>org.nutz</groupId>
            <artifactId>nutz-integration-jedis</artifactId>
            <version>1.r.62-SNAPSHOT</version>
        </dependency>
        <dependency>
             <groupId>org.nutz</groupId>
             <artifactId>nutz-plugins-wkcache</artifactId>
             <version>1.r.62-SNAPSHOT</version>
        </dependency>
        <dependency>
            <groupId>redis.clients</groupId>
            <artifactId>jedis</artifactId>
            <version>2.9.0</version>
            <scope>provided</scope>
        </dependency>
```
加载ioc对象jedis及wkcache
```
@IocBy(type = ComboIocProvider.class, args = {"*json", "config/ioc/", "*anno", "cn.wizzer", "*jedis", "*wkcache"})
```
redis.properties 配置文件
```
redis.host=localhost
redis.port=6379
redis.timeout=2000
redis.max_redir=10
redis.database=0
redis.maxTotal=100
#redis.password=wizzer
#redis集群模式设置 redis.mode=cluster
redis.mode=normal
#redis.nodes=
```
## 示例代码


```

@IocBean(args = {"refer:dao"})
@CacheDefaults(cacheName = "goods_product",cacheLiveTime = 3000)
//设置缓存名及失效时间(单位秒),如不设置失效时间则要手动删除缓存,缓存才能得到更新
public class GoodsProductServiceImpl extends BaseServiceImpl<Goods_product> implements GoodsProductService {
    public GoodsProductServiceImpl(Dao dao) {
        super(dao);
    }

    @CacheResult(cacheKey = "${args[0]}_${args[1]}_${args[2]}")
    //可以通过el表达式获取传递的参数作为cacheKey
    public int getPrice(String goodsId, String productId, String memberId) {
        //todo
        return 0;
    }
    
    @CacheResult(cacheKey = "${args[0].id}_${args[0].loginname}")
    public Object getObjData(Member_user user) {
        //todo
        return obj;
    }

    @CacheResult
    //不指定cacheKey按wkcache默认规则生成cacheKey
    //不指定cacheName,则使用类 @CacheDefaults设置的缓存名,若都不设置则缓存名为wk
    public Object getData(String goodsId) {
        // todo
        return obj;
    }
    
    @CacheRemove(cacheKey = "${args[0]}_*")
    //可以通过el表达式加 * 通配符来批量删除一批缓存
    public void deleteCache(String goodsId) {
    
    }
    
    @CacheRemoveAll
    //清空cacheName下的所有缓存数据
    public void clearCache() {

    }
}

```
