# NutzWK 开发指南


---

- [01. **快速开始**](01.QuickStart)
  - [01.01 **开发环境**](01.QuickStart/01.01.Environment.md)
  - [01.02 **数据源配置**](01.QuickStart/01.02.DBConfig.md)
  - [01.03 **项目启动**](01.QuickStart/01.03.Start.md)
- [02. **权限体系**](02.Shiro)
  - [02.01 **表设计**](02.Shiro/02.01.Desgin.md)
  - [02.02 **Shiro配置**](02.Shiro/02.02.Settings.md)
- [03. **框架运行**](03.Run)
  - [03.01 **入口类及数据初始化**](03.Run/03.01.Init.md)
  - [03.02 **动作链**](03.Run/03.02.Processor.md)
    - [03.02.01 **全局变量及国际化语言**](03.Run/03.02.01.GlobalsSettingProcessor.md)
    - [03.02.02 **打印响应耗时**](03.Run/03.02.02.LogTimeProcessor.md)
    - [03.02.03 **防SQL注入&跨站攻击**](03.Run/03.02.03.XssSqlFilterProcessor.md)
  - [03.03 **过滤器**](03.Run/03.03.Filter.md)
    - [03.03.01 **@Filters 注解**](03.Run/03.03.01.Filters.md)
    - [03.03.02 **自定义路由**](03.Run/03.03.02.RouteFilter.md)
  - [03.04 **@Async 异步方法**](03.Run/03.04.Async.md)
  - [03.05 **@SLog 操作日志**](03.Run/03.05.Slog.md)
- [04. **后台开发**](04.Code)
  - [04.01 **Pojo类**](04.Code/04.01.Pojo.md)
  - [04.02 **代码生成**](04.Code/04.02.Generator.md)
  - [04.03 **服务类**](04.Code/04.03.Service.md)
  - [04.04 **控制类**](04.Code/04.04.Controller.md)
- [05 **前台开发**](05.Web)
  - [05.01 **分页及查询**](05.Web/05.01.Datatable.md)
  - [05.02 **Loading**](05.Web/05.02.Loading.md)
  - [05.03 **提示框**](05.Web/05.03.Toast.md)
  - [05.04 **表单验证**](05.Web/05.04.Parsley.md)
- [06 **功能扩展**](06.Other)
  - [06.01 **RabbitMQ**](06.Other/06.01.Rabbitmq.md)
  - [06.02 **Websoket**](https://github.com/nutzam/nutzmore/tree/master/nutz-plugins-websocket)  
  - [06.03 **Dubbo**](https://github.com/nutzam/nutzmore/tree/master/nutz-integration-dubbo)
  - [06.04 **Activiti**](https://github.com/nutzam/nutzmore/tree/master/nutz-integration-activiti)
  - [06.05 **热插拔插件化**](https://github.com/nutzam/nutzmore/tree/master/nutz-plugins-hotplug)
  - [06.06 **方法缓存**](06.Other/06.06.wkcache.md)
  - [06.07 **微信支付**](06.Other/06.07.wxpay.md)
- [07 **Nutz 官方文档**](http://nutzam.com/core/nutz_preface.html)
