
GO
/****** Object:  Table [dbo].[SingleBook_BookConfig]    Script Date: 05/05/2013 13:26:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_BookConfig](
	[BookName] [nvarchar](50) NOT NULL,
	[BookSubject] [nvarchar](50) NOT NULL,
	[BookAuthor] [nvarchar](50) NOT NULL,
	[BookKeywords] [nvarchar](255) NOT NULL,
	[BookDescription] [nvarchar](512) NOT NULL,
	[BookStatus] [nvarchar](50) NOT NULL,
	[IsEnableVolume] [bit] NOT NULL,
	[IsEnableComment] [bit] NOT NULL,
 CONSTRAINT [PK_SingleBook_BookConfig] PRIMARY KEY CLUSTERED 
(
	[BookName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SingleBook_Book]    Script Date: 05/05/2013 13:26:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_Book](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[VID] [int] NOT NULL,
	[Title] [nvarchar](80) NOT NULL,
	[Content] [nvarchar](max) NOT NULL,
	[AddDate] [datetime] NOT NULL,
	[Hits] [int] NOT NULL,
 CONSTRAINT [PK_SingleBook_Book] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SingleBook_Admin]    Script Date: 05/05/2013 13:26:50 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_Admin](
	[AdminID] [int] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](50) NOT NULL,
	[PassWord] [nvarchar](32) NOT NULL,
	[ErrorCount] [int] NOT NULL,
	[LastErrorDateTime] [datetime] NOT NULL,
 CONSTRAINT [PK_SingleBook_Admin] PRIMARY KEY CLUSTERED 
(
	[AdminID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [UQ_SingleBook_Admin_UserName] UNIQUE NONCLUSTERED 
(
	[UserName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SingleBook_Volume]    Script Date: 05/05/2013 13:26:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_Volume](
	[VID] [int] IDENTITY(1,1) NOT NULL,
	[VName] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_SingleBook_Volume] PRIMARY KEY CLUSTERED 
(
	[VID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SingleBook_Link]    Script Date: 05/05/2013 13:26:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_Link](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SiteName] [nvarchar](50) NOT NULL,
	[SiteUrl] [nvarchar](255) NOT NULL,
	[Sort] [int] NOT NULL,
	[Contact] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_SingleBook_Link] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[SingleBook_Comment]    Script Date: 05/05/2013 13:26:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[SingleBook_Comment](
	[CID] [int] IDENTITY(1,1) NOT NULL,
	[CBookID] [int] NOT NULL,
	[CContent] [nvarchar](max) NOT NULL,
	[CAddDate] [datetime] NOT NULL,
	[CUserName] [nvarchar](50) NOT NULL,
	[CIP] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_SingleBook_Comment] PRIMARY KEY CLUSTERED 
(
	[CID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  ForeignKey [FK_SingleBook_Book_SingleBook_Comment]    Script Date: 05/05/2013 13:26:51 ******/
ALTER TABLE [dbo].[SingleBook_Comment]  WITH CHECK ADD  CONSTRAINT [FK_SingleBook_Book_SingleBook_Comment] FOREIGN KEY([CBookID])
REFERENCES [dbo].[SingleBook_Book] ([ID])
GO
ALTER TABLE [dbo].[SingleBook_Comment] CHECK CONSTRAINT [FK_SingleBook_Book_SingleBook_Comment]
GO

/********һĬС*******/
INSERT INTO [dbo].[SingleBook_BookConfig]
           ([BookName]
           ,[BookSubject]
           ,[BookAuthor]
           ,[BookKeywords]
           ,[BookDescription]
           ,[BookStatus]
           ,[IsEnableVolume]
           ,[IsEnableComment])
     VALUES
           ('Ĺʼ'
           ,'ֲ'
           ,''
           ,'Ĺʼ'
           ,'Ĺʼ'
           ,''
           ,1
           ,1)
GO

/**********Ա*************/
INSERT INTO [dbo].[SingleBook_Admin]
           ([UserName]
           ,[PassWord]
           ,[ErrorCount]
           ,[LastErrorDateTime])
     VALUES
           ('admin'
           ,'7FEF6171469E80D32C0559F88B377245'
           ,0
           ,GETDATE())
GO