﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem.Bll
{
    class Staff
    {
        public bool ExportDataGridview(DataGridView gridView, bool isShowExcle)
        {
            try
            {
                if (gridView.Rows.Count == 0)
                {
                    return false;
                }
                else
                {
                  
                    Excel.Application excel = new Excel.Application();
                    excel.Application.Workbooks.Add(true);
                    excel.Visible = isShowExcle;
                   
                    for (int i = 0; i < gridView.ColumnCount; i++)
                    {
                        excel.Cells[1, i + 1] = gridView.Columns[i].HeaderText;
                    }
                    
                    for (int i = 0; i < gridView.RowCount - 1; i++)
                    {
                        for (int j = 0; j < gridView.ColumnCount; j++)
                        {
                            if (gridView[j, i].ValueType == typeof(string))
                            {
                                excel.Cells[i + 2, j + 1] = "'" + gridView[j, i].Value.ToString();
                            }
                            else
                            {
                                excel.Cells[i + 2, j + 1] = gridView[j, i].Value.ToString();
                            }
                        }
                    }
                    return true;
                }
            }
            catch (Exception)
            {
                return false;
            }
        }
    }
}
