﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using HRManagerSystem.Bll;
namespace HRManagerSystem
{
    public partial class DepartForm : Form
    {
        public DepartForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        private void DepartForm_Load(object sender, EventArgs e)
        {
            
            Department dpt = new Department();
            dataGridView1.DataSource = dpt.DepartName();
            txt_name.ForeColor=Color.Gray;
           
        }

        
        
        /// <summary>
        /// 退出操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        /// <summary>
        /// 刷新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
          
            Department dpt = new Department();
            dataGridView1.DataSource = dpt.DepartName();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            AddDepartForm addde = new AddDepartForm();
            addde.ShowDialog();
            Department dpt = new Department();
            dataGridView1.DataSource = dpt.DepartName();
        }
        bool mark = false;
        /// <summary>
        /// 删除操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                var departinfo= ddt.T_Department.Single(id => id.Depart_ID == departid);
                if (DialogResult.Yes == MessageBox.Show("你确定要删除么？", "提示", MessageBoxButtons.YesNo))
                {
                    ddt.T_Department.DeleteOnSubmit(departinfo);//单个删除
                    ddt.SubmitChanges();
                }
                //加载数据源
                Department dpt = new Department();
                dataGridView1.DataSource = dpt.DepartName();
               
            }
            else
            {
                MessageBox.Show("请先选择一行数据再进行删除操作！", "提示", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
        }
        T_Department depart = new T_Department();
        int departid = 0;
        /// <summary>
        /// 单击dataGridView的事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
           
            if (e.RowIndex > -1)
            {
                depart = ddt.T_Department.Single(id => id.Depart_ID == Convert.ToInt32(dataGridView1.Rows[e.RowIndex].Cells[0].Value));


                departid = depart.Depart_ID;

            }
            mark = true;
        }

       
        /// <summary>
        /// 查找信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            
            Department dpt = new Department();
            dataGridView1.DataSource = dpt.SearchDepart(txt_name.Text);
            if (dpt.SearchDepart(txt_name.Text).Rows.Count==0)
            {
                MessageBox.Show("你查找的部门不存在！");
            }

        }

        private void txt_name_Click(object sender, EventArgs e)
        {
            txt_name.Clear();
            txt_name.Focus();
            txt_name.ForeColor = Color.Black;
        }
    }
}
