﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class DepartForm : Form
    {
        public DepartForm()
        {
            InitializeComponent();
        }
        DataDataContext ddt = new DataDataContext();
        private void DepartForm_Load(object sender, EventArgs e)
        {
            var result = ddt.T_Department.Select(dd=>dd);
            dataGridView1.DataSource = result;
        }

        
        
        /// <summary>
        /// 退出操作
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        /// <summary>
        /// 刷新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            var result = ddt.T_Department.Select(dd => dd);
            dataGridView1.DataSource = result;
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            AddDepartForm addde = new AddDepartForm();
            addde.ShowDialog();
            var result = ddt.T_Department.Select(dd => dd);
            dataGridView1.DataSource = result;
        }
        bool mark = false;
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                var departinfo= ddt.T_Department.Single(id => id.Depart_ID == departid);
                if (DialogResult.OK == MessageBox.Show("你确定要删除么？", "提示", MessageBoxButtons.YesNo))
                    ddt.T_Department.DeleteOnSubmit(departinfo);//单个删除
                ddt.SubmitChanges();
                //加载数据源
                var result = ddt.T_Department.Select(dd => dd);
                dataGridView1.DataSource = result;
               
            }
            else
            {
                MessageBox.Show("请先选择一行数据再进行删除操作！", "提示", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
        }
        T_Department depart = new T_Department();
        int departid = 0;
        private void dataGridView1_CellClick(object sender, DataGridViewCellEventArgs e)
        {
           
            if (e.RowIndex > -1)
            {
                depart = ddt.T_Department.Single(id => id.Depart_ID == Convert.ToInt32(dataGridView1.Rows[e.RowIndex].Cells[0].Value));


                departid = depart.Depart_ID;

            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

          
        }

        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            var result = ddt.T_Department.Select(name => name.Depart_Name == txt_name.Text);
            dataGridView1.DataSource = result;
            if (result.Count() == 0)
            {
                MessageBox.Show("你查找的部门不存在！");
            }

        }

        private void dataGridView1_Click(object sender, EventArgs e)
        {
            txt_name.Clear();
            txt_name.Focus();
        }
    }
}
