﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class StaffRemoveForm : Form
    {
        public StaffRemoveForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        DataTable DT = new DataTable();
        #region LINQ操作方法
        public void LINQOPT(DataTable dt)
        {
            dt.Columns.Add("编号", typeof(string));
            dt.Columns.Add("员工编号", typeof(string));
            dt.Columns.Add("名称", typeof(string));
            dt.Columns.Add("旧部门", typeof(string));
            dt.Columns.Add("新部门", typeof(string));
            dt.Columns.Add("旧职务", typeof(string));
            dt.Columns.Add("新职务", typeof(string));
            dt.Columns.Add("调动时间", typeof(string));
            foreach (var v in ddc.T_DiaoDu)
            {
                dt.Rows.Add(v.DiaoDu_ID, v.Staff_ID, v.T_StaffRecords.Staff_Name, v.T_Department.Depart_Name, v.T_Department1.Depart_Name, v.T_Jobs.Job_Name, v.T_Jobs1.Job_Name, v.DiaoDu_Time);
            }
            DD_DVG.DataSource = dt;
        } 
        #endregion
        private void StaffRemoveForm_Load(object sender, EventArgs e)
        {
            DataTable DT = new DataTable();
            toolStripStatusLabel2.Text = ddc.T_DiaoDu.Count().ToString();
            LINQOPT(DT);
        }
        /// <summary>
        /// 跳转到添加窗体
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            DataTable da = new DataTable();
            DD_AddStaffdd das = new DD_AddStaffdd();
            das.ShowDialog();
            LINQOPT(da);
        }
        /// <summary>
        /// 刷新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            DataTable de = new DataTable();
            LINQOPT(de);
        }
        //public bool mark;
        #region 退出
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            this.Close();
            //if (!mark)
            //{
            //    Environment.Exit(0);
            //}
        } 
        #endregion
        /// <summary>
        /// 跳转查询界面
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            DD_SelStaddInfo ddss = new DD_SelStaddInfo();
            ddss.ShowDialog();
        }
        string str;
        /// <summary>
        /// 获得数据中的ID
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        bool mark2 = false;
        private void DD_DVG_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            mark2 = true;
            if (e.RowIndex > -1)
            {
               str = DD_DVG.Rows[e.RowIndex].Cells[0].Value.ToString ();//获得数据表中的一行的ID号
            }
        }

        #region 删除操作
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            DataTable ds = new DataTable();
            if(!mark2)                   //if (str == "")
            {
                MessageBox.Show("请选择要删除的信息！");

            }
            else
            {
                try
                {
                    mark2 = !mark2;
                    if (DialogResult.OK == MessageBox.Show("确定要删除么！", "提示", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation))
                    {
                        //获得要删除的员工的调度信息中的id
                        var deldd = ddc.T_DiaoDu.Single(va => va.DiaoDu_ID == Convert.ToInt32(str));
                        ddc.T_DiaoDu.DeleteOnSubmit(deldd);//执行删除
                        ddc.SubmitChanges();
                        MessageBox.Show("删除成功！");
                    }
                }
                catch
                { }
            }
            LINQOPT(ds);
        }        
        #endregion

        #region 按照日期查询
        private void dateTimePicker1_ValueChanged(object sender, EventArgs e)
        {
            DataTable di = new DataTable();
            DateTime dtpstart = Convert.ToDateTime(dateTimePicker1.Text);//获得开始日期时间
            DateTime dtpend = Convert.ToDateTime(dateTimePicker2.Text);//获得结束日期时间
            if (dtpstart <= dtpend)
            {
                DD_DVG.DataSource = ddc.P_DiaoDuByStaffTime(dtpstart, dtpend);//调用储存过程查询
                if (ddc.P_DiaoDuByStaffTime(dtpstart, dtpend).Count() == 0)
                {
                    MessageBox.Show("该时间段没有调动记录！");
                }
                LINQOPT(di);
            }
            else
            {
                MessageBox.Show("日期输入错误！");
            }
        } 
        #endregion
    }
}
