﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace HRManagerSystem
{
    public partial class JC_AddSta : Form
    {
        public JC_AddSta()
        {
            InitializeComponent();
        }
        StaffPriseForm spf = new StaffPriseForm();
        DataDataContext ddc = new DataDataContext();
        private void JC_AddSta_Load(object sender, EventArgs e)
        {
            JC_AddDGV.Visible = false;
            this.MaximumSize = this.MinimumSize;
            //spf.SQLOPT();
            //JC_CMB.Text = jc.AwardORpunish.Value.ToString ();
        }
        /// <summary>
        /// 得到员工信息是用户选择
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        #region 得到员工的信息基于下拉框
        private void JC_AddDGV_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                int sid = Convert.ToInt32(JC_AddDGV.Rows[e.RowIndex].Cells[0].Value);
                string sname = Convert.ToString(JC_AddDGV.Rows[e.RowIndex].Cells[1].Value);
                string depart = Convert.ToString(JC_AddDGV.Rows[e.RowIndex].Cells[2].Value);
                string kpcont = Convert.ToString(JC_AddDGV.Rows[e.RowIndex].Cells[3].Value);
                string kpgrade = Convert.ToString(JC_AddDGV.Rows[e.RowIndex].Cells[4].Value);
                string kpresu = Convert.ToString(JC_AddDGV.Rows[e.RowIndex].Cells[5].Value);
                JC_staffCB.Text = sid.ToString();//得到员工编号
                JC_staTB.Text = sname;//得到员工姓名
                JC_departTB.Text = depart;//员工部门
                JC_staffkpConTB.Text = kpcont;//员工奖罚原因
                JC_kpstagrade.Text = kpgrade;//员工奖罚分数
                JC_kpstaReTb.Text = kpresu;//员工奖罚的结果
            } 
        #endregion
            JC_AddDGV.Visible = false;
        }
        /// <summary>
        /// 单击员工编号控件事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void JC_staffCB_Click(object sender, EventArgs e)
        {
            JC_AddDGV.Visible = true;
            JC_AddDGV.Focus();
            JC_AddDGV.DataSource = ddc.V_AddStaJC;//获得数据源
        }
        /// <summary>
        /// 增加员工奖惩情况
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        #region 增加员工奖惩情况
        private void UpDate_TSB_Click(object sender, EventArgs e)
        {
            T_JiangCheng jc = new T_JiangCheng();
            try
            {
                if (JC_staffCB .Text !="")
                {

                    jc.JC_Money = Convert.ToDecimal(JC_MoneyTB.Text);
                    jc.JC_Cause = JC_caseTB.Text;
                    jc.JC_Time = DateTime.Now;
                    jc.Staff_ID = Convert.ToInt32(JC_staffCB.Text);
                    if (JC_CMB.Text != "")
                    {
                        jc.AwardORpunish = JC_CMB.Text == "奖励" ? true : false;
                    }
                    ddc.T_JiangCheng.InsertOnSubmit(jc);
                    ddc.SubmitChanges();
                    MessageBox.Show("添加成功！");
                    this.ADD_TSB_Click(sender, e);
                }
                else
                {
                    MessageBox.Show("员工不能为空！");
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        } 
        #endregion
        /// <summary>
        /// 重新添加员工奖惩情况
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public  void ADD_TSB_Click(object sender, EventArgs e)
        {
            JC_staffCB.Text = "";
            JC_staTB.Text = "";
            JC_departTB.Text = "";
            JC_staffkpConTB.Text = "";
            JC_kpstagrade.Text ="";
            JC_kpstaReTb.Text = "";
            JC_MoneyTB.Text = "";
            JC_CMB.Text = "";
            JC_caseTB.Text = "";
        }
        /// <summary>
        /// 窗体退出
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Quit_TSB_Click(object sender, EventArgs e)
        {
            this.Close();
            
           // spf.SQLOPT();
        }
    }
}
