﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Configuration;

namespace HRManagerSystem
{
    public partial class JC_SelectJcInfo : Form
    {
        public JC_SelectJcInfo()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        StaffPriseForm spf = new StaffPriseForm();

        #region 数据操作方法
        public void SELSQLOPT()
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["HRManagerSystem.Properties.Settings.HR_DBConnectionString"].ConnectionString);//连接数据库
            string SQL = "select * from V_StaffJC";//SQL语句
            SqlDataAdapter sda = new SqlDataAdapter(SQL, con);
            DataTable dt = new DataTable();//用数据填充表
            sda.Fill(dt);
            dt.Columns.Add("奖惩", typeof(string), "IIF([AwardORpunish]=true,'奖','罚')");
            JC_SelDGV.DataSource = dt;//显示数据
        }  
        #endregion
        private void JC_SelectJcInfo_Load(object sender, EventArgs e)
        {
            this.SELSQLOPT();
        }

        #region 按类别查询
        private void SureBt_Click(object sender, EventArgs e)
        {
            try
            {
                if (JC_selectTB.Text != "")
                {
                    if (JC_selectNameRB.Checked)
                    {
                        JC_SelDGV.DataSource = ddc.V_StaffJC.Where(sname => sname.Staff_Name == JC_selectTB.Text);//根据姓名查询
                        if (ddc.V_StaffJC.Where(sname => sname.Staff_Name == JC_selectTB.Text).Count() == 0)
                        {
                            MessageBox.Show("没有检索到相关信息！");
                        }
                    }
                    else
                    {
                        JC_SelDGV.DataSource = ddc.V_StaffJC.Where(sname => sname.Depart_Name == JC_selectTB.Text);//根据部门查询
                        if (ddc.V_StaffJC.Where(sname => sname.Depart_Name == JC_selectTB.Text).Count() == 0)
                        {
                            MessageBox.Show("没有检索到相关信息！");
                        }
                    }
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        } 
        #endregion
    }
}
