﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Configuration;
using System.Data.Common;


namespace HRManagerSystem
{
    public partial class StaffPriseForm : Form
    {
        public StaffPriseForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();
        /// <summary>
        /// 操作SQL的方法
        /// </summary>
        #region SQL的操作方法
        
        public void SQLOPT()
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["HRManagerSystem.Properties.Settings.HR_DBConnectionString"].ConnectionString);//数据库连接
            string SQL = "select * from V_StaffJC";//SQL语句
            SqlDataAdapter sda = new SqlDataAdapter(SQL, con);
            DataTable dt = new DataTable();
            sda.Fill(dt);
            dt.Columns.Add("奖惩", typeof(string), "IIF([AwardORpunish]=true,'奖','罚')");
            JC_DGV.DataSource = dt;
        } 
        #endregion
        private void StaffPriseForm_Load(object sender, EventArgs e)
        {
            DataTable de = new DataTable();
            toolStripStatusLabel2 .Text  = ddc.T_JiangCheng.Count().ToString();//获得多少条奖惩记录
            this.JC_DGV.Focus() ;
            this.SQLOPT();

        }
        /// <summary>
        /// 跳转到增加窗体
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void JC_AddTSB_Click(object sender, EventArgs e)
        {
            JC_AddSta jas = new JC_AddSta();
            jas.ShowDialog();
            SQLOPT();
        }
        /// <summary>
        /// 刷新本窗体
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            //JC_DGV.DataSource = ddc.V_StaffJC.Select(str => str);
            SQLOPT();
        }
        /// <summary>
        /// 跳转到修改界面
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void JC_UpdateTSB_Click(object sender, EventArgs e)
        {
            if (mark)
            {
                JC_UpdateStajc jcus = new JC_UpdateStajc(sid);//new一个新的窗体
                jcus.ShowDialog();
                SQLOPT();
                mark = !mark;
            }
            else
            {
                MessageBox.Show("请先选中一条记录再进行操作！");
            }

        }
        T_StaffRecords sr = new T_StaffRecords();
        T_JiangCheng jc = new T_JiangCheng();
        string sid ;
        //string id;
        bool mark = false;
        //bool mark1 = false;
        private void JC_DGV_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            mark = true;
            //mark1 = true;
            if (e.RowIndex > -1)
            {
                sid = Convert.ToString(JC_DGV.Rows[e.RowIndex].Cells[0].Value);
                string sname = Convert.ToString(JC_DGV.Rows[e.RowIndex].Cells[1].Value);
            }
        }
        #region 删除用户奖惩信息
        private void JC_DelteTSB_Click(object sender, EventArgs e)
        { 
             
                if(!mark )
                //if (sid == "")
                {
                    MessageBox.Show("请选择要删除的用户！");
                }
                else
                {
                    try
                    {
                        if (DialogResult.OK == MessageBox.Show("确定要删除吗！", "提示", MessageBoxButtons.OKCancel, MessageBoxIcon.Information))
                        {
                            var JC_Desta = ddc.T_JiangCheng.Single(strid => strid.JC_ID == Convert.ToInt32(sid));//选择删除员工的信息
                            ddc.T_JiangCheng.DeleteOnSubmit(JC_Desta);
                            ddc.SubmitChanges();
                            MessageBox.Show("删除成功！");
                            mark = !mark;
                        }
                    }
                    catch
                    { 
                        
                    }
                       
            }
           this.SQLOPT();
        } 
        #endregion

        private void JC_SelectTSB_Click(object sender, EventArgs e)
        {
            JC_SelectJcInfo sji = new JC_SelectJcInfo();
            sji.ShowDialog();
        }
        /// <summary>
        /// 根据时间查询的开始时间点
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dateTimePicker1_ValueChanged(object sender, EventArgs e)
        {
            DateTime starttime =Convert.ToDateTime (dateTimePicker1.Value.ToShortDateString());//获得开始时间
            DateTime  endtime = Convert.ToDateTime (dateTimePicker2.Value.ToShortDateString ()) ;//获得结束时间
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["HRManagerSystem.Properties.Settings.HR_DBConnectionString"].ConnectionString);
            string SQL = "select * from V_StaffJC where V_StaffJC.JC_Time between '"+starttime+" ' and '"+endtime+"'";
            SqlDataAdapter sda = new SqlDataAdapter(SQL, con);
            DataTable dt = new DataTable();
            sda.Fill(dt);
            dt.Columns.Add("奖惩", typeof(string), "IIF([AwardORpunish]=true,'奖','罚')");
            JC_DGV.DataSource = dt;
        }
        /// <summary>
        /// 根据时间查询的最后时间点
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dateTimePicker2_ValueChanged(object sender, EventArgs e)
        {
            DateTime starttime = Convert.ToDateTime(dateTimePicker1.Value.ToShortDateString());//获得开始时间
            DateTime endtime = Convert.ToDateTime(dateTimePicker2.Value.ToShortDateString());//获得结束时间
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["HRManagerSystem.Properties.Settings.HR_DBConnectionString"].ConnectionString);
            string SQL = "select * from V_StaffJC where V_StaffJC.JC_Time between '" + starttime + " ' and '" + endtime + "'";
            SqlDataAdapter sda = new SqlDataAdapter(SQL, con);
            DataTable dt = new DataTable();
            sda.Fill(dt);
            dt.Columns.Add("奖惩", typeof(string), "IIF([AwardORpunish]=true,'奖','罚')");
            JC_DGV.DataSource = dt;
            
        }

        private void JC_QuiteTSB_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
