﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace HRManagerSystem.StaffManage
{
    public partial class AddStaffForm : Form
    {
        public AddStaffForm()
        {
            InitializeComponent();
        }
        DataDataContext ddc = new DataDataContext();//得到数据库
        T_StaffRecords sr = new T_StaffRecords();
        /// <summary>
        /// 加载相关信息
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void AddStaffForm_Load(object sender, EventArgs e)
        {
            cob_job.DataSource = ddc.T_Jobs.Select(se => new { se.Job_Name, se.Job_ID });
            cob_job.DisplayMember = "Job_Name";
            cob_job.ValueMember = "Job_ID";

            cob_nat.DataSource = ddc.T_Nation.Select(s => new { s.Nation_Name, s.Nation_ID });
            cob_nat.DisplayMember = "Nation_Name";
            cob_nat.ValueMember = "Nation_ID";
            cob_ty.DataSource = ddc.T_Type.Select(s1 => new { s1.Type_Name, s1.Type_ID });
            cob_ty.DisplayMember = "Type_Name";
            cob_ty.ValueMember = "Type_ID";
            cob_dep.DataSource = ddc.T_Department.Select(s2 => new { s2.Depart_Name, s2.Depart_ID });
            cob_dep.DisplayMember = "Depart_Name";
            cob_dep.ValueMember = "Depart_ID";
            cob_zc.DataSource = ddc.T_ZhiCheng.Select(s3 => new { s3.ZhiCheng_Name, s3.ZhiCheng_ID });
            cob_zc.DisplayMember = "ZhiCheng_Name";
            cob_zc.ValueMember = "ZhiCheng_ID";
            txt_id.Enabled = false;           
       }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {

        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void textBox13_TextChanged(object sender, EventArgs e)
        {

        }
        /// <summary>
        /// 重新添加时，清空相关记录
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            clear();              
        }
        void clear()
        {
            txt_addr.Text = "";
            cob_dep.SelectedIndex = 0;
            txt_edu.Text = "";
            txt_em.Text = "";
            txt_idnum.Text = "";
            cob_job.SelectedIndex = 0;
            txt_mob.Text = "";
            txt_name.Text = "";
            cob_nat.SelectedIndex = 0;
            txt_ph.Text = "";
            cob_sex.SelectedIndex = 0;
            cob_ty.SelectedIndex = 0;
            cob_zc.SelectedIndex = 0; 
        
        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox12_TextChanged(object sender, EventArgs e)
        {

        }
        /// <summary>
        /// 添加照片
        /// </summary>
         string str = "";
        private void pictureBox1_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.ShowDialog();
                str = openFileDialog1.FileName;
                pictureBox1.Image = Image.FromFile(str);
            }
            catch
            {
                MessageBox.Show("请选择正确路径");
            }
       
        }
        /// <summary>
        /// 添加照片
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.ShowDialog();
                str = openFileDialog1.FileName;
                pictureBox1.Image = Image.FromFile(str);
            }
            catch
            {
                MessageBox.Show("请选择正确照片路径！");
            }
        }
        /// <summary>
        /// 点击保存，存入数据库
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            try
            {                
                sr.Staff_Address = txt_addr.Text;             

                sr.Staff_DepartID = Convert.ToInt32(cob_dep.SelectedValue.ToString());
               
                sr.Staff_Education = txt_edu.Text;             
                sr.Staff_Email = txt_em.Text;              
              
                sr.Staff_IDNumber = txt_idnum.Text;               
                sr.Staff_JobID = Convert.ToInt32(cob_job.SelectedValue.ToString());               
                    sr.Staff_Mobile = txt_mob.Text;            
                            
                    sr.Staff_Name = txt_name.Text;               
               
                sr.Staff_NationID = Convert.ToInt32(cob_nat.SelectedValue.ToString());
                sr.Staff_Phone = txt_ph.Text;
               sr.Staff_Sex = cob_sex.Text == "男" ? true : false;               
                
                sr.Staff_TypeID = Convert.ToInt32(cob_ty.SelectedValue.ToString());
                sr.Staff_ZhiChengID = Convert.ToInt32(cob_zc.SelectedValue.ToString());
                //有照片就进行存入数据库
                if (File.Exists(str))
                {
                    string[] d = str.Split('\\');
                    string path = d.Last();
                    File.Copy(str, Application.StartupPath + "\\images\\" + path);
                    sr.Photo_Path = path;
                }
                ddc.T_StaffRecords.InsertOnSubmit(sr);
                ddc.SubmitChanges();
                MessageBox.Show("添加成功！");
                this.clear();
            }
            catch
            {
                MessageBox.Show("带*号的为必填项！"); 
            }            
         }

        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            MessageBox.Show("打印机不可用！");
        }    
   
    }
}
