/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.acra.ACRA;
import org.acra.ConfigurationInspector;
import org.acra.CrashReportDialog;
import org.acra.HttpUtils;
import org.acra.ReportingInteractionMode;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private static final String LOG_TAG = ACRA.LOG_TAG;
    private static final int MAX_SEND_REPORTS = 5;
    private static final String VERSION_NAME_KEY = "entry.0.single";
    private static final String PACKAGE_NAME_KEY = "entry.1.single";
    private static final String FILE_PATH_KEY = "entry.2.single";
    private static final String PHONE_MODEL_KEY = "entry.3.single";
    private static final String ANDROID_VERSION_KEY = "entry.4.single";
    private static final String BOARD_KEY = "entry.5.single";
    private static final String BRAND_KEY = "entry.6.single";
    private static final String DEVICE_KEY = "entry.7.single";
    private static final String BUILD_DISPLAY_KEY = "entry.8.single";
    private static final String FINGERPRINT_KEY = "entry.9.single";
    private static final String HOST_KEY = "entry.10.single";
    private static final String ID_KEY = "entry.11.single";
    private static final String MODEL_KEY = "entry.12.single";
    private static final String PRODUCT_KEY = "entry.13.single";
    private static final String TAGS_KEY = "entry.14.single";
    private static final String TIME_KEY = "entry.15.single";
    private static final String TYPE_KEY = "entry.16.single";
    private static final String USER_KEY = "entry.17.single";
    private static final String TOTAL_MEM_SIZE_KEY = "entry.18.single";
    private static final String AVAILABLE_MEM_SIZE_KEY = "entry.19.single";
    private static final String CUSTOM_DATA_KEY = "entry.20.single";
    private static final String STACK_TRACE_KEY = "entry.21.single";
    private static final String INITIAL_CONFIGURATION_KEY = "entry.22.single";
    private static final String CRASH_CONFIGURATION_KEY = "entry.23.single";
    private static final String DISPLAY_KEY = "entry.24.single";
    private static final String USER_COMMENT_KEY = "entry.25.single";
    private static final String USER_CRASH_DATE_KEY = "entry.26.single";
    private Properties mCrashProperties = new Properties();
    Map<String, String> mCustomParameters = new HashMap<String, String>();
    static String mUserComment = "";
    static final String IS_SILENT_KEY = "silent";
    static final String SILENT_SUFFIX = "-silent";
    static final String EXTRA_REPORT_FILE_NAME = "REPORT_FILE_NAME";
    private Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private static ErrorReporter mInstanceSingleton;
    private Context mContext;
    private String mInitialConfiguration;
    private ReportingInteractionMode mReportingInteractionMode = ReportingInteractionMode.SILENT;
    private Bundle mCrashResources = new Bundle();
    private static Uri mFormUri;

    void setFormUri(Uri formUri) {
        mFormUri = formUri;
    }

    @Deprecated
    public void addCustomData(String key, String value) {
        this.mCustomParameters.put(key, value);
    }

    public String putCustomData(String key, String value) {
        return this.mCustomParameters.put(key, value);
    }

    public String removeCustomData(String key) {
        return this.mCustomParameters.remove(key);
    }

    public String getCustomData(String key) {
        return this.mCustomParameters.get(key);
    }

    private String createCustomInfoString() {
        String CustomInfo = "";
        for (String CurrentKey : this.mCustomParameters.keySet()) {
            String CurrentVal = this.mCustomParameters.get(CurrentKey);
            CustomInfo = String.valueOf(CustomInfo) + CurrentKey + " = " + CurrentVal + "\n";
        }
        return CustomInfo;
    }

    public static ErrorReporter getInstance() {
        if (mInstanceSingleton == null) {
            mInstanceSingleton = new ErrorReporter();
        }
        return mInstanceSingleton;
    }

    public void init(Context context) {
        if (this.mDfltExceptionHandler == null) {
            this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(this);
            this.mContext = context;
            this.mInitialConfiguration = ConfigurationInspector.toString(this.mContext.getResources().getConfiguration());
        }
    }

    private static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    private static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    private void retrieveCrashData(Context context) {
        try {
            this.mCrashProperties.put(INITIAL_CONFIGURATION_KEY, this.mInitialConfiguration);
            Configuration crashConf = context.getResources().getConfiguration();
            this.mCrashProperties.put(CRASH_CONFIGURATION_KEY, ConfigurationInspector.toString(crashConf));
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            if (pi != null) {
                this.mCrashProperties.put(VERSION_NAME_KEY, pi.versionName != null ? "'" + pi.versionName : "not set");
            } else {
                this.mCrashProperties.put(PACKAGE_NAME_KEY, "Package info unavailable");
            }
            this.mCrashProperties.put(PACKAGE_NAME_KEY, context.getPackageName());
            this.mCrashProperties.put(PHONE_MODEL_KEY, Build.MODEL);
            this.mCrashProperties.put(ANDROID_VERSION_KEY, "'" + Build.VERSION.RELEASE);
            this.mCrashProperties.put(BOARD_KEY, Build.BOARD);
            this.mCrashProperties.put(BRAND_KEY, Build.BRAND);
            this.mCrashProperties.put(DEVICE_KEY, Build.DEVICE);
            this.mCrashProperties.put(BUILD_DISPLAY_KEY, Build.DISPLAY);
            this.mCrashProperties.put(FINGERPRINT_KEY, Build.FINGERPRINT);
            this.mCrashProperties.put(HOST_KEY, Build.HOST);
            this.mCrashProperties.put(ID_KEY, Build.ID);
            this.mCrashProperties.put(MODEL_KEY, Build.MODEL);
            this.mCrashProperties.put(PRODUCT_KEY, Build.PRODUCT);
            this.mCrashProperties.put(TAGS_KEY, Build.TAGS);
            this.mCrashProperties.put(TIME_KEY, "" + Build.TIME);
            this.mCrashProperties.put(TYPE_KEY, Build.TYPE);
            this.mCrashProperties.put(USER_KEY, Build.USER);
            this.mCrashProperties.put(TOTAL_MEM_SIZE_KEY, "" + ErrorReporter.getTotalInternalMemorySize());
            this.mCrashProperties.put(AVAILABLE_MEM_SIZE_KEY, "" + ErrorReporter.getAvailableInternalMemorySize());
            this.mCrashProperties.put(FILE_PATH_KEY, context.getFilesDir().getAbsolutePath());
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            this.mCrashProperties.put(DISPLAY_KEY, ErrorReporter.toString(display));
            Time curDate = new Time();
            curDate.setToNow();
            this.mCrashProperties.put(USER_CRASH_DATE_KEY, curDate.format3339(false));
            this.mCrashProperties.put(CUSTOM_DATA_KEY, this.createCustomInfoString());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Error while retrieving crash data", (Throwable)e);
        }
    }

    private static String toString(Display display) {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        StringBuilder result = new StringBuilder();
        result.append("width=").append(display.getWidth()).append('\n').append("height=").append(display.getHeight()).append('\n').append("pixelFormat=").append(display.getPixelFormat()).append('\n').append("refreshRate=").append(display.getRefreshRate()).append("fps").append('\n').append("metrics.density=x").append(metrics.density).append('\n').append("metrics.scaledDensity=x").append(metrics.scaledDensity).append('\n').append("metrics.widthPixels=").append(metrics.widthPixels).append('\n').append("metrics.heightPixels=").append(metrics.heightPixels).append('\n').append("metrics.xdpi=").append(metrics.xdpi).append('\n').append("metrics.ydpi=").append(metrics.ydpi);
        return result.toString();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        ReportsSenderWorker worker = this.handleException(e);
        if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e1) {
                Log.e((String)LOG_TAG, (String)"Error : ", (Throwable)e1);
            }
        }
        if (worker != null) {
            while (worker.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Log.e((String)LOG_TAG, (String)"Error : ", (Throwable)e1);
                }
            }
        }
        if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT) {
            this.mDfltExceptionHandler.uncaughtException(t, e);
        } else {
            CharSequence appName = "Application";
            try {
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    appName = pm.getApplicationInfo(this.mContext.getPackageName(), 0).loadLabel(this.mContext.getPackageManager());
                    Log.e((String)LOG_TAG, (String)(appName + " fatal error : " + e.getMessage()), (Throwable)e);
                }
                catch (PackageManager.NameNotFoundException e2) {
                    Log.e((String)LOG_TAG, (String)"Error : ", (Throwable)e2);
                    Process.killProcess((int)Process.myPid());
                    System.exit(10);
                }
            }
            finally {
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            }
        }
    }

    ReportsSenderWorker handleException(Throwable e, ReportingInteractionMode reportingInteractionMode) {
        boolean sendOnlySilentReports = false;
        if (reportingInteractionMode == null) {
            reportingInteractionMode = this.mReportingInteractionMode;
        } else if (reportingInteractionMode == ReportingInteractionMode.SILENT && this.mReportingInteractionMode != ReportingInteractionMode.SILENT) {
            sendOnlySilentReports = true;
        }
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        if (reportingInteractionMode == ReportingInteractionMode.TOAST) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    Toast.makeText((Context)ErrorReporter.this.mContext, (int)ErrorReporter.this.mCrashResources.getInt("RES_TOAST_TEXT"), (int)1).show();
                    Looper.loop();
                }
            }.start();
        }
        this.retrieveCrashData(this.mContext);
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        Log.getStackTraceString((Throwable)e);
        Throwable cause = e.getCause();
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        this.mCrashProperties.put(STACK_TRACE_KEY, ((Object)result).toString());
        printWriter.close();
        String reportFileName = this.saveCrashReportFile();
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST) {
            ReportsSenderWorker wk = new ReportsSenderWorker(sendOnlySilentReports);
            wk.start();
            return wk;
        }
        if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            this.notifySendReport(reportFileName);
        }
        return null;
    }

    public ReportsSenderWorker handleException(Throwable e) {
        return this.handleException(e, this.mReportingInteractionMode);
    }

    public ReportsSenderWorker handleSilentException(Throwable e) {
        this.mCrashProperties.put(IS_SILENT_KEY, "true");
        return this.handleException(e, ReportingInteractionMode.SILENT);
    }

    void notifySendReport(String reportFileName) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        int icon = 17301624;
        if (this.mCrashResources.containsKey("RES_NOTIF_ICON")) {
            icon = this.mCrashResources.getInt("RES_NOTIF_ICON");
        }
        CharSequence tickerText = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TICKER_TEXT"));
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, tickerText, when);
        CharSequence contentTitle = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TITLE"));
        CharSequence contentText = this.mContext.getText(this.mCrashResources.getInt("RES_NOTIF_TEXT"));
        Intent notificationIntent = new Intent(this.mContext, CrashReportDialog.class);
        notificationIntent.putExtra(EXTRA_REPORT_FILE_NAME, reportFileName);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)notificationIntent, (int)0);
        notification.setLatestEventInfo(this.mContext, contentTitle, contentText, contentIntent);
        notificationManager.notify(666, notification);
    }

    private static void sendCrashReport(Context context, Properties errorContent) throws UnsupportedEncodingException, IOException, KeyManagementException, NoSuchAlgorithmException {
        errorContent.put("pageNumber", "0");
        errorContent.put("backupCache", "");
        errorContent.put("submit", "Envoyer");
        URL reportUrl = new URL(mFormUri.toString());
        Log.d((String)LOG_TAG, (String)("Connect to " + reportUrl.toString()));
        HttpUtils.doPost(errorContent, reportUrl);
    }

    private String saveCrashReportFile() {
        try {
            Log.d((String)LOG_TAG, (String)"Writing crash report file.");
            Time now = new Time();
            now.setToNow();
            long timestamp = now.toMillis(false);
            String isSilent = this.mCrashProperties.getProperty(IS_SILENT_KEY);
            String fileName = timestamp + (isSilent != null ? SILENT_SUFFIX : "") + ".stacktrace";
            FileOutputStream trace = this.mContext.openFileOutput(fileName, 0);
            if (this.storeToXML()) {
                this.mCrashProperties.storeToXML(trace, "");
            } else {
                this.mCrashProperties.store(trace, "");
            }
            trace.close();
            return fileName;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"An error occured while writing the report file...", (Throwable)e);
            return null;
        }
    }

    String[] getCrashReportFilesList() {
        File dir = this.mContext.getFilesDir();
        if (dir != null) {
            Log.d((String)LOG_TAG, (String)("Looking for error files in " + dir.getAbsolutePath()));
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".stacktrace");
                }
            };
            return dir.list(filter);
        }
        Log.w((String)LOG_TAG, (String)"Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
        return new String[0];
    }

    void checkAndSendReports(Context context, String userCommentReportFileName, boolean sendOnlySilentReports) {
        try {
            try {
                String[] reportFilesList = this.getCrashReportFilesList();
                TreeSet<String> sortedFiles = new TreeSet<String>();
                sortedFiles.addAll(Arrays.asList(reportFilesList));
                if (reportFilesList != null && reportFilesList.length > 0) {
                    Properties previousCrashReport = new Properties();
                    int curIndex = 0;
                    boolean commentedReportFound = false;
                    for (String curFileName : sortedFiles) {
                        if (sendOnlySilentReports && (!sendOnlySilentReports || !this.isSilent(curFileName))) continue;
                        if (curIndex < 5) {
                            FileInputStream input = context.openFileInput(curFileName);
                            if (this.storeToXML()) {
                                previousCrashReport.loadFromXML(input);
                            } else {
                                previousCrashReport.load(input);
                            }
                            input.close();
                            if (!commentedReportFound && (curFileName.equals(userCommentReportFileName) || curIndex == sortedFiles.size() - 1 && !"".equals(mUserComment))) {
                                String custom = previousCrashReport.getProperty(CUSTOM_DATA_KEY);
                                custom = custom == null ? "" : String.valueOf(custom) + "\n";
                                previousCrashReport.put(USER_COMMENT_KEY, mUserComment);
                                mUserComment = "";
                            }
                            ErrorReporter.sendCrashReport(context, previousCrashReport);
                            File curFile = new File(context.getFilesDir(), curFileName);
                            curFile.delete();
                        }
                        ++curIndex;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                mUserComment = "";
            }
        }
        finally {
            mUserComment = "";
        }
    }

    private boolean storeToXML() {
        return ErrorReporter.getAPILevel() < 5;
    }

    void setReportingInteractionMode(ReportingInteractionMode reportingInteractionMode) {
        this.mReportingInteractionMode = reportingInteractionMode;
    }

    public void checkReportsOnApplicationStart() {
        String[] filesList = this.getCrashReportFilesList();
        if (filesList != null && filesList.length > 0) {
            boolean onlySilentReports = this.containsOnlySilentReports(filesList);
            if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT || this.mReportingInteractionMode == ReportingInteractionMode.TOAST || this.mReportingInteractionMode == ReportingInteractionMode.NOTIFICATION && onlySilentReports) {
                if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST && !onlySilentReports) {
                    Toast.makeText((Context)this.mContext, (int)this.mCrashResources.getInt("RES_TOAST_TEXT"), (int)1).show();
                }
                new ReportsSenderWorker().start();
            } else if (this.mReportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
                ErrorReporter.getInstance().notifySendReport(this.getLatestNonSilentReport(filesList));
            }
        }
    }

    private String getLatestNonSilentReport(String[] filesList) {
        if (filesList != null && filesList.length > 0) {
            int i = filesList.length - 1;
            while (i >= 0) {
                if (!this.isSilent(filesList[i])) {
                    return filesList[i];
                }
                --i;
            }
            return filesList[filesList.length - 1];
        }
        return null;
    }

    public void deletePendingReports() {
        this.deletePendingReports(true, true);
    }

    public void deletePendingSilentReports() {
        this.deletePendingReports(true, false);
    }

    public void deletePendingNonSilentReports() {
        this.deletePendingReports(false, true);
    }

    private void deletePendingReports(boolean deleteSilentReports, boolean deleteNonSilentReports) {
        String[] filesList = this.getCrashReportFilesList();
        if (filesList != null) {
            String[] stringArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (this.isSilent(fileName) && deleteSilentReports || !this.isSilent(fileName) && deleteNonSilentReports) {
                    new File(this.mContext.getFilesDir(), fileName).delete();
                }
                ++n2;
            }
        }
    }

    void setCrashResources(Bundle crashResources) {
        this.mCrashResources = crashResources;
    }

    public void disable() {
        if (this.mContext != null) {
            Log.d((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + this.mContext.getPackageName()));
        } else {
            Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled.");
        }
        if (this.mDfltExceptionHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(this.mDfltExceptionHandler);
        }
    }

    private boolean containsOnlySilentReports(String[] reportFileNames) {
        String[] stringArray = reportFileNames;
        int n = reportFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reportFileName = stringArray[n2];
            if (!this.isSilent(reportFileName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSilent(String reportFileName) {
        return reportFileName.contains(SILENT_SUFFIX);
    }

    public void setUserComment(String userComment) {
        mUserComment = userComment;
    }

    private static int getAPILevel() {
        int apiLevel;
        try {
            Field SDK_INT = Build.VERSION.class.getField("SDK_INT");
            apiLevel = SDK_INT.getInt(null);
        }
        catch (SecurityException e) {
            apiLevel = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (NoSuchFieldException e) {
            apiLevel = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (IllegalArgumentException e) {
            apiLevel = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (IllegalAccessException e) {
            apiLevel = Integer.parseInt(Build.VERSION.SDK);
        }
        return apiLevel;
    }

    final class ReportsSenderWorker
    extends Thread {
        private String mReportFileName = null;
        private boolean mSendOnlySilentReports = false;

        public ReportsSenderWorker(boolean sendOnlySilentReports) {
            this.mSendOnlySilentReports = sendOnlySilentReports;
        }

        public ReportsSenderWorker() {
        }

        @Override
        public void run() {
            ErrorReporter.this.checkAndSendReports(ErrorReporter.this.mContext, this.mReportFileName, this.mSendOnlySilentReports);
        }

        void setCommentReportFileName(String reportFileName) {
            this.mReportFileName = reportFileName;
        }
    }
}

