/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sdk.api.message;

import android.content.Context;
import android.os.Bundle;
import com.weibo.sdk.android.Oauth2AccessToken;
import com.weibo.sdk.android.WeiboParameters;
import com.weibo.sdk.android.api.WeiboAPI;
import com.weibo.sdk.android.net.RequestListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class InviteApi
extends WeiboAPI {
    public static final String KEY_TEXT = "text";
    public static final String KEY_URL = "url";
    public static final String KEY_INVITE_LOGO = "invite_logo";
    private final String INVITE_URL = "https://m.api.weibo.com/2/messages/invite.json";
    private String mAccessToken;
    private Bundle mData;
    private Context mContext;
    private String mUid;
    private String mContent;

    public InviteApi(Oauth2AccessToken oauth2AccessToken) {
        super(oauth2AccessToken);
    }

    public boolean sendInvite(Context context, Bundle content, String uid, RequestListener listener) {
        this.mContext = context;
        this.mData = content;
        this.mUid = uid;
        if (!this.encodeInvteContent()) {
            return false;
        }
        WeiboParameters params = new WeiboParameters();
        params.add("uid", this.mUid);
        params.add("data", this.mContent);
        this.request("https://m.api.weibo.com/2/messages/invite.json", params, "POST", listener);
        return true;
    }

    private boolean encodeInvteContent() {
        if (this.mData == null) {
            return false;
        }
        if (this.mData.containsKey(KEY_TEXT)) {
            String content = this.parseBundle2Json();
            try {
                this.mContent = URLEncoder.encode(content, "UTF-8");
                return true;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private String parseBundle2Json() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"").append(KEY_TEXT).append("\":").append("\"").append(this.mData.getString(KEY_TEXT)).append("\"");
        if (this.mData.containsKey(KEY_URL)) {
            stringBuilder.append(",\"").append(KEY_URL).append("\":").append("\"").append(this.mData.getString(KEY_URL)).append("\"");
        }
        if (this.mData.containsKey(KEY_INVITE_LOGO)) {
            stringBuilder.append(",\"").append(KEY_INVITE_LOGO).append("\":").append("\"").append(this.mData.getString(KEY_INVITE_LOGO)).append("\"");
        } else {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }
}

