/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.sina.weibo.sdk.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public abstract class BaseMediaObject
implements Parcelable {
    public static final int COMMAND_TEXT = 1;
    public static final int COMMAND_IMAGE = 2;
    public static final int COMMAND_MUSIC = 3;
    public static final int COMMAND_VIDEO = 4;
    public static final int COMMAND_WEBPAGE = 5;
    public static final int COMMAND_VOICE = 6;
    public static final int COMMAND_CMD = 7;
    public String actionUrl;
    public String schema;
    public String identify;
    public String title;
    public String description;
    public byte[] thumbData;

    public abstract int getObjType();

    public BaseMediaObject() {
    }

    public BaseMediaObject(Parcel in) {
        this.actionUrl = in.readString();
        this.schema = in.readString();
        this.identify = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.thumbData = in.createByteArray();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e("Weibo.BaseMediaObject", "put thumb failed");
            return;
        }
    }

    boolean checkArgs() {
        if (this.actionUrl == null || this.actionUrl.length() > 512) {
            Log.e("Weibo.BaseMediaObject", "checkArgs fail, actionUrl is invalid");
            return false;
        }
        if (this.identify == null || this.identify.length() > 512) {
            Log.e("Weibo.BaseMediaObject", "checkArgs fail, identify is invalid");
            return false;
        }
        if (this.thumbData == null || this.thumbData.length > 32768) {
            Log.e("Weibo.BaseMediaObject", "checkArgs fail, thumbData is invalid,size is " + this.thumbData.length + "! more then 32768.");
            return false;
        }
        if (this.title == null || this.title.length() > 512) {
            Log.e("Weibo.BaseMediaObject", "checkArgs fail, title is invalid");
            return false;
        }
        if (this.description == null || this.description.length() > 1024) {
            Log.e("Weibo.BaseMediaObject", "checkArgs fail, description is invalid");
            return false;
        }
        return true;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.actionUrl);
        dest.writeString(this.schema);
        dest.writeString(this.identify);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeByteArray(this.thumbData);
    }

    protected abstract BaseMediaObject toExtraMediaObject(String var1);

    protected abstract String toExtraMediaString();
}

