/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.content.Context;
import com.sina.weibo.sdk.api.ApiUtils;
import com.sina.weibo.sdk.api.CmdObject;
import com.sina.weibo.sdk.api.IVersionCheckHandler;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WeiboMessage;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.log.Log;

public class VersionCheckHandler
implements IVersionCheckHandler {
    private static final String TAG = "VersionCheckHandler";
    private String mPackageName;

    public VersionCheckHandler(String packageName) {
        this.mPackageName = packageName;
    }

    public VersionCheckHandler() {
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    @Override
    public boolean check(Context context, WeiboMessage message) {
        Log.d(TAG, "check WeiboMessage package : " + this.mPackageName);
        if (this.mPackageName == null || this.mPackageName.length() == 0) {
            return false;
        }
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfoByPackage(context, this.mPackageName);
        if (winfo == null) {
            return false;
        }
        Log.d(TAG, "check WeiboMessage WeiboInfo supportApi : " + winfo.supportApi);
        if (winfo.supportApi < 10351 && message.mediaObject != null && message.mediaObject instanceof VoiceObject) {
            message.mediaObject = null;
        }
        if (winfo.supportApi < 10352 && message.mediaObject != null && message.mediaObject instanceof CmdObject) {
            message.mediaObject = null;
        }
        return true;
    }

    @Override
    public boolean check(Context context, WeiboMultiMessage message) {
        Log.d(TAG, "check WeiboMultiMessage package : " + this.mPackageName);
        if (this.mPackageName == null || this.mPackageName.length() == 0) {
            return false;
        }
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfoByPackage(context, this.mPackageName);
        if (winfo == null) {
            return false;
        }
        Log.d(TAG, "check WeiboMultiMessage WeiboInfo supportApi : " + winfo.supportApi);
        if (winfo.supportApi < 10351) {
            return false;
        }
        if (winfo.supportApi < 10352 && message.mediaObject != null && message.mediaObject instanceof CmdObject) {
            message.mediaObject = null;
        }
        return true;
    }
}

