/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ApiUtils;
import com.sina.weibo.sdk.api.BaseRequest;
import com.sina.weibo.sdk.api.BaseResponse;
import com.sina.weibo.sdk.api.IWeiboAPI;
import com.sina.weibo.sdk.api.IWeiboDownloadListener;
import com.sina.weibo.sdk.api.IWeiboHandler;
import com.sina.weibo.sdk.api.ProvideMessageForWeiboRequest;
import com.sina.weibo.sdk.api.SendMessageToWeiboResponse;
import com.sina.weibo.sdk.api.VersionCheckHandler;
import com.sina.weibo.sdk.handler.ActivityHandler;
import com.sina.weibo.sdk.handler.ReceiverHandler;
import com.sina.weibo.sdk.log.Log;
import com.sina.weibo.sdk.utils.Util;

public class WeiboApiImpl
implements IWeiboAPI {
    private static final String TAG = "WeiboApiImpl";
    private Context mContext;
    private String mAppKey;
    private boolean mDownWeibo = true;
    private IWeiboDownloadListener mDownloadListener;

    public WeiboApiImpl(Context context, String appKey, boolean isDownWeibo) {
        this.mContext = context.getApplicationContext();
        this.mAppKey = appKey;
        this.mDownWeibo = isDownWeibo;
    }

    @Override
    public boolean registerApp() {
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(this.mContext);
        if (winfo == null) {
            Log.e(TAG, "registerApp() failed winfo == null");
            return false;
        }
        if (!ApiUtils.isWeiboAppSupportAPI(winfo.supportApi)) {
            Log.e(TAG, "registerApp() failed not isWeiboAppSupportAPI");
            return false;
        }
        String packageName = winfo.packageName;
        if (this.mAppKey == null || this.mAppKey.length() == 0) {
            Log.e(TAG, "registerApp() failed appkey is null");
            return false;
        }
        Log.d(TAG, "registerApp() packageName : " + packageName);
        ReceiverHandler.register(this.mContext, this.mAppKey);
        return true;
    }

    @Override
    public boolean isWeiboAppInstalled() {
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(this.mContext);
        if (winfo == null) {
            Log.e(TAG, "isWeiboAppInstalled() faild winfo is null");
            return false;
        }
        return true;
    }

    @Override
    public boolean responseListener(Intent intent, IWeiboHandler.Response handler) {
        String appPackage = intent.getStringExtra("_weibo_appPackage");
        if (appPackage == null) {
            Log.e(TAG, "responseListener() faild appPackage is null");
            return false;
        }
        if (!(handler instanceof Activity)) {
            Log.e(TAG, "responseListener() faild handler is not Activity");
            return false;
        }
        Activity act = (Activity)handler;
        String callPkg = act.getCallingPackage();
        Log.d(TAG, "responseListener() callPkg : " + callPkg);
        if (intent.getStringExtra("_weibo_transaction") == null) {
            Log.e(TAG, "responseListener() faild intent TRAN is null");
            return false;
        }
        if (!ApiUtils.validateSign(this.mContext, appPackage)) {
            Log.e(TAG, "responseListener() faild appPackage validateSign faild");
            return false;
        }
        SendMessageToWeiboResponse data = new SendMessageToWeiboResponse(intent.getExtras());
        handler.onResponse(data);
        return true;
    }

    @Override
    public boolean requestListener(Intent intent, IWeiboHandler.Request handler) {
        String appPackage = intent.getStringExtra("_weibo_appPackage");
        if (appPackage == null) {
            Log.e(TAG, "requestListener() faild appPackage validateSign faild");
            return false;
        }
        if (intent.getStringExtra("_weibo_transaction") == null) {
            Log.e(TAG, "requestListener() faild intent TRAN is null");
            return false;
        }
        if (!ApiUtils.validateSign(this.mContext, appPackage)) {
            Log.e(TAG, "requestListener() faild appPackage validateSign faild");
            return false;
        }
        ProvideMessageForWeiboRequest data = new ProvideMessageForWeiboRequest(intent.getExtras());
        handler.onRequest(data);
        return true;
    }

    @Override
    public void registerWeiboDownloadListener(IWeiboDownloadListener listener) {
        this.mDownloadListener = listener;
    }

    @Override
    public boolean isWeiboAppSupportAPI() {
        return ApiUtils.isWeiboAppSupportAPI(this.getWeiboAppSupportAPI());
    }

    @Override
    public int getWeiboAppSupportAPI() {
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(this.mContext);
        if (winfo == null) {
            Log.e(TAG, "getWeiboAppSupportAPI() faild winfo is null");
            return -1;
        }
        return winfo.supportApi;
    }

    @Override
    public boolean startWeibo() {
        String packageName;
        block4: {
            ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(this.mContext);
            if (winfo == null) {
                Log.e(TAG, "startWeibo() faild winfo is null");
                return false;
            }
            try {
                packageName = winfo.packageName;
                Log.d(TAG, "startWeibo() packageName : " + packageName);
                if (!TextUtils.isEmpty((CharSequence)packageName)) break block4;
                Log.e(TAG, "startWeibo() faild packageName is null");
                return false;
            }
            catch (Exception e) {
                Log.e(TAG, e.getMessage(), e);
                return false;
            }
        }
        this.mContext.startActivity(this.mContext.getPackageManager().getLaunchIntentForPackage(packageName));
        return true;
    }

    @Override
    public boolean sendRequest(Activity act, BaseRequest request) {
        if (act == null || request == null) {
            Log.e(TAG, "sendRequest faild act == null or request == null");
            return false;
        }
        ApiUtils.WeiboInfo winfo = ApiUtils.queryWeiboInfo(this.mContext);
        if (winfo == null) {
            Log.e(TAG, "sendRequest faild winfo is null");
            if (this.mDownWeibo) {
                Util.createConfirmDialog(act, this.mDownloadListener);
            }
            return false;
        }
        if (!ApiUtils.isWeiboAppSupportAPI(winfo.supportApi)) {
            Log.e(TAG, "sendRequest faild isWeiboAppSupportAPI");
            return false;
        }
        VersionCheckHandler checkHandler = new VersionCheckHandler(winfo.packageName);
        if (!request.check(this.mContext, checkHandler)) {
            Log.e(TAG, "sendRequest faild request check faild");
            return false;
        }
        Bundle data = new Bundle();
        request.toBundle(data);
        return ActivityHandler.sendToWeibo(act, winfo.packageName, this.mAppKey, data);
    }

    @Override
    public boolean sendResponse(BaseResponse response) {
        if (response == null) {
            Log.e(TAG, "sendResponse failed response null");
            return false;
        }
        if (!response.check(this.mContext, new VersionCheckHandler())) {
            Log.e(TAG, "sendResponse checkArgs fail");
            return false;
        }
        Bundle data = new Bundle();
        response.toBundle(data);
        return ReceiverHandler.sendToWeibo(this.mContext, this.mAppKey, data, response.reqPackageName);
    }
}

