/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.handler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.log.Log;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Util;

public class ReceiverHandler {
    public static void sendBroadcast(Context context, String action, String key, Bundle data, String packageName) {
        String permission = "com.sina.weibo.permission.WEIBO_SDK_PERMISSION";
        Intent intent = new Intent(action);
        if (data != null) {
            intent.putExtras(data);
        }
        String appPackage = context.getPackageName();
        intent.putExtra("_weibo_sdkVersion", 22);
        intent.putExtra("_weibo_appPackage", appPackage);
        intent.putExtra("_weibo_appKey", key);
        intent.putExtra("_weibo_flag", 538116905);
        intent.putExtra("_weibo_sign", MD5.hexdigest(Util.getSign(context, appPackage)));
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        context.sendBroadcast(intent, permission);
        Log.d("ReceiverHandler", "send message, intent=" + action + ", appPackage=" + appPackage);
    }

    public static void register(Context context, String content) {
        ReceiverHandler.sendBroadcast(context, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_REGISTER", content, null, null);
    }

    public static boolean sendToWeibo(Context context, String mAppKey, Bundle data, String packageName) {
        ReceiverHandler.sendBroadcast(context, "com.sina.weibo.sdk.Intent.ACTION_WEIBO_RESPONSE", mAppKey, data, packageName);
        return true;
    }
}

