/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.sdk.view;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Button;
import com.weibo.sdk.android.Weibo;
import com.weibo.sdk.android.WeiboAuthListener;
import com.weibo.sdk.android.sso.SsoHandler;

public class LoginButton
extends Button {
    private SsoHandler mSsoHandler;
    private Weibo mWeiboAuth;
    private Context mContext;
    private Activity mCurrentActivity;
    private WeiboAuthListener mListener = null;

    public LoginButton(Context context) {
        super(context);
        this.mContext = context;
        this.initButton();
    }

    public LoginButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initButton();
    }

    public LoginButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.initButton();
    }

    private void initButton() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginButton.this.mWeiboAuth = Weibo.getInstance("2045436852", "http://www.sina.com", "email,direct_messages_read,direct_messages_write,friendships_groups_read,friendships_groups_write,statuses_to_me_read,follow_app_official_microblog,invitation_write");
                LoginButton.this.mSsoHandler = new SsoHandler(LoginButton.this.mCurrentActivity, LoginButton.this.mWeiboAuth);
                LoginButton.this.mSsoHandler.authorize(LoginButton.this.mListener);
            }
        });
    }

    public void setAuthListener(WeiboAuthListener listener) {
        this.mListener = listener;
    }

    public void setCurrentActivity(Activity activity) {
        this.mCurrentActivity = activity;
    }

    public Activity getCurrentActivity() {
        return this.mCurrentActivity;
    }

    public SsoHandler getSsoHandler() {
        return this.mSsoHandler;
    }
}

