package com.codeim.youliao;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;

import com.codeim.youliao.data.Tweet;
import com.codeim.youliao.db.StatusTable;
import com.codeim.youliao.fanfou.Status;
import com.codeim.youliao.http.HttpException;
import com.codeim.youliao.ui.base.BrowseCursorBaseActivity;
import com.codeim.youliao.ui.module.NavBar;
import com.codeim.youliao.R;

/**
 * 随便看看
 * 
 * @author jmx
 * 
 */
public class BrowseActivity extends BrowseCursorBaseActivity {
	private static final String TAG = "BrowseActivity";
	
	private NavBar mNavBar;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		Log.d(TAG, "Browse _onCreate");
		super.onCreate(savedInstanceState);
		//mNavbar.setHeaderTitle(getActivityTitle());
		mNavBar = new NavBar(NavBar.HEADER_STYLE_BACK, this);
		mNavBar.setHeaderTitle("随便看看");
		getTweetList().removeFooterView(mListFooter); // 随便看看没有获取更多功能
	}

	@Override
	protected String getActivityTitle() {
		return getResources().getString(R.string.page_title_browse);
	}

	@SuppressWarnings("deprecation")
	@Override
	public int addMessages(ArrayList<Tweet> tweets, boolean isUnread) {
	
	    //先删除sqlite已经存在的tweet，因为重复插入同一条tweet在sqlite会出错.
		for (int i = tweets.size() - 1; i >= 0; i--) {
			Tweet tweet = tweets.get(i);
			if (getDb().isExists(tweet.id, getUserId(), StatusTable.TYPE_BROWSE)) {
			    getDb().deleteTweet(tweet.id, getUserId(), StatusTable.TYPE_BROWSE);
			}
		}

		return getDb().putTweets(tweets, getUserId(), StatusTable.TYPE_BROWSE, isUnread);
	}

	@Override
	public String fetchMaxId() {
		return getDb().fetchMaxTweetId(getUserId(), StatusTable.TYPE_BROWSE);
	}
	
	@SuppressWarnings("deprecation")
	@Override
	protected Cursor fetchMessages() {
		return getDb().fetchAllTweets(getUserId(), StatusTable.TYPE_BROWSE);
	}

	@Override
	public List<Status> getMessageSinceId(String maxId) throws HttpException {
		return getApi().getPublicTimeline();
	}

	@Override
	protected void markAllRead() {
		getDb().markAllTweetsRead(getUserId(), StatusTable.TYPE_BROWSE);
	}

	@Override
	public String fetchMinId() {
		// 随便看看没有获取更多的功能
		return null;
	}

	@Override
	public List<Status> getMoreMessageFromId(String minId) throws HttpException {
		// 随便看看没有获取更多的功能
		return null;
	}

	@Override
	public int getDatabaseType() {
		return StatusTable.TYPE_BROWSE;
	}

	@Override
	public String getUserId() {
		return TwitterApplication.getMyselfId(false);
	}
}
