/*
 * Copyright (C) 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codeim.youliao;

import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;

import com.codeim.youliao.fanfou.Paging;
import com.codeim.youliao.fanfou.Status;
import com.codeim.youliao.http.HttpException;
import com.codeim.youliao.task.GenericTask;
// import com.codeim.youliao.task.TaskAdapter;
// import com.codeim.youliao.task.TaskListener;
// import com.codeim.youliao.task.TaskParams;
// import com.codeim.youliao.task.TaskResult;
// import com.codeim.youliao.task.TweetCommonTask;
import com.codeim.youliao.ui.base.TwitterArrayBaseActivity;
import com.codeim.youliao.ui.module.NavBar;

public class CategoryActivity extends TwitterArrayBaseActivity {
    private static final String TAG = "CategoryActivity";
	
	private static final String LAUNCH_ACTION = "com.codeim.youliao.TWEETS";
	private static final String CATEGORY = "category";
	private NavBar mNavBar;
	protected GenericTask mDeleteTask;
	
	private int mCategory;
	private String [] catetegoryName = new String[] {"情感天地", "轻松搞笑", "我唱你听", "有问有答", "体育播报", 
	        "女性密语", "周边推荐", "真话冒险", /*"性感话题"*/ "故土乡音" };  // 性感话题 改为故土乡音
	
	/*
	private TaskListener mDeleteTaskListener = new TaskAdapter() {

		@Override
		public String getName() {
			return "DeleteTask";
		}

		@Override
		public void onPostExecute(GenericTask task, TaskResult result) {
			if (result == TaskResult.AUTH_ERROR) {
				logout();
			} else if (result == TaskResult.OK) {
				onDeleteSuccess();
			} else if (result == TaskResult.IO_ERROR) {
				onDeleteFailure();
			}
		}
	};
	*/
	
	public static Intent createIntent(int category) {
		Intent intent = new Intent(LAUNCH_ACTION);
		intent.putExtra(CATEGORY, category);
		return intent;
	}
	
	@Override
	protected boolean _onCreate(Bundle savedInstanceState) {
		Intent intent = getIntent();
		Bundle extras = intent.getExtras();
	    if (extras != null) {
			mCategory = extras.getInt(CATEGORY);
		}
		if (super._onCreate(savedInstanceState)) {
	        mNameType = "category" + mCategory + "_";
			mNavBar = new NavBar(NavBar.HEADER_STYLE_WRITE, this);
			mNavBar.setCategory(mCategory);
			mNavBar.setHeaderTitle(catetegoryName[mCategory-1]);
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	protected void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();

		if (mDeleteTask != null && mDeleteTask.getStatus() == GenericTask.Status.RUNNING) {
			mDeleteTask.cancel(true);
		}
	}
	
	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		if (mDeleteTask != null && mDeleteTask.getStatus() == GenericTask.Status.RUNNING) {
			outState.putBoolean(SIS_RUNNING_KEY, true);
		}
	}
	
	// Menu.
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		return super.onCreateOptionsMenu(menu);
	}
	
	@Override
	public int getCategory() {
		return mCategory;
	}
	
	@Override
	public List<Status> getCategorySinceId(String minId, int category) throws HttpException {
		if (minId != null) {
			return getApi().getCategory(new Paging(minId), category);
		} else {
			return getApi().getCategory(category);
		}
	}
	
	@Override
	public List<Status> getMoreCategoryFromId(String maxId, int category) throws HttpException {
		Paging paging = new Paging(1, 20);
		paging.setMaxId(maxId);
		return getApi().getCategory(paging, category);
	}
	
	public void onDeleteFailure() {
		Log.e(TAG, "Delete failed");
	}

	public void onDeleteSuccess() {
		mTweetAdapter.refresh();
	}
	
	/*
	private void doDelete(String id) {

		if (mDeleteTask != null && mDeleteTask.getStatus() == GenericTask.Status.RUNNING) {
			return;
		} else {
			mDeleteTask = new TweetCommonTask.DeleteTask(this);
			mDeleteTask.setListener(mDeleteTaskListener);

			TaskParams params = new TaskParams();
			params.put("id", id);
			mDeleteTask.execute(params);
		}
	}
	*/
	
	@Override
	public String getUserId() {
		return TwitterApplication.getMyselfId(false);
	}
	
    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
	    Log.d("TwitterActivity", "in onKeyDown");
        return false;
    }
}