package com.codeim.youliao;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.widget.RelativeLayout;

public class ChannelActivity extends Activity implements OnClickListener {
	
	private static final String TAG = "ChannelActivity";
	protected static final int REQUEST_CODE_LAUNCH_ACTIVITY = 0;

    private RelativeLayout mHotLayoutBtn;
	private RelativeLayout mFollowLayoutBtn;
	
	private RelativeLayout mCategoryLoveLayoutBtn;  // 1
	private RelativeLayout mCategoryJokeLayoutBtn;  // 2
	private RelativeLayout mCategorySingLayoutBtn;  // 3
	private RelativeLayout mCategoryAskLayoutBtn;  // 4
	private RelativeLayout mCategorySportsLayoutBtn;  // 5
	private RelativeLayout mCategoryLadyLayoutBtn;  // 6
	private RelativeLayout mCategoryNearbyLayoutBtn;  // 7
	private RelativeLayout mCategoryTruthLayoutBtn;  // 8
	// private RelativeLayout mCategorySexLayoutBtn;  // 9
	private RelativeLayout mCategoryLocalismLayoutBtn; // 9
	
	@Override 
	protected void onCreate(Bundle savedInstanceState) {
		Log.d(TAG, "onCreate");
		
	    super.onCreate(savedInstanceState);
		setContentView(R.layout.channel_group);
		
		mHotLayoutBtn = (RelativeLayout) findViewById(R.id.hot_btn_layout);
		mHotLayoutBtn.setOnClickListener(this);
		
		mFollowLayoutBtn = (RelativeLayout) findViewById(R.id.follow_btn_layout);
		mFollowLayoutBtn.setOnClickListener(this);
		
		mCategoryLoveLayoutBtn = (RelativeLayout) findViewById(R.id.love_btn_layout);
		mCategoryLoveLayoutBtn.setOnClickListener(this);
		
		mCategoryJokeLayoutBtn = (RelativeLayout) findViewById(R.id.joke_btn_layout);
		mCategoryJokeLayoutBtn.setOnClickListener(this);
		
		mCategorySingLayoutBtn = (RelativeLayout) findViewById(R.id.sing_btn_layout);
		mCategorySingLayoutBtn.setOnClickListener(this);
		
		mCategoryAskLayoutBtn = (RelativeLayout) findViewById(R.id.ask_btn_layout);
		mCategoryAskLayoutBtn.setOnClickListener(this);
		
		mCategorySportsLayoutBtn = (RelativeLayout) findViewById(R.id.sports_btn_layout);
		mCategorySportsLayoutBtn.setOnClickListener(this);
		
		mCategoryLadyLayoutBtn = (RelativeLayout) findViewById(R.id.lady_btn_layout);
		mCategoryLadyLayoutBtn.setOnClickListener(this);
		
		mCategoryNearbyLayoutBtn = (RelativeLayout) findViewById(R.id.nearby_btn_layout);
		mCategoryNearbyLayoutBtn.setOnClickListener(this);
		
		mCategoryTruthLayoutBtn = (RelativeLayout) findViewById(R.id.truth_btn_layout);
		mCategoryTruthLayoutBtn.setOnClickListener(this);
		
		// mCategorySexLayoutBtn = (RelativeLayout) findViewById(R.id.sex_btn_layout);
		// mCategorySexLayoutBtn.setOnClickListener(this);
		
		mCategoryLocalismLayoutBtn = (RelativeLayout) findViewById(R.id.localism_btn_layout);
		mCategoryLocalismLayoutBtn.setOnClickListener(this);
	}
	
	@Override
	protected void onStart() {
		Log.d(TAG, "onStart");
		// TODO Auto-generated method stub
		super.onStart();
	}
	
	@Override
	protected void onRestart() {
		Log.d(TAG, "onRestart");
		// TODO Auto-generated method stub
		super.onRestart();
	}

	@Override
	protected void onResume() {
		Log.d(TAG, "onResume");
		// TODO Auto-generated method stub
		super.onResume();
	}
	
	@Override
	protected void onPause() {
		Log.d(TAG, "onPause");
		// TODO Auto-generated method stub
		super.onPause();
	}
	
	@Override
	protected void onStop() {
		Log.d(TAG, "onStop");
		// TODO Auto-generated method stub
		super.onStop();
	}
	
	@Override
	protected void onDestroy() {
		Log.d(TAG, "onDestroy");
		// TODO Auto-generated method stub
		super.onDestroy();
	}
	
	@Override
	public void onClick(View v) {
	    switch(v.getId()) {
		    case R.id.hot_btn_layout:
		    	// goTo(BrowseActivity.class);
			    break;
			case R.id.follow_btn_layout:
			    goTo(TwitterActivity.class);
				break;
				
			case R.id.love_btn_layout:  // 1
				goTo(CategoryActivity.class, 1);
			    break;
			case R.id.joke_btn_layout:  // 2
			    goTo(CategoryActivity.class, 2);
			    break;
			case R.id.sing_btn_layout:  // 3
			    goTo(CategoryActivity.class, 3);
			    break;
			case R.id.ask_btn_layout:  // 4
			    goTo(CategoryActivity.class, 4);
			    break;
			case R.id.sports_btn_layout:  // 5
			    goTo(CategoryActivity.class, 5);
			    break;
			case R.id.lady_btn_layout:  // 6
			    goTo(CategoryActivity.class, 6);
			    break;
			case R.id.nearby_btn_layout:  // 7
			    goTo(CategoryActivity.class, 7);
			    break;
			case R.id.truth_btn_layout:  // 8
			    goTo(CategoryActivity.class, 8);
			    break;
			/*
			case R.id.sex_btn_layout:  // 9
			    goTo(CategoryActivity.class, 9);
			    break;
			*/
			case R.id.localism_btn_layout:  // 9
			    goTo(CategoryActivity.class, 9);
			    break;
		}
	}
	
	protected void launchActivity(Intent intent) {
		// TODO: probably don't need this result chaining to finish upon logout.
		// since the subclasses have to check in onResume.
		startActivityForResult(intent, REQUEST_CODE_LAUNCH_ACTIVITY);
	}
	
	private void goTo(Class<?> cls) {
		Intent intent = new Intent(ChannelActivity.this, cls).addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		//把一个Activity转换成一个View
		Window w = ChannelActivityGroup.GROUP.getLocalActivityManager().startActivity(cls.toString(), intent);
		View view = w.getDecorView();
		//把View添加大ActivityGroup中
		//ChannelActivityGroup.GROUP.viewHistory.add(view);
		//ChannelActivityGroup.GROUP.setContentView(view);
		ChannelActivityGroup.GROUP.replaceContentView(view);
	}
	
	private void goTo(Class<?> cls, int category) {
		Intent intent = new Intent(ChannelActivity.this, cls).addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		Bundle bundle = new Bundle();
		bundle.putInt("category", category);
		intent.putExtras(bundle);
		//把一个Activity转换成一个View
		Window w = ChannelActivityGroup.GROUP.getLocalActivityManager().startActivity(cls.toString(), intent);
		View view = w.getDecorView();
		//把View添加大ActivityGroup中
		//ChannelActivityGroup.GROUP.viewHistory.add(view);
		//ChannelActivityGroup.GROUP.setContentView(view);
		ChannelActivityGroup.GROUP.replaceContentView(view);
	}
}