﻿package com.codeim.youliao;

import android.app.ActivityGroup;
import android.content.Intent;
import android.os.Bundle;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;

import java.util.List;
import java.util.ArrayList;

public class ChannelActivityGroup extends ActivityGroup {
	private static final String TAG = "ChannelActivityGroup";
    public static ChannelActivityGroup GROUP;
	public List<View> viewHistory;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		
		Log.d(TAG, "onCreate");
		super.onCreate(savedInstanceState);
		
		viewHistory = new ArrayList<View>();
		GROUP = this;
		
		//要跳转的界面
		Intent intent = new Intent(this, ChannelActivity.class).addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		//把一个Activity转换成一个View
		Window w = GROUP.getLocalActivityManager().startActivity("ChannelActivity", intent);
	    View view = w.getDecorView();
	    //把View添加到ActivityGroup中
		//viewHistory.add(view);
        //setContentView(view);
	    replaceContentView(view);
	}
	
	@Override
	protected void onStart() {
		Log.d(TAG, "onStart");
		// TODO Auto-generated method stub
		super.onStart();
	}
	
	@Override
	protected void onRestart() {
		Log.d(TAG, "onRestart");
		// TODO Auto-generated method stub
		super.onRestart();
	}

	@Override
	protected void onResume() {
		Log.d(TAG, "onResume");
		// TODO Auto-generated method stub
		super.onResume();
	}
	
	@Override
	protected void onPause() {
		Log.d(TAG, "onPause");
		// TODO Auto-generated method stub
		super.onPause();
	}
	
	@Override
	protected void onStop() {
		Log.d(TAG, "onStop");
		// TODO Auto-generated method stub
		super.onStop();
	}
	
	@Override
	protected void onDestroy() {
		Log.d(TAG, "onDestroy");
		// TODO Auto-generated method stub
		super.onDestroy();
	}
	
	public void replaceContentView(View view) {
        viewHistory.add(view);
        setContentView(view);
    }
	
	public void back() {
	    Log.d(TAG, "in back");
        if (!viewHistory.isEmpty()) {
            viewHistory.remove(viewHistory.get(viewHistory.size() - 1));
            if (viewHistory.isEmpty()) {
                finish();
                return;
            }
            setContentView(viewHistory.get(viewHistory.size() - 1));
        } else {
            finish();
        }
    }
	
    @Override
    public void onBackPressed() {
	    Log.d("ChannelActivityGroup", "in onBackPressed");
        back();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
	    Log.d("ChannelActivityGroup", "in onKeyDown");
        if (android.os.Build.VERSION.SDK_INT <= Build.VERSION_CODES.DONUT && keyCode == KeyEvent.KEYCODE_BACK
                && event.getRepeatCount() == 0) {
            // Take care of calling this method on earlier versions of
            // the platform where it doesn't exist.
        	Log.d("ChannelActivityGroup", "before onBackPressed");
            onBackPressed();
            return true;
        }
        
        Log.d("ChannelActivityGroup", "no in onBackPressed");
        return super.onKeyDown(keyCode, event);
    }
	
	@Override
	public boolean dispatchKeyEvent(KeyEvent event) {
	    Log.d("ChannelActivityGroup", "in dispatchKeyEvent");
	    if(event.getKeyCode() == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
		    Log.d("ChannelActivityGroup", "before onBackPressed");
            onBackPressed();
            return true;
		}
		
		return super.dispatchKeyEvent(event); 
	}
}