package com.codeim.youliao;

// import java.text.MessageFormat;
import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.codeim.youliao.fanfou.Paging;
import com.codeim.youliao.http.HttpException;
import com.codeim.youliao.ui.base.UserArrayBaseActivity;
import com.codeim.youliao.ui.module.NavBar;
// import com.codeim.youliao.R;

public class FollowersActivity extends UserArrayBaseActivity {

	private static final String TAG = "FollowersActivity";
	private static final String LAUNCH_ACTION = "com.codeim.youliao.FOLLOWERS";
	private static final String USER_ID = "userId";
	private static final String USER_NAME = "userName";

	private String userId;
	private String userName;
	private NavBar mNavBar;
	private int currentPage = 1;

	@Override
	protected boolean _onCreate(Bundle savedInstanceState) {
		if (super._onCreate(savedInstanceState)) {
			Intent intent = getIntent();
			Bundle extras = intent.getExtras();
			if (extras != null) {
				this.userId = extras.getString(USER_ID);
				this.userName = extras.getString(USER_NAME);
			} else {
				// 获取登录用户id
				userId = TwitterApplication.getMyselfId(false);  // TODO:有时会为null？
				userName = TwitterApplication.getMyselfName(false);				
			}
			Log.d(TAG, "userName = " + userName);
			mNavBar = new NavBar(NavBar.HEADER_STYLE_BACK, this);
			mNavBar.setHeaderTitle("粉丝");

			/*
			String myself = TwitterApplication.getMyselfId(false);
			if (getUserId() == myself) {
				// mNavBar.setHeaderTitle(MessageFormat.format(getString(R.string.profile_followers_count_title), "我"));
			} else {
				// mNavBar.setHeaderTitle(MessageFormat.format(getString(R.string.profile_followers_count_title), userName));
			}
			*/
			
			return true;

		} else {
			return false;
		}
	}

	public static Intent createIntent(String userId, String userName) {
		Intent intent = new Intent(LAUNCH_ACTION);
		intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		intent.putExtra(USER_ID, userId);
		intent.putExtra(USER_NAME, userName);
		return intent;
	}

	@Override
	public Paging getNextPage() {
		currentPage += 1;
		return new Paging(currentPage);
	}

	@Override
	protected String getUserId() {
		return this.userId;
	}

	@Override
	public Paging getCurrentPage() {
		currentPage = 1;
		return new Paging(this.currentPage);
	}

	@Override
	protected List<com.codeim.youliao.fanfou.User> getUsers(String userId, Paging page) throws HttpException {
		return getApi().getFollowersList(userId, page);
	}
}
