package com.codeim.youliao;

// import java.text.MessageFormat;
import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.AdapterContextMenuInfo;
// import android.widget.ListView;

import com.codeim.youliao.data.User;
import com.codeim.youliao.fanfou.Paging;
import com.codeim.youliao.http.HttpException;
import com.codeim.youliao.ui.base.UserArrayBaseActivity;
import com.codeim.youliao.ui.module.NavBar;
// import com.codeim.youliao.ui.module.UserArrayAdapter;
import com.codeim.youliao.R;

public class FollowingActivity extends UserArrayBaseActivity {
	
	private static final String TAG = "FollowingActivity";
	private static final String LAUNCH_ACTION = "com.codeim.youliao.FOLLOWING";
	private static final String USER_ID = "userId";
	private static final String USER_NAME = "userName";

	// private ListView mUserList;
	// private UserArrayAdapter mAdapter;
	private String userId;
	private String userName;
	private NavBar mNavBar;
	private int currentPage = 1;
	String myself = "";

	@Override
	protected boolean _onCreate(Bundle savedInstanceState) {
		Intent intent = getIntent();
		Bundle extras = intent.getExtras();
		if (extras != null) {
			this.userId = extras.getString(USER_ID);
			this.userName = extras.getString(USER_NAME);
		} else {
			// 获取登录用户id
			userId = TwitterApplication.getMyselfId(false);
			userName = TwitterApplication.getMyselfName(false);
		}
		Log.d(TAG, "userName = " + userName);

		if (super._onCreate(savedInstanceState)) {
			mNavBar = new NavBar(NavBar.HEADER_STYLE_BACK, this);
			mNavBar.setHeaderTitle("关注");

			myself = TwitterApplication.getMyselfId(false);
			if (getUserId() == myself) {
				// mNavBar.setHeaderTitle(MessageFormat.format(getString(R.string.profile_friends_count_title), "我"));
			} else {
				// mNavBar.setHeaderTitle(MessageFormat.format(getString(R.string.profile_friends_count_title), userName));
			}
			
			return true;
		} else {
			return false;
		}
	}

	/*
	 * 添加取消关注按钮
	 * 
	 * @see
	 * com.codeim.youliao.ui.base.UserListBaseActivity#onCreateContextMenu
	 * (android.view.ContextMenu, android.view.View,
	 * android.view.ContextMenu.ContextMenuInfo)
	 */
	@Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		super.onCreateContextMenu(menu, v, menuInfo);
		if (getUserId() == myself) {
			AdapterView.AdapterContextMenuInfo info = (AdapterContextMenuInfo) menuInfo;
			User user = getContextItemUser(info.position);
			menu.add(0, CONTENT_DEL_FRIEND, 0, getResources().getString(R.string.cmenu_user_addfriend_prefix)
					+ user.screenName + getResources().getString(R.string.cmenu_user_friend_suffix));
		}
	}

	public static Intent createIntent(String userId, String userName) {
		Intent intent = new Intent(LAUNCH_ACTION);
		intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		intent.putExtra(USER_ID, userId);
		intent.putExtra(USER_NAME, userName);
		return intent;
	}

	@Override
	public Paging getNextPage() {
		currentPage += 1;
		return new Paging(currentPage);
	}

	@Override
	protected String getUserId() {
		return this.userId;
	}

	@Override
	public Paging getCurrentPage() {
		currentPage = 1;
		return new Paging(this.currentPage);
	}

	@Override
	protected List<com.codeim.youliao.fanfou.User> getUsers(String userId, Paging page) throws HttpException {
		return getApi().getFriendsStatuses(userId, page);
	}
}
