package com.codeim.youliao;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.widget.RelativeLayout;

public class FriendActivity extends Activity implements OnClickListener {
	
	private static final String TAG = "FriendActivity";

    private RelativeLayout mFollowingLayoutBtn;  // 关注   
	private RelativeLayout mFollowerLayoutBtn;   // 粉丝
	
	@Override 
	protected void onCreate(Bundle savedInstanceState) {
		Log.d(TAG, "onCreate");
		
	    super.onCreate(savedInstanceState);
		setContentView(R.layout.friend_group);
		
		mFollowingLayoutBtn = (RelativeLayout) findViewById(R.id.following_btn_layout);
		mFollowingLayoutBtn.setOnClickListener(this);
		
		mFollowerLayoutBtn = (RelativeLayout) findViewById(R.id.follower_btn_layout);
		mFollowerLayoutBtn.setOnClickListener(this);
	}
	
	@Override
	protected void onStart() {
		Log.d(TAG, "onStart");
		// TODO Auto-generated method stub
		super.onStart();
	}
	
	@Override
	protected void onRestart() {
		Log.d(TAG, "onRestart");
		// TODO Auto-generated method stub
		super.onRestart();
	}

	@Override
	protected void onResume() {
		Log.d(TAG, "onResume");
		// TODO Auto-generated method stub
		super.onResume();
	}
	
	@Override
	protected void onPause() {
		Log.d(TAG, "onPause");
		// TODO Auto-generated method stub
		super.onPause();
	}
	
	@Override
	protected void onStop() {
		Log.d(TAG, "onStop");
		// TODO Auto-generated method stub
		super.onStop();
	}
	
	@Override
	protected void onDestroy() {
		Log.d(TAG, "onDestroy");
		// TODO Auto-generated method stub
		super.onDestroy();
	}
	
	@Override
	public void onClick(View v) {
	    switch(v.getId()) {
		    case R.id.following_btn_layout:
		    	goTo(FollowingActivity.class);
			    break;
			case R.id.follower_btn_layout:
			    goTo(FollowersActivity.class);
				break;
		}
	}
	
	private void goTo(Class<?> cls) {
		Intent intent = new Intent(FriendActivity.this, cls).addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		Window w = FriendActivityGroup.GROUP.getLocalActivityManager().startActivity(cls.toString(), intent);
		View view = w.getDecorView();
		//FriendActivityGroup.GROUP.viewHistory.add(view);
		//FriendActivityGroup.GROUP.setContentView(view);
		FriendActivityGroup.GROUP.replaceContentView(view);
	}
}