﻿package com.codeim.youliao;

import android.app.TabActivity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;
import android.widget.TabHost;
import android.widget.Toast;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.preference.PreferenceManager;

import com.codeim.youliao.app.Preferences;
import com.codeim.youliao.fanfou.Weibo;

public class MainActivity extends TabActivity implements OnCheckedChangeListener {
    /** Called when the activity is first created. */
	
	private static final String TAG = "MainActivity";
	private static final int RESULT_LOGOUT = RESULT_FIRST_USER + 1;
	
	private TabHost mHost;
	private RadioGroup radioderGroup;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
		Log.d("MainActivity", "onCreate MainActivity");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main_youliao);
		
		//检验是否登录
		if(checkIsLogin()) {
            //实例化TabHost
            mHost = this.getTabHost();
        
            //添加选项卡
            mHost.addTab(mHost.newTabSpec("NEARBY").setIndicator("NEARBY").setContent(new Intent(this, NearbyActivity.class)));
            mHost.addTab(mHost.newTabSpec("CHANNEL").setIndicator("CHANNEL").setContent(new Intent(this, ChannelActivityGroup.class)));
            mHost.addTab(mHost.newTabSpec("MESSAGE").setIndicator("MESSAGE").setContent(new Intent(this, DmActivity.class)));
            mHost.addTab(mHost.newTabSpec("CONTACT").setIndicator("CONTACT").setContent(new Intent(this, FriendActivityGroup.class)));
            mHost.addTab(mHost.newTabSpec("SETTING").setIndicator("SETTING").setContent(new Intent(this, SettingsActivity.class)));
        
            radioderGroup = (RadioGroup) findViewById(R.id.main_radio);
		    radioderGroup.setOnCheckedChangeListener(this);
		}
    }
	
	@Override
	public void onCheckedChanged(RadioGroup group, int checkedId) {
		switch(checkedId) {
		    case R.id.radio_btn_nearby:
			    mHost.setCurrentTabByTag("NEARBY");
			    break;
		    case R.id.radio_btn_channel:
			    mHost.setCurrentTabByTag("CHANNEL");
			    break;
		    case R.id.radio_btn_message:
			    mHost.setCurrentTabByTag("MESSAGE");
			    break;
		    case R.id.radio_btn_contact:
			    mHost.setCurrentTabByTag("CONTACT");
			    break;
		    case R.id.radio_btn_setting:
			    mHost.setCurrentTabByTag("SETTING");
			    break;
		}		
	}
	
	@Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if(newConfig.orientation==Configuration.ORIENTATION_LANDSCAPE){
		    MainActivity.this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        	// Toast.makeText(getApplicationContext(), "当前屏幕为横屏", Toast.LENGTH_SHORT).show();
        }else{
        	// Toast.makeText(getApplicationContext(), "当前屏幕为竖屏", Toast.LENGTH_SHORT).show();
        }
    }
	
	private boolean checkIsLogin() {
	    if (TwitterApplication.mPref.getBoolean(Preferences.FORCE_SCREEN_ORIENTATION_PORTRAIT, false)) {
			setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
		}
		if (!checkIsLogedIn()) {
			return false;
		} else {
			PreferenceManager.setDefaultValues(this, R.xml.preferences, false);
			return true;
		}
	}
	
	protected boolean checkIsLogedIn() {
		if (!getApi().isLoggedIn()) {
			Log.d(TAG, "Not logged in.");
			handleLoggedOut();
			return false;
		}
		return true;
	}
	
	protected void handleLoggedOut() {
	    Log.d(TAG, "before handleLoggedOut");
		if (isTaskRoot()) {
		    Log.d(TAG, "before showLogin");
			showLogin();
		} else {
			setResult(RESULT_LOGOUT);
		}

		finish();
	}
	
	public Weibo getApi() {
		return TwitterApplication.mApi;
	}
	
	protected void showLogin() {
		Intent intent = new Intent(this, LoginActivity.class);
		// TODO: might be a hack?
		intent.putExtra(Intent.EXTRA_INTENT, getIntent());

		startActivity(intent);
	}
}