/*
 * Copyright (C) 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * AbstractTwitterListBaseLine用于抽象tweets List的展现
 * UI基本元素要求：一个ListView用于tweet列表
 *               一个ProgressText用于提示信息
 */
package com.codeim.youliao.ui.base;

import android.app.Activity;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.Menu;
import android.widget.ListView;
import android.widget.TextView;

import com.codeim.youliao.R;
import com.codeim.youliao.TwitterApplication;
import com.codeim.youliao.data.Tweet;
import com.codeim.youliao.db.TwitterDatabase;
import com.codeim.youliao.fanfou.Weibo;
import com.codeim.youliao.ui.module.Feedback;
import com.codeim.youliao.ui.module.FeedbackFactory;
import com.codeim.youliao.ui.module.FeedbackFactory.FeedbackType;
import com.codeim.youliao.ui.module.TweetAdapter;

public abstract class BrowseListBaseActivity extends Activity implements Refreshable {
	static final String TAG = "BrowseListBaseActivity";

	protected SharedPreferences mPreferences;
	protected TextView mProgressText;
	protected Feedback mFeedback;

	protected static final int STATE_ALL = 0;
	protected static final String SIS_RUNNING_KEY = "running";

	static final int DIALOG_WRITE_ID = 0;

	abstract protected int getLayoutId();

	abstract protected ListView getTweetList();

	abstract protected TweetAdapter getTweetAdapter();

	abstract protected void setupState();

	abstract protected String getActivityTitle();

	abstract protected boolean useBasicMenu();

	abstract protected Tweet getContextItemTweet(int position);

	abstract protected void updateTweet(Tweet tweet);

	public static final int CONTEXT_REPLY_ID = Menu.FIRST + 1;
	// public static final int CONTEXT_AT_ID = Menu.FIRST + 2;
	public static final int CONTEXT_RETWEET_ID = Menu.FIRST + 3;
	public static final int CONTEXT_DM_ID = Menu.FIRST + 4;
	public static final int CONTEXT_MORE_ID = Menu.FIRST + 5;
	public static final int CONTEXT_ADD_FAV_ID = Menu.FIRST + 6;
	public static final int CONTEXT_DEL_FAV_ID = Menu.FIRST + 7;

	/**
	 * 如果增加了Context Menu常量的数量，则必须重载此方法， 以保证其他人使用常量时不产生重复
	 * 
	 * @return 最大的Context Menu常量
	 */
	protected int getLastContextMenuId() {
		return CONTEXT_DEL_FAV_ID;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
		setContentView(getLayoutId());
		mFeedback = FeedbackFactory.create(this, FeedbackType.PROGRESS);
		mPreferences = TwitterApplication.mPref;

		// 提示栏
		mProgressText = (TextView) findViewById(R.id.progress_text);

		setupState();

			// registerForContextMenu(getTweetList());
			// registerOnClickListener(getTweetList());
	}

	@Override
	protected void onResume() {
		super.onResume();
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
	}
    
	public TwitterDatabase getDb() {
		return TwitterApplication.mDb;
	}

	public Weibo getApi() {
		return TwitterApplication.mApi;
	}

	public SharedPreferences getPreferences() {
		return mPreferences;
	}

	protected void draw() {
		getTweetAdapter().refresh();
	}

	protected void goTop() {
		getTweetList().setSelection(1);
	}

	protected void adapterRefresh() {
		getTweetAdapter().refresh();
	}

	public void onFavSuccess() {
		// updateProgress(getString(R.string.refreshing));
		adapterRefresh();
	}

	public void onFavFailure() {
		// updateProgress(getString(R.string.refreshing));
	}

	protected void specialItemClicked(int position) {

	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		if(getTweetList() != null) {
			int lastPosition = getTweetList().getFirstVisiblePosition();
			outState.putInt("LAST_POSITION", lastPosition);
		}
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		
		if(getTweetList() != null) {
			int lastPosition = savedInstanceState.getInt("LAST_POSITION");
			getTweetList().setSelection(lastPosition);
		}
	}

	@Override
	public void doRetrieve() {
		// TODO Auto-generated method stub
	}
	
	public static boolean isTrue(Bundle bundle, String key) {
		return bundle != null && bundle.containsKey(key) && bundle.getBoolean(key);
	}
}