package com.codeim.youliao.ui.module;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;

import com.codeim.youliao.R;

public class CategoryCheckBox extends LinearLayout {
    private Context mContext;
	private View mView;
	private LayoutParams mLayoutParams;
	
	private int mCategory = 0;
	
	private CheckBox mFirstLeftCheckBox;      // 情感天地          1
	private CheckBox mFirstMiddleCheckBox;    // 轻松搞笑          2
	private CheckBox mFirstRightCheckBox;     // 我唱你听           3
	private CheckBox mSecondLeftCheckBox;     // 有问有答           4
	private CheckBox mSecondMiddleCheckBox;   // 体育播报           5
	private CheckBox mSecondRightCheckBox;    // 女性密语           6
	private CheckBox mThirdLeftCheckBox;      // 周边推荐           7
	private CheckBox mThirdMiddleCheckBox;    // 真心话大冒险  8
	private CheckBox mThirdRightCheckBox;     // 性感话题           9
	
	/**
	 * 构造方法
	 * 
	 * @param context
	 * @param attrs
	 * @param defStyle
	 */
	public CategoryCheckBox(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs);
		this.mContext = context;
		init();
	}
	
	/**
	 * 构造方法
	 * 
	 * @param context
	 * @param attrs
	 */
	public CategoryCheckBox(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.mContext = context;
		init();
	}
	
	/**
	 * 构造方法
	 * 
	 * @param context
	 */
	public CategoryCheckBox(Context context) {
		super(context);
		this.mContext = context;
		init();
	}
	
	/**
	 * 初始化  */
	private void init() {
		mView = LayoutInflater.from(mContext).inflate(R.layout.category_checkbox, null);
		mFirstLeftCheckBox = (CheckBox) mView.findViewById(R.id.first_checkBox1);
		mFirstMiddleCheckBox = (CheckBox) mView.findViewById(R.id.first_checkBox2);
		mFirstRightCheckBox = (CheckBox) mView.findViewById(R.id.first_checkBox3);
		mSecondLeftCheckBox = (CheckBox) mView.findViewById(R.id.second_checkBox1);
		mSecondMiddleCheckBox = (CheckBox) mView.findViewById(R.id.second_checkBox2);
		mSecondRightCheckBox = (CheckBox) mView.findViewById(R.id.second_checkBox3);
		mThirdLeftCheckBox = (CheckBox) mView.findViewById(R.id.third_checkBox1);
		mThirdMiddleCheckBox = (CheckBox) mView.findViewById(R.id.third_checkBox2);
		mThirdRightCheckBox = (CheckBox) mView.findViewById(R.id.third_checkBox3);
		
		mFirstLeftCheckBox.setText("情感天地");
		mFirstMiddleCheckBox.setText("轻松搞笑");
		mFirstRightCheckBox.setText("我唱你听");
		mSecondLeftCheckBox.setText("有问有答");
		mSecondMiddleCheckBox.setText("体育播报");
		mSecondRightCheckBox.setText("女性密语");
		mThirdLeftCheckBox.setText("周边推荐");
		mThirdMiddleCheckBox.setText("真话冒险");
		mThirdRightCheckBox.setText("故土乡音");  // 性感话题
		
		mLayoutParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		mView.setLayoutParams(mLayoutParams);
		this.setLayoutParams(mLayoutParams);
		this.addView(mView);
	
	    mFirstLeftCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 1;
                	// mFirstLeftCheckBox.setChecked(true);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 1) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mFirstMiddleCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 2;
                	mFirstLeftCheckBox.setChecked(false);
            		// mFirstMiddleCheckBox.setChecked(true);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 2) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mFirstRightCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 3;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		// mFirstRightCheckBox.setChecked(true);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 3) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mSecondLeftCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 4;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		// mSecondLeftCheckBox.setChecked(true);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 4) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mSecondMiddleCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 5;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		// mSecondMiddleCheckBox.setChecked(true);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 5) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mSecondRightCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 6;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		// mSecondRightCheckBox.setChecked(true);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 6) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mThirdLeftCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 7;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		// mThirdLeftCheckBox.setChecked(true);
            		mThirdMiddleCheckBox.setChecked(false);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 7) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mThirdMiddleCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 8;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		// mThirdMiddleCheckBox.setChecked(true);
            		mThirdRightCheckBox.setChecked(false);
                } else {
                	if (mCategory == 8) {
                	    mCategory = 0;
                	}
                }
            }
        });
	    
	    mThirdRightCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                // TODO Auto-generated method stub
                if (isChecked) {
                	mCategory = 9;
                	mFirstLeftCheckBox.setChecked(false);
            		mFirstMiddleCheckBox.setChecked(false);
            		mFirstRightCheckBox.setChecked(false);
            		mSecondLeftCheckBox.setChecked(false);
            		mSecondMiddleCheckBox.setChecked(false);
            		mSecondRightCheckBox.setChecked(false);
            		mThirdLeftCheckBox.setChecked(false);
            		mThirdMiddleCheckBox.setChecked(false);
            		// mThirdRightCheckBox.setChecked(true);
                } else {
                	if (mCategory == 9) {
                	    mCategory = 0;
                	}
                }
            }
        });
	}
	
	public void setCategory(int category) {
	    mCategory = category;
		
		switch (category) {
		    case 1: mFirstLeftCheckBox.setChecked(true);
			    break;
			case 2: mFirstMiddleCheckBox.setChecked(true);
			    break;
			case 3: mFirstRightCheckBox.setChecked(true);
			    break;
            case 4:	mSecondLeftCheckBox.setChecked(true);
			    break;
            case 5:	mSecondMiddleCheckBox.setChecked(true);
			    break;
            case 6:	mSecondRightCheckBox.setChecked(true);
			    break;
            case 7:	mThirdLeftCheckBox.setChecked(true);
			    break;
            case 8:	mThirdMiddleCheckBox.setChecked(true);
			    break;
            case 9:	mThirdRightCheckBox.setChecked(true);
			    break;
			default : ;
			    break;
		}
	}
	
	public int getCategory() {
		return mCategory;
	}
}