package com.codeim.youliao.ui.module;

import com.codeim.youliao.R;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RadioGroup.OnCheckedChangeListener;

/**
 * �ؼ�
 * 
 * @author Luo.Yunlongx
 * 
 */
public class GenderChoose extends LinearLayout {

	private Context mContext;

	private View mView;
	private RadioGroup mRadioGroup;
	private RadioButton mLeftRadioButton;
	private RadioButton mRightRadioButton;

	private LayoutParams mLayoutParams;

	/**
	 * ���췽��
	 * 
	 * @param context
	 * @param attrs
	 * @param defStyle
	 */
	public GenderChoose(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs);
		this.mContext = context;
		init();
	}

	/**
	 * ���췽��
	 * 
	 * @param context
	 * @param attrs
	 */
	public GenderChoose(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.mContext = context;
		init();
	}

	/**
	 * ���췽��
	 * 
	 * @param context
	 */
	public GenderChoose(Context context) {
		super(context);
		this.mContext = context;
		init();
	}

	/**
	 * ��ʼ��
	 */
	private void init() {
		mView = LayoutInflater.from(mContext).inflate(R.layout.view_genderchoose, null);
		mLeftRadioButton = (RadioButton) mView.findViewById(R.id.mychoose_radioButton1);
		mRightRadioButton = (RadioButton) mView.findViewById(R.id.mychoose_radioButton2);
		mRadioGroup = (RadioGroup) mView.findViewById(R.id.mychoose_radioGroup);
		mLayoutParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);

		mView.setLayoutParams(mLayoutParams);

		this.setLayoutParams(mLayoutParams);
		this.addView(mView);
	}

	/**
	 * ������ʾ������
	 * 
	 * @param leftText
	 *            �������
	 * @param rightText
	 *            �Ҳ�����
	 */
	public void setTexts(String leftText, String rightText) {
		mLeftRadioButton.setText(leftText);
		mRightRadioButton.setText(rightText);
	}

	/**
	 * ���õ���¼�
	 * 
	 * @param mOnCheckedChange
	 */
	public void setOnClick(final IOnCheckedChange mOnCheckedChange, final int id) {
		mRadioGroup.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {

				switch (checkedId) {
				case R.id.mychoose_radioButton1:
					/* �ı��ֵ���ɫ */
					mLeftRadioButton.setTextColor(mContext.getResources()
							.getColor(android.R.color.white));
					mRightRadioButton.setTextColor(mContext.getResources()
							.getColor(android.R.color.black));
					/**
					 * ѡ�����ʱ���¼�
					 */
					if (mOnCheckedChange != null) {
						mOnCheckedChange.leftOnClick(id);
					}
					break;
				case R.id.mychoose_radioButton2:
					/* �ı��ֵ���ɫ */
					mRightRadioButton.setTextColor(mContext.getResources()
							.getColor(android.R.color.white));
					mLeftRadioButton.setTextColor(mContext.getResources()
							.getColor(android.R.color.black));
					/**
					 * ѡ���Ҳ�ʱ���¼�
					 */
					if (mOnCheckedChange != null) {
						mOnCheckedChange.rightOnClick(id);
					}
					break;
				}
			}
		});
	}

	/**
	 * �Ƿ��һ��ѡ��
	 * 
	 * @param leftSelected
	 */
	public void setChoose(boolean leftSelected) {
		mLeftRadioButton.setSelected(leftSelected);
		mRightRadioButton.setSelected(!leftSelected);
	}

	/**
	 * 
	 * �Լ�д���ӿڣ�����RadioGroup.setOnCheckedChangeListener��Ӧ
	 * 
	 * @author Luo.Yunlongx
	 * 
	 */
	public interface IOnCheckedChange {
		/**
		 * ��౻ѡ��
		 * 
		 * @param id
		 *            ����¼�Դ
		 */
		public void leftOnClick(int id);

		/**
		 * �Ҳ౻ѡ��
		 * 
		 * @param id
		 *            ����¼�Դ
		 */
		public void rightOnClick(int id);
	}

}
