<?php get_header();?>

<div class="wrapper">
  <div id="contentTop"></div>
  <div id="container">
    <div class="main">
    
    <h1 class="page-title">
<?php if ( is_day() ) : ?>
				<?php printf( __( 'Daily Archives: <span>%s</span>', 'jeans' ), get_the_date() ); ?>
<?php elseif ( is_month() ) : ?>
				<?php printf( __( 'Monthly Archives: <span>%s</span>', 'jeans' ), get_the_date('F Y') ); ?>
<?php elseif ( is_year() ) : ?>
				<?php printf( __( 'Yearly Archives: <span>%s</span>', 'jeans' ), get_the_date('Y') ); ?>
<?php else : ?>
				<?php _e( 'Blog Archives', 'jeans' ); ?>
<?php endif; ?>
			</h1>
            
      <?php if (have_posts()) : ?>
      <?php while (have_posts()) : the_post(); ?>
       
         <div class="time">
              <?php the_time('F'); ?>
          
              <div class="white">
                <?php the_time('j'); ?>
              </div>
            </div>
            
      <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <ul class="posts-quick">
       <li>
           
            <h3><a href="<?php the_permalink();?>" rel="bookmark" title="<?php the_title(); ?>">
              <?php the_title(); ?>
              </a></h3>
            <div class="entry-summary">
              <div class="postmetadata">
                <div class="postmetadata">
                发表在
                <?php the_category(', ') ?>
                &nbsp;|&nbsp;
                由
                <?php the_author();?>
                &nbsp;|&nbsp;
                <?php the_time('g:i a'); ?>
                &nbsp;|&nbsp; 
                <?php comments_popup_link('0 评论', '1 评论', '% 评论'); ?>
                
              </div>
              <div class="entry-thumbnails">
                <div class="entry-thumbnailsBg"></div>
                <a href="<?php the_permalink();?>">
                <?php dm_the_thumbnail()?>
                </a></div>
              <div class="entry">
                <p><?php echo jeans_cutstr(apply_filters('the_content',$post->post_content),500) ?></p>
                <?php the_tags('标签: ', ', ', '<br />'); ?>
                <p class="quick-read-more"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                 阅读全文
                  </a></p>
              </div>
            </div>
          </li>
        </ul>
      </div>
      <!--post end-->
      <?php endwhile; ?>
      <div class="navigation">
        <?php posts_nav_link(); ?>
      </div>
      <?php else : ?>
      <div class="post" id="post-<?php the_ID(); ?>">
         <h3>
          未找到
        </h3>
        <p>对不起，你搜索的内容未找到.</p>
        <p>你可以点击以下链接:</p>
        <h2>
          <?php _e('Archives','jeans');?>
        </h2>
        <?php wp_get_archives('type=monthly');?>
        <p>或用搜索框继续查询:</p>
        <h2>
          <?php _e('search','jeans');?>
        </h2>
        <div id="search">
          <?php get_search_form() ;?>
        </div>
      </div>
      <?php endif; ?>
    </div>
    <!--main end-->
    
    <div id="sidebarBtn"> 
    <div class="close-sidebar"><a href="#"><img src="<?php echo get_template_directory_uri('template_url'); ?>/images/HiddenSidebar.png" width="45" height="148" /></a></div> 
    <div class="show-sidebar" style="display:none;"><a href="#"><img src="<?php echo get_template_directory_uri('template_url'); ?>/images/showSidebar.png" width="45" height="148" /></a></div> 
    </div>
    
    <?php get_sidebar(); ?>
  </div>
  <div id="contentBot"></div>
</div>
<!--content end-->
<?php get_footer(); ?>
