<?php
if( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'name' => __( 'sidebar', 'jeans' ),
		'before_widget' => '<li>', 
		'after_widget' => '</li>',
		'before_title' => '<h2>', 
		'after_title' => '</h2>' 
 
	));

}
	
function jeans_theme_init(){
	load_theme_textdomain('jeans', get_template_directory() . '/language');
}

add_action ('init', 'jeans_theme_init');
add_theme_support( 'post-thumbnails' );
 
global $content_width;
$content_width = 676;

function dm_the_thumbnail() {   
 
global $post;   

if ( has_post_thumbnail() ) {   
echo '<a href="'.get_permalink().'" title="Read More">';   
the_post_thumbnail('thumbnail');   
echo '</a>';   
} else {   

$content = $post->post_content;   
preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $content, $strResult, PREG_PATTERN_ORDER);   
$n = count($strResult[1]);  
 
if($n > 0){    
            echo '<a href="'.get_permalink().'" title="Read More"><img src="'.$strResult[1][0].'" alt="thumbnail" /></a>';   
        }else {      
            echo '<a href="'.get_permalink().'" title="Read More"><img src="'.get_bloginfo('template_url').'/images/thumbnail.png" alt="thumbnail" /></a>';  
       }   
  }    
}  


function jeans_setup() {

	// This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	// This theme uses post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( 'jeans', TEMPLATEPATH . '/languages' );
	
	// This theme allows users to set a custom background
	add_custom_background();
	
	define( 'HEADER_TEXTCOLOR', '' );
	define( 'HEADER_IMAGE', '%s/images/headers/lake.jpg' );

	// The height and width of your custom header. You can hook into the theme's own filters to change these values.
	// Add a filter to jeans_header_image_width and jeans_header_image_height to change these values.
	define( 'HEADER_IMAGE_WIDTH', apply_filters( 'jeans_header_image_width', 960 ) );
	define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'jeans_header_image_height', 302 ) );

	// We'll be using post thumbnails for custom header images on posts and pages.
	// We want them to be 940 pixels wide by 198 pixels tall.
	// Larger images will be auto-cropped to fit, smaller ones will be ignored. See header.php.
		set_post_thumbnail_size( HEADER_IMAGE_WIDTH, HEADER_IMAGE_HEIGHT, true );

	// Don't support text inside the header image.
	define( 'NO_HEADER_TEXT', true );

	// Add a way for the custom header to be styled in the admin panel that controls
	// custom headers. See jeans_admin_header_style(), below.
	add_custom_image_header( '', 'jeans_admin_header_style' );

	// ... and thus ends the changeable header business.

	// Default custom headers packaged with the theme. %s is a placeholder for the theme template directory URI.
	register_default_headers( array(
		'lake' => array(
			'url' => '%s/images/headers/lake.jpg',
			'thumbnail_url' => '%s/images/headers/lake-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'lake', 'jeans' )
		),
		'house' => array(
			'url' => '%s/images/headers/house.jpg',
			'thumbnail_url' => '%s/images/headers/house-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'house', 'jeans' )
		),
		'cowboy' => array(
			'url' => '%s/images/headers/cowboy.jpg',
			'thumbnail_url' => '%s/images/headers/cowboy-thumbnail.jpg',
			/* translators: header image description */
			'description' => __( 'cowboy', 'jeans' )
		)
	) );
}

add_action( 'after_setup_theme', 'jeans_setup'); 


function jeans_cutstr($string, $length) {
	         $string =strip_tags($string);
         $strcut= '';
         if(strlen($string) > $length) {
        preg_match_all("/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/", $string, $info);
         $j = 0;
        for($i=0; $i<count($info[0]); $i++) {
        	 
                $strcut .= $info[0][$i];
                
                $j = ord($info[0][$i]) > 127 ? $j + 2 : $j + 1;
                if ($j > $length - 3) {
                        return $strcut." ...";
                }
        }
        return join('', $info[0]);
                 } else {
                          return $string;
                 }
} 
      

function jeans_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'jeans_page_menu_args' );

?>